use gabi::*;

fn print_type_of<T>(_: &T) {
    println!("{}", std::any::type_name::<T>())
}
fn main() {
    let a = Bytes(124 as u8);
    let b = Bytes(5247 as u16);
    let c = Bytes(156765 as u32);
    let d = Bytes(5259731856 as u64);

    // But not:
    // let _x = Bytes("5");
    // let _y = Bytes(5 as i8);
    // let _z = Bytes(5 as f64);

    print!("{} stored as ", a);
    print_type_of(&a.0); // 124 B stored as u8

    print!("{} stored as ", b);
    print_type_of(&b.0); // 5.25 KB stored as u16

    print!("{} stored as ", c);
    print_type_of(&c.0); // 156.76 KB stored as u32

    print!("{} stored as ", d);
    print_type_of(&d.0); // 5.26 GB stored as u64
}
