# Gabi

This crate provides a simple `Bytes` struct that stores a number and displays it in as the appropriate multiple of a power of  1000 bytes, i.e. in Megabytes, Gigabyte, etc. for human readability.

Example:

```rust
let b = Bytes(5247 as u16);
assert_eq("5.25 MB", b);
```

The number is stored internally in the same type as was provided to initialize the struct: `u16` in this example.

*Writing this simple crate was a good exercise to learn generics, trait bounds and automated tests.*

| Decimal | Name  |
| ------- | ----- |
| 1       | Byte  |
| 1000    | Kilo  |
| 1000^2  | Mega  |
| 1000^3  | Giga  |
| 1000^4  | Tera  |
| 1000^5  | Peta  |
| 1000^6  | Exa   |
| 1000^7  | Zetta |
| 1000^8  | Yotta |

| Decimal | Name |
| ------- | ---- |
| 1       | Byte |
| 1024    | Kibi |
| 1024^2  | Mebi |
| 1024^3  | Gibi |
| 1024^4  | Tebi |
| 1024^5  | Pebi |
| 1024^6  | Exbi |
| 1024^7  | Zebi |
| 1024^8  | Yobi |

Ze* and Yo* are outside the range of numbers that can be represented by u64 (maximum 1.84467440737e+19 or 18.4467440737*1000^6).
