const DIV9_TABLE: [usize; 128] = [
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 14, 14,
];

#[inline]
pub(crate) fn get_units(d: i8) -> usize {
    div9(d + 8)
}

#[inline]
pub(crate) fn div9(d: i8) -> usize {
    DIV9_TABLE[d as usize]
}

const MOD9_TABLE: [usize; 128] = [
    0, 1, 2, 3, 4, 5, 6, 7, 8, 0, 1, 2, 3, 4, 5, 6, 7, 8, 0, 1, 2, 3, 4, 5, 6, 7, 8, 0, 1, 2, 3, 4,
    5, 6, 7, 8, 0, 1, 2, 3, 4, 5, 6, 7, 8, 0, 1, 2, 3, 4, 5, 6, 7, 8, 0, 1, 2, 3, 4, 5, 6, 7, 8, 0,
    1, 2, 3, 4, 5, 6, 7, 8, 0, 1, 2, 3, 4, 5, 6, 7, 8, 0, 1, 2, 3, 4, 5, 6, 7, 8, 0, 1, 2, 3, 4, 5,
    6, 7, 8, 0, 1, 2, 3, 4, 5, 6, 7, 8, 0, 1, 2, 3, 4, 5, 6, 7, 8, 0, 1, 2, 3, 4, 5, 6, 7, 8, 0, 1,
];

#[inline]
pub(crate) fn mod9(d: i8) -> usize {
    MOD9_TABLE[d as usize]
}

pub(crate) const POW10: [i32; 10] = [
    1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000,
];

pub(crate) const BIN_HIGH_UNIT: i32 = 1_000_000;
pub(crate) const BIN_MID_UNIT: i32 = 1_000;

pub(crate) const BIN2CHAR: [u8; 4001] = [
    0x00, b'0', b'0', b'0', 0x01, b'0', b'0', b'1', 0x01, b'0', b'0', b'2', 0x01, b'0', b'0', b'3',
    0x01, b'0', b'0', b'4', 0x01, b'0', b'0', b'5', 0x01, b'0', b'0', b'6', 0x01, b'0', b'0', b'7',
    0x01, b'0', b'0', b'8', 0x01, b'0', b'0', b'9', 0x02, b'0', b'1', b'0', 0x02, b'0', b'1', b'1',
    0x02, b'0', b'1', b'2', 0x02, b'0', b'1', b'3', 0x02, b'0', b'1', b'4', 0x02, b'0', b'1', b'5',
    0x02, b'0', b'1', b'6', 0x02, b'0', b'1', b'7', 0x02, b'0', b'1', b'8', 0x02, b'0', b'1', b'9',
    0x02, b'0', b'2', b'0', 0x02, b'0', b'2', b'1', 0x02, b'0', b'2', b'2', 0x02, b'0', b'2', b'3',
    0x02, b'0', b'2', b'4', 0x02, b'0', b'2', b'5', 0x02, b'0', b'2', b'6', 0x02, b'0', b'2', b'7',
    0x02, b'0', b'2', b'8', 0x02, b'0', b'2', b'9', 0x02, b'0', b'3', b'0', 0x02, b'0', b'3', b'1',
    0x02, b'0', b'3', b'2', 0x02, b'0', b'3', b'3', 0x02, b'0', b'3', b'4', 0x02, b'0', b'3', b'5',
    0x02, b'0', b'3', b'6', 0x02, b'0', b'3', b'7', 0x02, b'0', b'3', b'8', 0x02, b'0', b'3', b'9',
    0x02, b'0', b'4', b'0', 0x02, b'0', b'4', b'1', 0x02, b'0', b'4', b'2', 0x02, b'0', b'4', b'3',
    0x02, b'0', b'4', b'4', 0x02, b'0', b'4', b'5', 0x02, b'0', b'4', b'6', 0x02, b'0', b'4', b'7',
    0x02, b'0', b'4', b'8', 0x02, b'0', b'4', b'9', 0x02, b'0', b'5', b'0', 0x02, b'0', b'5', b'1',
    0x02, b'0', b'5', b'2', 0x02, b'0', b'5', b'3', 0x02, b'0', b'5', b'4', 0x02, b'0', b'5', b'5',
    0x02, b'0', b'5', b'6', 0x02, b'0', b'5', b'7', 0x02, b'0', b'5', b'8', 0x02, b'0', b'5', b'9',
    0x02, b'0', b'6', b'0', 0x02, b'0', b'6', b'1', 0x02, b'0', b'6', b'2', 0x02, b'0', b'6', b'3',
    0x02, b'0', b'6', b'4', 0x02, b'0', b'6', b'5', 0x02, b'0', b'6', b'6', 0x02, b'0', b'6', b'7',
    0x02, b'0', b'6', b'8', 0x02, b'0', b'6', b'9', 0x02, b'0', b'7', b'0', 0x02, b'0', b'7', b'1',
    0x02, b'0', b'7', b'2', 0x02, b'0', b'7', b'3', 0x02, b'0', b'7', b'4', 0x02, b'0', b'7', b'5',
    0x02, b'0', b'7', b'6', 0x02, b'0', b'7', b'7', 0x02, b'0', b'7', b'8', 0x02, b'0', b'7', b'9',
    0x02, b'0', b'8', b'0', 0x02, b'0', b'8', b'1', 0x02, b'0', b'8', b'2', 0x02, b'0', b'8', b'3',
    0x02, b'0', b'8', b'4', 0x02, b'0', b'8', b'5', 0x02, b'0', b'8', b'6', 0x02, b'0', b'8', b'7',
    0x02, b'0', b'8', b'8', 0x02, b'0', b'8', b'9', 0x02, b'0', b'9', b'0', 0x02, b'0', b'9', b'1',
    0x02, b'0', b'9', b'2', 0x02, b'0', b'9', b'3', 0x02, b'0', b'9', b'4', 0x02, b'0', b'9', b'5',
    0x02, b'0', b'9', b'6', 0x02, b'0', b'9', b'7', 0x02, b'0', b'9', b'8', 0x02, b'0', b'9', b'9',
    0x03, b'1', b'0', b'0', 0x03, b'1', b'0', b'1', 0x03, b'1', b'0', b'2', 0x03, b'1', b'0', b'3',
    0x03, b'1', b'0', b'4', 0x03, b'1', b'0', b'5', 0x03, b'1', b'0', b'6', 0x03, b'1', b'0', b'7',
    0x03, b'1', b'0', b'8', 0x03, b'1', b'0', b'9', 0x03, b'1', b'1', b'0', 0x03, b'1', b'1', b'1',
    0x03, b'1', b'1', b'2', 0x03, b'1', b'1', b'3', 0x03, b'1', b'1', b'4', 0x03, b'1', b'1', b'5',
    0x03, b'1', b'1', b'6', 0x03, b'1', b'1', b'7', 0x03, b'1', b'1', b'8', 0x03, b'1', b'1', b'9',
    0x03, b'1', b'2', b'0', 0x03, b'1', b'2', b'1', 0x03, b'1', b'2', b'2', 0x03, b'1', b'2', b'3',
    0x03, b'1', b'2', b'4', 0x03, b'1', b'2', b'5', 0x03, b'1', b'2', b'6', 0x03, b'1', b'2', b'7',
    0x03, b'1', b'2', b'8', 0x03, b'1', b'2', b'9', 0x03, b'1', b'3', b'0', 0x03, b'1', b'3', b'1',
    0x03, b'1', b'3', b'2', 0x03, b'1', b'3', b'3', 0x03, b'1', b'3', b'4', 0x03, b'1', b'3', b'5',
    0x03, b'1', b'3', b'6', 0x03, b'1', b'3', b'7', 0x03, b'1', b'3', b'8', 0x03, b'1', b'3', b'9',
    0x03, b'1', b'4', b'0', 0x03, b'1', b'4', b'1', 0x03, b'1', b'4', b'2', 0x03, b'1', b'4', b'3',
    0x03, b'1', b'4', b'4', 0x03, b'1', b'4', b'5', 0x03, b'1', b'4', b'6', 0x03, b'1', b'4', b'7',
    0x03, b'1', b'4', b'8', 0x03, b'1', b'4', b'9', 0x03, b'1', b'5', b'0', 0x03, b'1', b'5', b'1',
    0x03, b'1', b'5', b'2', 0x03, b'1', b'5', b'3', 0x03, b'1', b'5', b'4', 0x03, b'1', b'5', b'5',
    0x03, b'1', b'5', b'6', 0x03, b'1', b'5', b'7', 0x03, b'1', b'5', b'8', 0x03, b'1', b'5', b'9',
    0x03, b'1', b'6', b'0', 0x03, b'1', b'6', b'1', 0x03, b'1', b'6', b'2', 0x03, b'1', b'6', b'3',
    0x03, b'1', b'6', b'4', 0x03, b'1', b'6', b'5', 0x03, b'1', b'6', b'6', 0x03, b'1', b'6', b'7',
    0x03, b'1', b'6', b'8', 0x03, b'1', b'6', b'9', 0x03, b'1', b'7', b'0', 0x03, b'1', b'7', b'1',
    0x03, b'1', b'7', b'2', 0x03, b'1', b'7', b'3', 0x03, b'1', b'7', b'4', 0x03, b'1', b'7', b'5',
    0x03, b'1', b'7', b'6', 0x03, b'1', b'7', b'7', 0x03, b'1', b'7', b'8', 0x03, b'1', b'7', b'9',
    0x03, b'1', b'8', b'0', 0x03, b'1', b'8', b'1', 0x03, b'1', b'8', b'2', 0x03, b'1', b'8', b'3',
    0x03, b'1', b'8', b'4', 0x03, b'1', b'8', b'5', 0x03, b'1', b'8', b'6', 0x03, b'1', b'8', b'7',
    0x03, b'1', b'8', b'8', 0x03, b'1', b'8', b'9', 0x03, b'1', b'9', b'0', 0x03, b'1', b'9', b'1',
    0x03, b'1', b'9', b'2', 0x03, b'1', b'9', b'3', 0x03, b'1', b'9', b'4', 0x03, b'1', b'9', b'5',
    0x03, b'1', b'9', b'6', 0x03, b'1', b'9', b'7', 0x03, b'1', b'9', b'8', 0x03, b'1', b'9', b'9',
    0x03, b'2', b'0', b'0', 0x03, b'2', b'0', b'1', 0x03, b'2', b'0', b'2', 0x03, b'2', b'0', b'3',
    0x03, b'2', b'0', b'4', 0x03, b'2', b'0', b'5', 0x03, b'2', b'0', b'6', 0x03, b'2', b'0', b'7',
    0x03, b'2', b'0', b'8', 0x03, b'2', b'0', b'9', 0x03, b'2', b'1', b'0', 0x03, b'2', b'1', b'1',
    0x03, b'2', b'1', b'2', 0x03, b'2', b'1', b'3', 0x03, b'2', b'1', b'4', 0x03, b'2', b'1', b'5',
    0x03, b'2', b'1', b'6', 0x03, b'2', b'1', b'7', 0x03, b'2', b'1', b'8', 0x03, b'2', b'1', b'9',
    0x03, b'2', b'2', b'0', 0x03, b'2', b'2', b'1', 0x03, b'2', b'2', b'2', 0x03, b'2', b'2', b'3',
    0x03, b'2', b'2', b'4', 0x03, b'2', b'2', b'5', 0x03, b'2', b'2', b'6', 0x03, b'2', b'2', b'7',
    0x03, b'2', b'2', b'8', 0x03, b'2', b'2', b'9', 0x03, b'2', b'3', b'0', 0x03, b'2', b'3', b'1',
    0x03, b'2', b'3', b'2', 0x03, b'2', b'3', b'3', 0x03, b'2', b'3', b'4', 0x03, b'2', b'3', b'5',
    0x03, b'2', b'3', b'6', 0x03, b'2', b'3', b'7', 0x03, b'2', b'3', b'8', 0x03, b'2', b'3', b'9',
    0x03, b'2', b'4', b'0', 0x03, b'2', b'4', b'1', 0x03, b'2', b'4', b'2', 0x03, b'2', b'4', b'3',
    0x03, b'2', b'4', b'4', 0x03, b'2', b'4', b'5', 0x03, b'2', b'4', b'6', 0x03, b'2', b'4', b'7',
    0x03, b'2', b'4', b'8', 0x03, b'2', b'4', b'9', 0x03, b'2', b'5', b'0', 0x03, b'2', b'5', b'1',
    0x03, b'2', b'5', b'2', 0x03, b'2', b'5', b'3', 0x03, b'2', b'5', b'4', 0x03, b'2', b'5', b'5',
    0x03, b'2', b'5', b'6', 0x03, b'2', b'5', b'7', 0x03, b'2', b'5', b'8', 0x03, b'2', b'5', b'9',
    0x03, b'2', b'6', b'0', 0x03, b'2', b'6', b'1', 0x03, b'2', b'6', b'2', 0x03, b'2', b'6', b'3',
    0x03, b'2', b'6', b'4', 0x03, b'2', b'6', b'5', 0x03, b'2', b'6', b'6', 0x03, b'2', b'6', b'7',
    0x03, b'2', b'6', b'8', 0x03, b'2', b'6', b'9', 0x03, b'2', b'7', b'0', 0x03, b'2', b'7', b'1',
    0x03, b'2', b'7', b'2', 0x03, b'2', b'7', b'3', 0x03, b'2', b'7', b'4', 0x03, b'2', b'7', b'5',
    0x03, b'2', b'7', b'6', 0x03, b'2', b'7', b'7', 0x03, b'2', b'7', b'8', 0x03, b'2', b'7', b'9',
    0x03, b'2', b'8', b'0', 0x03, b'2', b'8', b'1', 0x03, b'2', b'8', b'2', 0x03, b'2', b'8', b'3',
    0x03, b'2', b'8', b'4', 0x03, b'2', b'8', b'5', 0x03, b'2', b'8', b'6', 0x03, b'2', b'8', b'7',
    0x03, b'2', b'8', b'8', 0x03, b'2', b'8', b'9', 0x03, b'2', b'9', b'0', 0x03, b'2', b'9', b'1',
    0x03, b'2', b'9', b'2', 0x03, b'2', b'9', b'3', 0x03, b'2', b'9', b'4', 0x03, b'2', b'9', b'5',
    0x03, b'2', b'9', b'6', 0x03, b'2', b'9', b'7', 0x03, b'2', b'9', b'8', 0x03, b'2', b'9', b'9',
    0x03, b'3', b'0', b'0', 0x03, b'3', b'0', b'1', 0x03, b'3', b'0', b'2', 0x03, b'3', b'0', b'3',
    0x03, b'3', b'0', b'4', 0x03, b'3', b'0', b'5', 0x03, b'3', b'0', b'6', 0x03, b'3', b'0', b'7',
    0x03, b'3', b'0', b'8', 0x03, b'3', b'0', b'9', 0x03, b'3', b'1', b'0', 0x03, b'3', b'1', b'1',
    0x03, b'3', b'1', b'2', 0x03, b'3', b'1', b'3', 0x03, b'3', b'1', b'4', 0x03, b'3', b'1', b'5',
    0x03, b'3', b'1', b'6', 0x03, b'3', b'1', b'7', 0x03, b'3', b'1', b'8', 0x03, b'3', b'1', b'9',
    0x03, b'3', b'2', b'0', 0x03, b'3', b'2', b'1', 0x03, b'3', b'2', b'2', 0x03, b'3', b'2', b'3',
    0x03, b'3', b'2', b'4', 0x03, b'3', b'2', b'5', 0x03, b'3', b'2', b'6', 0x03, b'3', b'2', b'7',
    0x03, b'3', b'2', b'8', 0x03, b'3', b'2', b'9', 0x03, b'3', b'3', b'0', 0x03, b'3', b'3', b'1',
    0x03, b'3', b'3', b'2', 0x03, b'3', b'3', b'3', 0x03, b'3', b'3', b'4', 0x03, b'3', b'3', b'5',
    0x03, b'3', b'3', b'6', 0x03, b'3', b'3', b'7', 0x03, b'3', b'3', b'8', 0x03, b'3', b'3', b'9',
    0x03, b'3', b'4', b'0', 0x03, b'3', b'4', b'1', 0x03, b'3', b'4', b'2', 0x03, b'3', b'4', b'3',
    0x03, b'3', b'4', b'4', 0x03, b'3', b'4', b'5', 0x03, b'3', b'4', b'6', 0x03, b'3', b'4', b'7',
    0x03, b'3', b'4', b'8', 0x03, b'3', b'4', b'9', 0x03, b'3', b'5', b'0', 0x03, b'3', b'5', b'1',
    0x03, b'3', b'5', b'2', 0x03, b'3', b'5', b'3', 0x03, b'3', b'5', b'4', 0x03, b'3', b'5', b'5',
    0x03, b'3', b'5', b'6', 0x03, b'3', b'5', b'7', 0x03, b'3', b'5', b'8', 0x03, b'3', b'5', b'9',
    0x03, b'3', b'6', b'0', 0x03, b'3', b'6', b'1', 0x03, b'3', b'6', b'2', 0x03, b'3', b'6', b'3',
    0x03, b'3', b'6', b'4', 0x03, b'3', b'6', b'5', 0x03, b'3', b'6', b'6', 0x03, b'3', b'6', b'7',
    0x03, b'3', b'6', b'8', 0x03, b'3', b'6', b'9', 0x03, b'3', b'7', b'0', 0x03, b'3', b'7', b'1',
    0x03, b'3', b'7', b'2', 0x03, b'3', b'7', b'3', 0x03, b'3', b'7', b'4', 0x03, b'3', b'7', b'5',
    0x03, b'3', b'7', b'6', 0x03, b'3', b'7', b'7', 0x03, b'3', b'7', b'8', 0x03, b'3', b'7', b'9',
    0x03, b'3', b'8', b'0', 0x03, b'3', b'8', b'1', 0x03, b'3', b'8', b'2', 0x03, b'3', b'8', b'3',
    0x03, b'3', b'8', b'4', 0x03, b'3', b'8', b'5', 0x03, b'3', b'8', b'6', 0x03, b'3', b'8', b'7',
    0x03, b'3', b'8', b'8', 0x03, b'3', b'8', b'9', 0x03, b'3', b'9', b'0', 0x03, b'3', b'9', b'1',
    0x03, b'3', b'9', b'2', 0x03, b'3', b'9', b'3', 0x03, b'3', b'9', b'4', 0x03, b'3', b'9', b'5',
    0x03, b'3', b'9', b'6', 0x03, b'3', b'9', b'7', 0x03, b'3', b'9', b'8', 0x03, b'3', b'9', b'9',
    0x03, b'4', b'0', b'0', 0x03, b'4', b'0', b'1', 0x03, b'4', b'0', b'2', 0x03, b'4', b'0', b'3',
    0x03, b'4', b'0', b'4', 0x03, b'4', b'0', b'5', 0x03, b'4', b'0', b'6', 0x03, b'4', b'0', b'7',
    0x03, b'4', b'0', b'8', 0x03, b'4', b'0', b'9', 0x03, b'4', b'1', b'0', 0x03, b'4', b'1', b'1',
    0x03, b'4', b'1', b'2', 0x03, b'4', b'1', b'3', 0x03, b'4', b'1', b'4', 0x03, b'4', b'1', b'5',
    0x03, b'4', b'1', b'6', 0x03, b'4', b'1', b'7', 0x03, b'4', b'1', b'8', 0x03, b'4', b'1', b'9',
    0x03, b'4', b'2', b'0', 0x03, b'4', b'2', b'1', 0x03, b'4', b'2', b'2', 0x03, b'4', b'2', b'3',
    0x03, b'4', b'2', b'4', 0x03, b'4', b'2', b'5', 0x03, b'4', b'2', b'6', 0x03, b'4', b'2', b'7',
    0x03, b'4', b'2', b'8', 0x03, b'4', b'2', b'9', 0x03, b'4', b'3', b'0', 0x03, b'4', b'3', b'1',
    0x03, b'4', b'3', b'2', 0x03, b'4', b'3', b'3', 0x03, b'4', b'3', b'4', 0x03, b'4', b'3', b'5',
    0x03, b'4', b'3', b'6', 0x03, b'4', b'3', b'7', 0x03, b'4', b'3', b'8', 0x03, b'4', b'3', b'9',
    0x03, b'4', b'4', b'0', 0x03, b'4', b'4', b'1', 0x03, b'4', b'4', b'2', 0x03, b'4', b'4', b'3',
    0x03, b'4', b'4', b'4', 0x03, b'4', b'4', b'5', 0x03, b'4', b'4', b'6', 0x03, b'4', b'4', b'7',
    0x03, b'4', b'4', b'8', 0x03, b'4', b'4', b'9', 0x03, b'4', b'5', b'0', 0x03, b'4', b'5', b'1',
    0x03, b'4', b'5', b'2', 0x03, b'4', b'5', b'3', 0x03, b'4', b'5', b'4', 0x03, b'4', b'5', b'5',
    0x03, b'4', b'5', b'6', 0x03, b'4', b'5', b'7', 0x03, b'4', b'5', b'8', 0x03, b'4', b'5', b'9',
    0x03, b'4', b'6', b'0', 0x03, b'4', b'6', b'1', 0x03, b'4', b'6', b'2', 0x03, b'4', b'6', b'3',
    0x03, b'4', b'6', b'4', 0x03, b'4', b'6', b'5', 0x03, b'4', b'6', b'6', 0x03, b'4', b'6', b'7',
    0x03, b'4', b'6', b'8', 0x03, b'4', b'6', b'9', 0x03, b'4', b'7', b'0', 0x03, b'4', b'7', b'1',
    0x03, b'4', b'7', b'2', 0x03, b'4', b'7', b'3', 0x03, b'4', b'7', b'4', 0x03, b'4', b'7', b'5',
    0x03, b'4', b'7', b'6', 0x03, b'4', b'7', b'7', 0x03, b'4', b'7', b'8', 0x03, b'4', b'7', b'9',
    0x03, b'4', b'8', b'0', 0x03, b'4', b'8', b'1', 0x03, b'4', b'8', b'2', 0x03, b'4', b'8', b'3',
    0x03, b'4', b'8', b'4', 0x03, b'4', b'8', b'5', 0x03, b'4', b'8', b'6', 0x03, b'4', b'8', b'7',
    0x03, b'4', b'8', b'8', 0x03, b'4', b'8', b'9', 0x03, b'4', b'9', b'0', 0x03, b'4', b'9', b'1',
    0x03, b'4', b'9', b'2', 0x03, b'4', b'9', b'3', 0x03, b'4', b'9', b'4', 0x03, b'4', b'9', b'5',
    0x03, b'4', b'9', b'6', 0x03, b'4', b'9', b'7', 0x03, b'4', b'9', b'8', 0x03, b'4', b'9', b'9',
    0x03, b'5', b'0', b'0', 0x03, b'5', b'0', b'1', 0x03, b'5', b'0', b'2', 0x03, b'5', b'0', b'3',
    0x03, b'5', b'0', b'4', 0x03, b'5', b'0', b'5', 0x03, b'5', b'0', b'6', 0x03, b'5', b'0', b'7',
    0x03, b'5', b'0', b'8', 0x03, b'5', b'0', b'9', 0x03, b'5', b'1', b'0', 0x03, b'5', b'1', b'1',
    0x03, b'5', b'1', b'2', 0x03, b'5', b'1', b'3', 0x03, b'5', b'1', b'4', 0x03, b'5', b'1', b'5',
    0x03, b'5', b'1', b'6', 0x03, b'5', b'1', b'7', 0x03, b'5', b'1', b'8', 0x03, b'5', b'1', b'9',
    0x03, b'5', b'2', b'0', 0x03, b'5', b'2', b'1', 0x03, b'5', b'2', b'2', 0x03, b'5', b'2', b'3',
    0x03, b'5', b'2', b'4', 0x03, b'5', b'2', b'5', 0x03, b'5', b'2', b'6', 0x03, b'5', b'2', b'7',
    0x03, b'5', b'2', b'8', 0x03, b'5', b'2', b'9', 0x03, b'5', b'3', b'0', 0x03, b'5', b'3', b'1',
    0x03, b'5', b'3', b'2', 0x03, b'5', b'3', b'3', 0x03, b'5', b'3', b'4', 0x03, b'5', b'3', b'5',
    0x03, b'5', b'3', b'6', 0x03, b'5', b'3', b'7', 0x03, b'5', b'3', b'8', 0x03, b'5', b'3', b'9',
    0x03, b'5', b'4', b'0', 0x03, b'5', b'4', b'1', 0x03, b'5', b'4', b'2', 0x03, b'5', b'4', b'3',
    0x03, b'5', b'4', b'4', 0x03, b'5', b'4', b'5', 0x03, b'5', b'4', b'6', 0x03, b'5', b'4', b'7',
    0x03, b'5', b'4', b'8', 0x03, b'5', b'4', b'9', 0x03, b'5', b'5', b'0', 0x03, b'5', b'5', b'1',
    0x03, b'5', b'5', b'2', 0x03, b'5', b'5', b'3', 0x03, b'5', b'5', b'4', 0x03, b'5', b'5', b'5',
    0x03, b'5', b'5', b'6', 0x03, b'5', b'5', b'7', 0x03, b'5', b'5', b'8', 0x03, b'5', b'5', b'9',
    0x03, b'5', b'6', b'0', 0x03, b'5', b'6', b'1', 0x03, b'5', b'6', b'2', 0x03, b'5', b'6', b'3',
    0x03, b'5', b'6', b'4', 0x03, b'5', b'6', b'5', 0x03, b'5', b'6', b'6', 0x03, b'5', b'6', b'7',
    0x03, b'5', b'6', b'8', 0x03, b'5', b'6', b'9', 0x03, b'5', b'7', b'0', 0x03, b'5', b'7', b'1',
    0x03, b'5', b'7', b'2', 0x03, b'5', b'7', b'3', 0x03, b'5', b'7', b'4', 0x03, b'5', b'7', b'5',
    0x03, b'5', b'7', b'6', 0x03, b'5', b'7', b'7', 0x03, b'5', b'7', b'8', 0x03, b'5', b'7', b'9',
    0x03, b'5', b'8', b'0', 0x03, b'5', b'8', b'1', 0x03, b'5', b'8', b'2', 0x03, b'5', b'8', b'3',
    0x03, b'5', b'8', b'4', 0x03, b'5', b'8', b'5', 0x03, b'5', b'8', b'6', 0x03, b'5', b'8', b'7',
    0x03, b'5', b'8', b'8', 0x03, b'5', b'8', b'9', 0x03, b'5', b'9', b'0', 0x03, b'5', b'9', b'1',
    0x03, b'5', b'9', b'2', 0x03, b'5', b'9', b'3', 0x03, b'5', b'9', b'4', 0x03, b'5', b'9', b'5',
    0x03, b'5', b'9', b'6', 0x03, b'5', b'9', b'7', 0x03, b'5', b'9', b'8', 0x03, b'5', b'9', b'9',
    0x03, b'6', b'0', b'0', 0x03, b'6', b'0', b'1', 0x03, b'6', b'0', b'2', 0x03, b'6', b'0', b'3',
    0x03, b'6', b'0', b'4', 0x03, b'6', b'0', b'5', 0x03, b'6', b'0', b'6', 0x03, b'6', b'0', b'7',
    0x03, b'6', b'0', b'8', 0x03, b'6', b'0', b'9', 0x03, b'6', b'1', b'0', 0x03, b'6', b'1', b'1',
    0x03, b'6', b'1', b'2', 0x03, b'6', b'1', b'3', 0x03, b'6', b'1', b'4', 0x03, b'6', b'1', b'5',
    0x03, b'6', b'1', b'6', 0x03, b'6', b'1', b'7', 0x03, b'6', b'1', b'8', 0x03, b'6', b'1', b'9',
    0x03, b'6', b'2', b'0', 0x03, b'6', b'2', b'1', 0x03, b'6', b'2', b'2', 0x03, b'6', b'2', b'3',
    0x03, b'6', b'2', b'4', 0x03, b'6', b'2', b'5', 0x03, b'6', b'2', b'6', 0x03, b'6', b'2', b'7',
    0x03, b'6', b'2', b'8', 0x03, b'6', b'2', b'9', 0x03, b'6', b'3', b'0', 0x03, b'6', b'3', b'1',
    0x03, b'6', b'3', b'2', 0x03, b'6', b'3', b'3', 0x03, b'6', b'3', b'4', 0x03, b'6', b'3', b'5',
    0x03, b'6', b'3', b'6', 0x03, b'6', b'3', b'7', 0x03, b'6', b'3', b'8', 0x03, b'6', b'3', b'9',
    0x03, b'6', b'4', b'0', 0x03, b'6', b'4', b'1', 0x03, b'6', b'4', b'2', 0x03, b'6', b'4', b'3',
    0x03, b'6', b'4', b'4', 0x03, b'6', b'4', b'5', 0x03, b'6', b'4', b'6', 0x03, b'6', b'4', b'7',
    0x03, b'6', b'4', b'8', 0x03, b'6', b'4', b'9', 0x03, b'6', b'5', b'0', 0x03, b'6', b'5', b'1',
    0x03, b'6', b'5', b'2', 0x03, b'6', b'5', b'3', 0x03, b'6', b'5', b'4', 0x03, b'6', b'5', b'5',
    0x03, b'6', b'5', b'6', 0x03, b'6', b'5', b'7', 0x03, b'6', b'5', b'8', 0x03, b'6', b'5', b'9',
    0x03, b'6', b'6', b'0', 0x03, b'6', b'6', b'1', 0x03, b'6', b'6', b'2', 0x03, b'6', b'6', b'3',
    0x03, b'6', b'6', b'4', 0x03, b'6', b'6', b'5', 0x03, b'6', b'6', b'6', 0x03, b'6', b'6', b'7',
    0x03, b'6', b'6', b'8', 0x03, b'6', b'6', b'9', 0x03, b'6', b'7', b'0', 0x03, b'6', b'7', b'1',
    0x03, b'6', b'7', b'2', 0x03, b'6', b'7', b'3', 0x03, b'6', b'7', b'4', 0x03, b'6', b'7', b'5',
    0x03, b'6', b'7', b'6', 0x03, b'6', b'7', b'7', 0x03, b'6', b'7', b'8', 0x03, b'6', b'7', b'9',
    0x03, b'6', b'8', b'0', 0x03, b'6', b'8', b'1', 0x03, b'6', b'8', b'2', 0x03, b'6', b'8', b'3',
    0x03, b'6', b'8', b'4', 0x03, b'6', b'8', b'5', 0x03, b'6', b'8', b'6', 0x03, b'6', b'8', b'7',
    0x03, b'6', b'8', b'8', 0x03, b'6', b'8', b'9', 0x03, b'6', b'9', b'0', 0x03, b'6', b'9', b'1',
    0x03, b'6', b'9', b'2', 0x03, b'6', b'9', b'3', 0x03, b'6', b'9', b'4', 0x03, b'6', b'9', b'5',
    0x03, b'6', b'9', b'6', 0x03, b'6', b'9', b'7', 0x03, b'6', b'9', b'8', 0x03, b'6', b'9', b'9',
    0x03, b'7', b'0', b'0', 0x03, b'7', b'0', b'1', 0x03, b'7', b'0', b'2', 0x03, b'7', b'0', b'3',
    0x03, b'7', b'0', b'4', 0x03, b'7', b'0', b'5', 0x03, b'7', b'0', b'6', 0x03, b'7', b'0', b'7',
    0x03, b'7', b'0', b'8', 0x03, b'7', b'0', b'9', 0x03, b'7', b'1', b'0', 0x03, b'7', b'1', b'1',
    0x03, b'7', b'1', b'2', 0x03, b'7', b'1', b'3', 0x03, b'7', b'1', b'4', 0x03, b'7', b'1', b'5',
    0x03, b'7', b'1', b'6', 0x03, b'7', b'1', b'7', 0x03, b'7', b'1', b'8', 0x03, b'7', b'1', b'9',
    0x03, b'7', b'2', b'0', 0x03, b'7', b'2', b'1', 0x03, b'7', b'2', b'2', 0x03, b'7', b'2', b'3',
    0x03, b'7', b'2', b'4', 0x03, b'7', b'2', b'5', 0x03, b'7', b'2', b'6', 0x03, b'7', b'2', b'7',
    0x03, b'7', b'2', b'8', 0x03, b'7', b'2', b'9', 0x03, b'7', b'3', b'0', 0x03, b'7', b'3', b'1',
    0x03, b'7', b'3', b'2', 0x03, b'7', b'3', b'3', 0x03, b'7', b'3', b'4', 0x03, b'7', b'3', b'5',
    0x03, b'7', b'3', b'6', 0x03, b'7', b'3', b'7', 0x03, b'7', b'3', b'8', 0x03, b'7', b'3', b'9',
    0x03, b'7', b'4', b'0', 0x03, b'7', b'4', b'1', 0x03, b'7', b'4', b'2', 0x03, b'7', b'4', b'3',
    0x03, b'7', b'4', b'4', 0x03, b'7', b'4', b'5', 0x03, b'7', b'4', b'6', 0x03, b'7', b'4', b'7',
    0x03, b'7', b'4', b'8', 0x03, b'7', b'4', b'9', 0x03, b'7', b'5', b'0', 0x03, b'7', b'5', b'1',
    0x03, b'7', b'5', b'2', 0x03, b'7', b'5', b'3', 0x03, b'7', b'5', b'4', 0x03, b'7', b'5', b'5',
    0x03, b'7', b'5', b'6', 0x03, b'7', b'5', b'7', 0x03, b'7', b'5', b'8', 0x03, b'7', b'5', b'9',
    0x03, b'7', b'6', b'0', 0x03, b'7', b'6', b'1', 0x03, b'7', b'6', b'2', 0x03, b'7', b'6', b'3',
    0x03, b'7', b'6', b'4', 0x03, b'7', b'6', b'5', 0x03, b'7', b'6', b'6', 0x03, b'7', b'6', b'7',
    0x03, b'7', b'6', b'8', 0x03, b'7', b'6', b'9', 0x03, b'7', b'7', b'0', 0x03, b'7', b'7', b'1',
    0x03, b'7', b'7', b'2', 0x03, b'7', b'7', b'3', 0x03, b'7', b'7', b'4', 0x03, b'7', b'7', b'5',
    0x03, b'7', b'7', b'6', 0x03, b'7', b'7', b'7', 0x03, b'7', b'7', b'8', 0x03, b'7', b'7', b'9',
    0x03, b'7', b'8', b'0', 0x03, b'7', b'8', b'1', 0x03, b'7', b'8', b'2', 0x03, b'7', b'8', b'3',
    0x03, b'7', b'8', b'4', 0x03, b'7', b'8', b'5', 0x03, b'7', b'8', b'6', 0x03, b'7', b'8', b'7',
    0x03, b'7', b'8', b'8', 0x03, b'7', b'8', b'9', 0x03, b'7', b'9', b'0', 0x03, b'7', b'9', b'1',
    0x03, b'7', b'9', b'2', 0x03, b'7', b'9', b'3', 0x03, b'7', b'9', b'4', 0x03, b'7', b'9', b'5',
    0x03, b'7', b'9', b'6', 0x03, b'7', b'9', b'7', 0x03, b'7', b'9', b'8', 0x03, b'7', b'9', b'9',
    0x03, b'8', b'0', b'0', 0x03, b'8', b'0', b'1', 0x03, b'8', b'0', b'2', 0x03, b'8', b'0', b'3',
    0x03, b'8', b'0', b'4', 0x03, b'8', b'0', b'5', 0x03, b'8', b'0', b'6', 0x03, b'8', b'0', b'7',
    0x03, b'8', b'0', b'8', 0x03, b'8', b'0', b'9', 0x03, b'8', b'1', b'0', 0x03, b'8', b'1', b'1',
    0x03, b'8', b'1', b'2', 0x03, b'8', b'1', b'3', 0x03, b'8', b'1', b'4', 0x03, b'8', b'1', b'5',
    0x03, b'8', b'1', b'6', 0x03, b'8', b'1', b'7', 0x03, b'8', b'1', b'8', 0x03, b'8', b'1', b'9',
    0x03, b'8', b'2', b'0', 0x03, b'8', b'2', b'1', 0x03, b'8', b'2', b'2', 0x03, b'8', b'2', b'3',
    0x03, b'8', b'2', b'4', 0x03, b'8', b'2', b'5', 0x03, b'8', b'2', b'6', 0x03, b'8', b'2', b'7',
    0x03, b'8', b'2', b'8', 0x03, b'8', b'2', b'9', 0x03, b'8', b'3', b'0', 0x03, b'8', b'3', b'1',
    0x03, b'8', b'3', b'2', 0x03, b'8', b'3', b'3', 0x03, b'8', b'3', b'4', 0x03, b'8', b'3', b'5',
    0x03, b'8', b'3', b'6', 0x03, b'8', b'3', b'7', 0x03, b'8', b'3', b'8', 0x03, b'8', b'3', b'9',
    0x03, b'8', b'4', b'0', 0x03, b'8', b'4', b'1', 0x03, b'8', b'4', b'2', 0x03, b'8', b'4', b'3',
    0x03, b'8', b'4', b'4', 0x03, b'8', b'4', b'5', 0x03, b'8', b'4', b'6', 0x03, b'8', b'4', b'7',
    0x03, b'8', b'4', b'8', 0x03, b'8', b'4', b'9', 0x03, b'8', b'5', b'0', 0x03, b'8', b'5', b'1',
    0x03, b'8', b'5', b'2', 0x03, b'8', b'5', b'3', 0x03, b'8', b'5', b'4', 0x03, b'8', b'5', b'5',
    0x03, b'8', b'5', b'6', 0x03, b'8', b'5', b'7', 0x03, b'8', b'5', b'8', 0x03, b'8', b'5', b'9',
    0x03, b'8', b'6', b'0', 0x03, b'8', b'6', b'1', 0x03, b'8', b'6', b'2', 0x03, b'8', b'6', b'3',
    0x03, b'8', b'6', b'4', 0x03, b'8', b'6', b'5', 0x03, b'8', b'6', b'6', 0x03, b'8', b'6', b'7',
    0x03, b'8', b'6', b'8', 0x03, b'8', b'6', b'9', 0x03, b'8', b'7', b'0', 0x03, b'8', b'7', b'1',
    0x03, b'8', b'7', b'2', 0x03, b'8', b'7', b'3', 0x03, b'8', b'7', b'4', 0x03, b'8', b'7', b'5',
    0x03, b'8', b'7', b'6', 0x03, b'8', b'7', b'7', 0x03, b'8', b'7', b'8', 0x03, b'8', b'7', b'9',
    0x03, b'8', b'8', b'0', 0x03, b'8', b'8', b'1', 0x03, b'8', b'8', b'2', 0x03, b'8', b'8', b'3',
    0x03, b'8', b'8', b'4', 0x03, b'8', b'8', b'5', 0x03, b'8', b'8', b'6', 0x03, b'8', b'8', b'7',
    0x03, b'8', b'8', b'8', 0x03, b'8', b'8', b'9', 0x03, b'8', b'9', b'0', 0x03, b'8', b'9', b'1',
    0x03, b'8', b'9', b'2', 0x03, b'8', b'9', b'3', 0x03, b'8', b'9', b'4', 0x03, b'8', b'9', b'5',
    0x03, b'8', b'9', b'6', 0x03, b'8', b'9', b'7', 0x03, b'8', b'9', b'8', 0x03, b'8', b'9', b'9',
    0x03, b'9', b'0', b'0', 0x03, b'9', b'0', b'1', 0x03, b'9', b'0', b'2', 0x03, b'9', b'0', b'3',
    0x03, b'9', b'0', b'4', 0x03, b'9', b'0', b'5', 0x03, b'9', b'0', b'6', 0x03, b'9', b'0', b'7',
    0x03, b'9', b'0', b'8', 0x03, b'9', b'0', b'9', 0x03, b'9', b'1', b'0', 0x03, b'9', b'1', b'1',
    0x03, b'9', b'1', b'2', 0x03, b'9', b'1', b'3', 0x03, b'9', b'1', b'4', 0x03, b'9', b'1', b'5',
    0x03, b'9', b'1', b'6', 0x03, b'9', b'1', b'7', 0x03, b'9', b'1', b'8', 0x03, b'9', b'1', b'9',
    0x03, b'9', b'2', b'0', 0x03, b'9', b'2', b'1', 0x03, b'9', b'2', b'2', 0x03, b'9', b'2', b'3',
    0x03, b'9', b'2', b'4', 0x03, b'9', b'2', b'5', 0x03, b'9', b'2', b'6', 0x03, b'9', b'2', b'7',
    0x03, b'9', b'2', b'8', 0x03, b'9', b'2', b'9', 0x03, b'9', b'3', b'0', 0x03, b'9', b'3', b'1',
    0x03, b'9', b'3', b'2', 0x03, b'9', b'3', b'3', 0x03, b'9', b'3', b'4', 0x03, b'9', b'3', b'5',
    0x03, b'9', b'3', b'6', 0x03, b'9', b'3', b'7', 0x03, b'9', b'3', b'8', 0x03, b'9', b'3', b'9',
    0x03, b'9', b'4', b'0', 0x03, b'9', b'4', b'1', 0x03, b'9', b'4', b'2', 0x03, b'9', b'4', b'3',
    0x03, b'9', b'4', b'4', 0x03, b'9', b'4', b'5', 0x03, b'9', b'4', b'6', 0x03, b'9', b'4', b'7',
    0x03, b'9', b'4', b'8', 0x03, b'9', b'4', b'9', 0x03, b'9', b'5', b'0', 0x03, b'9', b'5', b'1',
    0x03, b'9', b'5', b'2', 0x03, b'9', b'5', b'3', 0x03, b'9', b'5', b'4', 0x03, b'9', b'5', b'5',
    0x03, b'9', b'5', b'6', 0x03, b'9', b'5', b'7', 0x03, b'9', b'5', b'8', 0x03, b'9', b'5', b'9',
    0x03, b'9', b'6', b'0', 0x03, b'9', b'6', b'1', 0x03, b'9', b'6', b'2', 0x03, b'9', b'6', b'3',
    0x03, b'9', b'6', b'4', 0x03, b'9', b'6', b'5', 0x03, b'9', b'6', b'6', 0x03, b'9', b'6', b'7',
    0x03, b'9', b'6', b'8', 0x03, b'9', b'6', b'9', 0x03, b'9', b'7', b'0', 0x03, b'9', b'7', b'1',
    0x03, b'9', b'7', b'2', 0x03, b'9', b'7', b'3', 0x03, b'9', b'7', b'4', 0x03, b'9', b'7', b'5',
    0x03, b'9', b'7', b'6', 0x03, b'9', b'7', b'7', 0x03, b'9', b'7', b'8', 0x03, b'9', b'7', b'9',
    0x03, b'9', b'8', b'0', 0x03, b'9', b'8', b'1', 0x03, b'9', b'8', b'2', 0x03, b'9', b'8', b'3',
    0x03, b'9', b'8', b'4', 0x03, b'9', b'8', b'5', 0x03, b'9', b'8', b'6', 0x03, b'9', b'8', b'7',
    0x03, b'9', b'8', b'8', 0x03, b'9', b'8', b'9', 0x03, b'9', b'9', b'0', 0x03, b'9', b'9', b'1',
    0x03, b'9', b'9', b'2', 0x03, b'9', b'9', b'3', 0x03, b'9', b'9', b'4', 0x03, b'9', b'9', b'5',
    0x03, b'9', b'9', b'6', 0x03, b'9', b'9', b'7', 0x03, b'9', b'9', b'8', 0x03, b'9', b'9', b'9',
    0x00,
];

#[inline]
pub(crate) fn d3_to_str(val: i32, buf: &mut Vec<u8>, elim_heading_zeroes: bool) -> bool {
    let val = val as usize;
    if !elim_heading_zeroes {
        buf.extend_from_slice(&BIN2CHAR[val * 4 + 1..val * 4 + 4]);
        return false;
    }
    let cl = BIN2CHAR[val * 4];
    if cl > 0 {
        // lookup char length, might be 0-3
        let start_idx = val * 4 + 4 - cl as usize;
        buf.extend_from_slice(&BIN2CHAR[start_idx..start_idx + cl as usize]);
        return false;
    }
    // skip if eliminating heading zeros and cl == 0
    true
}

#[inline]
pub(crate) fn unit_leading_zeroes(val: i32) -> usize {
    if val >= 100_000_000 {
        return 0;
    }
    if val >= 10_000_000 {
        return 1;
    }
    if val >= 1_000_000 {
        return 2;
    }
    if val >= 100_000 {
        return 3;
    }
    if val >= 10_000 {
        return 4;
    }
    if val >= 1_000 {
        return 5;
    }
    if val >= 100 {
        return 6;
    }
    if val >= 10 {
        return 7;
    }
    if val >= 1 {
        return 8;
    }
    9
}

#[inline]
pub(crate) fn units_greater_equal(lhs: &[i32], rhs: &[i32]) -> bool {
    if lhs.len() > rhs.len() {
        for (l, r) in lhs
            .iter()
            .rev()
            .zip(rhs.iter().rev().chain(std::iter::repeat(&0)))
        {
            if l > r {
                return true;
            }
            if l < r {
                return false;
            }
        }
        return true;
    }
    for (l, r) in lhs
        .iter()
        .rev()
        .chain(std::iter::repeat(&0))
        .zip(rhs.iter().rev())
    {
        if l > r {
            return true;
        }
        if l < r {
            return false;
        }
    }
    true
}

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn test_units_greater_equal() {
        for (lhs, rhs, expected) in vec![
            (vec![1], vec![1], true),
            (vec![2], vec![1], true),
            (vec![1], vec![2], false),
            (vec![1, 1], vec![1, 1], true),
            (vec![1, 1], vec![2, 1], false),
            (vec![2, 1], vec![1, 1], true),
            (vec![2, 1], vec![1, 2], false),
            (vec![1, 1], vec![1, 2], false),
            (vec![1, 2], vec![1, 2], true),
            (vec![0, 2], vec![1, 2], false),
            (vec![1, 1, 1], vec![1, 1], true),
            (vec![0, 1, 1], vec![1, 1], true),
            (vec![1, 1, 1], vec![2, 1], false),
            (vec![1, 1], vec![0, 1, 1], true),
            (vec![1, 1], vec![1, 1, 1], false),
        ] {
            let actual = units_greater_equal(&lhs, &rhs);
            assert_eq!(actual, expected);
        }
    }
}
