use std::path::PathBuf;

use crate::traits::{SaveToStatsFolder, Sensor};

/// A sensor that does nothing.
///
/// In practice, it is used in conjunction with [`UnitPool`](crate::sensors_and_pools::UnitPool) to
/// favour one particular test case throughout the whole fuzzing run. This is partly how the `minify`
/// command is implemented.
pub struct NoopSensor;

impl Sensor for NoopSensor {
    type Observations = ();
    #[no_coverage]
    fn start_recording(&mut self) {}
    #[no_coverage]
    fn stop_recording(&mut self) {}

    #[no_coverage]
    fn get_observations(&mut self) {}
}
impl SaveToStatsFolder for NoopSensor {
    #[no_coverage]
    fn save_to_stats_folder(&self) -> Vec<(PathBuf, Vec<u8>)> {
        vec![]
    }
}
