#![allow(unused)]

use std::collections::{LinkedList, VecDeque, HashMap};
// use std::ops::{Deref, Index};

pub fn vector_demo() {
    let mut flights:Vec<&str> = Vec::new();
    flights.push("DA113\tto Boston departs at 06:20");
    flights.push("DA98\tto London departs at 09:43");
    flights.push("DA428\tto Salt Lake City departs at 12:05");
    flights.push("DA41\tto Berlin departs at 15:30");
    flights.push("DA2815\tto Nashville departs at 17:11");

    flights.insert(2, "DA918\tto Orlando departs at 11:12");

    let ve = vec![1,2,3];
    //new_vector.remove(0);

    let raw_value = flights[3];

    for flight in flights.iter() {
        println!("{}", flight);
    }

    if let Some(flight_value) = flights.get(5) {
        println!("{}", flight_value);
    }



    match flights.first() {
        Some(number) => {
            println!("{}", number);
        }
        _ => {}
    }
}

pub fn vector_deque_demo() {
    let mut flights:VecDeque<&str> = VecDeque::new();

    flights.push_front("DA918\tto Orlando departs at 11:12");
    flights.push_back("DA428\tto Salt Lake City departs at 12:05");
    flights.push_front("DA98\tto London departs at 09:43");
    flights.push_front("DA113\tto Boston departs at 06:20");
    flights.push_back("DA41\tto Berlin departs at 15:30");
    flights.push_back("DA2815\tto Nashville departs at 17:11");
    
    for flight in flights.iter() {
        println!("{}", flight);
    }

    println!("{}", flights.contains(&"DA98\tto London departs at 09:43"));

}

pub fn map_demo() {
    let mut flights = HashMap::new();
    flights.insert("DA918", ("11:12", "Orlando"));
    flights.insert("DA428", ("12:05", "Salt Lake City"));
    flights.insert("DA98", ("09:43", "London"));
    flights.insert("DA113", ("06:20", "Boston"));
    flights.insert("DA41", ("15:30", "Berlin"));
    flights.insert("DA2815", ("17:11", "Nashville"));

    let option = flights.get("DA41");
    println!("{:?}", option);

    for flight in flights.iter() {
        println!("{:?}", flight);
    }
}

pub fn linked_list_demo() {
    let mut linked_list:LinkedList<i32> = LinkedList::new();
    linked_list.push_front(1);
    linked_list.push_back(2);
    linked_list.push_back(3);
    linked_list.push_back(4);
    linked_list.push_back(5);
    linked_list.push_back(6);
    linked_list.push_back(7);
    linked_list.push_back(8);
    linked_list.push_back(9);
    linked_list.push_back(10);

    let linked_list_2: LinkedList<i32> = linked_list.split_off(5);
}