# fuego
Port Scanner API

This is an API to use in "Pelican", a free and open source data gathering platform.
Still in more of a prototyping phase.

here are the available things
```rust
    use fuego::carriers::{CommonCarrier, RadioFlyer};
    use fuego::constants::COMMON_PORTS;
#[tokio::main]
async fn main() -> Result<(), Box<dyn std::error::Error>> {
    
    //Get a banner
        let record = RadioFlyer::get_banner("example.com", 80);
        assert_eq!(record.is_ok(), true);
        println!("{:?}", record.unwrap());

        let record = RadioFlyer::string_drop(
            "example.com",
            "GET / HTTP/1.1\n\n",
            80
        );
        assert_eq!(record.is_ok(), true);
        println!("{:?}", record.unwrap());
    
    //Get the hosts
        let hosts = RadioFlyer::host_drop("example.com");
        assert_eq!(hosts.is_ok(), true);
        let unwrapped = hosts.unwrap();
        assert_eq!(unwrapped.len() > 0, true);
        println!("{:?}", hosts);
    
    //Port scan a host
        let ports: Vec<u16> = COMMON_PORTS.to_vec();
        let record = RadioFlyer::scan_drop("8.8.8.8", ports, 100);
        assert_eq!(record.is_ok(), true);
        println!("{:?}", record.unwrap());

    //Banner scan a host
        let ports: Vec<u16> = COMMON_PORTS.to_vec();
        let record = RadioFlyer::banner_drop("example.com", ports, 100);
        assert_eq!(record.is_ok(), true);
        println!("{:?}", record.unwrap());
    
    //Scan multiple hosts with common ports
        let ports: Vec<u16> = COMMON_PORTS.to_vec();
        let record = RadioFlyer::scan_drops(
            vec![
                "2001:4860:4860:0000:0000:0000:0000:8888",
                "8.8.8.8",
                "8.8.4.4",
                "example.com",
            ],
            ports,
            50,
        );
        assert_eq!(record.is_ok(), true);
        println!("{:?}", record.unwrap());

    //Banner scan multiple hosts
        let ports: Vec<u16> = COMMON_PORTS.to_vec();
        let record = RadioFlyer::banner_drops(
            vec![
                "2001:4860:4860:0000:0000:0000:0000:8888",
                "8.8.8.8",
                "8.8.4.4",
                "example.com",
            ],
            ports,
            50,
        );
        assert_eq!(record.is_ok(), true);
        println!("{:?}", record.unwrap());

    //from a json file
        let record = CommonCarrier::from_file("./assets/import_test.json");
        assert_eq!(record.is_ok(), true);
        let unwrapped = record.unwrap();
        println!("{:?}", record.unwrap());
}


```
##JSON format example

```json
{
  "addresses": [{
    "host": "google.com",
    "ports": [53, 123, 8006]
  },
    {
      "host": "example.com",
      "ports": [53, 123]
    },
    {
      "host": "8.8.8.8",
      "ports": [53, 123]
    },
    {
      "host": "8.8.4.4",
      "ports": [53, 123]
    },
    {
      "host": "2001:4860:4860:0000:0000:0000:0000:8888",
      "ports": [53, 123]
    }
  ],
  "global_ports": [80,443]
}
```
