# fs-hdfs

It's based on the version ``0.0.4`` of http://hyunsik.github.io/hdfs-rs to provide libhdfs binding library and rust APIs which safely wraps libhdfs binding APIs.

# Current Status
* All libhdfs FFI APIs are ported.
* Safe Rust wrapping APIs to cover most of the libhdfs APIs except those related to zero-copy read.
* Compared to hdfs-rs, it removes the lifetime in HdfsFs, which will be more friendly for others to depend on.

## Documentation
* [API documentation] (https://yahonanjing.github.io/fs-hdfs)

## Requirements
* Hadoop compiled with native library (i.e., maven profile ``-Pnative``)
    * Please refer to https://github.com/apache/hadoop/blob/trunk/BUILDING.txt if you need more description.
* The C related files are from the branch ``3.3.1`` of hadoop repository. For rust usage, a few changes are also applied.

## Usage
Add this to your Cargo.toml:

```toml
[dependencies]
fs-hdfs = "0.1.1"
```

fs-hdfs uses libhdfs. Firstly, we need to add library path to find the libhdfs. An example for MacOS,

```sh
export DYLD_LIBRARY_PATH=$HADOOP_HOME/lib/native:$JAVA_HOME/jre/lib/server
```

Here, ``$HADOOP_HOME`` and ``$JAVA_HOME`` need to be specified and exported.

Since our dependent libhdfs is JNI native implementation, it requires the proper ``CLASSPATH``. An example,

```sh
export CLASSPATH=$CLASSPATH:`hadoop classpath`
```

## Testing
The test also requires the ``CLASSPATH``. In case that the java class of ``org.junit.Assert`` can't be found. Refine the ``$CLASSPATH`` as follows:

```sh
export CLASSPATH=$CLASSPATH:`hadoop classpath`:$HADOOP_HOME/share/hadoop/tools/lib/*
```

Then you can run

```bash
cargo test
```

## Example

```rust
use hdfs::hdfs::HdfsFs;

let fs: HdfsFs = HdfsFs::new("hdfs://localhost:8020/").ok().unwrap();
match fs.mkdir("/data") {
    Ok(_) => { println!("/data has been created") },
    Err(_)  => { panic!("/data creation has failed") }
};
```