//!
//! Roast functions
//!
pub mod new_roast;

#[cfg(test)]
mod tests {
    use super::new_roast::time_now;
    use super::new_roast::*;
    use std::io::Result;

    #[test]
    fn test_new_roast() -> Result<()> {
        let mut bean = Bean::default();
        bean.bean_nickname = "test_bean".to_string();
        let mut roast = Roast::new(bean.clone());
        let db_file = "test_roastdb";
        init_db(db_file).unwrap();
        bean.insert(db_file).unwrap();
        let event = RoastEvent::BeansIn();
        event.handle(&mut roast)?;
        roast.delete(db_file).unwrap();
        bean.delete(db_file).unwrap();
        Ok(())
    }

    #[test]
    fn test_timenow() -> std::io::Result<()> {
        let ts = time_now();
        assert_ne!(ts, time_now());
        Ok(())
    }
}
