//!
//! Roast functions
//!
pub mod new_roast;

#[cfg(test)]
mod tests {
    use super::new_roast::*;
    use std::io::Result;

    #[test]
    fn test_new_roast() -> Result<()> {
        let mut bean = Bean::default();
        bean.bean_nickname = "test_bean".to_string();
        let roast = Roast::new(bean.clone());
        let db_file = "test_roastdb";
        init_db(db_file).unwrap();
        bean.insert(db_file).unwrap();
        let event = RoastEvent::BeansIn();
        handle_roast_event(event, roast.to_owned())?;
        roast.delete(db_file).unwrap();
        bean.delete(db_file).unwrap();
        Ok(())
    }
}
