//!
//! Runs the roast
//!
extern crate chrono;
extern crate uuid;

use freeroast::roast::new_roast::*;
use std::io;
use std::io::Result;

///
/// Checks the IO buffer when collecting
/// timestamps
///
fn check_buff(buff: String) {
    if buff != "\n" {
        panic!("Invalid input");
    }
}

fn main() -> Result<()> {
    // Create new bean struct
    let mut bean = Bean::default();

    // Buffer for stdin
    let mut buff = &mut String::new();

    // Set filename for database
    let db_file = "roastdb";

    // Initialize database
    init_db(db_file).unwrap();

    // Get bean from user
    println!("Enter the name of the bean ");
    let stdin = io::stdin();
    stdin.read_line(&mut buff)?;
    buff.pop();
    if buff.ends_with('\n') {
        println!("Ends with newline");
        buff.pop();
        bean.bean_nickname = buff.to_string();
    }
    bean.bean_nickname = buff.to_string();

    // Get name from database if exists
    bean.get(db_file).unwrap();

    // Create new roast instance
    let mut new_roast = &mut Roast::new(bean.to_owned());

    println!("Bean name you entered: {}", bean.bean_nickname);
    String::clear(&mut buff);

    // Get starting weight from user
    println!("Enter starting weight: ");
    stdin.read_line(&mut buff)?;
    new_roast.starting_weight = buff.trim().parse::<u32>().unwrap();
    println!("Starting weight: {}", new_roast.starting_weight);
    String::clear(&mut buff);

    // Get time beans were put in
    println!("Press ENTER when you put beans in ");
    stdin.read_line(&mut buff)?;
    check_buff(buff.to_string());
    handle_roast_event(RoastEvent::BeansIn(), new_roast.to_owned())?;

    // Clear buff
    String::clear(&mut buff);
    // Get start of first crack
    println!("Press ENTER when first crack starts");
    stdin.read_line(&mut buff)?;
    check_buff(buff.to_string());
    handle_roast_event(RoastEvent::FirstCrackStart(), new_roast.to_owned())?;

    // Clear buff
    String::clear(&mut buff);

    // Get the end of first crack
    println!("Press ENTER when first crack is done");
    io::stdin().read_line(&mut buff)?;
    check_buff(buff.to_string());
    handle_roast_event(RoastEvent::FirstCrackEnd(), new_roast.to_owned())?;

    // Clear buff
    String::clear(&mut buff);

    // Determine weather second crack is going to happen
    println!("Enter \"s\" if going to second crack. Press any other key to end roast");
    stdin.read_line(buff)?;
    if buff.eq(&mut "s\n") {
        String::clear(&mut buff);
        println!("Press ENTER when second crack starts ");
        io::stdin().read_line(buff)?;
        check_buff(buff.to_string());
        handle_roast_event(RoastEvent::SecondCrackStart(), new_roast.to_owned())?;
        String::clear(&mut buff);

        println!(
            "Press ENTER to end roast or \"s\" to record end of second crack and keep roasting"
        );
        io::stdin().read_line(buff)?;
        if buff.eq(&mut "s\n") {
            handle_roast_event(RoastEvent::SecondCrackEnd(), new_roast.to_owned())?;
            String::clear(&mut buff);
            println!("Press ENTER to end roast");
            stdin.read_line(buff)?;
            check_buff(buff.to_string());
            handle_roast_event(RoastEvent::EndRoast(), new_roast.to_owned())?;
        }
    } else {
        handle_roast_event(RoastEvent::EndRoast(), new_roast.to_owned())?;
        new_roast.insert(db_file).unwrap();
    }

    Ok(())
}
