extern crate chrono;
extern crate uuid;

pub use crate::db::{init_db::*, roasts::*};
use chrono::NaiveDateTime;
use std::io::Result;

pub fn time_now() -> NaiveDateTime {
    chrono::Utc::now().naive_utc()
}

pub enum RoastEvent {
    BeansIn(),
    FirstCrackStart(),
    FirstCrackEnd(),
    SecondCrackStart(),
    SecondCrackEnd(),
    EndRoast(),
}

/// Meant to handle events durring roast
pub fn handle_roast_event(event: RoastEvent, mut roast: Roast) -> Result<()> {
    match event {
        RoastEvent::BeansIn() => {
            roast.beans_in = time_now();
            println!("Beans put in at {}", roast.beans_in);
        }
        RoastEvent::FirstCrackStart() => {
            roast.first_crack_start = time_now();
            println!("First crack started at {}", roast.first_crack_start);
        }
        RoastEvent::FirstCrackEnd() => {
            roast.first_crack_finish = time_now();
            println!("Fisrt crack ended at {}", roast.first_crack_finish);
        }
        RoastEvent::SecondCrackStart() => {
            roast.second_crack_start = Some(time_now());
            println!(
                "Second crack started at {}",
                roast.second_crack_start.unwrap()
            );
        }
        RoastEvent::SecondCrackEnd() => {
            roast.second_crack_finish = Some(time_now());
            println!(
                "Second crack ended at {}",
                roast.second_crack_finish.unwrap()
            );
        }
        RoastEvent::EndRoast() => {
            roast.beans_out = time_now();
            println!("Roast ended at {}", roast.beans_out);
        }
    }
    Ok(())
}
