//!
//! Database mappings and methods
//! for roasts and beans
//!
pub mod beans;
pub mod init_db;
pub mod roasts;

#[cfg(test)]
mod tests {
    use super::{init_db::*, roasts::*};

    #[test]
    fn test_bean() {
        let db_file = "test_roastdb";
        init_db(db_file).expect("Problem initializing database");
        let mut bean = Bean::default();
        bean.id = uuid::Uuid::new_v4().to_string();
        bean.bean_nickname = "test_bean".to_string();
        bean.bean_nickname = "test_bean".to_string();
        bean.country_of_origin = "Rwanda".to_string();
        bean.region = "test_region".to_string();
        bean.grower = "test_grower".to_string();

        bean.insert(db_file).expect("Problem inserting bean data");

        bean.get(db_file).unwrap();

        bean.delete(db_file).unwrap();
    }

    #[test]
    fn test_roast() -> std::io::Result<()> {
        let mut bean: Bean = Bean::default();
        bean.id = uuid::Uuid::new_v4().to_string();
        bean.bean_nickname = "test_bean".to_string();
        bean.bean_nickname = "test_bean".to_string();
        bean.country_of_origin = "Rwanda".to_string();
        bean.region = "test_region".to_string();
        bean.grower = "test_grower".to_string();

        let mut roast = Roast::new(bean.clone());

        let db_file = "test_roastdb";

        init_db(db_file).unwrap();

        bean.insert(db_file).unwrap();

        roast.bean_name = bean.clone().bean_nickname;
        roast.starting_weight = 11;

        roast.insert(db_file).expect("Problem inserting roast");

        let new_roast = Roast::new(bean.clone());
        new_roast
            .insert(db_file)
            .expect("Problem inserting new roast");

        new_roast.delete(db_file).unwrap();
        roast.delete(db_file).unwrap();
        bean.delete(db_file).unwrap();

        Ok(())
    }
}
