//!
//! Database configuration
//!
extern crate rusqlite;

use rusqlite::{Connection, Result};

/// Initialize new sqlite database if none exist already
pub fn init_db(db_file: &'static str) -> Result<()> {
    let mut conn = Connection::open(db_file)?;

    let tx = conn.transaction()?;

    // Enable foreign keys
    tx.execute("PRAGMA foreign_keys = ON;", [])?;

    // Create beans table in database
    tx.execute(
        "
            CREATE TABLE IF NOT EXISTS beans (
                id TEXT UNIQUE NOT NULL PRIMARY KEY,
                bean_nickname TEXT NOT NULL UNIQUE,
                country_of_origin TEXT NOT NULL,
                region TEXT NOT NULL,
                grower TEXT NOT NULL
            );
            ",
        [],
    )?;

    // Create roasts table in database
    tx.execute(
        "
            CREATE TABLE IF NOT EXISTS roasts (
                id TEXT NOT NULL PRIMARY KEY,
                bean_name TEXT NOT NULL,
                starting_weight INTEGER NOT NULL,
                beans_in INTEGER NOT NULL,
                first_crack_start INTEGER NOT NULL,
                first_crack_finish INTEGER NOT NULL,
                second_crack_start INTEGER DEFAULT NULL,
                second_crack_finish INTEGER DEFAULT NULL,
                beans_out INTEGER NOT NULL,
                FOREIGN KEY (bean_name) 
                    REFERENCES beans (bean_nickname)
                    ON DELETE RESTRICT
            );
            ",
        [],
    )?;

    tx.commit()?;

    Ok(())
}
