extern crate rusqlite;

// Database mappings for data objects
use rusqlite::{Connection, Result};

// Initialize new sqlite database if none exist already
pub fn init_db(db_file: &'static str) -> Result<()> {
    let conn = Connection::open(db_file)?;

    // Create roasts table in database
    conn.execute(
        "
            CREATE TABLE IF NOT EXISTS roasts (
                id TEXT PRIMARY KEY,
                bean_name TEXT NOT NULL,
                starting_weight INTEGER NOT NULL,
                beans_in INTEGER NOT NULL,
                first_crack_start INTEGER NOT NULL,
                first_crack_finish INTEGER NOT NULL,
                second_crack_start INTEGER DEFAULT NULL,
                second_crack_finish INTEGER DEFAULT NULL,
                beans_out INTEGER NOT NULL
            );
            ",
        [],
    )?;

    // Create beans table in database
    conn.execute(
        "
            CREATE TABLE IF NOT EXISTS beans (
                id TEXT UNIQUE NOT NULL PRIMARY KEY,
                bean_nickname TEXT UNIQUE NOT NULL,
                country_of_origin TEXT NOT NULL,
                region TEXT NOT NULL,
                grower TEXT NOT NULL
            );
            ",
        [],
    )?;

    Ok(())
}
