extern crate rusqlite;

use rusqlite::{params, Connection, Result};

/// Data structure for beans in stock
pub struct Bean {
    pub id: String,
    pub bean_nickname: String,
    pub country_of_origin: String,
    pub region: String,
    pub grower: String,
}

/// Bean mappings for database
impl Bean {
    pub fn new() -> Bean {
        Bean {
            id: uuid::Uuid::new_v4().to_string(),
            bean_nickname: "".to_string(),
            country_of_origin: "".to_string(),
            region: "".to_string(),
            grower: "".to_string(),
        }
    }

    /// Insert new bean into database
    pub fn insert(&self, db_file: &'static str) -> Result<()> {
        let mut conn = Connection::open(db_file)?;
        let tx = conn.transaction()?;
        tx.execute(
            "
                      INSERT INTO beans (id, bean_nickname, country_of_origin, region, grower)
                      VALUES (?1, ?2, ?3, ?4, ?5)
                      ",
            params![
                self.id,
                self.bean_nickname,
                self.country_of_origin,
                self.region,
                self.grower,
            ],
        )?;

        // Commit transaction to database
        tx.commit()?;

        Ok(())
    }

    /// Delete bean form database
    pub fn delete(&self, db_file: &'static str) -> Result<()> {
        let mut conn = Connection::open(db_file).unwrap();

        let tx = conn.transaction()?;

        tx.execute("DELETE FROM beans WHERE ?1 like \"id\";", params!(&self.id))?;
        tx.commit()?;

        conn.close().unwrap();

        Ok(())
    }
}
