extern crate chrono;
extern crate uuid;

use freeroast::{db::init_db::*, db::roasts::*};
use std::io;
use std::io::Result;

fn now() -> i64 {
    chrono::Utc::now().timestamp()
}

///
/// Checks the IO buffer when collecting
/// timestamps
///
fn check_buff(buff: String) {
    if buff != "\n" {
        panic!("Invalid input");
    }
}

fn main() -> Result<()> {
    // Get bean name from user
    let mut new_roast = Roast::new();

    // Set filename for database
    let db_file = "roastdb";

    // Initialize database
    init_db(db_file).unwrap();

    // Get bean name from user
    println!("Enter bean name: ");
    io::stdin().read_line(&mut new_roast.bean_name)?;

    // Get starting weight from user
    println!("Enter starting weight: ");
    io::stdin().read_line(&mut new_roast.starting_weight.to_string())?;

    // Get time beans were put in
    println!("Press ENTER when you put beans in ");
    let mut buff = &mut String::new();
    io::stdin().read_line(&mut buff)?;
    check_buff(buff.to_string());
    new_roast.beans_in = now();

    // Clear buff
    String::clear(&mut buff);

    // Get start of first crack
    println!("Press ENTER when first crack starts");
    io::stdin().read_line(&mut buff)?;
    check_buff(buff.to_string());
    new_roast.first_crack_start = now();

    // Clear buff
    String::clear(&mut buff);

    // Get the end of first crack
    println!("Press ENTER when first crack is done");
    io::stdin().read_line(&mut buff)?;
    check_buff(buff.to_string());
    new_roast.first_crack_finish = now();

    // Insert new roast onto database
    new_roast
        .insert(db_file)
        .expect("Problem inserting new roast");

    Ok(())
}
