/*
 * freee API
 *
 *  <h1 id=\"freee_api\">freee API</h1> <hr /> <h2 id=\"start_guide\">スタートガイド</h2>  <p>freee API開発がはじめての方は<a href=\"https://developer.freee.co.jp/getting-started\">freee API スタートガイド</a>を参照してください。</p>  <hr /> <h2 id=\"specification\">仕様</h2>  <h3 id=\"api_endpoint\">APIエンドポイント</h3>  <p>https://api.freee.co.jp/ (httpsのみ)</p>  <h3 id=\"about_authorize\">認証について</h3> <p>OAuth2.0を利用します。詳細は<a href=\"https://developer.freee.co.jp/docs\" target=\"_blank\">ドキュメントの認証</a>パートを参照してください。</p>  <h3 id=\"data_format\">データフォーマット</h3>  <p>リクエスト、レスポンスともにJSON形式をサポートしていますが、詳細は、API毎の説明欄（application/jsonなど）を確認してください。</p>  <h3 id=\"compatibility\">後方互換性ありの変更</h3>  <p>freeeでは、APIを改善していくために以下のような変更は後方互換性ありとして通知なく変更を入れることがあります。アプリケーション実装者は以下を踏まえて開発を行ってください。</p>  <ul> <li>新しいAPIリソース・エンドポイントの追加</li> <li>既存のAPIに対して必須ではない新しいリクエストパラメータの追加</li> <li>既存のAPIレスポンスに対する新しいプロパティの追加</li> <li>既存のAPIレスポンスに対するプロパティの順番の入れ変え</li> <li>keyとなっているidやcodeの長さの変更（長くする）</li> </ul>  <h3 id=\"common_response_header\">共通レスポンスヘッダー</h3>  <p>すべてのAPIのレスポンスには以下のHTTPヘッダーが含まれます。</p>  <ul> <li> <p>X-Freee-Request-ID</p> <ul> <li>各リクエスト毎に発行されるID</li> </ul> </li> </ul>  <h3 id=\"common_error_response\">共通エラーレスポンス</h3>  <ul> <li> <p>ステータスコードはレスポンス内のJSONに含まれる他、HTTPヘッダにも含まれる</p> </li> <li> <p>一部のエラーレスポンスにはエラーコードが含まれます。<br>詳細は、<a href=\"https://developer.freee.co.jp/tips/faq/40x-checkpoint\">HTTPステータスコード400台エラー時のチェックポイント</a>を参照してください</p> </li> <p>type</p>  <ul> <li>status : HTTPステータスコードの説明</li>  <li>validation : エラーの詳細の説明（開発者向け）</li> </ul> </li> </ul>  <p>レスポンスの例</p>  <pre><code>  {     &quot;status_code&quot; : 400,     &quot;errors&quot; : [       {         &quot;type&quot; : &quot;status&quot;,         &quot;messages&quot; : [&quot;不正なリクエストです。&quot;]       },       {         &quot;type&quot; : &quot;validation&quot;,         &quot;messages&quot; : [&quot;Date は不正な日付フォーマットです。入力例：2019-12-17&quot;]       }     ]   }</code></pre>  </br>  <h3 id=\"api_rate_limit\">API使用制限</h3>    <p>freeeは一定期間に過度のアクセスを検知した場合、APIアクセスをコントロールする場合があります。</p>   <p>その際のhttp status codeは403となります。制限がかかってから10分程度が過ぎると再度使用することができるようになります。</p>  <h4 id=\"reports_api_endpoint\">/reportsと/receipts/{id}/downloadエンドポイント</h4>  <p>freeeはエンドポイント毎に一定頻度以上のアクセスを検知した場合、APIアクセスをコントロールする場合があります。その際のhttp status codeは429（too many requests）となります。</p>  <ul>   <li>/reports:1秒に10回まで</li>   <li>/receipts/{id}/download:1秒に3回まで</li> </ul>  <p>レスポンスボディのmetaプロパティに以下を含めます。</p>  <ul>   <li>設定されている上限値</li>   <li>上限に達するまでの使用可能回数</li>   <li>（上限値に達した場合）使用回数がリセットされる時刻</li> </ul>  <h3 id=\"plan_api_rate_limit\">プラン別のAPI Rate Limit</h3>   <table border=\"1\">     <tbody>       <tr>         <th style=\"padding: 10px\"><strong>freee会計プラン名</strong></th>         <th style=\"padding: 10px\"><strong>事業所とアプリケーション毎に1日でのAPIコール数</strong></th>       </tr>       <tr>         <td style=\"padding: 10px\">エンタープライズ</td>         <td style=\"padding: 10px\">10,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">プロフェッショナル</td>         <td style=\"padding: 10px\">5,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">ベーシック</td>         <td style=\"padding: 10px\">3,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">ミニマム</td>         <td style=\"padding: 10px\">3,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">上記以外</td>         <td style=\"padding: 10px\">3,000</td>       </tr>     </tbody>   </table>  <h3 id=\"webhook\">Webhookについて</h3>  <p>詳細は<a href=\"https://developer.freee.co.jp/docs/accounting/webhook\" target=\"_blank\">会計Webhook概要</a>を参照してください。</p>  <hr /> <h2 id=\"contact\">連絡先</h2>  <p>ご不明点、ご要望等は <a href=\"https://support.freee.co.jp/hc/ja/requests/new\">freee サポートデスクへのお問い合わせフォーム</a> からご連絡ください。</p> <hr />&copy; Since 2013 freee K.K.
 *
 * The version of the OpenAPI document: v1.0
 * 
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct InlineResponse2005 {
    #[serde(rename = "wallet_txns")]
    pub wallet_txns: Box<crate::models::UserCapability>,
    #[serde(rename = "deals")]
    pub deals: Box<crate::models::UserCapability>,
    #[serde(rename = "transfers")]
    pub transfers: Box<crate::models::UserCapability>,
    #[serde(rename = "docs")]
    pub docs: Box<crate::models::UserCapability>,
    #[serde(rename = "doc_postings")]
    pub doc_postings: Box<crate::models::UserCapability>,
    #[serde(rename = "receipts")]
    pub receipts: Box<crate::models::UserCapability>,
    #[serde(rename = "receipt_stream_editor")]
    pub receipt_stream_editor: Box<crate::models::UserCapability>,
    #[serde(rename = "expense_applications")]
    pub expense_applications: Box<crate::models::UserCapability>,
    #[serde(rename = "spreadsheets")]
    pub spreadsheets: Box<crate::models::UserCapability>,
    #[serde(rename = "payment_requests")]
    pub payment_requests: Box<crate::models::UserCapability>,
    #[serde(rename = "request_forms")]
    pub request_forms: Box<crate::models::UserCapability>,
    #[serde(rename = "approval_requests")]
    pub approval_requests: Box<crate::models::UserCapability>,
    #[serde(rename = "reports")]
    pub reports: Box<crate::models::UserCapability>,
    #[serde(rename = "reports_income_expense")]
    pub reports_income_expense: Box<crate::models::UserCapability>,
    #[serde(rename = "reports_receivables")]
    pub reports_receivables: Box<crate::models::UserCapability>,
    #[serde(rename = "reports_payables")]
    pub reports_payables: Box<crate::models::UserCapability>,
    #[serde(rename = "reports_cash_balance")]
    pub reports_cash_balance: Box<crate::models::UserCapability>,
    #[serde(rename = "reports_crosstabs")]
    pub reports_crosstabs: Box<crate::models::UserCapability>,
    #[serde(rename = "reports_general_ledgers")]
    pub reports_general_ledgers: Box<crate::models::UserCapability>,
    #[serde(rename = "reports_pl")]
    pub reports_pl: Box<crate::models::UserCapability>,
    #[serde(rename = "reports_bs")]
    pub reports_bs: Box<crate::models::UserCapability>,
    #[serde(rename = "reports_journals")]
    pub reports_journals: Box<crate::models::UserCapability>,
    #[serde(rename = "reports_managements_planning")]
    pub reports_managements_planning: Box<crate::models::UserCapability>,
    #[serde(rename = "reports_managements_navigation")]
    pub reports_managements_navigation: Box<crate::models::UserCapability>,
    #[serde(rename = "manual_journals")]
    pub manual_journals: Box<crate::models::UserCapability>,
    #[serde(rename = "fixed_assets")]
    pub fixed_assets: Box<crate::models::UserCapability>,
    #[serde(rename = "inventory_refreshes")]
    pub inventory_refreshes: Box<crate::models::UserCapability>,
    #[serde(rename = "biz_allocations")]
    pub biz_allocations: Box<crate::models::UserCapability>,
    #[serde(rename = "payment_records")]
    pub payment_records: Box<crate::models::UserCapability>,
    #[serde(rename = "annual_reports")]
    pub annual_reports: Box<crate::models::UserCapability>,
    #[serde(rename = "tax_reports")]
    pub tax_reports: Box<crate::models::UserCapability>,
    #[serde(rename = "consumption_entries")]
    pub consumption_entries: Box<crate::models::UserCapability>,
    #[serde(rename = "tax_return")]
    pub tax_return: Box<crate::models::UserCapability>,
    #[serde(rename = "account_item_statements")]
    pub account_item_statements: Box<crate::models::UserCapability>,
    #[serde(rename = "month_end")]
    pub month_end: Box<crate::models::UserCapability>,
    #[serde(rename = "year_end")]
    pub year_end: Box<crate::models::UserCapability>,
    #[serde(rename = "walletables")]
    pub walletables: Box<crate::models::UserCapability>,
    #[serde(rename = "companies")]
    pub companies: Box<crate::models::UserCapability>,
    #[serde(rename = "invitations")]
    pub invitations: Box<crate::models::UserCapability>,
    #[serde(rename = "sign_in_logs")]
    pub sign_in_logs: Box<crate::models::UserCapability>,
    #[serde(rename = "backups")]
    pub backups: Box<crate::models::UserCapability>,
    #[serde(rename = "opening_balances")]
    pub opening_balances: Box<crate::models::UserCapability>,
    #[serde(rename = "system_conversion")]
    pub system_conversion: Box<crate::models::UserCapability>,
    #[serde(rename = "resets")]
    pub resets: Box<crate::models::UserCapability>,
    #[serde(rename = "partners")]
    pub partners: Box<crate::models::UserCapability>,
    #[serde(rename = "items")]
    pub items: Box<crate::models::UserCapability>,
    #[serde(rename = "sections")]
    pub sections: Box<crate::models::UserCapability>,
    #[serde(rename = "tags")]
    pub tags: Box<crate::models::UserCapability>,
    #[serde(rename = "account_items")]
    pub account_items: Box<crate::models::UserCapability>,
    #[serde(rename = "taxes")]
    pub taxes: Box<crate::models::UserCapability>,
    #[serde(rename = "user_matchers")]
    pub user_matchers: Box<crate::models::UserCapability>,
    #[serde(rename = "deal_templates")]
    pub deal_templates: Box<crate::models::UserCapability>,
    #[serde(rename = "manual_journal_templates")]
    pub manual_journal_templates: Box<crate::models::UserCapability>,
    #[serde(rename = "cost_allocations")]
    pub cost_allocations: Box<crate::models::UserCapability>,
    #[serde(rename = "approval_flow_routes")]
    pub approval_flow_routes: Box<crate::models::UserCapability>,
    #[serde(rename = "expense_application_templates")]
    pub expense_application_templates: Box<crate::models::UserCapability>,
    #[serde(rename = "workflows")]
    pub workflows: Box<crate::models::UserCapability>,
    #[serde(rename = "oauth_applications")]
    pub oauth_applications: Box<crate::models::UserCapability>,
    #[serde(rename = "oauth_authorizations")]
    pub oauth_authorizations: Box<crate::models::UserCapability>,
    #[serde(rename = "bank_accountant_staff_users")]
    pub bank_accountant_staff_users: Box<crate::models::UserCapability>,
}

impl InlineResponse2005 {
    pub fn new(wallet_txns: crate::models::UserCapability, deals: crate::models::UserCapability, transfers: crate::models::UserCapability, docs: crate::models::UserCapability, doc_postings: crate::models::UserCapability, receipts: crate::models::UserCapability, receipt_stream_editor: crate::models::UserCapability, expense_applications: crate::models::UserCapability, spreadsheets: crate::models::UserCapability, payment_requests: crate::models::UserCapability, request_forms: crate::models::UserCapability, approval_requests: crate::models::UserCapability, reports: crate::models::UserCapability, reports_income_expense: crate::models::UserCapability, reports_receivables: crate::models::UserCapability, reports_payables: crate::models::UserCapability, reports_cash_balance: crate::models::UserCapability, reports_crosstabs: crate::models::UserCapability, reports_general_ledgers: crate::models::UserCapability, reports_pl: crate::models::UserCapability, reports_bs: crate::models::UserCapability, reports_journals: crate::models::UserCapability, reports_managements_planning: crate::models::UserCapability, reports_managements_navigation: crate::models::UserCapability, manual_journals: crate::models::UserCapability, fixed_assets: crate::models::UserCapability, inventory_refreshes: crate::models::UserCapability, biz_allocations: crate::models::UserCapability, payment_records: crate::models::UserCapability, annual_reports: crate::models::UserCapability, tax_reports: crate::models::UserCapability, consumption_entries: crate::models::UserCapability, tax_return: crate::models::UserCapability, account_item_statements: crate::models::UserCapability, month_end: crate::models::UserCapability, year_end: crate::models::UserCapability, walletables: crate::models::UserCapability, companies: crate::models::UserCapability, invitations: crate::models::UserCapability, sign_in_logs: crate::models::UserCapability, backups: crate::models::UserCapability, opening_balances: crate::models::UserCapability, system_conversion: crate::models::UserCapability, resets: crate::models::UserCapability, partners: crate::models::UserCapability, items: crate::models::UserCapability, sections: crate::models::UserCapability, tags: crate::models::UserCapability, account_items: crate::models::UserCapability, taxes: crate::models::UserCapability, user_matchers: crate::models::UserCapability, deal_templates: crate::models::UserCapability, manual_journal_templates: crate::models::UserCapability, cost_allocations: crate::models::UserCapability, approval_flow_routes: crate::models::UserCapability, expense_application_templates: crate::models::UserCapability, workflows: crate::models::UserCapability, oauth_applications: crate::models::UserCapability, oauth_authorizations: crate::models::UserCapability, bank_accountant_staff_users: crate::models::UserCapability) -> InlineResponse2005 {
        InlineResponse2005 {
            wallet_txns: Box::new(wallet_txns),
            deals: Box::new(deals),
            transfers: Box::new(transfers),
            docs: Box::new(docs),
            doc_postings: Box::new(doc_postings),
            receipts: Box::new(receipts),
            receipt_stream_editor: Box::new(receipt_stream_editor),
            expense_applications: Box::new(expense_applications),
            spreadsheets: Box::new(spreadsheets),
            payment_requests: Box::new(payment_requests),
            request_forms: Box::new(request_forms),
            approval_requests: Box::new(approval_requests),
            reports: Box::new(reports),
            reports_income_expense: Box::new(reports_income_expense),
            reports_receivables: Box::new(reports_receivables),
            reports_payables: Box::new(reports_payables),
            reports_cash_balance: Box::new(reports_cash_balance),
            reports_crosstabs: Box::new(reports_crosstabs),
            reports_general_ledgers: Box::new(reports_general_ledgers),
            reports_pl: Box::new(reports_pl),
            reports_bs: Box::new(reports_bs),
            reports_journals: Box::new(reports_journals),
            reports_managements_planning: Box::new(reports_managements_planning),
            reports_managements_navigation: Box::new(reports_managements_navigation),
            manual_journals: Box::new(manual_journals),
            fixed_assets: Box::new(fixed_assets),
            inventory_refreshes: Box::new(inventory_refreshes),
            biz_allocations: Box::new(biz_allocations),
            payment_records: Box::new(payment_records),
            annual_reports: Box::new(annual_reports),
            tax_reports: Box::new(tax_reports),
            consumption_entries: Box::new(consumption_entries),
            tax_return: Box::new(tax_return),
            account_item_statements: Box::new(account_item_statements),
            month_end: Box::new(month_end),
            year_end: Box::new(year_end),
            walletables: Box::new(walletables),
            companies: Box::new(companies),
            invitations: Box::new(invitations),
            sign_in_logs: Box::new(sign_in_logs),
            backups: Box::new(backups),
            opening_balances: Box::new(opening_balances),
            system_conversion: Box::new(system_conversion),
            resets: Box::new(resets),
            partners: Box::new(partners),
            items: Box::new(items),
            sections: Box::new(sections),
            tags: Box::new(tags),
            account_items: Box::new(account_items),
            taxes: Box::new(taxes),
            user_matchers: Box::new(user_matchers),
            deal_templates: Box::new(deal_templates),
            manual_journal_templates: Box::new(manual_journal_templates),
            cost_allocations: Box::new(cost_allocations),
            approval_flow_routes: Box::new(approval_flow_routes),
            expense_application_templates: Box::new(expense_application_templates),
            workflows: Box::new(workflows),
            oauth_applications: Box::new(oauth_applications),
            oauth_authorizations: Box::new(oauth_authorizations),
            bank_accountant_staff_users: Box::new(bank_accountant_staff_users),
        }
    }
}


