/*
 * freee API
 *
 *  <h1 id=\"freee_api\">freee API</h1> <hr /> <h2 id=\"start_guide\">スタートガイド</h2>  <p>freee API開発がはじめての方は<a href=\"https://developer.freee.co.jp/getting-started\">freee API スタートガイド</a>を参照してください。</p>  <hr /> <h2 id=\"specification\">仕様</h2>  <h3 id=\"api_endpoint\">APIエンドポイント</h3>  <p>https://api.freee.co.jp/ (httpsのみ)</p>  <h3 id=\"about_authorize\">認証について</h3> <p>OAuth2.0を利用します。詳細は<a href=\"https://developer.freee.co.jp/docs\" target=\"_blank\">ドキュメントの認証</a>パートを参照してください。</p>  <h3 id=\"data_format\">データフォーマット</h3>  <p>リクエスト、レスポンスともにJSON形式をサポートしていますが、詳細は、API毎の説明欄（application/jsonなど）を確認してください。</p>  <h3 id=\"compatibility\">後方互換性ありの変更</h3>  <p>freeeでは、APIを改善していくために以下のような変更は後方互換性ありとして通知なく変更を入れることがあります。アプリケーション実装者は以下を踏まえて開発を行ってください。</p>  <ul> <li>新しいAPIリソース・エンドポイントの追加</li> <li>既存のAPIに対して必須ではない新しいリクエストパラメータの追加</li> <li>既存のAPIレスポンスに対する新しいプロパティの追加</li> <li>既存のAPIレスポンスに対するプロパティの順番の入れ変え</li> <li>keyとなっているidやcodeの長さの変更（長くする）</li> </ul>  <h3 id=\"common_response_header\">共通レスポンスヘッダー</h3>  <p>すべてのAPIのレスポンスには以下のHTTPヘッダーが含まれます。</p>  <ul> <li> <p>X-Freee-Request-ID</p> <ul> <li>各リクエスト毎に発行されるID</li> </ul> </li> </ul>  <h3 id=\"common_error_response\">共通エラーレスポンス</h3>  <ul> <li> <p>ステータスコードはレスポンス内のJSONに含まれる他、HTTPヘッダにも含まれる</p> </li> <li> <p>一部のエラーレスポンスにはエラーコードが含まれます。<br>詳細は、<a href=\"https://developer.freee.co.jp/tips/faq/40x-checkpoint\">HTTPステータスコード400台エラー時のチェックポイント</a>を参照してください</p> </li> <p>type</p>  <ul> <li>status : HTTPステータスコードの説明</li>  <li>validation : エラーの詳細の説明（開発者向け）</li> </ul> </li> </ul>  <p>レスポンスの例</p>  <pre><code>  {     &quot;status_code&quot; : 400,     &quot;errors&quot; : [       {         &quot;type&quot; : &quot;status&quot;,         &quot;messages&quot; : [&quot;不正なリクエストです。&quot;]       },       {         &quot;type&quot; : &quot;validation&quot;,         &quot;messages&quot; : [&quot;Date は不正な日付フォーマットです。入力例：2019-12-17&quot;]       }     ]   }</code></pre>  </br>  <h3 id=\"api_rate_limit\">API使用制限</h3>    <p>freeeは一定期間に過度のアクセスを検知した場合、APIアクセスをコントロールする場合があります。</p>   <p>その際のhttp status codeは403となります。制限がかかってから10分程度が過ぎると再度使用することができるようになります。</p>  <h4 id=\"reports_api_endpoint\">/reportsと/receipts/{id}/downloadエンドポイント</h4>  <p>freeeはエンドポイント毎に一定頻度以上のアクセスを検知した場合、APIアクセスをコントロールする場合があります。その際のhttp status codeは429（too many requests）となります。</p>  <ul>   <li>/reports:1秒に10回まで</li>   <li>/receipts/{id}/download:1秒に3回まで</li> </ul>  <p>レスポンスボディのmetaプロパティに以下を含めます。</p>  <ul>   <li>設定されている上限値</li>   <li>上限に達するまでの使用可能回数</li>   <li>（上限値に達した場合）使用回数がリセットされる時刻</li> </ul>  <h3 id=\"plan_api_rate_limit\">プラン別のAPI Rate Limit</h3>   <table border=\"1\">     <tbody>       <tr>         <th style=\"padding: 10px\"><strong>freee会計プラン名</strong></th>         <th style=\"padding: 10px\"><strong>事業所とアプリケーション毎に1日でのAPIコール数</strong></th>       </tr>       <tr>         <td style=\"padding: 10px\">エンタープライズ</td>         <td style=\"padding: 10px\">10,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">プロフェッショナル</td>         <td style=\"padding: 10px\">5,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">ベーシック</td>         <td style=\"padding: 10px\">3,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">ミニマム</td>         <td style=\"padding: 10px\">3,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">上記以外</td>         <td style=\"padding: 10px\">3,000</td>       </tr>     </tbody>   </table>  <h3 id=\"webhook\">Webhookについて</h3>  <p>詳細は<a href=\"https://developer.freee.co.jp/docs/accounting/webhook\" target=\"_blank\">会計Webhook概要</a>を参照してください。</p>  <hr /> <h2 id=\"contact\">連絡先</h2>  <p>ご不明点、ご要望等は <a href=\"https://support.freee.co.jp/hc/ja/requests/new\">freee サポートデスクへのお問い合わせフォーム</a> からご連絡ください。</p> <hr />&copy; Since 2013 freee K.K.
 *
 * The version of the OpenAPI document: v1.0
 * 
 * Generated by: https://openapi-generator.tech
 */


use reqwest;

use crate::apis::ResponseContent;
use super::{Error, configuration};


/// struct for typed errors of method [`get_trial_bs`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetTrialBsError {
    Status400(crate::models::BadRequestError),
    Status401(crate::models::UnauthorizedError),
    Status403(crate::models::ForbiddenError),
    Status429(crate::models::TooManyRequestsError),
    Status500(crate::models::InternalServerError),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`get_trial_bs_three_years`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetTrialBsThreeYearsError {
    Status400(crate::models::BadRequestError),
    Status401(crate::models::UnauthorizedError),
    Status403(crate::models::ForbiddenError),
    Status429(crate::models::TooManyRequestsError),
    Status500(crate::models::InternalServerError),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`get_trial_bs_two_years`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetTrialBsTwoYearsError {
    Status400(crate::models::BadRequestError),
    Status401(crate::models::UnauthorizedError),
    Status403(crate::models::ForbiddenError),
    Status429(crate::models::TooManyRequestsError),
    Status500(crate::models::InternalServerError),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`get_trial_cr`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetTrialCrError {
    Status400(crate::models::BadRequestError),
    Status401(crate::models::UnauthorizedError),
    Status403(crate::models::ForbiddenError),
    Status429(crate::models::TooManyRequestsError),
    Status500(crate::models::InternalServerError),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`get_trial_cr_sections`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetTrialCrSectionsError {
    Status400(crate::models::BadRequestError),
    Status401(crate::models::UnauthorizedError),
    Status403(crate::models::ForbiddenError),
    Status429(crate::models::TooManyRequestsError),
    Status500(crate::models::InternalServerError),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`get_trial_cr_segment1_tags`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetTrialCrSegment1TagsError {
    Status400(crate::models::BadRequestError),
    Status401(crate::models::UnauthorizedError),
    Status403(crate::models::ForbiddenError),
    Status429(crate::models::TooManyRequestsError),
    Status500(crate::models::InternalServerError),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`get_trial_cr_segment2_tags`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetTrialCrSegment2TagsError {
    Status400(crate::models::BadRequestError),
    Status401(crate::models::UnauthorizedError),
    Status403(crate::models::ForbiddenError),
    Status429(crate::models::TooManyRequestsError),
    Status500(crate::models::InternalServerError),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`get_trial_cr_segment3_tags`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetTrialCrSegment3TagsError {
    Status400(crate::models::BadRequestError),
    Status401(crate::models::UnauthorizedError),
    Status403(crate::models::ForbiddenError),
    Status429(crate::models::TooManyRequestsError),
    Status500(crate::models::InternalServerError),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`get_trial_cr_three_years`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetTrialCrThreeYearsError {
    Status400(crate::models::BadRequestError),
    Status401(crate::models::UnauthorizedError),
    Status403(crate::models::ForbiddenError),
    Status429(crate::models::TooManyRequestsError),
    Status500(crate::models::InternalServerError),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`get_trial_cr_two_years`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetTrialCrTwoYearsError {
    Status400(crate::models::BadRequestError),
    Status401(crate::models::UnauthorizedError),
    Status403(crate::models::ForbiddenError),
    Status429(crate::models::TooManyRequestsError),
    Status500(crate::models::InternalServerError),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`get_trial_pl`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetTrialPlError {
    Status400(crate::models::BadRequestError),
    Status401(crate::models::UnauthorizedError),
    Status403(crate::models::ForbiddenError),
    Status429(crate::models::TooManyRequestsError),
    Status500(crate::models::InternalServerError),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`get_trial_pl_sections`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetTrialPlSectionsError {
    Status400(crate::models::BadRequestError),
    Status401(crate::models::UnauthorizedError),
    Status403(crate::models::ForbiddenError),
    Status429(crate::models::TooManyRequestsError),
    Status500(crate::models::InternalServerError),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`get_trial_pl_segment1_tags`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetTrialPlSegment1TagsError {
    Status400(crate::models::BadRequestError),
    Status401(crate::models::UnauthorizedError),
    Status403(crate::models::ForbiddenError),
    Status429(crate::models::TooManyRequestsError),
    Status500(crate::models::InternalServerError),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`get_trial_pl_segment2_tags`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetTrialPlSegment2TagsError {
    Status400(crate::models::BadRequestError),
    Status401(crate::models::UnauthorizedError),
    Status403(crate::models::ForbiddenError),
    Status429(crate::models::TooManyRequestsError),
    Status500(crate::models::InternalServerError),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`get_trial_pl_segment3_tags`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetTrialPlSegment3TagsError {
    Status400(crate::models::BadRequestError),
    Status401(crate::models::UnauthorizedError),
    Status403(crate::models::ForbiddenError),
    Status429(crate::models::TooManyRequestsError),
    Status500(crate::models::InternalServerError),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`get_trial_pl_three_years`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetTrialPlThreeYearsError {
    Status400(crate::models::BadRequestError),
    Status401(crate::models::UnauthorizedError),
    Status403(crate::models::ForbiddenError),
    Status429(crate::models::TooManyRequestsError),
    Status500(crate::models::InternalServerError),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`get_trial_pl_two_years`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetTrialPlTwoYearsError {
    Status400(crate::models::BadRequestError),
    Status401(crate::models::UnauthorizedError),
    Status403(crate::models::ForbiddenError),
    Status429(crate::models::TooManyRequestsError),
    Status500(crate::models::InternalServerError),
    UnknownValue(serde_json::Value),
}


///  <h2 id=\"\">概要</h2>  <p>指定した事業所の貸借対照表を取得する</p>  <h2 id=\"_2\">定義</h2>  <ul>  <li> <p>created_at : 作成日時</p> </li>  <li> <p>account_item_name : 勘定科目名</p> </li>  <li> <p>hierarchy_level: 階層レベル</p> </li>  <li> <p>parent_account_category_name: 上位勘定科目カテゴリー名</p> </li> <li> <p>opening_balance : 期首残高 </p> </li>  <li> <p>debit_amount : 借方金額 </p> </li> <li> <p>credit_amount:  貸方金額 </p> </li> <li> <p>closing_balance : 期末残高 </p> </li> <li> <p>composition_ratio : 構成比</p> </li> <h2 id=\"_3\">注意点</h2> <ul> <li>会計年度が指定されない場合、現在の会計年度がデフォルトとなります。</li> <li>up_to_dateがfalseの場合、残高の集計が完了していません。最新の集計結果を確認したい場合は、時間を空けて再度取得する必要があります。</li> <li>取引先、品目、部門、セグメントはそれぞれの合計値が1000を超えるとレスポンスを得ることができません。</li> <li>partner_codeとpartner_idは同時に指定することはできません。</li> <li>start_date / end_date を指定した場合、以下を同時に指定することはできません。</li>   <ul>   <li>fiscal_year</li>   <li>start_month</li>   <li>end_month</li>   </ul> <li>0を指定すると未選択で絞り込めます</li>   <ul>   <li>partner_idに0を指定して絞り込んだ場合</li>     <ul>     <li>取引先が設定されていない取引、振替伝票の金額がレスポンスに返却されます</li>     </ul>   </ul> </ul> <h2 id=\"_4\">レスポンスの例</h2>  <blockquote> <p>GET https://api.freee.co.jp/api/1/reports/trial_bs?company_id=1&amp;fiscal_year=2019&amp;breakdown_display_type=partner</p> </blockquote>  <pre><code>{   &quot;trial_bs&quot; :     {       &quot;company_id&quot; : 1,       &quot;fiscal_year&quot; : 2019,       &quot;breakdown_display_type&quot; : &quot;partner&quot;,       &quot;created_at&quot; : &quot;2019-12-17 12:00:50&quot       &quot;balances&quot; : [{         &quot;account_item_id&quot; : 1000,         &quot;account_item_name&quot; : &quot;現金&quot;,         &quot;hierarchy_level&quot; : 2,         &quot;account_category_name&quot; : &quot;流動資産&quot;,         &quot;opening_balance&quot; : 100000,         &quot;debit_amount&quot; : 50000,         &quot;credit_amount&quot; : 20000,         &quot;closing_balance&quot; : 130000,         &quot;composition_ratio&quot; : 0.25         &quot;partners&quot; : [{           &quot;id&quot; : 123,           &quot;name&quot; : &quot;freee&quot;,           &quot;opening_balance&quot; : 100000,           &quot;debit_amount&quot; : 50000,           &quot;credit_amount&quot; : 20000,           &quot;closing_balance&quot; : 130000,           &quot;composition_ratio&quot; : 0.25           },         ...         ]       },       ...       ]     } }</code></pre> 
pub async fn get_trial_bs(configuration: &configuration::Configuration, company_id: i32, fiscal_year: Option<i32>, start_month: Option<i32>, end_month: Option<i32>, start_date: Option<&str>, end_date: Option<&str>, account_item_display_type: Option<&str>, breakdown_display_type: Option<&str>, partner_id: Option<i32>, partner_code: Option<&str>, item_id: Option<i32>, section_id: Option<i32>, adjustment: Option<&str>, approval_flow_status: Option<&str>) -> Result<crate::models::TrialBsResponse, Error<GetTrialBsError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/api/1/reports/trial_bs", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    local_var_req_builder = local_var_req_builder.query(&[("company_id", &company_id.to_string())]);
    if let Some(ref local_var_str) = fiscal_year {
        local_var_req_builder = local_var_req_builder.query(&[("fiscal_year", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_month {
        local_var_req_builder = local_var_req_builder.query(&[("start_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_month {
        local_var_req_builder = local_var_req_builder.query(&[("end_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_date {
        local_var_req_builder = local_var_req_builder.query(&[("start_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_date {
        local_var_req_builder = local_var_req_builder.query(&[("end_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = account_item_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("account_item_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = breakdown_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("breakdown_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_id {
        local_var_req_builder = local_var_req_builder.query(&[("partner_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_code {
        local_var_req_builder = local_var_req_builder.query(&[("partner_code", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = item_id {
        local_var_req_builder = local_var_req_builder.query(&[("item_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = section_id {
        local_var_req_builder = local_var_req_builder.query(&[("section_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = adjustment {
        local_var_req_builder = local_var_req_builder.query(&[("adjustment", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = approval_flow_status {
        local_var_req_builder = local_var_req_builder.query(&[("approval_flow_status", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<GetTrialBsError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

///  <h2 id=\"\">概要</h2>  <p>指定した事業所の貸借対照表(３期間比較)を取得する</p>  <h2 id=\"_2\">定義</h2>  <ul>  <li> <p>created_at : 作成日時</p> </li>  <li> <p>account_item_name : 勘定科目名</p> </li>  <li> <p>hierarchy_level: 階層レベル</p> </li>  <li> <p>parent_account_category_name: 上位勘定科目カテゴリー名</p> </li> <li> <p>two_years_before_closing_balance:  前々年度期末残高 </p> </li> <li> <p>last_year_closing_balance:  前年度期末残高 </p> </li> <li> <p>closing_balance : 期末残高 </p> </li> <li> <p>year_on_year : 前年比</p> </li> <h2 id=\"_3\">注意点</h2> <ul> <li>会計年度が指定されない場合、現在の会計年度がデフォルトとなります。</li> <li>up_to_dateがfalseの場合、残高の集計が完了していません。最新の集計結果を確認したい場合は、時間を空けて再度取得する必要があります。</li> <li>取引先、品目、部門、セグメントはそれぞれの合計値が1000を超えるとレスポンスを得ることができません。</li> <li>partner_codeとpartner_idは同時に指定することはできません。</li> <li>start_date / end_date を指定した場合、以下を同時に指定することはできません。</li>   <ul>   <li>fiscal_year</li>   <li>start_month</li>   <li>end_month</li>   </ul> <li>0を指定すると未選択で絞り込めます</li>   <ul>   <li>partner_idに0を指定して絞り込んだ場合</li>     <ul>     <li>取引先が設定されていない取引、振替伝票の金額がレスポンスに返却されます</li>     </ul>   </ul> </ul> <h2 id=\"_4\">レスポンスの例</h2>  <blockquote> <p>GET https://api.freee.co.jp/api/1/reports/trial_bs_three_years?company_id=1&amp;fiscal_year=2019</p> </blockquote>  <pre><code>{   &quot;trial_bs_three_years&quot; :     {       &quot;company_id&quot; : 1,       &quot;fiscal_year&quot; : 2019,       &quot;created_at&quot; : &quot;2019-12-17 12:00:50&quot       &quot;balances&quot; : [{         &quot;account_item_id&quot; : 1000,         &quot;account_item_name&quot; : &quot;現金&quot;,         &quot;hierarchy_level&quot; : 2,         &quot;account_category_name&quot; : &quot;流動資産&quot;,         &quot;two_year_before_closing_balance&quot; : 50000,         &quot;last_year_closing_balance&quot; : 25000,         &quot;closing_balance&quot; : 100000,         &quot;year_on_year&quot; : 0.85       },       ...       ]     } }</code></pre> 
pub async fn get_trial_bs_three_years(configuration: &configuration::Configuration, company_id: i32, fiscal_year: Option<i32>, start_month: Option<i32>, end_month: Option<i32>, start_date: Option<&str>, end_date: Option<&str>, account_item_display_type: Option<&str>, breakdown_display_type: Option<&str>, partner_id: Option<i32>, partner_code: Option<&str>, item_id: Option<i32>, section_id: Option<i32>, adjustment: Option<&str>, approval_flow_status: Option<&str>) -> Result<crate::models::TrialBsThreeYearsResponse, Error<GetTrialBsThreeYearsError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/api/1/reports/trial_bs_three_years", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    local_var_req_builder = local_var_req_builder.query(&[("company_id", &company_id.to_string())]);
    if let Some(ref local_var_str) = fiscal_year {
        local_var_req_builder = local_var_req_builder.query(&[("fiscal_year", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_month {
        local_var_req_builder = local_var_req_builder.query(&[("start_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_month {
        local_var_req_builder = local_var_req_builder.query(&[("end_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_date {
        local_var_req_builder = local_var_req_builder.query(&[("start_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_date {
        local_var_req_builder = local_var_req_builder.query(&[("end_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = account_item_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("account_item_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = breakdown_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("breakdown_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_id {
        local_var_req_builder = local_var_req_builder.query(&[("partner_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_code {
        local_var_req_builder = local_var_req_builder.query(&[("partner_code", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = item_id {
        local_var_req_builder = local_var_req_builder.query(&[("item_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = section_id {
        local_var_req_builder = local_var_req_builder.query(&[("section_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = adjustment {
        local_var_req_builder = local_var_req_builder.query(&[("adjustment", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = approval_flow_status {
        local_var_req_builder = local_var_req_builder.query(&[("approval_flow_status", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<GetTrialBsThreeYearsError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

///  <h2 id=\"\">概要</h2>  <p>指定した事業所の貸借対照表(前年比較)を取得する</p>  <h2 id=\"_2\">定義</h2>  <ul>  <li> <p>created_at : 作成日時</p> </li>  <li> <p>account_item_name : 勘定科目名</p> </li>  <li> <p>hierarchy_level: 階層レベル</p> </li>  <li> <p>parent_account_category_name: 上位勘定科目カテゴリー名</p> </li> <li> <p>last_year_closing_balance:  前年度期末残高 </p> </li> <li> <p>closing_balance : 期末残高 </p> </li> <li> <p>year_on_year : 前年比</p> </li> <h2 id=\"_3\">注意点</h2> <ul> <li>会計年度が指定されない場合、現在の会計年度がデフォルトとなります。</li> <li>up_to_dateがfalseの場合、残高の集計が完了していません。最新の集計結果を確認したい場合は、時間を空けて再度取得する必要があります。</li> <li>取引先、品目、部門、セグメントはそれぞれの合計値が1000を超えるとレスポンスを得ることができません。</li> <li>partner_codeとpartner_idは同時に指定することはできません。</li> <li>start_date / end_date を指定した場合、以下を同時に指定することはできません。</li>   <ul>   <li>fiscal_year</li>   <li>start_month</li>   <li>end_month</li>   </ul> <li>0を指定すると未選択で絞り込めます</li>   <ul>   <li>partner_idに0を指定して絞り込んだ場合</li>     <ul>     <li>取引先が設定されていない取引、振替伝票の金額がレスポンスに返却されます</li>     </ul>   </ul> </ul>  <h2 id=\"_4\">レスポンスの例</h2>  <blockquote> <p>GET https://api.freee.co.jp/api/1/reports/trial_bs_two_years?company_id=1&amp;fiscal_year=2019</p> </blockquote>  <pre><code>{   &quot;trial_bs_two_years&quot; :     {       &quot;company_id&quot; : 1,       &quot;fiscal_year&quot; : 2019,       &quot;created_at&quot; : &quot;2019-12-17 12:00:50&quot       &quot;balances&quot; : [{         &quot;account_item_id&quot; : 1000,         &quot;account_item_name&quot; : &quot;現金&quot;,         &quot;hierarchy_level&quot; : 2,         &quot;account_category_name&quot; : &quot;流動資産&quot;,         &quot;last_year_closing_balance&quot; : 25000,         &quot;closing_balance&quot; : 100000,         &quot;year_on_year&quot; : 0.85        },       ...       ]     } }</code></pre> 
pub async fn get_trial_bs_two_years(configuration: &configuration::Configuration, company_id: i32, fiscal_year: Option<i32>, start_month: Option<i32>, end_month: Option<i32>, start_date: Option<&str>, end_date: Option<&str>, account_item_display_type: Option<&str>, breakdown_display_type: Option<&str>, partner_id: Option<i32>, partner_code: Option<&str>, item_id: Option<i32>, section_id: Option<i32>, adjustment: Option<&str>, approval_flow_status: Option<&str>) -> Result<crate::models::TrialBsTwoYearsResponse, Error<GetTrialBsTwoYearsError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/api/1/reports/trial_bs_two_years", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    local_var_req_builder = local_var_req_builder.query(&[("company_id", &company_id.to_string())]);
    if let Some(ref local_var_str) = fiscal_year {
        local_var_req_builder = local_var_req_builder.query(&[("fiscal_year", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_month {
        local_var_req_builder = local_var_req_builder.query(&[("start_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_month {
        local_var_req_builder = local_var_req_builder.query(&[("end_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_date {
        local_var_req_builder = local_var_req_builder.query(&[("start_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_date {
        local_var_req_builder = local_var_req_builder.query(&[("end_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = account_item_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("account_item_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = breakdown_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("breakdown_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_id {
        local_var_req_builder = local_var_req_builder.query(&[("partner_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_code {
        local_var_req_builder = local_var_req_builder.query(&[("partner_code", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = item_id {
        local_var_req_builder = local_var_req_builder.query(&[("item_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = section_id {
        local_var_req_builder = local_var_req_builder.query(&[("section_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = adjustment {
        local_var_req_builder = local_var_req_builder.query(&[("adjustment", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = approval_flow_status {
        local_var_req_builder = local_var_req_builder.query(&[("approval_flow_status", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<GetTrialBsTwoYearsError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// <h2 id=\"\">概要</h2> <p>指定した事業所の製造原価報告書を取得する</p> <h2 id=\"_2\">定義</h2> <ul> <li> <p>created_at : 作成日時</p> </li> <li> <p>account_item_name : 勘定科目名</p> </li> <li> <p>hierarchy_level: 階層レベル</p> </li> <li> <p>parent_account_category_name: 上位勘定科目カテゴリー名</p> </li> <li> <p>opening_balance : 期首残高 </p> </li> <li> <p>debit_amount : 借方金額 </p> </li> <li> <p>credit_amount:  貸方金額 </p> </li> <li> <p>closing_balance : 期末残高 </p> </li> <li> <p>composition_ratio : 構成比</p> </li> <h2 id=\"_3\">注意点</h2> <ul> <li>法人向けのプランで利用可能なAPIです。対象外のプランでは401エラーを返却します。</li> <li>会計年度が指定されない場合、現在の会計年度がデフォルトとなります。</li> <li>up_to_dateがfalseの場合、残高の集計が完了していません。最新の集計結果を確認したい場合は、時間を空けて再度取得する必要があります。</li> <li>配賦仕訳の絞り込み（cost_allocation）は法人向けのベーシックプラン以上で利用可能です。</li> <li>取引先、品目、部門、セグメントはそれぞれの合計値が1000を超えるとレスポンスを得ることができません。</li> <li>partner_codeとpartner_idは同時に指定することはできません。</li> <li>start_date / end_date を指定した場合、以下を同時に指定することはできません。</li>   <ul>   <li>fiscal_year</li>   <li>start_month</li>   <li>end_month</li>   </ul> <li>0を指定すると未選択で絞り込めます</li>   <ul>   <li>partner_idに0を指定して絞り込んだ場合</li>     <ul>     <li>取引先が設定されていない取引、振替伝票の金額がレスポンスに返却されます</li>     </ul>   </ul> </ul> <h2 id=\"_4\">レスポンスの例</h2> <blockquote> <p>GET https://api.freee.co.jp/api/1/reports/trial_cr?company_id=1&amp;fiscal_year=2019&amp;breakdown_display_type=partner</p> </blockquote> <pre><code>{   &quot;trial_cr&quot; :     {       &quot;company_id&quot; : 1,       &quot;fiscal_year&quot; : 2019,       &quot;breakdown_display_type&quot; : &quot;partner&quot;,       &quot;created_at&quot; : &quot;2019-12-17 12:00:50&quot       &quot;balances&quot; : [{         &quot;account_item_id&quot; : 1500,         &quot;account_item_name&quot; : &quot;[製]期首材料棚卸高&quot;,         &quot;hierarchy_level&quot; : 2,         &quot;account_category_name&quot; : &quot;期首原材料棚卸&quot;,         &quot;opening_balance&quot; : 100000,         &quot;debit_amount&quot; : 50000,         &quot;credit_amount&quot; : 20000,         &quot;closing_balance&quot; : 130000,         &quot;composition_ratio&quot; : 0.25         &quot;partners&quot; : [{           &quot;id&quot; : 123,           &quot;name&quot; : &quot;freee&quot;,           &quot;opening_balance&quot; : 100000,           &quot;debit_amount&quot; : 50000,           &quot;credit_amount&quot; : 20000,           &quot;closing_balance&quot; : 130000,           &quot;composition_ratio&quot; : 0.25           },         ...         ]       },       ...       ]     } }</code></pre> 
pub async fn get_trial_cr(configuration: &configuration::Configuration, company_id: i32, fiscal_year: Option<i32>, start_month: Option<i32>, end_month: Option<i32>, start_date: Option<&str>, end_date: Option<&str>, account_item_display_type: Option<&str>, breakdown_display_type: Option<&str>, partner_id: Option<i32>, partner_code: Option<&str>, item_id: Option<i32>, section_id: Option<i32>, adjustment: Option<&str>, cost_allocation: Option<&str>, approval_flow_status: Option<&str>) -> Result<crate::models::TrialCrResponse, Error<GetTrialCrError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/api/1/reports/trial_cr", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    local_var_req_builder = local_var_req_builder.query(&[("company_id", &company_id.to_string())]);
    if let Some(ref local_var_str) = fiscal_year {
        local_var_req_builder = local_var_req_builder.query(&[("fiscal_year", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_month {
        local_var_req_builder = local_var_req_builder.query(&[("start_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_month {
        local_var_req_builder = local_var_req_builder.query(&[("end_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_date {
        local_var_req_builder = local_var_req_builder.query(&[("start_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_date {
        local_var_req_builder = local_var_req_builder.query(&[("end_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = account_item_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("account_item_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = breakdown_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("breakdown_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_id {
        local_var_req_builder = local_var_req_builder.query(&[("partner_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_code {
        local_var_req_builder = local_var_req_builder.query(&[("partner_code", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = item_id {
        local_var_req_builder = local_var_req_builder.query(&[("item_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = section_id {
        local_var_req_builder = local_var_req_builder.query(&[("section_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = adjustment {
        local_var_req_builder = local_var_req_builder.query(&[("adjustment", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = cost_allocation {
        local_var_req_builder = local_var_req_builder.query(&[("cost_allocation", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = approval_flow_status {
        local_var_req_builder = local_var_req_builder.query(&[("approval_flow_status", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<GetTrialCrError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

///  <h2 id=\"\">概要</h2>  <p>指定した事業所の製造原価報告書(部門比較)を取得する</p>  <h2 id=\"_2\">定義</h2>  <ul>  <li> <p>created_at : 作成日時</p> </li>  <li> <p>account_item_name : 勘定科目名</p> </li>  <li> <p>hierarchy_level: 階層レベル</p> </li>  <li> <p>parent_account_category_name: 上位勘定科目カテゴリー名</p> </li> <li> <p>closing_balance : 期末残高 </p> </li> <h2 id=\"_3\">注意点</h2> <ul> <li>法人向けのベーシックプラン以上で利用可能なAPIです。対象外のプランでは401エラーを返却します。</li> <li>会計年度が指定されない場合、現在の会計年度がデフォルトとなります。</li> <li>up_to_dateがfalseの場合、残高の集計が完了していません。最新の集計結果を確認したい場合は、時間を空けて再度取得する必要があります。</li> <li>配賦仕訳の絞り込み（cost_allocation）は法人向けのベーシックプラン以上で利用可能です。</li> <li>取引先、品目、部門、セグメントはそれぞれの合計値が1000を超えるとレスポンスを得ることができません。</li> <li>partner_codeとpartner_idは同時に指定することはできません。</li> <li>start_date / end_date を指定した場合、以下を同時に指定することはできません。</li>   <ul>   <li>fiscal_year</li>   <li>start_month</li>   <li>end_month</li>   </ul> <li>0を指定すると未選択で絞り込めます</li>   <ul>   <li>partner_idに0を指定して絞り込んだ場合</li>     <ul>     <li>取引先が設定されていない取引、振替伝票の金額がレスポンスに返却されます</li>     </ul>   </ul> </ul> <h2 id=\"_4\">レスポンスの例</h2>  <blockquote> <p>GET https://api.freee.co.jp/api/1/reports/trial_cr_sections?company_id=1&amp;section_ids=1,2,3&amp;fiscal_year=2019</p></p> </blockquote>  <pre><code>{   &quot;trial_cr_sections&quot; :     {       &quot;company_id&quot; : 1,       &quot;section_ids&quot; : &quot;1,2,3&quot;,       &quot;fiscal_year&quot; : 2019,       &quot;created_at&quot; : &quot;2019-12-17 12:00:50&quot       &quot;balances&quot; : [{         &quot;account_item_id&quot; : 1500,         &quot;account_item_name&quot; : &quot;[製]期首材料棚卸高&quot;,         &quot;hierarchy_level&quot; : 2,         &quot;account_category_name&quot; : &quot;期首原材料棚卸&quot;,         &quot;closing_balance&quot; : 1000000,         &quot;sections&quot; : [{           &quot;id&quot;: 1           &quot;name&quot;: &quot;営業部&quot;,           &quot;closing_balance&quot; : 100000         },         {           &quot;id&quot;: 2           &quot;name&quot;: &quot;広報部&quot;,           &quot;closing_balance&quot; : 200000         },         {           &quot;id&quot;: 3           &quot;name&quot;: &quot;人事部&quot;,           &quot;closing_balance&quot; : 300000         },         ...         ]       },       ...       ]     } }</code></pre> 
pub async fn get_trial_cr_sections(configuration: &configuration::Configuration, company_id: i32, section_ids: &str, fiscal_year: Option<i32>, start_month: Option<i32>, end_month: Option<i32>, start_date: Option<&str>, end_date: Option<&str>, account_item_display_type: Option<&str>, breakdown_display_type: Option<&str>, partner_id: Option<i32>, partner_code: Option<&str>, item_id: Option<i32>, adjustment: Option<&str>, cost_allocation: Option<&str>, approval_flow_status: Option<&str>) -> Result<crate::models::TrialCrSectionsResponse, Error<GetTrialCrSectionsError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/api/1/reports/trial_cr_sections", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    local_var_req_builder = local_var_req_builder.query(&[("company_id", &company_id.to_string())]);
    local_var_req_builder = local_var_req_builder.query(&[("section_ids", &section_ids.to_string())]);
    if let Some(ref local_var_str) = fiscal_year {
        local_var_req_builder = local_var_req_builder.query(&[("fiscal_year", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_month {
        local_var_req_builder = local_var_req_builder.query(&[("start_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_month {
        local_var_req_builder = local_var_req_builder.query(&[("end_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_date {
        local_var_req_builder = local_var_req_builder.query(&[("start_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_date {
        local_var_req_builder = local_var_req_builder.query(&[("end_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = account_item_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("account_item_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = breakdown_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("breakdown_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_id {
        local_var_req_builder = local_var_req_builder.query(&[("partner_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_code {
        local_var_req_builder = local_var_req_builder.query(&[("partner_code", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = item_id {
        local_var_req_builder = local_var_req_builder.query(&[("item_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = adjustment {
        local_var_req_builder = local_var_req_builder.query(&[("adjustment", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = cost_allocation {
        local_var_req_builder = local_var_req_builder.query(&[("cost_allocation", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = approval_flow_status {
        local_var_req_builder = local_var_req_builder.query(&[("approval_flow_status", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<GetTrialCrSectionsError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

///  <h2 id=\"\">概要</h2>  <p>指定した事業所の製造原価報告書(セグメント1比較)を取得する</p>  <h2 id=\"_2\">定義</h2>  <ul>  <li> <p>created_at : 作成日時</p> </li>  <li> <p>account_item_name : 勘定科目名</p> </li>  <li> <p>hierarchy_level: 階層レベル</p> </li>  <li> <p>parent_account_category_name: 上位勘定科目カテゴリー名</p> </li> <li> <p>closing_balance : 期末残高 </p> </li> <h2 id=\"_3\">注意点</h2> <ul> <li>法人向けのプロフェッショナルプラン以上で利用可能なAPIです。対象外のプランでは401エラーを返却します。</li> <li>会計年度が指定されない場合、現在の会計年度がデフォルトとなります。</li> <li>up_to_dateがfalseの場合、残高の集計が完了していません。最新の集計結果を確認したい場合は、時間を空けて再度取得する必要があります。</li> <li>取引先、品目、部門、セグメントはそれぞれの合計値が1000を超えるとレスポンスを得ることができません。</li> <li>partner_codeとpartner_idは同時に指定することはできません。</li> <li>start_date / end_date を指定した場合、以下を同時に指定することはできません。</li>   <ul>   <li>fiscal_year</li>   <li>start_month</li>   <li>end_month</li>   </ul> <li>0を指定すると未選択で絞り込めます</li>   <ul>   <li>partner_idに0を指定して絞り込んだ場合</li>     <ul>     <li>取引先が設定されていない取引、振替伝票の金額がレスポンスに返却されます</li>     </ul>   </ul> </ul> <h2 id=\"_4\">レスポンスの例</h2>  <blockquote> <p>GET https://api.freee.co.jp/api/1/reports/trial_cr_segment_1_tags?company_id=1&amp;segment_1_tag_ids=1,2,3&amp;fiscal_year=2019</p></p> </blockquote>  <pre><code>{   &quot;trial_cr_segment_1_tags&quot; :     {       &quot;company_id&quot; : 1,       &quot;segment_1_tag_ids&quot; : &quot;1,2,3&quot;,       &quot;fiscal_year&quot; : 2019,       &quot;created_at&quot; : &quot;2019-12-17 12:00:50&quot       &quot;balances&quot; : [{         &quot;account_item_id&quot; : 1500,         &quot;account_item_name&quot; : &quot;[製]期首材料棚卸高&quot;,         &quot;hierarchy_level&quot; : 2,         &quot;account_category_name&quot; : &quot;期首原材料棚卸&quot;,         &quot;closing_balance&quot; : 1000000,         &quot;segment_1_tags&quot; : [{           &quot;id&quot;: 1           &quot;name&quot;: &quot;プロジェクトA&quot;,           &quot;closing_balance&quot; : 100000         },         {           &quot;id&quot;: 2           &quot;name&quot;: &quot;プロジェクトB&quot;,           &quot;closing_balance&quot; : 200000         },         {           &quot;id&quot;: 3           &quot;name&quot;: &quot;プロジェクトC&quot;,           &quot;closing_balance&quot; : 300000         },         ...         ]       },       ...       ]     } }</code></pre> 
pub async fn get_trial_cr_segment1_tags(configuration: &configuration::Configuration, company_id: i32, segment_1_tag_ids: &str, fiscal_year: Option<i32>, start_month: Option<i32>, end_month: Option<i32>, start_date: Option<&str>, end_date: Option<&str>, account_item_display_type: Option<&str>, breakdown_display_type: Option<&str>, partner_id: Option<i32>, partner_code: Option<&str>, item_id: Option<i32>, section_id: Option<i32>, adjustment: Option<&str>, cost_allocation: Option<&str>, approval_flow_status: Option<&str>) -> Result<crate::models::TrialCrSegment1TagsResponse, Error<GetTrialCrSegment1TagsError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/api/1/reports/trial_cr_segment_1_tags", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    local_var_req_builder = local_var_req_builder.query(&[("company_id", &company_id.to_string())]);
    local_var_req_builder = local_var_req_builder.query(&[("segment_1_tag_ids", &segment_1_tag_ids.to_string())]);
    if let Some(ref local_var_str) = fiscal_year {
        local_var_req_builder = local_var_req_builder.query(&[("fiscal_year", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_month {
        local_var_req_builder = local_var_req_builder.query(&[("start_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_month {
        local_var_req_builder = local_var_req_builder.query(&[("end_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_date {
        local_var_req_builder = local_var_req_builder.query(&[("start_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_date {
        local_var_req_builder = local_var_req_builder.query(&[("end_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = account_item_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("account_item_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = breakdown_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("breakdown_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_id {
        local_var_req_builder = local_var_req_builder.query(&[("partner_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_code {
        local_var_req_builder = local_var_req_builder.query(&[("partner_code", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = item_id {
        local_var_req_builder = local_var_req_builder.query(&[("item_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = section_id {
        local_var_req_builder = local_var_req_builder.query(&[("section_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = adjustment {
        local_var_req_builder = local_var_req_builder.query(&[("adjustment", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = cost_allocation {
        local_var_req_builder = local_var_req_builder.query(&[("cost_allocation", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = approval_flow_status {
        local_var_req_builder = local_var_req_builder.query(&[("approval_flow_status", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<GetTrialCrSegment1TagsError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

///  <h2 id=\"\">概要</h2>  <p>指定した事業所の製造原価報告書(セグメント2比較)を取得する</p>  <h2 id=\"_2\">定義</h2>  <ul>  <li> <p>created_at : 作成日時</p> </li>  <li> <p>account_item_name : 勘定科目名</p> </li>  <li> <p>hierarchy_level: 階層レベル</p> </li>  <li> <p>parent_account_category_name: 上位勘定科目カテゴリー名</p> </li> <li> <p>closing_balance : 期末残高 </p> </li> <h2 id=\"_3\">注意点</h2> <ul> <li>法人向けのエンタープライズプランで利用可能なAPIです。対象外のプランでは401エラーを返却します。</li> <li>会計年度が指定されない場合、現在の会計年度がデフォルトとなります。</li> <li>up_to_dateがfalseの場合、残高の集計が完了していません。最新の集計結果を確認したい場合は、時間を空けて再度取得する必要があります。</li> <li>取引先、品目、部門、セグメントはそれぞれの合計値が1000を超えるとレスポンスを得ることができません。</li> <li>partner_codeとpartner_idは同時に指定することはできません。</li> <li>start_date / end_date を指定した場合、以下を同時に指定することはできません。</li>   <ul>   <li>fiscal_year</li>   <li>start_month</li>   <li>end_month</li>   </ul> <li>0を指定すると未選択で絞り込めます</li>   <ul>   <li>partner_idに0を指定して絞り込んだ場合</li>     <ul>     <li>取引先が設定されていない取引、振替伝票の金額がレスポンスに返却されます</li>     </ul>   </ul> </ul> <h2 id=\"_4\">レスポンスの例</h2>  <blockquote> <p>GET https://api.freee.co.jp/api/1/reports/trial_cr_segment_2_tags?company_id=1&amp;segment_2_tag_ids=1,2,3&amp;fiscal_year=2019</p></p> </blockquote>  <pre><code>{   &quot;trial_cr_segment_2_tags&quot; :     {       &quot;company_id&quot; : 1,       &quot;segment_2_tag_ids&quot; : &quot;1,2,3&quot;,       &quot;fiscal_year&quot; : 2019,       &quot;created_at&quot; : &quot;2019-12-17 12:00:50&quot       &quot;balances&quot; : [{         &quot;account_item_id&quot; : 1500,         &quot;account_item_name&quot; : &quot;[製]期首材料棚卸高&quot;,         &quot;hierarchy_level&quot; : 2,         &quot;account_category_name&quot; : &quot;期首原材料棚卸&quot;,         &quot;closing_balance&quot; : 1000000,         &quot;segment_2_tags&quot; : [{           &quot;id&quot;: 1           &quot;name&quot;: &quot;プロジェクトA&quot;,           &quot;closing_balance&quot; : 100000         },         {           &quot;id&quot;: 2           &quot;name&quot;: &quot;プロジェクトB&quot;,           &quot;closing_balance&quot; : 200000         },         {           &quot;id&quot;: 3           &quot;name&quot;: &quot;プロジェクトC&quot;,           &quot;closing_balance&quot; : 300000         },         ...         ]       },       ...       ]     } }</code></pre> 
pub async fn get_trial_cr_segment2_tags(configuration: &configuration::Configuration, company_id: i32, segment_2_tag_ids: &str, fiscal_year: Option<i32>, start_month: Option<i32>, end_month: Option<i32>, start_date: Option<&str>, end_date: Option<&str>, account_item_display_type: Option<&str>, breakdown_display_type: Option<&str>, partner_id: Option<i32>, partner_code: Option<&str>, item_id: Option<i32>, section_id: Option<i32>, adjustment: Option<&str>, cost_allocation: Option<&str>, approval_flow_status: Option<&str>) -> Result<crate::models::TrialCrSegment2TagsResponse, Error<GetTrialCrSegment2TagsError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/api/1/reports/trial_cr_segment_2_tags", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    local_var_req_builder = local_var_req_builder.query(&[("company_id", &company_id.to_string())]);
    local_var_req_builder = local_var_req_builder.query(&[("segment_2_tag_ids", &segment_2_tag_ids.to_string())]);
    if let Some(ref local_var_str) = fiscal_year {
        local_var_req_builder = local_var_req_builder.query(&[("fiscal_year", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_month {
        local_var_req_builder = local_var_req_builder.query(&[("start_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_month {
        local_var_req_builder = local_var_req_builder.query(&[("end_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_date {
        local_var_req_builder = local_var_req_builder.query(&[("start_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_date {
        local_var_req_builder = local_var_req_builder.query(&[("end_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = account_item_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("account_item_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = breakdown_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("breakdown_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_id {
        local_var_req_builder = local_var_req_builder.query(&[("partner_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_code {
        local_var_req_builder = local_var_req_builder.query(&[("partner_code", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = item_id {
        local_var_req_builder = local_var_req_builder.query(&[("item_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = section_id {
        local_var_req_builder = local_var_req_builder.query(&[("section_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = adjustment {
        local_var_req_builder = local_var_req_builder.query(&[("adjustment", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = cost_allocation {
        local_var_req_builder = local_var_req_builder.query(&[("cost_allocation", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = approval_flow_status {
        local_var_req_builder = local_var_req_builder.query(&[("approval_flow_status", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<GetTrialCrSegment2TagsError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

///  <h2 id=\"\">概要</h2>  <p>指定した事業所の製造原価報告書(セグメント3比較)を取得する</p>  <h2 id=\"_2\">定義</h2>  <ul>  <li> <p>created_at : 作成日時</p> </li>  <li> <p>account_item_name : 勘定科目名</p> </li>  <li> <p>hierarchy_level: 階層レベル</p> </li>  <li> <p>parent_account_category_name: 上位勘定科目カテゴリー名</p> </li> <li> <p>closing_balance : 期末残高 </p> </li> <h2 id=\"_3\">注意点</h2> <ul> <li>法人向けのエンタープライズプランで利用可能なAPIです。対象外のプランでは401エラーを返却します。</li> <li>会計年度が指定されない場合、現在の会計年度がデフォルトとなります。</li> <li>up_to_dateがfalseの場合、残高の集計が完了していません。最新の集計結果を確認したい場合は、時間を空けて再度取得する必要があります。</li> <li>取引先、品目、部門、セグメントはそれぞれの合計値が1000を超えるとレスポンスを得ることができません。</li> <li>partner_codeとpartner_idは同時に指定することはできません。</li> <li>start_date / end_date を指定した場合、以下を同時に指定することはできません。</li>   <ul>   <li>fiscal_year</li>   <li>start_month</li>   <li>end_month</li>   </ul> <li>0を指定すると未選択で絞り込めます</li>   <ul>   <li>partner_idに0を指定して絞り込んだ場合</li>     <ul>     <li>取引先が設定されていない取引、振替伝票の金額がレスポンスに返却されます</li>     </ul>   </ul> </ul> <h2 id=\"_4\">レスポンスの例</h2>  <blockquote> <p>GET https://api.freee.co.jp/api/1/reports/trial_cr_segment_3_tags?company_id=1&amp;segment_3_tag_ids=1,2,3&amp;fiscal_year=2019</p></p> </blockquote>  <pre><code>{   &quot;trial_cr_segment_3_tags&quot; :     {       &quot;company_id&quot; : 1,       &quot;segment_3_tag_ids&quot; : &quot;1,2,3&quot;,       &quot;fiscal_year&quot; : 2019,       &quot;created_at&quot; : &quot;2019-12-17 12:00:50&quot       &quot;balances&quot; : [{         &quot;account_item_id&quot; : 1500,         &quot;account_item_name&quot; : &quot;[製]期首材料棚卸高&quot;,         &quot;hierarchy_level&quot; : 2,         &quot;account_category_name&quot; : &quot;期首原材料棚卸&quot;,         &quot;closing_balance&quot; : 1000000,         &quot;segment_3_tags&quot; : [{           &quot;id&quot;: 1           &quot;name&quot;: &quot;プロジェクトA&quot;,           &quot;closing_balance&quot; : 100000         },         {           &quot;id&quot;: 2           &quot;name&quot;: &quot;プロジェクトB&quot;,           &quot;closing_balance&quot; : 200000         },         {           &quot;id&quot;: 3           &quot;name&quot;: &quot;プロジェクトC&quot;,           &quot;closing_balance&quot; : 300000         },         ...         ]       },       ...       ]     } }</code></pre> 
pub async fn get_trial_cr_segment3_tags(configuration: &configuration::Configuration, company_id: i32, segment_3_tag_ids: &str, fiscal_year: Option<i32>, start_month: Option<i32>, end_month: Option<i32>, start_date: Option<&str>, end_date: Option<&str>, account_item_display_type: Option<&str>, breakdown_display_type: Option<&str>, partner_id: Option<i32>, partner_code: Option<&str>, item_id: Option<i32>, section_id: Option<i32>, adjustment: Option<&str>, cost_allocation: Option<&str>, approval_flow_status: Option<&str>) -> Result<crate::models::TrialCrSegment3TagsResponse, Error<GetTrialCrSegment3TagsError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/api/1/reports/trial_cr_segment_3_tags", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    local_var_req_builder = local_var_req_builder.query(&[("company_id", &company_id.to_string())]);
    local_var_req_builder = local_var_req_builder.query(&[("segment_3_tag_ids", &segment_3_tag_ids.to_string())]);
    if let Some(ref local_var_str) = fiscal_year {
        local_var_req_builder = local_var_req_builder.query(&[("fiscal_year", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_month {
        local_var_req_builder = local_var_req_builder.query(&[("start_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_month {
        local_var_req_builder = local_var_req_builder.query(&[("end_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_date {
        local_var_req_builder = local_var_req_builder.query(&[("start_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_date {
        local_var_req_builder = local_var_req_builder.query(&[("end_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = account_item_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("account_item_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = breakdown_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("breakdown_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_id {
        local_var_req_builder = local_var_req_builder.query(&[("partner_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_code {
        local_var_req_builder = local_var_req_builder.query(&[("partner_code", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = item_id {
        local_var_req_builder = local_var_req_builder.query(&[("item_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = section_id {
        local_var_req_builder = local_var_req_builder.query(&[("section_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = adjustment {
        local_var_req_builder = local_var_req_builder.query(&[("adjustment", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = cost_allocation {
        local_var_req_builder = local_var_req_builder.query(&[("cost_allocation", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = approval_flow_status {
        local_var_req_builder = local_var_req_builder.query(&[("approval_flow_status", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<GetTrialCrSegment3TagsError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

///  <h2 id=\"\">概要</h2>  <p>指定した事業所の製造原価報告書(３期間比較)を取得する</p>  <h2 id=\"_2\">定義</h2>  <ul>  <li> <p>created_at : 作成日時</p> </li>  <li> <p>account_item_name : 勘定科目名</p> </li>  <li> <p>hierarchy_level: 階層レベル</p> </li>  <li> <p>parent_account_category_name: 上位勘定科目カテゴリー名</p> </li> <li> <p>two_years_before_closing_balance:  前々年度期末残高 </p> </li> <li> <p>last_year_closing_balance:  前年度期末残高 </p> </li> <li> <p>closing_balance : 期末残高 </p> </li> <li> <p>year_on_year : 前年比</p> </li> <h2 id=\"_3\">注意点</h2> <ul> <li>法人向けのプランで利用可能なAPIです。対象外のプランでは401エラーを返却します。</li> <li>会計年度が指定されない場合、現在の会計年度がデフォルトとなります。</li> <li>up_to_dateがfalseの場合、残高の集計が完了していません。最新の集計結果を確認したい場合は、時間を空けて再度取得する必要があります。</li> <li>配賦仕訳の絞り込み（cost_allocation）は法人向けのベーシックプラン以上で利用可能です。</li> <li>取引先、品目、部門、セグメントはそれぞれの合計値が1000を超えるとレスポンスを得ることができません。</li> <li>partner_codeとpartner_idは同時に指定することはできません。</li> <li>start_date / end_date を指定した場合、以下を同時に指定することはできません。</li>   <ul>   <li>fiscal_year</li>   <li>start_month</li>   <li>end_month</li>   </ul> <li>0を指定すると未選択で絞り込めます</li>   <ul>   <li>partner_idに0を指定して絞り込んだ場合</li>     <ul>     <li>取引先が設定されていない取引、振替伝票の金額がレスポンスに返却されます</li>     </ul>   </ul> </ul> <h2 id=\"_4\">レスポンスの例</h2>  <blockquote> <p>GET https://api.freee.co.jp/api/1/reports/trial_cr_three_years?company_id=1&fiscal_year=2019</p> </blockquote>  <pre><code>{   &quot;trial_cr_three_years&quot; :     {       &quot;company_id&quot; : 1,       &quot;fiscal_year&quot; : 2019,       &quot;created_at&quot; : &quot;2019-12-17 12:00:50&quot       &quot;balances&quot; : [{         &quot;account_item_id&quot; : 1500,         &quot;account_item_name&quot; : &quot;[製]期首材料棚卸高&quot;,         &quot;hierarchy_level&quot; : 2,         &quot;account_category_name&quot; : &quot;期首原材料棚卸&quot;,         &quot;two_year_before_closing_balance&quot; : 50000,         &quot;last_year_closing_balance&quot; : 25000,         &quot;closing_balance&quot; : 100000,         &quot;year_on_year&quot; : 0.85       },       ...       ]     } }</code></pre> 
pub async fn get_trial_cr_three_years(configuration: &configuration::Configuration, company_id: i32, fiscal_year: Option<i32>, start_month: Option<i32>, end_month: Option<i32>, start_date: Option<&str>, end_date: Option<&str>, account_item_display_type: Option<&str>, breakdown_display_type: Option<&str>, partner_id: Option<i32>, partner_code: Option<&str>, item_id: Option<i32>, section_id: Option<i32>, adjustment: Option<&str>, cost_allocation: Option<&str>, approval_flow_status: Option<&str>) -> Result<crate::models::TrialCrThreeYearsResponse, Error<GetTrialCrThreeYearsError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/api/1/reports/trial_cr_three_years", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    local_var_req_builder = local_var_req_builder.query(&[("company_id", &company_id.to_string())]);
    if let Some(ref local_var_str) = fiscal_year {
        local_var_req_builder = local_var_req_builder.query(&[("fiscal_year", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_month {
        local_var_req_builder = local_var_req_builder.query(&[("start_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_month {
        local_var_req_builder = local_var_req_builder.query(&[("end_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_date {
        local_var_req_builder = local_var_req_builder.query(&[("start_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_date {
        local_var_req_builder = local_var_req_builder.query(&[("end_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = account_item_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("account_item_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = breakdown_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("breakdown_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_id {
        local_var_req_builder = local_var_req_builder.query(&[("partner_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_code {
        local_var_req_builder = local_var_req_builder.query(&[("partner_code", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = item_id {
        local_var_req_builder = local_var_req_builder.query(&[("item_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = section_id {
        local_var_req_builder = local_var_req_builder.query(&[("section_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = adjustment {
        local_var_req_builder = local_var_req_builder.query(&[("adjustment", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = cost_allocation {
        local_var_req_builder = local_var_req_builder.query(&[("cost_allocation", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = approval_flow_status {
        local_var_req_builder = local_var_req_builder.query(&[("approval_flow_status", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<GetTrialCrThreeYearsError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

///  <h2 id=\"\">概要</h2>  <p>指定した事業所の製造原価報告書(前年比較)を取得する</p>  <h2 id=\"_2\">定義</h2>  <ul>  <li> <p>created_at : 作成日時</p> </li>  <li> <p>account_item_name : 勘定科目名</p> </li>  <li> <p>hierarchy_level: 階層レベル</p> </li>  <li> <p>parent_account_category_name: 上位勘定科目カテゴリー名</p> </li> <li> <p>last_year_closing_balance:  前年度期末残高 </p> </li> <li> <p>closing_balance : 期末残高 </p> </li> <li> <p>year_on_year : 前年比</p> </li> <h2 id=\"_3\">注意点</h2> <ul> <li>法人向けのプランで利用可能なAPIです。対象外のプランでは401エラーを返却します。</li> <li>会計年度が指定されない場合、現在の会計年度がデフォルトとなります。</li> <li>up_to_dateがfalseの場合、残高の集計が完了していません。最新の集計結果を確認したい場合は、時間を空けて再度取得する必要があります。</li> <li>配賦仕訳の絞り込み（cost_allocation）は法人向けのベーシックプラン以上で利用可能です。</li> <li>取引先、品目、部門、セグメントはそれぞれの合計値が1000を超えるとレスポンスを得ることができません。</li> <li>partner_codeとpartner_idは同時に指定することはできません。</li> <li>start_date / end_date を指定した場合、以下を同時に指定することはできません。</li>   <ul>   <li>fiscal_year</li>   <li>start_month</li>   <li>end_month</li>   </ul> <li>0を指定すると未選択で絞り込めます</li>   <ul>   <li>partner_idに0を指定して絞り込んだ場合</li>     <ul>     <li>取引先が設定されていない取引、振替伝票の金額がレスポンスに返却されます</li>     </ul>   </ul> </ul>  <h2 id=\"_4\">レスポンスの例</h2>  <blockquote> <p>GET https://api.freee.co.jp/api/1/reports/trial_cr_two_years?company_id=1&amp;fiscal_year=2019</p> </blockquote>  <pre><code>{   &quot;trial_cr_two_years&quot; :     {       &quot;company_id&quot; : 1,       &quot;fiscal_year&quot; : 2019,       &quot;created_at&quot; : &quot;2019-12-17 12:00:50&quot       &quot;balances&quot; : [{         &quot;account_item_id&quot; : 1500,         &quot;account_item_name&quot; : &quot;[製]期首材料棚卸高&quot;,         &quot;hierarchy_level&quot; : 2,         &quot;account_category_name&quot; : &quot;期首原材料棚卸&quot;,         &quot;last_year_closing_balance&quot; : 25000,         &quot;closing_balance&quot; : 100000,         &quot;year_on_year&quot; : 0.85        },       ...       ]     } }</code></pre> 
pub async fn get_trial_cr_two_years(configuration: &configuration::Configuration, company_id: i32, fiscal_year: Option<i32>, start_month: Option<i32>, end_month: Option<i32>, start_date: Option<&str>, end_date: Option<&str>, account_item_display_type: Option<&str>, breakdown_display_type: Option<&str>, partner_id: Option<i32>, partner_code: Option<&str>, item_id: Option<i32>, section_id: Option<i32>, adjustment: Option<&str>, cost_allocation: Option<&str>, approval_flow_status: Option<&str>) -> Result<crate::models::TrialCrTwoYearsResponse, Error<GetTrialCrTwoYearsError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/api/1/reports/trial_cr_two_years", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    local_var_req_builder = local_var_req_builder.query(&[("company_id", &company_id.to_string())]);
    if let Some(ref local_var_str) = fiscal_year {
        local_var_req_builder = local_var_req_builder.query(&[("fiscal_year", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_month {
        local_var_req_builder = local_var_req_builder.query(&[("start_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_month {
        local_var_req_builder = local_var_req_builder.query(&[("end_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_date {
        local_var_req_builder = local_var_req_builder.query(&[("start_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_date {
        local_var_req_builder = local_var_req_builder.query(&[("end_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = account_item_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("account_item_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = breakdown_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("breakdown_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_id {
        local_var_req_builder = local_var_req_builder.query(&[("partner_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_code {
        local_var_req_builder = local_var_req_builder.query(&[("partner_code", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = item_id {
        local_var_req_builder = local_var_req_builder.query(&[("item_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = section_id {
        local_var_req_builder = local_var_req_builder.query(&[("section_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = adjustment {
        local_var_req_builder = local_var_req_builder.query(&[("adjustment", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = cost_allocation {
        local_var_req_builder = local_var_req_builder.query(&[("cost_allocation", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = approval_flow_status {
        local_var_req_builder = local_var_req_builder.query(&[("approval_flow_status", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<GetTrialCrTwoYearsError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

///  <h2 id=\"\">概要</h2>  <p>指定した事業所の損益計算書を取得する</p>  <h2 id=\"_2\">定義</h2>  <ul>  <li> <p>created_at : 作成日時</p> </li>  <li> <p>account_item_name : 勘定科目名</p> </li>  <li> <p>hierarchy_level: 階層レベル</p> </li>  <li> <p>parent_account_category_name: 上位勘定科目カテゴリー名</p> </li> <li> <p>opening_balance : 期首残高 </p> </li>  <li> <p>debit_amount : 借方金額 </p> </li> <li> <p>credit_amount:  貸方金額 </p> </li> <li> <p>closing_balance : 期末残高 </p> </li> <li> <p>composition_ratio : 構成比</p> </li> <h2 id=\"_3\">注意点</h2> <ul> <li>会計年度が指定されない場合、現在の会計年度がデフォルトとなります。</li> <li>up_to_dateがfalseの場合、残高の集計が完了していません。最新の集計結果を確認したい場合は、時間を空けて再度取得する必要があります。</li> <li>配賦仕訳の絞り込み（cost_allocation）は法人向けのベーシックプラン以上で利用可能です。</li> <li>取引先、品目、部門、セグメントはそれぞれの合計値が1000を超えるとレスポンスを得ることができません。</li> <li>partner_codeとpartner_idは同時に指定することはできません。</li> <li>start_date / end_date を指定した場合、以下を同時に指定することはできません。</li>   <ul>   <li>fiscal_year</li>   <li>start_month</li>   <li>end_month</li>   </ul> <li>0を指定すると未選択で絞り込めます</li>   <ul>   <li>partner_idに0を指定して絞り込んだ場合</li>     <ul>     <li>取引先が設定されていない取引、振替伝票の金額がレスポンスに返却されます</li>     </ul>   </ul> </ul> <h2 id=\"_4\">レスポンスの例</h2>  <blockquote> <p>GET https://api.freee.co.jp/api/1/reports/trial_pl?company_id=1&amp;fiscal_year=2019&amp;breakdown_display_type=partner</p> </blockquote>  <pre><code>{   &quot;trial_pl&quot; :     {       &quot;company_id&quot; : 1,       &quot;fiscal_year&quot; : 2019,       &quot;breakdown_display_type&quot; : &quot;partner&quot;,       &quot;created_at&quot; : &quot;2019-12-17 12:00:50&quot       &quot;balances&quot; : [{         &quot;account_item_id&quot; : 1500,         &quot;account_item_name&quot; : &quot;売上高&quot;,         &quot;hierarchy_level&quot; : 2,         &quot;account_category_name&quot; : &quot;営業収益&quot;,         &quot;opening_balance&quot; : 100000,         &quot;debit_amount&quot; : 50000,         &quot;credit_amount&quot; : 20000,         &quot;closing_balance&quot; : 130000,         &quot;composition_ratio&quot; : 0.25         &quot;partners&quot; : [{           &quot;id&quot; : 123,           &quot;name&quot; : &quot;freee&quot;,           &quot;opening_balance&quot; : 100000,           &quot;debit_amount&quot; : 50000,           &quot;credit_amount&quot; : 20000,           &quot;closing_balance&quot; : 130000,           &quot;composition_ratio&quot; : 0.25           },         ...         ]       },       ...       ]     } }</code></pre> 
pub async fn get_trial_pl(configuration: &configuration::Configuration, company_id: i32, fiscal_year: Option<i32>, start_month: Option<i32>, end_month: Option<i32>, start_date: Option<&str>, end_date: Option<&str>, account_item_display_type: Option<&str>, breakdown_display_type: Option<&str>, partner_id: Option<i32>, partner_code: Option<&str>, item_id: Option<i32>, section_id: Option<i32>, adjustment: Option<&str>, cost_allocation: Option<&str>, approval_flow_status: Option<&str>) -> Result<crate::models::TrialPlResponse, Error<GetTrialPlError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/api/1/reports/trial_pl", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    local_var_req_builder = local_var_req_builder.query(&[("company_id", &company_id.to_string())]);
    if let Some(ref local_var_str) = fiscal_year {
        local_var_req_builder = local_var_req_builder.query(&[("fiscal_year", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_month {
        local_var_req_builder = local_var_req_builder.query(&[("start_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_month {
        local_var_req_builder = local_var_req_builder.query(&[("end_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_date {
        local_var_req_builder = local_var_req_builder.query(&[("start_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_date {
        local_var_req_builder = local_var_req_builder.query(&[("end_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = account_item_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("account_item_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = breakdown_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("breakdown_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_id {
        local_var_req_builder = local_var_req_builder.query(&[("partner_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_code {
        local_var_req_builder = local_var_req_builder.query(&[("partner_code", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = item_id {
        local_var_req_builder = local_var_req_builder.query(&[("item_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = section_id {
        local_var_req_builder = local_var_req_builder.query(&[("section_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = adjustment {
        local_var_req_builder = local_var_req_builder.query(&[("adjustment", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = cost_allocation {
        local_var_req_builder = local_var_req_builder.query(&[("cost_allocation", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = approval_flow_status {
        local_var_req_builder = local_var_req_builder.query(&[("approval_flow_status", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<GetTrialPlError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

///  <h2 id=\"\">概要</h2>  <p>指定した事業所の損益計算書(部門比較)を取得する</p>  <h2 id=\"_2\">定義</h2>  <ul>  <li> <p>created_at : 作成日時</p> </li>  <li> <p>account_item_name : 勘定科目名</p> </li>  <li> <p>hierarchy_level: 階層レベル</p> </li>  <li> <p>parent_account_category_name: 上位勘定科目カテゴリー名</p> </li> <li> <p>closing_balance : 期末残高 </p> </li> <h2 id=\"_3\">注意点</h2> <ul> <li>個人向けのプレミアムプラン、法人向けのベーシックプラン以上で利用可能なAPIです。対象外のプランでは401エラーを返却します。</li> <li>会計年度が指定されない場合、現在の会計年度がデフォルトとなります。</li> <li>up_to_dateがfalseの場合、残高の集計が完了していません。最新の集計結果を確認したい場合は、時間を空けて再度取得する必要があります。</li> <li>配賦仕訳の絞り込み（cost_allocation）は法人向けのベーシックプラン以上で利用可能です。</li> <li>取引先、品目、部門、セグメントはそれぞれの合計値が1000を超えるとレスポンスを得ることができません。</li> <li>partner_codeとpartner_idは同時に指定することはできません。</li> <li>start_date / end_date を指定した場合、以下を同時に指定することはできません。</li>   <ul>   <li>fiscal_year</li>   <li>start_month</li>   <li>end_month</li>   </ul> <li>0を指定すると未選択で絞り込めます</li>   <ul>   <li>partner_idに0を指定して絞り込んだ場合</li>     <ul>     <li>取引先が設定されていない取引、振替伝票の金額がレスポンスに返却されます</li>     </ul>   </ul> </ul> <h2 id=\"_4\">レスポンスの例</h2>  <blockquote> <p>GET https://api.freee.co.jp/api/1/reports/trial_pl_sections?company_id=1&amp;section_ids=1,2,3&amp;fiscal_year=2019</p></p> </blockquote>  <pre><code>{   &quot;trial_pl_sections&quot; :     {       &quot;company_id&quot; : 1,       &quot;section_ids&quot; : &quot;1,2,3&quot;,       &quot;fiscal_year&quot; : 2019,       &quot;created_at&quot; : &quot;2019-12-17 12:00:50&quot       &quot;balances&quot; : [{         &quot;account_item_id&quot; : 1500,         &quot;account_item_name&quot; : &quot;売上高&quot;,         &quot;hierarchy_level&quot; : 2,         &quot;account_category_name&quot; : &quot;営業収益&quot;,         &quot;closing_balance&quot; : 1000000,         &quot;sections&quot; : [{           &quot;id&quot;: 1           &quot;name&quot;: &quot;営業部&quot;,           &quot;closing_balance&quot; : 100000         },         {           &quot;id&quot;: 2           &quot;name&quot;: &quot;広報部&quot;,           &quot;closing_balance&quot; : 200000         },         {           &quot;id&quot;: 3           &quot;name&quot;: &quot;人事部&quot;,           &quot;closing_balance&quot; : 300000         },         ...         ]       },       ...       ]     } }</code></pre> 
pub async fn get_trial_pl_sections(configuration: &configuration::Configuration, company_id: i32, section_ids: &str, fiscal_year: Option<i32>, start_month: Option<i32>, end_month: Option<i32>, start_date: Option<&str>, end_date: Option<&str>, account_item_display_type: Option<&str>, breakdown_display_type: Option<&str>, partner_id: Option<i32>, partner_code: Option<&str>, item_id: Option<i32>, adjustment: Option<&str>, cost_allocation: Option<&str>, approval_flow_status: Option<&str>) -> Result<crate::models::TrialPlSectionsResponse, Error<GetTrialPlSectionsError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/api/1/reports/trial_pl_sections", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    local_var_req_builder = local_var_req_builder.query(&[("company_id", &company_id.to_string())]);
    local_var_req_builder = local_var_req_builder.query(&[("section_ids", &section_ids.to_string())]);
    if let Some(ref local_var_str) = fiscal_year {
        local_var_req_builder = local_var_req_builder.query(&[("fiscal_year", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_month {
        local_var_req_builder = local_var_req_builder.query(&[("start_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_month {
        local_var_req_builder = local_var_req_builder.query(&[("end_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_date {
        local_var_req_builder = local_var_req_builder.query(&[("start_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_date {
        local_var_req_builder = local_var_req_builder.query(&[("end_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = account_item_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("account_item_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = breakdown_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("breakdown_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_id {
        local_var_req_builder = local_var_req_builder.query(&[("partner_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_code {
        local_var_req_builder = local_var_req_builder.query(&[("partner_code", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = item_id {
        local_var_req_builder = local_var_req_builder.query(&[("item_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = adjustment {
        local_var_req_builder = local_var_req_builder.query(&[("adjustment", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = cost_allocation {
        local_var_req_builder = local_var_req_builder.query(&[("cost_allocation", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = approval_flow_status {
        local_var_req_builder = local_var_req_builder.query(&[("approval_flow_status", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<GetTrialPlSectionsError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

///  <h2 id=\"\">概要</h2>  <p>指定した事業所の損益計算書(セグメント1比較)を取得する</p>  <h2 id=\"_2\">定義</h2>  <ul>  <li> <p>created_at : 作成日時</p> </li>  <li> <p>account_item_name : 勘定科目名</p> </li>  <li> <p>hierarchy_level: 階層レベル</p> </li>  <li> <p>parent_account_category_name: 上位勘定科目カテゴリー名</p> </li> <li> <p>closing_balance : 期末残高 </p> </li> <h2 id=\"_3\">注意点</h2> <ul> <li>法人向けのプロフェッショナルプラン以上で利用可能なAPIです。対象外のプランでは401エラーを返却します。</li> <li>会計年度が指定されない場合、現在の会計年度がデフォルトとなります。</li> <li>up_to_dateがfalseの場合、残高の集計が完了していません。最新の集計結果を確認したい場合は、時間を空けて再度取得する必要があります。</li> <li>取引先、品目、部門、セグメントはそれぞれの合計値が1000を超えるとレスポンスを得ることができません。</li> <li>partner_codeとpartner_idは同時に指定することはできません。</li> <li>start_date / end_date を指定した場合、以下を同時に指定することはできません。</li>   <ul>   <li>fiscal_year</li>   <li>start_month</li>   <li>end_month</li>   </ul> <li>0を指定すると未選択で絞り込めます</li>   <ul>   <li>partner_idに0を指定して絞り込んだ場合</li>     <ul>     <li>取引先が設定されていない取引、振替伝票の金額がレスポンスに返却されます</li>     </ul>   </ul> </ul> <h2 id=\"_4\">レスポンスの例</h2>  <blockquote> <p>GET https://api.freee.co.jp/api/1/reports/trial_pl_segment_1_tags?company_id=1&amp;segment_1_tag_ids=1,2,3&amp;fiscal_year=2019</p></p> </blockquote>  <pre><code>{   &quot;trial_pl_segment_1_tags&quot; :     {       &quot;company_id&quot; : 1,       &quot;segment_1_tag_ids&quot; : &quot;1,2,3&quot;,       &quot;fiscal_year&quot; : 2019,       &quot;created_at&quot; : &quot;2019-12-17 12:00:50&quot       &quot;balances&quot; : [{         &quot;account_item_id&quot; : 1500,         &quot;account_item_name&quot; : &quot;売上高&quot;,         &quot;hierarchy_level&quot; : 2,         &quot;account_category_name&quot; : &quot;営業収益&quot;,         &quot;closing_balance&quot; : 1000000,         &quot;segment_1_tags&quot; : [{           &quot;id&quot;: 1           &quot;name&quot;: &quot;プロジェクトA&quot;,           &quot;closing_balance&quot; : 100000         },         {           &quot;id&quot;: 2           &quot;name&quot;: &quot;プロジェクトB&quot;,           &quot;closing_balance&quot; : 200000         },         {           &quot;id&quot;: 3           &quot;name&quot;: &quot;プロジェクトC&quot;,           &quot;closing_balance&quot; : 300000         },         ...         ]       },       ...       ]     } }</code></pre> 
pub async fn get_trial_pl_segment1_tags(configuration: &configuration::Configuration, company_id: i32, segment_1_tag_ids: &str, fiscal_year: Option<i32>, start_month: Option<i32>, end_month: Option<i32>, start_date: Option<&str>, end_date: Option<&str>, account_item_display_type: Option<&str>, breakdown_display_type: Option<&str>, partner_id: Option<i32>, partner_code: Option<&str>, item_id: Option<i32>, section_id: Option<i32>, adjustment: Option<&str>, cost_allocation: Option<&str>, approval_flow_status: Option<&str>) -> Result<crate::models::TrialPlSegment1TagsResponse, Error<GetTrialPlSegment1TagsError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/api/1/reports/trial_pl_segment_1_tags", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    local_var_req_builder = local_var_req_builder.query(&[("company_id", &company_id.to_string())]);
    local_var_req_builder = local_var_req_builder.query(&[("segment_1_tag_ids", &segment_1_tag_ids.to_string())]);
    if let Some(ref local_var_str) = fiscal_year {
        local_var_req_builder = local_var_req_builder.query(&[("fiscal_year", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_month {
        local_var_req_builder = local_var_req_builder.query(&[("start_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_month {
        local_var_req_builder = local_var_req_builder.query(&[("end_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_date {
        local_var_req_builder = local_var_req_builder.query(&[("start_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_date {
        local_var_req_builder = local_var_req_builder.query(&[("end_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = account_item_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("account_item_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = breakdown_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("breakdown_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_id {
        local_var_req_builder = local_var_req_builder.query(&[("partner_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_code {
        local_var_req_builder = local_var_req_builder.query(&[("partner_code", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = item_id {
        local_var_req_builder = local_var_req_builder.query(&[("item_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = section_id {
        local_var_req_builder = local_var_req_builder.query(&[("section_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = adjustment {
        local_var_req_builder = local_var_req_builder.query(&[("adjustment", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = cost_allocation {
        local_var_req_builder = local_var_req_builder.query(&[("cost_allocation", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = approval_flow_status {
        local_var_req_builder = local_var_req_builder.query(&[("approval_flow_status", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<GetTrialPlSegment1TagsError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

///  <h2 id=\"\">概要</h2>  <p>指定した事業所の損益計算書(セグメント2比較)を取得する</p>  <h2 id=\"_2\">定義</h2>  <ul>  <li> <p>created_at : 作成日時</p> </li>  <li> <p>account_item_name : 勘定科目名</p> </li>  <li> <p>hierarchy_level: 階層レベル</p> </li>  <li> <p>parent_account_category_name: 上位勘定科目カテゴリー名</p> </li> <li> <p>closing_balance : 期末残高 </p> </li> <h2 id=\"_3\">注意点</h2> <ul> <li>法人向けのエンタープライズプランで利用可能なAPIです。対象外のプランでは401エラーを返却します。</li> <li>会計年度が指定されない場合、現在の会計年度がデフォルトとなります。</li> <li>up_to_dateがfalseの場合、残高の集計が完了していません。最新の集計結果を確認したい場合は、時間を空けて再度取得する必要があります。</li> <li>取引先、品目、部門、セグメントはそれぞれの合計値が1000を超えるとレスポンスを得ることができません。</li> <li>partner_codeとpartner_idは同時に指定することはできません。</li> <li>start_date / end_date を指定した場合、以下を同時に指定することはできません。</li>   <ul>   <li>fiscal_year</li>   <li>start_month</li>   <li>end_month</li>   </ul> <li>0を指定すると未選択で絞り込めます</li>   <ul>   <li>partner_idに0を指定して絞り込んだ場合</li>     <ul>     <li>取引先が設定されていない取引、振替伝票の金額がレスポンスに返却されます</li>     </ul>   </ul> </ul> <h2 id=\"_4\">レスポンスの例</h2>  <blockquote> <p>GET https://api.freee.co.jp/api/1/reports/trial_pl_segment_2_tags?company_id=1&amp;segment_2_tag_ids=1,2,3&amp;fiscal_year=2019</p></p> </blockquote>  <pre><code>{   &quot;trial_pl_segment_2_tags&quot; :     {       &quot;company_id&quot; : 1,       &quot;segment_2_tag_ids&quot; : &quot;1,2,3&quot;,       &quot;fiscal_year&quot; : 2019,       &quot;created_at&quot; : &quot;2019-12-17 12:00:50&quot       &quot;balances&quot; : [{         &quot;account_item_id&quot; : 1500,         &quot;account_item_name&quot; : &quot;売上高&quot;,         &quot;hierarchy_level&quot; : 2,         &quot;account_category_name&quot; : &quot;営業収益&quot;,         &quot;closing_balance&quot; : 1000000,         &quot;segment_2_tags&quot; : [{           &quot;id&quot;: 1           &quot;name&quot;: &quot;プロジェクトA&quot;,           &quot;closing_balance&quot; : 100000         },         {           &quot;id&quot;: 2           &quot;name&quot;: &quot;プロジェクトB&quot;,           &quot;closing_balance&quot; : 200000         },         {           &quot;id&quot;: 3           &quot;name&quot;: &quot;プロジェクトC&quot;,           &quot;closing_balance&quot; : 300000         },         ...         ]       },       ...       ]     } }</code></pre> 
pub async fn get_trial_pl_segment2_tags(configuration: &configuration::Configuration, company_id: i32, segment_2_tag_ids: &str, fiscal_year: Option<i32>, start_month: Option<i32>, end_month: Option<i32>, start_date: Option<&str>, end_date: Option<&str>, account_item_display_type: Option<&str>, breakdown_display_type: Option<&str>, partner_id: Option<i32>, partner_code: Option<&str>, item_id: Option<i32>, section_id: Option<i32>, adjustment: Option<&str>, cost_allocation: Option<&str>, approval_flow_status: Option<&str>) -> Result<crate::models::TrialPlSegment2TagsResponse, Error<GetTrialPlSegment2TagsError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/api/1/reports/trial_pl_segment_2_tags", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    local_var_req_builder = local_var_req_builder.query(&[("company_id", &company_id.to_string())]);
    local_var_req_builder = local_var_req_builder.query(&[("segment_2_tag_ids", &segment_2_tag_ids.to_string())]);
    if let Some(ref local_var_str) = fiscal_year {
        local_var_req_builder = local_var_req_builder.query(&[("fiscal_year", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_month {
        local_var_req_builder = local_var_req_builder.query(&[("start_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_month {
        local_var_req_builder = local_var_req_builder.query(&[("end_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_date {
        local_var_req_builder = local_var_req_builder.query(&[("start_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_date {
        local_var_req_builder = local_var_req_builder.query(&[("end_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = account_item_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("account_item_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = breakdown_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("breakdown_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_id {
        local_var_req_builder = local_var_req_builder.query(&[("partner_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_code {
        local_var_req_builder = local_var_req_builder.query(&[("partner_code", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = item_id {
        local_var_req_builder = local_var_req_builder.query(&[("item_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = section_id {
        local_var_req_builder = local_var_req_builder.query(&[("section_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = adjustment {
        local_var_req_builder = local_var_req_builder.query(&[("adjustment", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = cost_allocation {
        local_var_req_builder = local_var_req_builder.query(&[("cost_allocation", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = approval_flow_status {
        local_var_req_builder = local_var_req_builder.query(&[("approval_flow_status", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<GetTrialPlSegment2TagsError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

///  <h2 id=\"\">概要</h2>  <p>指定した事業所の損益計算書(セグメント3比較)を取得する</p>  <h2 id=\"_2\">定義</h2>  <ul>  <li> <p>created_at : 作成日時</p> </li>  <li> <p>account_item_name : 勘定科目名</p> </li>  <li> <p>hierarchy_level: 階層レベル</p> </li>  <li> <p>parent_account_category_name: 上位勘定科目カテゴリー名</p> </li> <li> <p>closing_balance : 期末残高 </p> </li> <h2 id=\"_3\">注意点</h2> <ul> <li>法人向けのエンタープライズプランで利用可能なAPIです。対象外のプランでは401エラーを返却します。</li> <li>会計年度が指定されない場合、現在の会計年度がデフォルトとなります。</li> <li>up_to_dateがfalseの場合、残高の集計が完了していません。最新の集計結果を確認したい場合は、時間を空けて再度取得する必要があります。</li> <li>取引先、品目、部門、セグメントはそれぞれの合計値が1000を超えるとレスポンスを得ることができません。</li> <li>partner_codeとpartner_idは同時に指定することはできません。</li> <li>start_date / end_date を指定した場合、以下を同時に指定することはできません。</li>   <ul>   <li>fiscal_year</li>   <li>start_month</li>   <li>end_month</li>   </ul> <li>0を指定すると未選択で絞り込めます</li>   <ul>   <li>partner_idに0を指定して絞り込んだ場合</li>     <ul>     <li>取引先が設定されていない取引、振替伝票の金額がレスポンスに返却されます</li>     </ul>   </ul> </ul> <h2 id=\"_4\">レスポンスの例</h2>  <blockquote> <p>GET https://api.freee.co.jp/api/1/reports/trial_pl_segment_3_tags?company_id=1&amp;segment_3_tag_ids=1,2,3&amp;fiscal_year=2019</p></p> </blockquote>  <pre><code>{   &quot;trial_pl_segment_3_tags&quot; :     {       &quot;company_id&quot; : 1,       &quot;segment_3_tag_ids&quot; : &quot;1,2,3&quot;,       &quot;fiscal_year&quot; : 2019,       &quot;created_at&quot; : &quot;2019-12-17 12:00:50&quot       &quot;balances&quot; : [{         &quot;account_item_id&quot; : 1500,         &quot;account_item_name&quot; : &quot;売上高&quot;,         &quot;hierarchy_level&quot; : 2,         &quot;account_category_name&quot; : &quot;営業収益&quot;,         &quot;closing_balance&quot; : 1000000,         &quot;segment_3_tags&quot; : [{           &quot;id&quot;: 1           &quot;name&quot;: &quot;プロジェクトA&quot;,           &quot;closing_balance&quot; : 100000         },         {           &quot;id&quot;: 2           &quot;name&quot;: &quot;プロジェクトB&quot;,           &quot;closing_balance&quot; : 200000         },         {           &quot;id&quot;: 3           &quot;name&quot;: &quot;プロジェクトC&quot;,           &quot;closing_balance&quot; : 300000         },         ...         ]       },       ...       ]     } }</code></pre> 
pub async fn get_trial_pl_segment3_tags(configuration: &configuration::Configuration, company_id: i32, segment_3_tag_ids: &str, fiscal_year: Option<i32>, start_month: Option<i32>, end_month: Option<i32>, start_date: Option<&str>, end_date: Option<&str>, account_item_display_type: Option<&str>, breakdown_display_type: Option<&str>, partner_id: Option<i32>, partner_code: Option<&str>, item_id: Option<i32>, section_id: Option<i32>, adjustment: Option<&str>, cost_allocation: Option<&str>, approval_flow_status: Option<&str>) -> Result<crate::models::TrialPlSegment3TagsResponse, Error<GetTrialPlSegment3TagsError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/api/1/reports/trial_pl_segment_3_tags", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    local_var_req_builder = local_var_req_builder.query(&[("company_id", &company_id.to_string())]);
    local_var_req_builder = local_var_req_builder.query(&[("segment_3_tag_ids", &segment_3_tag_ids.to_string())]);
    if let Some(ref local_var_str) = fiscal_year {
        local_var_req_builder = local_var_req_builder.query(&[("fiscal_year", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_month {
        local_var_req_builder = local_var_req_builder.query(&[("start_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_month {
        local_var_req_builder = local_var_req_builder.query(&[("end_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_date {
        local_var_req_builder = local_var_req_builder.query(&[("start_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_date {
        local_var_req_builder = local_var_req_builder.query(&[("end_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = account_item_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("account_item_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = breakdown_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("breakdown_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_id {
        local_var_req_builder = local_var_req_builder.query(&[("partner_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_code {
        local_var_req_builder = local_var_req_builder.query(&[("partner_code", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = item_id {
        local_var_req_builder = local_var_req_builder.query(&[("item_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = section_id {
        local_var_req_builder = local_var_req_builder.query(&[("section_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = adjustment {
        local_var_req_builder = local_var_req_builder.query(&[("adjustment", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = cost_allocation {
        local_var_req_builder = local_var_req_builder.query(&[("cost_allocation", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = approval_flow_status {
        local_var_req_builder = local_var_req_builder.query(&[("approval_flow_status", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<GetTrialPlSegment3TagsError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

///  <h2 id=\"\">概要</h2>  <p>指定した事業所の損益計算書(３期間比較)を取得する</p>  <h2 id=\"_2\">定義</h2>  <ul>  <li> <p>created_at : 作成日時</p> </li>  <li> <p>account_item_name : 勘定科目名</p> </li>  <li> <p>hierarchy_level: 階層レベル</p> </li>  <li> <p>parent_account_category_name: 上位勘定科目カテゴリー名</p> </li> <li> <p>two_years_before_closing_balance:  前々年度期末残高 </p> </li> <li> <p>last_year_closing_balance:  前年度期末残高 </p> </li> <li> <p>closing_balance : 期末残高 </p> </li> <li> <p>year_on_year : 前年比</p> </li> <h2 id=\"_3\">注意点</h2> <ul> <li>会計年度が指定されない場合、現在の会計年度がデフォルトとなります。</li> <li>up_to_dateがfalseの場合、残高の集計が完了していません。最新の集計結果を確認したい場合は、時間を空けて再度取得する必要があります。</li> <li>配賦仕訳の絞り込み（cost_allocation）は法人向けのベーシックプラン以上で利用可能です。</li> <li>取引先、品目、部門、セグメントはそれぞれの合計値が1000を超えるとレスポンスを得ることができません。</li> <li>partner_codeとpartner_idは同時に指定することはできません。</li> <li>start_date / end_date を指定した場合、以下を同時に指定することはできません。</li>   <ul>   <li>fiscal_year</li>   <li>start_month</li>   <li>end_month</li>   </ul> <li>0を指定すると未選択で絞り込めます</li>   <ul>   <li>partner_idに0を指定して絞り込んだ場合</li>     <ul>     <li>取引先が設定されていない取引、振替伝票の金額がレスポンスに返却されます</li>     </ul>   </ul> </ul> <h2 id=\"_4\">レスポンスの例</h2>  <blockquote> <p>GET https://api.freee.co.jp/api/1/reports/trial_pl_three_years?company_id=1&fiscal_year=2019</p> </blockquote>  <pre><code>{   &quot;trial_pl_three_years&quot; :     {       &quot;company_id&quot; : 1,       &quot;fiscal_year&quot; : 2019,       &quot;created_at&quot; : &quot;2019-12-17 12:00:50&quot       &quot;balances&quot; : [{         &quot;account_item_id&quot; : 1500,         &quot;account_item_name&quot; : &quot;売上高&quot;,         &quot;hierarchy_level&quot; : 2,         &quot;account_category_name&quot; : &quot;営業収益&quot;,         &quot;two_year_before_closing_balance&quot; : 50000,         &quot;last_year_closing_balance&quot; : 25000,         &quot;closing_balance&quot; : 100000,         &quot;year_on_year&quot; : 0.85       },       ...       ]     } }</code></pre> 
pub async fn get_trial_pl_three_years(configuration: &configuration::Configuration, company_id: i32, fiscal_year: Option<i32>, start_month: Option<i32>, end_month: Option<i32>, start_date: Option<&str>, end_date: Option<&str>, account_item_display_type: Option<&str>, breakdown_display_type: Option<&str>, partner_id: Option<i32>, partner_code: Option<&str>, item_id: Option<i32>, section_id: Option<i32>, adjustment: Option<&str>, cost_allocation: Option<&str>, approval_flow_status: Option<&str>) -> Result<crate::models::TrialPlThreeYearsResponse, Error<GetTrialPlThreeYearsError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/api/1/reports/trial_pl_three_years", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    local_var_req_builder = local_var_req_builder.query(&[("company_id", &company_id.to_string())]);
    if let Some(ref local_var_str) = fiscal_year {
        local_var_req_builder = local_var_req_builder.query(&[("fiscal_year", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_month {
        local_var_req_builder = local_var_req_builder.query(&[("start_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_month {
        local_var_req_builder = local_var_req_builder.query(&[("end_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_date {
        local_var_req_builder = local_var_req_builder.query(&[("start_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_date {
        local_var_req_builder = local_var_req_builder.query(&[("end_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = account_item_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("account_item_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = breakdown_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("breakdown_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_id {
        local_var_req_builder = local_var_req_builder.query(&[("partner_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_code {
        local_var_req_builder = local_var_req_builder.query(&[("partner_code", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = item_id {
        local_var_req_builder = local_var_req_builder.query(&[("item_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = section_id {
        local_var_req_builder = local_var_req_builder.query(&[("section_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = adjustment {
        local_var_req_builder = local_var_req_builder.query(&[("adjustment", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = cost_allocation {
        local_var_req_builder = local_var_req_builder.query(&[("cost_allocation", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = approval_flow_status {
        local_var_req_builder = local_var_req_builder.query(&[("approval_flow_status", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<GetTrialPlThreeYearsError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

///  <h2 id=\"\">概要</h2>  <p>指定した事業所の損益計算書(前年比較)を取得する</p>  <h2 id=\"_2\">定義</h2>  <ul>  <li> <p>created_at : 作成日時</p> </li>  <li> <p>account_item_name : 勘定科目名</p> </li>  <li> <p>hierarchy_level: 階層レベル</p> </li>  <li> <p>parent_account_category_name: 上位勘定科目カテゴリー名</p> </li> <li> <p>last_year_closing_balance:  前年度期末残高 </p> </li> <li> <p>closing_balance : 期末残高 </p> </li> <li> <p>year_on_year : 前年比</p> </li> <h2 id=\"_3\">注意点</h2> <ul> <li>会計年度が指定されない場合、現在の会計年度がデフォルトとなります。</li> <li>up_to_dateがfalseの場合、残高の集計が完了していません。最新の集計結果を確認したい場合は、時間を空けて再度取得する必要があります。</li> <li>配賦仕訳の絞り込み（cost_allocation）は法人向けのベーシックプラン以上で利用可能です。</li> <li>取引先、品目、部門、セグメントはそれぞれの合計値が1000を超えるとレスポンスを得ることができません。</li> <li>partner_codeとpartner_idは同時に指定することはできません。</li> <li>start_date / end_date を指定した場合、以下を同時に指定することはできません。</li>   <ul>   <li>fiscal_year</li>   <li>start_month</li>   <li>end_month</li>   </ul> <li>0を指定すると未選択で絞り込めます</li>   <ul>   <li>partner_idに0を指定して絞り込んだ場合</li>     <ul>     <li>取引先が設定されていない取引、振替伝票の金額がレスポンスに返却されます</li>     </ul>   </ul> </ul>  <h2 id=\"_4\">レスポンスの例</h2>  <blockquote> <p>GET https://api.freee.co.jp/api/1/reports/trial_pl_two_years?company_id=1&amp;fiscal_year=2019</p> </blockquote>  <pre><code>{   &quot;trial_pl_two_years&quot; :     {       &quot;company_id&quot; : 1,       &quot;fiscal_year&quot; : 2019,       &quot;created_at&quot; : &quot;2019-12-17 12:00:50&quot       &quot;balances&quot; : [{         &quot;account_item_id&quot; : 1500,         &quot;account_item_name&quot; : &quot;売上高&quot;,         &quot;hierarchy_level&quot; : 2,         &quot;account_category_name&quot; : &quot;営業収益&quot;,         &quot;last_year_closing_balance&quot; : 25000,         &quot;closing_balance&quot; : 100000,         &quot;year_on_year&quot; : 0.85        },       ...       ]     } }</code></pre> 
pub async fn get_trial_pl_two_years(configuration: &configuration::Configuration, company_id: i32, fiscal_year: Option<i32>, start_month: Option<i32>, end_month: Option<i32>, start_date: Option<&str>, end_date: Option<&str>, account_item_display_type: Option<&str>, breakdown_display_type: Option<&str>, partner_id: Option<i32>, partner_code: Option<&str>, item_id: Option<i32>, section_id: Option<i32>, adjustment: Option<&str>, cost_allocation: Option<&str>, approval_flow_status: Option<&str>) -> Result<crate::models::TrialPlTwoYearsResponse, Error<GetTrialPlTwoYearsError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/api/1/reports/trial_pl_two_years", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    local_var_req_builder = local_var_req_builder.query(&[("company_id", &company_id.to_string())]);
    if let Some(ref local_var_str) = fiscal_year {
        local_var_req_builder = local_var_req_builder.query(&[("fiscal_year", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_month {
        local_var_req_builder = local_var_req_builder.query(&[("start_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_month {
        local_var_req_builder = local_var_req_builder.query(&[("end_month", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = start_date {
        local_var_req_builder = local_var_req_builder.query(&[("start_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = end_date {
        local_var_req_builder = local_var_req_builder.query(&[("end_date", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = account_item_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("account_item_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = breakdown_display_type {
        local_var_req_builder = local_var_req_builder.query(&[("breakdown_display_type", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_id {
        local_var_req_builder = local_var_req_builder.query(&[("partner_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = partner_code {
        local_var_req_builder = local_var_req_builder.query(&[("partner_code", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = item_id {
        local_var_req_builder = local_var_req_builder.query(&[("item_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = section_id {
        local_var_req_builder = local_var_req_builder.query(&[("section_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = adjustment {
        local_var_req_builder = local_var_req_builder.query(&[("adjustment", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = cost_allocation {
        local_var_req_builder = local_var_req_builder.query(&[("cost_allocation", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = approval_flow_status {
        local_var_req_builder = local_var_req_builder.query(&[("approval_flow_status", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<GetTrialPlTwoYearsError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

