# Rust API client for openapi


<h1 id=\"freee_api\">freee API</h1>
<hr />
<h2 id=\"start_guide\">スタートガイド</h2>

<p>freee API開発がはじめての方は<a href=\"https://developer.freee.co.jp/getting-started\">freee API スタートガイド</a>を参照してください。</p>

<hr />
<h2 id=\"specification\">仕様</h2>

<h3 id=\"api_endpoint\">APIエンドポイント</h3>

<p>https://api.freee.co.jp/ (httpsのみ)</p>

<h3 id=\"about_authorize\">認証について</h3>
<p>OAuth2.0を利用します。詳細は<a href=\"https://developer.freee.co.jp/docs\" target=\"_blank\">ドキュメントの認証</a>パートを参照してください。</p>

<h3 id=\"data_format\">データフォーマット</h3>

<p>リクエスト、レスポンスともにJSON形式をサポートしていますが、詳細は、API毎の説明欄（application/jsonなど）を確認してください。</p>

<h3 id=\"compatibility\">後方互換性ありの変更</h3>

<p>freeeでは、APIを改善していくために以下のような変更は後方互換性ありとして通知なく変更を入れることがあります。アプリケーション実装者は以下を踏まえて開発を行ってください。</p>

<ul>
<li>新しいAPIリソース・エンドポイントの追加</li>
<li>既存のAPIに対して必須ではない新しいリクエストパラメータの追加</li>
<li>既存のAPIレスポンスに対する新しいプロパティの追加</li>
<li>既存のAPIレスポンスに対するプロパティの順番の入れ変え</li>
<li>keyとなっているidやcodeの長さの変更（長くする）</li>
</ul>

<h3 id=\"common_response_header\">共通レスポンスヘッダー</h3>

<p>すべてのAPIのレスポンスには以下のHTTPヘッダーが含まれます。</p>

<ul>
<li>
<p>X-Freee-Request-ID</p>
<ul>
<li>各リクエスト毎に発行されるID</li>
</ul>
</li>
</ul>

<h3 id=\"common_error_response\">共通エラーレスポンス</h3>

<ul>
<li>
<p>ステータスコードはレスポンス内のJSONに含まれる他、HTTPヘッダにも含まれる</p>
</li>
<li>
<p>一部のエラーレスポンスにはエラーコードが含まれます。<br>詳細は、<a href=\"https://developer.freee.co.jp/tips/faq/40x-checkpoint\">HTTPステータスコード400台エラー時のチェックポイント</a>を参照してください</p>
</li>
<p>type</p>

<ul>
<li>status : HTTPステータスコードの説明</li>

<li>validation : エラーの詳細の説明（開発者向け）</li>
</ul>
</li>
</ul>

<p>レスポンスの例</p>

<pre><code>  {
    &quot;status_code&quot; : 400,
    &quot;errors&quot; : [
      {
        &quot;type&quot; : &quot;status&quot;,
        &quot;messages&quot; : [&quot;不正なリクエストです。&quot;]
      },
      {
        &quot;type&quot; : &quot;validation&quot;,
        &quot;messages&quot; : [&quot;Date は不正な日付フォーマットです。入力例：2019-12-17&quot;]
      }
    ]
  }</code></pre>

</br>

<h3 id=\"api_rate_limit\">API使用制限</h3>

  <p>freeeは一定期間に過度のアクセスを検知した場合、APIアクセスをコントロールする場合があります。</p>
  <p>その際のhttp status codeは403となります。制限がかかってから10分程度が過ぎると再度使用することができるようになります。</p>

<h4 id=\"reports_api_endpoint\">/reportsと/receipts/{id}/downloadエンドポイント</h4>

<p>freeeはエンドポイント毎に一定頻度以上のアクセスを検知した場合、APIアクセスをコントロールする場合があります。その際のhttp status codeは429（too many requests）となります。</p>

<ul>
  <li>/reports:1秒に10回まで</li>
  <li>/receipts/{id}/download:1秒に3回まで</li>
</ul>

<p>レスポンスボディのmetaプロパティに以下を含めます。</p>

<ul>
  <li>設定されている上限値</li>
  <li>上限に達するまでの使用可能回数</li>
  <li>（上限値に達した場合）使用回数がリセットされる時刻</li>
</ul>

<h3 id=\"plan_api_rate_limit\">プラン別のAPI Rate Limit</h3>
  <table border=\"1\">
    <tbody>
      <tr>
        <th style=\"padding: 10px\"><strong>freee会計プラン名</strong></th>
        <th style=\"padding: 10px\"><strong>事業所とアプリケーション毎に1日でのAPIコール数</strong></th>
      </tr>
      <tr>
        <td style=\"padding: 10px\">エンタープライズ</td>
        <td style=\"padding: 10px\">10,000</td>
      </tr>
      <tr>
        <td style=\"padding: 10px\">プロフェッショナル</td>
        <td style=\"padding: 10px\">5,000</td>
      </tr>
      <tr>
        <td style=\"padding: 10px\">ベーシック</td>
        <td style=\"padding: 10px\">3,000</td>
      </tr>
      <tr>
        <td style=\"padding: 10px\">ミニマム</td>
        <td style=\"padding: 10px\">3,000</td>
      </tr>
      <tr>
        <td style=\"padding: 10px\">上記以外</td>
        <td style=\"padding: 10px\">3,000</td>
      </tr>
    </tbody>
  </table>

<h3 id=\"webhook\">Webhookについて</h3>

<p>詳細は<a href=\"https://developer.freee.co.jp/docs/accounting/webhook\" target=\"_blank\">会計Webhook概要</a>を参照してください。</p>

<hr />
<h2 id=\"contact\">連絡先</h2>

<p>ご不明点、ご要望等は <a href=\"https://support.freee.co.jp/hc/ja/requests/new\">freee サポートデスクへのお問い合わせフォーム</a> からご連絡ください。</p>
<hr />&copy; Since 2013 freee K.K.


## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: v1.0
- Package version: v1.0
- Build package: `org.openapitools.codegen.languages.RustClientCodegen`

## Installation

Put the package under your project folder in a directory named `openapi` and add the following to `Cargo.toml` under `[dependencies]`:

```
openapi = { path = "./openapi" }
```

## Documentation for API Endpoints

All URIs are relative to *https://api.freee.co.jp*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountItemsApi* | [**create_account_item**](docs/AccountItemsApi.md#create_account_item) | **POST** /api/1/account_items | 勘定科目の作成
*AccountItemsApi* | [**destroy_account_item**](docs/AccountItemsApi.md#destroy_account_item) | **DELETE** /api/1/account_items/{id} | 勘定科目の削除
*AccountItemsApi* | [**get_account_item**](docs/AccountItemsApi.md#get_account_item) | **GET** /api/1/account_items/{id} | 勘定科目の詳細情報の取得
*AccountItemsApi* | [**get_account_items**](docs/AccountItemsApi.md#get_account_items) | **GET** /api/1/account_items | 勘定科目一覧の取得
*AccountItemsApi* | [**update_account_item**](docs/AccountItemsApi.md#update_account_item) | **PUT** /api/1/account_items/{id} | 勘定科目の更新
*ApprovalFlowRoutesApi* | [**get_approval_flow_route**](docs/ApprovalFlowRoutesApi.md#get_approval_flow_route) | **GET** /api/1/approval_flow_routes/{id} | 申請経路の取得
*ApprovalFlowRoutesApi* | [**get_approval_flow_routes**](docs/ApprovalFlowRoutesApi.md#get_approval_flow_routes) | **GET** /api/1/approval_flow_routes | 申請経路一覧の取得
*ApprovalRequestsApi* | [**create_approval_request**](docs/ApprovalRequestsApi.md#create_approval_request) | **POST** /api/1/approval_requests | 各種申請の作成
*ApprovalRequestsApi* | [**destroy_approval_request**](docs/ApprovalRequestsApi.md#destroy_approval_request) | **DELETE** /api/1/approval_requests/{id} | 各種申請の削除
*ApprovalRequestsApi* | [**get_approval_request**](docs/ApprovalRequestsApi.md#get_approval_request) | **GET** /api/1/approval_requests/{id} | 各種申請の取得
*ApprovalRequestsApi* | [**get_approval_request_form**](docs/ApprovalRequestsApi.md#get_approval_request_form) | **GET** /api/1/approval_requests/forms/{id} | 各種申請の申請フォームの取得
*ApprovalRequestsApi* | [**get_approval_request_forms**](docs/ApprovalRequestsApi.md#get_approval_request_forms) | **GET** /api/1/approval_requests/forms | 各種申請の申請フォーム一覧の取得
*ApprovalRequestsApi* | [**get_approval_requests**](docs/ApprovalRequestsApi.md#get_approval_requests) | **GET** /api/1/approval_requests | 各種申請の一覧
*ApprovalRequestsApi* | [**update_approval_request**](docs/ApprovalRequestsApi.md#update_approval_request) | **PUT** /api/1/approval_requests/{id} | 各種申請の更新
*ApprovalRequestsApi* | [**update_approval_request_action**](docs/ApprovalRequestsApi.md#update_approval_request_action) | **POST** /api/1/approval_requests/{id}/actions | 各種申請の承認操作
*BanksApi* | [**get_bank**](docs/BanksApi.md#get_bank) | **GET** /api/1/banks/{id} | 連携サービスの取得
*BanksApi* | [**get_banks**](docs/BanksApi.md#get_banks) | **GET** /api/1/banks | 連携サービス一覧の取得
*CompaniesApi* | [**get_companies**](docs/CompaniesApi.md#get_companies) | **GET** /api/1/companies | 事業所一覧の取得
*CompaniesApi* | [**get_company**](docs/CompaniesApi.md#get_company) | **GET** /api/1/companies/{id} | 事業所の詳細情報の取得
*DealsApi* | [**create_deal**](docs/DealsApi.md#create_deal) | **POST** /api/1/deals | 取引（収入／支出）の作成
*DealsApi* | [**destroy_deal**](docs/DealsApi.md#destroy_deal) | **DELETE** /api/1/deals/{id} | 取引（収入／支出）の削除
*DealsApi* | [**get_deal**](docs/DealsApi.md#get_deal) | **GET** /api/1/deals/{id} | 取引（収入／支出）の取得
*DealsApi* | [**get_deals**](docs/DealsApi.md#get_deals) | **GET** /api/1/deals | 取引（収入／支出）一覧の取得
*DealsApi* | [**update_deal**](docs/DealsApi.md#update_deal) | **PUT** /api/1/deals/{id} | 取引（収入／支出）の更新
*ExpenseApplicationLineTemplatesApi* | [**create_expense_application_line_template**](docs/ExpenseApplicationLineTemplatesApi.md#create_expense_application_line_template) | **POST** /api/1/expense_application_line_templates | 経費科目の作成
*ExpenseApplicationLineTemplatesApi* | [**destroy_expense_application_line_template**](docs/ExpenseApplicationLineTemplatesApi.md#destroy_expense_application_line_template) | **DELETE** /api/1/expense_application_line_templates/{id} | 経費科目の削除
*ExpenseApplicationLineTemplatesApi* | [**get_expense_application_line_template**](docs/ExpenseApplicationLineTemplatesApi.md#get_expense_application_line_template) | **GET** /api/1/expense_application_line_templates/{id} | 経費科目の取得
*ExpenseApplicationLineTemplatesApi* | [**get_expense_application_line_templates**](docs/ExpenseApplicationLineTemplatesApi.md#get_expense_application_line_templates) | **GET** /api/1/expense_application_line_templates | 経費科目一覧の取得
*ExpenseApplicationLineTemplatesApi* | [**update_expense_application_line_template**](docs/ExpenseApplicationLineTemplatesApi.md#update_expense_application_line_template) | **PUT** /api/1/expense_application_line_templates/{id} | 経費科目の更新
*ExpenseApplicationsApi* | [**create_expense_application**](docs/ExpenseApplicationsApi.md#create_expense_application) | **POST** /api/1/expense_applications | 経費申請の作成
*ExpenseApplicationsApi* | [**destroy_expense_application**](docs/ExpenseApplicationsApi.md#destroy_expense_application) | **DELETE** /api/1/expense_applications/{id} | 経費申請の削除
*ExpenseApplicationsApi* | [**get_expense_application**](docs/ExpenseApplicationsApi.md#get_expense_application) | **GET** /api/1/expense_applications/{id} | 経費申請詳細の取得
*ExpenseApplicationsApi* | [**get_expense_applications**](docs/ExpenseApplicationsApi.md#get_expense_applications) | **GET** /api/1/expense_applications | 経費申請一覧の取得
*ExpenseApplicationsApi* | [**update_expense_application**](docs/ExpenseApplicationsApi.md#update_expense_application) | **PUT** /api/1/expense_applications/{id} | 経費申請の更新
*ExpenseApplicationsApi* | [**update_expense_application_action**](docs/ExpenseApplicationsApi.md#update_expense_application_action) | **POST** /api/1/expense_applications/{id}/actions | 経費申請の承認操作
*InvoicesApi* | [**create_invoice**](docs/InvoicesApi.md#create_invoice) | **POST** /api/1/invoices | 請求書の作成
*InvoicesApi* | [**destroy_invoice**](docs/InvoicesApi.md#destroy_invoice) | **DELETE** /api/1/invoices/{id} | 請求書の削除
*InvoicesApi* | [**get_invoice**](docs/InvoicesApi.md#get_invoice) | **GET** /api/1/invoices/{id} | 請求書の取得
*InvoicesApi* | [**get_invoices**](docs/InvoicesApi.md#get_invoices) | **GET** /api/1/invoices | 請求書一覧の取得
*InvoicesApi* | [**update_invoice**](docs/InvoicesApi.md#update_invoice) | **PUT** /api/1/invoices/{id} | 請求書の更新
*ItemsApi* | [**create_item**](docs/ItemsApi.md#create_item) | **POST** /api/1/items | 品目の作成
*ItemsApi* | [**destroy_item**](docs/ItemsApi.md#destroy_item) | **DELETE** /api/1/items/{id} | 品目の削除
*ItemsApi* | [**get_item**](docs/ItemsApi.md#get_item) | **GET** /api/1/items/{id} | 品目の取得
*ItemsApi* | [**get_items**](docs/ItemsApi.md#get_items) | **GET** /api/1/items | 品目一覧の取得
*ItemsApi* | [**update_item**](docs/ItemsApi.md#update_item) | **PUT** /api/1/items/{id} | 品目の更新
*JournalsApi* | [**download_journal**](docs/JournalsApi.md#download_journal) | **GET** /api/1/journals/reports/{id}/download | ダウンロード実行
*JournalsApi* | [**get_journal_status**](docs/JournalsApi.md#get_journal_status) | **GET** /api/1/journals/reports/{id}/status | ステータス確認
*JournalsApi* | [**get_journals**](docs/JournalsApi.md#get_journals) | **GET** /api/1/journals | ダウンロード要求
*ManualJournalsApi* | [**create_manual_journal**](docs/ManualJournalsApi.md#create_manual_journal) | **POST** /api/1/manual_journals | 振替伝票の作成
*ManualJournalsApi* | [**destroy_manual_journal**](docs/ManualJournalsApi.md#destroy_manual_journal) | **DELETE** /api/1/manual_journals/{id} | 振替伝票の削除
*ManualJournalsApi* | [**get_manual_journal**](docs/ManualJournalsApi.md#get_manual_journal) | **GET** /api/1/manual_journals/{id} | 振替伝票の取得
*ManualJournalsApi* | [**get_manual_journals**](docs/ManualJournalsApi.md#get_manual_journals) | **GET** /api/1/manual_journals | 振替伝票一覧の取得
*ManualJournalsApi* | [**update_manual_journal**](docs/ManualJournalsApi.md#update_manual_journal) | **PUT** /api/1/manual_journals/{id} | 振替伝票の更新
*PartnersApi* | [**create_partner**](docs/PartnersApi.md#create_partner) | **POST** /api/1/partners | 取引先の作成
*PartnersApi* | [**destroy_partner**](docs/PartnersApi.md#destroy_partner) | **DELETE** /api/1/partners/{id} | 取引先の削除
*PartnersApi* | [**get_partner**](docs/PartnersApi.md#get_partner) | **GET** /api/1/partners/{id} | 取引先の取得
*PartnersApi* | [**get_partners**](docs/PartnersApi.md#get_partners) | **GET** /api/1/partners | 取引先一覧の取得
*PartnersApi* | [**update_partner**](docs/PartnersApi.md#update_partner) | **PUT** /api/1/partners/{id} | 取引先の更新
*PartnersApi* | [**update_partner_by_code**](docs/PartnersApi.md#update_partner_by_code) | **PUT** /api/1/partners/code/{code} | 取引先の更新
*PaymentRequestsApi* | [**create_payment_request**](docs/PaymentRequestsApi.md#create_payment_request) | **POST** /api/1/payment_requests | 支払依頼の作成
*PaymentRequestsApi* | [**destroy_payment_request**](docs/PaymentRequestsApi.md#destroy_payment_request) | **DELETE** /api/1/payment_requests/{id} | 支払依頼の削除
*PaymentRequestsApi* | [**get_payment_request**](docs/PaymentRequestsApi.md#get_payment_request) | **GET** /api/1/payment_requests/{id} | 支払依頼詳細の取得
*PaymentRequestsApi* | [**get_payment_requests**](docs/PaymentRequestsApi.md#get_payment_requests) | **GET** /api/1/payment_requests | 支払依頼一覧の取得
*PaymentRequestsApi* | [**update_payment_request**](docs/PaymentRequestsApi.md#update_payment_request) | **PUT** /api/1/payment_requests/{id} | 支払依頼の更新
*PaymentRequestsApi* | [**update_payment_request_action**](docs/PaymentRequestsApi.md#update_payment_request_action) | **POST** /api/1/payment_requests/{id}/actions | 支払依頼の承認操作
*PaymentsApi* | [**create_deal_payment**](docs/PaymentsApi.md#create_deal_payment) | **POST** /api/1/deals/{id}/payments | 取引（収入／支出）の支払行作成
*PaymentsApi* | [**destroy_deal_payment**](docs/PaymentsApi.md#destroy_deal_payment) | **DELETE** /api/1/deals/{id}/payments/{payment_id} | 取引（収入／支出）の支払行削除
*PaymentsApi* | [**update_deal_payment**](docs/PaymentsApi.md#update_deal_payment) | **PUT** /api/1/deals/{id}/payments/{payment_id} | 取引（収入／支出）の支払行更新
*QuotationsApi* | [**create_quotation**](docs/QuotationsApi.md#create_quotation) | **POST** /api/1/quotations | 見積書の作成
*QuotationsApi* | [**destroy_quotation**](docs/QuotationsApi.md#destroy_quotation) | **DELETE** /api/1/quotations/{id} | 見積書の削除
*QuotationsApi* | [**get_quotation**](docs/QuotationsApi.md#get_quotation) | **GET** /api/1/quotations/{id} | 見積書の取得
*QuotationsApi* | [**get_quotations**](docs/QuotationsApi.md#get_quotations) | **GET** /api/1/quotations | 見積書一覧の取得
*QuotationsApi* | [**update_quotation**](docs/QuotationsApi.md#update_quotation) | **PUT** /api/1/quotations/{id} | 見積書の更新
*ReceiptsApi* | [**create_receipt**](docs/ReceiptsApi.md#create_receipt) | **POST** /api/1/receipts | ファイルボックス 証憑ファイルアップロード
*ReceiptsApi* | [**destroy_receipt**](docs/ReceiptsApi.md#destroy_receipt) | **DELETE** /api/1/receipts/{id} | ファイルボックス 証憑ファイルを削除する
*ReceiptsApi* | [**download_receipt**](docs/ReceiptsApi.md#download_receipt) | **GET** /api/1/receipts/{id}/download | ファイルボックス 証憑ファイルのダウンロード
*ReceiptsApi* | [**get_receipt**](docs/ReceiptsApi.md#get_receipt) | **GET** /api/1/receipts/{id} | ファイルボックス 証憑ファイルの取得
*ReceiptsApi* | [**get_receipts**](docs/ReceiptsApi.md#get_receipts) | **GET** /api/1/receipts | ファイルボックス 証憑ファイル一覧の取得
*ReceiptsApi* | [**update_receipt**](docs/ReceiptsApi.md#update_receipt) | **PUT** /api/1/receipts/{id} | ファイルボックス 証憑ファイル情報更新
*RenewsApi* | [**create_deal_renew**](docs/RenewsApi.md#create_deal_renew) | **POST** /api/1/deals/{id}/renews | 取引（収入／支出）に対する+更新の作成
*RenewsApi* | [**delete_deal_renew**](docs/RenewsApi.md#delete_deal_renew) | **DELETE** /api/1/deals/{id}/renews/{renew_id} | 取引（収入／支出）の+更新の削除
*RenewsApi* | [**update_deal_renew**](docs/RenewsApi.md#update_deal_renew) | **PUT** /api/1/deals/{id}/renews/{renew_id} | 取引（収入／支出）の+更新の更新
*SectionsApi* | [**create_section**](docs/SectionsApi.md#create_section) | **POST** /api/1/sections | 部門の作成
*SectionsApi* | [**destroy_section**](docs/SectionsApi.md#destroy_section) | **DELETE** /api/1/sections/{id} | 部門の削除
*SectionsApi* | [**get_section**](docs/SectionsApi.md#get_section) | **GET** /api/1/sections/{id} | 
*SectionsApi* | [**get_sections**](docs/SectionsApi.md#get_sections) | **GET** /api/1/sections | 部門一覧の取得
*SectionsApi* | [**update_section**](docs/SectionsApi.md#update_section) | **PUT** /api/1/sections/{id} | 部門の更新
*SegmentTagsApi* | [**create_segment_tag**](docs/SegmentTagsApi.md#create_segment_tag) | **POST** /api/1/segments/{segment_id}/tags | セグメントの作成
*SegmentTagsApi* | [**destroy_segments_tag**](docs/SegmentTagsApi.md#destroy_segments_tag) | **DELETE** /api/1/segments/{segment_id}/tags/{id} | セグメントタグの削除
*SegmentTagsApi* | [**get_segment_tags**](docs/SegmentTagsApi.md#get_segment_tags) | **GET** /api/1/segments/{segment_id}/tags | セグメントタグ一覧の取得
*SegmentTagsApi* | [**update_segment_tag**](docs/SegmentTagsApi.md#update_segment_tag) | **PUT** /api/1/segments/{segment_id}/tags/{id} | セグメントタグの更新
*SelectablesApi* | [**get_forms_selectables**](docs/SelectablesApi.md#get_forms_selectables) | **GET** /api/1/forms/selectables | フォーム用選択項目情報の取得
*TagsApi* | [**create_tag**](docs/TagsApi.md#create_tag) | **POST** /api/1/tags | メモタグの作成
*TagsApi* | [**destroy_tag**](docs/TagsApi.md#destroy_tag) | **DELETE** /api/1/tags/{id} | メモタグの削除
*TagsApi* | [**get_tag**](docs/TagsApi.md#get_tag) | **GET** /api/1/tags/{id} | メモタグの詳細情報の取得
*TagsApi* | [**get_tags**](docs/TagsApi.md#get_tags) | **GET** /api/1/tags | メモタグ一覧の取得
*TagsApi* | [**update_tag**](docs/TagsApi.md#update_tag) | **PUT** /api/1/tags/{id} | メモタグの更新
*TaxesApi* | [**get_tax_code**](docs/TaxesApi.md#get_tax_code) | **GET** /api/1/taxes/codes/{code} | 税区分コードの取得
*TaxesApi* | [**get_tax_codes**](docs/TaxesApi.md#get_tax_codes) | **GET** /api/1/taxes/codes | 税区分コード一覧の取得
*TaxesApi* | [**get_taxes_companies**](docs/TaxesApi.md#get_taxes_companies) | **GET** /api/1/taxes/companies/{company_id} | 税区分コード詳細一覧の取得
*TransfersApi* | [**create_transfer**](docs/TransfersApi.md#create_transfer) | **POST** /api/1/transfers | 取引（振替）の作成
*TransfersApi* | [**destroy_transfer**](docs/TransfersApi.md#destroy_transfer) | **DELETE** /api/1/transfers/{id} | 取引（振替）の削除する
*TransfersApi* | [**get_transfer**](docs/TransfersApi.md#get_transfer) | **GET** /api/1/transfers/{id} | 取引（振替）の取得
*TransfersApi* | [**get_transfers**](docs/TransfersApi.md#get_transfers) | **GET** /api/1/transfers | 取引（振替）一覧の取得
*TransfersApi* | [**update_transfer**](docs/TransfersApi.md#update_transfer) | **PUT** /api/1/transfers/{id} | 取引（振替）の更新
*TrialBalanceApi* | [**get_trial_bs**](docs/TrialBalanceApi.md#get_trial_bs) | **GET** /api/1/reports/trial_bs | 貸借対照表の取得
*TrialBalanceApi* | [**get_trial_bs_three_years**](docs/TrialBalanceApi.md#get_trial_bs_three_years) | **GET** /api/1/reports/trial_bs_three_years | 貸借対照表(３期間比較)の取得
*TrialBalanceApi* | [**get_trial_bs_two_years**](docs/TrialBalanceApi.md#get_trial_bs_two_years) | **GET** /api/1/reports/trial_bs_two_years | 貸借対照表(前年比較)の取得
*TrialBalanceApi* | [**get_trial_cr**](docs/TrialBalanceApi.md#get_trial_cr) | **GET** /api/1/reports/trial_cr | 製造原価報告書の取得
*TrialBalanceApi* | [**get_trial_cr_sections**](docs/TrialBalanceApi.md#get_trial_cr_sections) | **GET** /api/1/reports/trial_cr_sections | 製造原価報告書(部門比較)の取得
*TrialBalanceApi* | [**get_trial_cr_segment1_tags**](docs/TrialBalanceApi.md#get_trial_cr_segment1_tags) | **GET** /api/1/reports/trial_cr_segment_1_tags | 製造原価報告書(セグメント1比較)の取得
*TrialBalanceApi* | [**get_trial_cr_segment2_tags**](docs/TrialBalanceApi.md#get_trial_cr_segment2_tags) | **GET** /api/1/reports/trial_cr_segment_2_tags | 製造原価報告書(セグメント2比較)の取得
*TrialBalanceApi* | [**get_trial_cr_segment3_tags**](docs/TrialBalanceApi.md#get_trial_cr_segment3_tags) | **GET** /api/1/reports/trial_cr_segment_3_tags | 製造原価報告書(セグメント3比較)の取得
*TrialBalanceApi* | [**get_trial_cr_three_years**](docs/TrialBalanceApi.md#get_trial_cr_three_years) | **GET** /api/1/reports/trial_cr_three_years | 製造原価報告書(３期間比較)の取得
*TrialBalanceApi* | [**get_trial_cr_two_years**](docs/TrialBalanceApi.md#get_trial_cr_two_years) | **GET** /api/1/reports/trial_cr_two_years | 製造原価報告書(前年比較)の取得
*TrialBalanceApi* | [**get_trial_pl**](docs/TrialBalanceApi.md#get_trial_pl) | **GET** /api/1/reports/trial_pl | 損益計算書の取得
*TrialBalanceApi* | [**get_trial_pl_sections**](docs/TrialBalanceApi.md#get_trial_pl_sections) | **GET** /api/1/reports/trial_pl_sections | 損益計算書(部門比較)の取得
*TrialBalanceApi* | [**get_trial_pl_segment1_tags**](docs/TrialBalanceApi.md#get_trial_pl_segment1_tags) | **GET** /api/1/reports/trial_pl_segment_1_tags | 損益計算書(セグメント1比較)の取得
*TrialBalanceApi* | [**get_trial_pl_segment2_tags**](docs/TrialBalanceApi.md#get_trial_pl_segment2_tags) | **GET** /api/1/reports/trial_pl_segment_2_tags | 損益計算書(セグメント2比較)の取得
*TrialBalanceApi* | [**get_trial_pl_segment3_tags**](docs/TrialBalanceApi.md#get_trial_pl_segment3_tags) | **GET** /api/1/reports/trial_pl_segment_3_tags | 損益計算書(セグメント3比較)の取得
*TrialBalanceApi* | [**get_trial_pl_three_years**](docs/TrialBalanceApi.md#get_trial_pl_three_years) | **GET** /api/1/reports/trial_pl_three_years | 損益計算書(３期間比較)の取得
*TrialBalanceApi* | [**get_trial_pl_two_years**](docs/TrialBalanceApi.md#get_trial_pl_two_years) | **GET** /api/1/reports/trial_pl_two_years | 損益計算書(前年比較)の取得
*UsersApi* | [**get_users**](docs/UsersApi.md#get_users) | **GET** /api/1/users | 事業所に所属するユーザー一覧の取得
*UsersApi* | [**get_users_capabilities**](docs/UsersApi.md#get_users_capabilities) | **GET** /api/1/users/capabilities | ログインユーザーの権限の取得
*UsersApi* | [**get_users_me**](docs/UsersApi.md#get_users_me) | **GET** /api/1/users/me | ログインユーザー情報の取得
*UsersApi* | [**update_user**](docs/UsersApi.md#update_user) | **PUT** /api/1/users/me | ユーザー情報の更新
*WalletTxnsApi* | [**create_wallet_txn**](docs/WalletTxnsApi.md#create_wallet_txn) | **POST** /api/1/wallet_txns | 明細の作成
*WalletTxnsApi* | [**destroy_wallet_txn**](docs/WalletTxnsApi.md#destroy_wallet_txn) | **DELETE** /api/1/wallet_txns/{id} | 明細の削除
*WalletTxnsApi* | [**get_wallet_txn**](docs/WalletTxnsApi.md#get_wallet_txn) | **GET** /api/1/wallet_txns/{id} | 明細の取得
*WalletTxnsApi* | [**get_wallet_txns**](docs/WalletTxnsApi.md#get_wallet_txns) | **GET** /api/1/wallet_txns | 明細一覧の取得
*WalletablesApi* | [**create_walletable**](docs/WalletablesApi.md#create_walletable) | **POST** /api/1/walletables | 口座の作成
*WalletablesApi* | [**destroy_walletable**](docs/WalletablesApi.md#destroy_walletable) | **DELETE** /api/1/walletables/{type}/{id} | 口座の削除
*WalletablesApi* | [**get_walletable**](docs/WalletablesApi.md#get_walletable) | **GET** /api/1/walletables/{type}/{id} | 口座情報の取得
*WalletablesApi* | [**get_walletables**](docs/WalletablesApi.md#get_walletables) | **GET** /api/1/walletables | 口座一覧の取得
*WalletablesApi* | [**update_walletable**](docs/WalletablesApi.md#update_walletable) | **PUT** /api/1/walletables/{type}/{id} | 口座の更新


## Documentation For Models

 - [AccountItemParams](docs/AccountItemParams.md)
 - [AccountItemParamsAccountItem](docs/AccountItemParamsAccountItem.md)
 - [AccountItemParamsAccountItemItems](docs/AccountItemParamsAccountItemItems.md)
 - [AccountItemResponse](docs/AccountItemResponse.md)
 - [AccountItemResponseAccountItem](docs/AccountItemResponseAccountItem.md)
 - [AccountItemResponseAccountItemItems](docs/AccountItemResponseAccountItemItems.md)
 - [AccountItemResponseAccountItemPartners](docs/AccountItemResponseAccountItemPartners.md)
 - [AccountItemsResponse](docs/AccountItemsResponse.md)
 - [AccountItemsResponseAccountItems](docs/AccountItemsResponseAccountItems.md)
 - [ApprovalFlowRouteResponse](docs/ApprovalFlowRouteResponse.md)
 - [ApprovalFlowRouteResponseApprovalFlowRoute](docs/ApprovalFlowRouteResponseApprovalFlowRoute.md)
 - [ApprovalFlowRouteResponseApprovalFlowRouteSteps](docs/ApprovalFlowRouteResponseApprovalFlowRouteSteps.md)
 - [ApprovalFlowRoutesIndexResponse](docs/ApprovalFlowRoutesIndexResponse.md)
 - [ApprovalFlowRoutesIndexResponseApprovalFlowRoutes](docs/ApprovalFlowRoutesIndexResponseApprovalFlowRoutes.md)
 - [ApprovalRequestActionCreateParams](docs/ApprovalRequestActionCreateParams.md)
 - [ApprovalRequestCreateParams](docs/ApprovalRequestCreateParams.md)
 - [ApprovalRequestCreateParamsRequestItems](docs/ApprovalRequestCreateParamsRequestItems.md)
 - [ApprovalRequestFormIndexResponse](docs/ApprovalRequestFormIndexResponse.md)
 - [ApprovalRequestFormIndexResponseApprovalRequestForms](docs/ApprovalRequestFormIndexResponseApprovalRequestForms.md)
 - [ApprovalRequestFormResponse](docs/ApprovalRequestFormResponse.md)
 - [ApprovalRequestFormResponseApprovalRequestForm](docs/ApprovalRequestFormResponseApprovalRequestForm.md)
 - [ApprovalRequestResponse](docs/ApprovalRequestResponse.md)
 - [ApprovalRequestResponseApprovalRequest](docs/ApprovalRequestResponseApprovalRequest.md)
 - [ApprovalRequestResponseApprovalRequestApprovalRequestForm](docs/ApprovalRequestResponseApprovalRequestApprovalRequestForm.md)
 - [ApprovalRequestResponseApprovalRequestApprovalRequestFormParts](docs/ApprovalRequestResponseApprovalRequestApprovalRequestFormParts.md)
 - [ApprovalRequestResponseApprovalRequestApprovalRequestFormValues](docs/ApprovalRequestResponseApprovalRequestApprovalRequestFormValues.md)
 - [ApprovalRequestUpdateParams](docs/ApprovalRequestUpdateParams.md)
 - [ApprovalRequestsIndexResponse](docs/ApprovalRequestsIndexResponse.md)
 - [ApprovalRequestsIndexResponseApprovalRequests](docs/ApprovalRequestsIndexResponseApprovalRequests.md)
 - [ApprovalRequestsIndexResponseRequestItems](docs/ApprovalRequestsIndexResponseRequestItems.md)
 - [BadRequestError](docs/BadRequestError.md)
 - [BadRequestErrorErrors](docs/BadRequestErrorErrors.md)
 - [BadRequestNotFoundError](docs/BadRequestNotFoundError.md)
 - [BadRequestNotFoundErrorErrors](docs/BadRequestNotFoundErrorErrors.md)
 - [Bank](docs/Bank.md)
 - [BankResponse](docs/BankResponse.md)
 - [CompaniesPlanResponse](docs/CompaniesPlanResponse.md)
 - [CompanyIndexResponse](docs/CompanyIndexResponse.md)
 - [CompanyIndexResponseCompanies](docs/CompanyIndexResponseCompanies.md)
 - [CompanyResponse](docs/CompanyResponse.md)
 - [CompanyResponseCompany](docs/CompanyResponseCompany.md)
 - [Deal](docs/Deal.md)
 - [DealCreateParams](docs/DealCreateParams.md)
 - [DealCreateParamsDetails](docs/DealCreateParamsDetails.md)
 - [DealCreateParamsPayments](docs/DealCreateParamsPayments.md)
 - [DealCreateResponse](docs/DealCreateResponse.md)
 - [DealCreateResponseDeal](docs/DealCreateResponseDeal.md)
 - [DealCreateResponseDealDetails](docs/DealCreateResponseDealDetails.md)
 - [DealCreateResponseDealPayments](docs/DealCreateResponseDealPayments.md)
 - [DealDetails](docs/DealDetails.md)
 - [DealReceipts](docs/DealReceipts.md)
 - [DealRenews](docs/DealRenews.md)
 - [DealResponse](docs/DealResponse.md)
 - [DealUpdateParams](docs/DealUpdateParams.md)
 - [DealUpdateParamsDetails](docs/DealUpdateParamsDetails.md)
 - [DealUser](docs/DealUser.md)
 - [ExpenseApplicationActionCreateParams](docs/ExpenseApplicationActionCreateParams.md)
 - [ExpenseApplicationCreateParams](docs/ExpenseApplicationCreateParams.md)
 - [ExpenseApplicationCreateParamsExpenseApplicationLines](docs/ExpenseApplicationCreateParamsExpenseApplicationLines.md)
 - [ExpenseApplicationLineTemplate](docs/ExpenseApplicationLineTemplate.md)
 - [ExpenseApplicationLineTemplateParams](docs/ExpenseApplicationLineTemplateParams.md)
 - [ExpenseApplicationLineTemplateResponse](docs/ExpenseApplicationLineTemplateResponse.md)
 - [ExpenseApplicationResponse](docs/ExpenseApplicationResponse.md)
 - [ExpenseApplicationResponseExpenseApplication](docs/ExpenseApplicationResponseExpenseApplication.md)
 - [ExpenseApplicationResponseExpenseApplicationApprovalFlowLogs](docs/ExpenseApplicationResponseExpenseApplicationApprovalFlowLogs.md)
 - [ExpenseApplicationResponseExpenseApplicationApprovers](docs/ExpenseApplicationResponseExpenseApplicationApprovers.md)
 - [ExpenseApplicationResponseExpenseApplicationComments](docs/ExpenseApplicationResponseExpenseApplicationComments.md)
 - [ExpenseApplicationResponseExpenseApplicationExpenseApplicationLines](docs/ExpenseApplicationResponseExpenseApplicationExpenseApplicationLines.md)
 - [ExpenseApplicationUpdateParams](docs/ExpenseApplicationUpdateParams.md)
 - [ExpenseApplicationUpdateParamsExpenseApplicationLines](docs/ExpenseApplicationUpdateParamsExpenseApplicationLines.md)
 - [ExpenseApplicationsIndexResponse](docs/ExpenseApplicationsIndexResponse.md)
 - [ExpenseApplicationsIndexResponseExpenseApplicationLines](docs/ExpenseApplicationsIndexResponseExpenseApplicationLines.md)
 - [ExpenseApplicationsIndexResponseExpenseApplications](docs/ExpenseApplicationsIndexResponseExpenseApplications.md)
 - [FiscalYears](docs/FiscalYears.md)
 - [ForbiddenError](docs/ForbiddenError.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse20010](docs/InlineResponse20010.md)
 - [InlineResponse20011](docs/InlineResponse20011.md)
 - [InlineResponse20012](docs/InlineResponse20012.md)
 - [InlineResponse20013](docs/InlineResponse20013.md)
 - [InlineResponse20014](docs/InlineResponse20014.md)
 - [InlineResponse20015](docs/InlineResponse20015.md)
 - [InlineResponse20016](docs/InlineResponse20016.md)
 - [InlineResponse2002](docs/InlineResponse2002.md)
 - [InlineResponse2002Meta](docs/InlineResponse2002Meta.md)
 - [InlineResponse2003](docs/InlineResponse2003.md)
 - [InlineResponse2004](docs/InlineResponse2004.md)
 - [InlineResponse2005](docs/InlineResponse2005.md)
 - [InlineResponse2006](docs/InlineResponse2006.md)
 - [InlineResponse2007](docs/InlineResponse2007.md)
 - [InlineResponse2008](docs/InlineResponse2008.md)
 - [InlineResponse2008Taxes](docs/InlineResponse2008Taxes.md)
 - [InlineResponse2009](docs/InlineResponse2009.md)
 - [InlineResponse2009Meta](docs/InlineResponse2009Meta.md)
 - [InternalServerError](docs/InternalServerError.md)
 - [InternalServerErrorErrors](docs/InternalServerErrorErrors.md)
 - [InvoiceCreateParams](docs/InvoiceCreateParams.md)
 - [InvoiceCreateParamsInvoiceContents](docs/InvoiceCreateParamsInvoiceContents.md)
 - [InvoiceIndexResponse](docs/InvoiceIndexResponse.md)
 - [InvoiceIndexResponseInvoiceContents](docs/InvoiceIndexResponseInvoiceContents.md)
 - [InvoiceIndexResponseInvoices](docs/InvoiceIndexResponseInvoices.md)
 - [InvoiceIndexResponseTotalAmountPerVatRate](docs/InvoiceIndexResponseTotalAmountPerVatRate.md)
 - [InvoiceResponse](docs/InvoiceResponse.md)
 - [InvoiceResponseInvoice](docs/InvoiceResponseInvoice.md)
 - [InvoiceUpdateParams](docs/InvoiceUpdateParams.md)
 - [InvoiceUpdateParamsInvoiceContents](docs/InvoiceUpdateParamsInvoiceContents.md)
 - [Item](docs/Item.md)
 - [ItemParams](docs/ItemParams.md)
 - [ItemResponse](docs/ItemResponse.md)
 - [JournalStatusResponse](docs/JournalStatusResponse.md)
 - [JournalStatusResponseJournals](docs/JournalStatusResponseJournals.md)
 - [JournalsResponse](docs/JournalsResponse.md)
 - [JournalsResponseJournals](docs/JournalsResponseJournals.md)
 - [JournalsResponseJournalsUpToDateReasons](docs/JournalsResponseJournalsUpToDateReasons.md)
 - [ManualJournal](docs/ManualJournal.md)
 - [ManualJournalCreateParams](docs/ManualJournalCreateParams.md)
 - [ManualJournalCreateParamsDetails](docs/ManualJournalCreateParamsDetails.md)
 - [ManualJournalDetails](docs/ManualJournalDetails.md)
 - [ManualJournalResponse](docs/ManualJournalResponse.md)
 - [ManualJournalUpdateParams](docs/ManualJournalUpdateParams.md)
 - [ManualJournalUpdateParamsDetails](docs/ManualJournalUpdateParamsDetails.md)
 - [MeResponse](docs/MeResponse.md)
 - [MeResponseUser](docs/MeResponseUser.md)
 - [MeResponseUserCompanies](docs/MeResponseUserCompanies.md)
 - [PartnerCreateParams](docs/PartnerCreateParams.md)
 - [PartnerCreateParamsAddressAttributes](docs/PartnerCreateParamsAddressAttributes.md)
 - [PartnerCreateParamsPartnerBankAccountAttributes](docs/PartnerCreateParamsPartnerBankAccountAttributes.md)
 - [PartnerCreateParamsPartnerDocSettingAttributes](docs/PartnerCreateParamsPartnerDocSettingAttributes.md)
 - [PartnerCreateParamsPaymentTermAttributes](docs/PartnerCreateParamsPaymentTermAttributes.md)
 - [PartnerResponse](docs/PartnerResponse.md)
 - [PartnerResponsePartner](docs/PartnerResponsePartner.md)
 - [PartnerResponsePartnerAddressAttributes](docs/PartnerResponsePartnerAddressAttributes.md)
 - [PartnerResponsePartnerPaymentTermAttributes](docs/PartnerResponsePartnerPaymentTermAttributes.md)
 - [PartnerUpdateParams](docs/PartnerUpdateParams.md)
 - [PartnersResponse](docs/PartnersResponse.md)
 - [PartnersResponseAddressAttributes](docs/PartnersResponseAddressAttributes.md)
 - [PartnersResponsePartnerBankAccountAttributes](docs/PartnersResponsePartnerBankAccountAttributes.md)
 - [PartnersResponsePartnerDocSettingAttributes](docs/PartnersResponsePartnerDocSettingAttributes.md)
 - [PartnersResponsePartners](docs/PartnersResponsePartners.md)
 - [PaymentParams](docs/PaymentParams.md)
 - [PaymentRequestActionCreateParams](docs/PaymentRequestActionCreateParams.md)
 - [PaymentRequestCreateParams](docs/PaymentRequestCreateParams.md)
 - [PaymentRequestCreateParamsPaymentRequestLines](docs/PaymentRequestCreateParamsPaymentRequestLines.md)
 - [PaymentRequestResponse](docs/PaymentRequestResponse.md)
 - [PaymentRequestResponsePaymentRequest](docs/PaymentRequestResponsePaymentRequest.md)
 - [PaymentRequestResponsePaymentRequestPaymentRequestLines](docs/PaymentRequestResponsePaymentRequestPaymentRequestLines.md)
 - [PaymentRequestUpdateParams](docs/PaymentRequestUpdateParams.md)
 - [PaymentRequestUpdateParamsPaymentRequestLines](docs/PaymentRequestUpdateParamsPaymentRequestLines.md)
 - [PaymentRequestsIndexResponse](docs/PaymentRequestsIndexResponse.md)
 - [PaymentRequestsIndexResponsePaymentRequests](docs/PaymentRequestsIndexResponsePaymentRequests.md)
 - [QuotationCreateParams](docs/QuotationCreateParams.md)
 - [QuotationIndexResponse](docs/QuotationIndexResponse.md)
 - [QuotationIndexResponseQuotationContents](docs/QuotationIndexResponseQuotationContents.md)
 - [QuotationIndexResponseQuotations](docs/QuotationIndexResponseQuotations.md)
 - [QuotationResponse](docs/QuotationResponse.md)
 - [QuotationResponseQuotation](docs/QuotationResponseQuotation.md)
 - [QuotationUpdateParams](docs/QuotationUpdateParams.md)
 - [QuotationUpdateParamsQuotationContents](docs/QuotationUpdateParamsQuotationContents.md)
 - [Receipt](docs/Receipt.md)
 - [ReceiptResponse](docs/ReceiptResponse.md)
 - [ReceiptUpdateParams](docs/ReceiptUpdateParams.md)
 - [RenewCreateParams](docs/RenewCreateParams.md)
 - [RenewCreateParamsDetails](docs/RenewCreateParamsDetails.md)
 - [RenewUpdateParams](docs/RenewUpdateParams.md)
 - [RenewUpdateParamsDetails](docs/RenewUpdateParamsDetails.md)
 - [Section](docs/Section.md)
 - [SectionParams](docs/SectionParams.md)
 - [SectionResponse](docs/SectionResponse.md)
 - [SegmentTag](docs/SegmentTag.md)
 - [SegmentTagParams](docs/SegmentTagParams.md)
 - [SegmentTagResponse](docs/SegmentTagResponse.md)
 - [SelectablesIndexResponse](docs/SelectablesIndexResponse.md)
 - [SelectablesIndexResponseAccountCategories](docs/SelectablesIndexResponseAccountCategories.md)
 - [SelectablesIndexResponseAccountGroups](docs/SelectablesIndexResponseAccountGroups.md)
 - [SelectablesIndexResponseAccountItems](docs/SelectablesIndexResponseAccountItems.md)
 - [SelectablesIndexResponseDefaultTax](docs/SelectablesIndexResponseDefaultTax.md)
 - [SelectablesIndexResponseDefaultTaxTaxRate5](docs/SelectablesIndexResponseDefaultTaxTaxRate5.md)
 - [SelectablesIndexResponseDefaultTaxTaxRate8](docs/SelectablesIndexResponseDefaultTaxTaxRate8.md)
 - [ServiceUnavailableError](docs/ServiceUnavailableError.md)
 - [ServiceUnavailableErrorErrors](docs/ServiceUnavailableErrorErrors.md)
 - [Tag](docs/Tag.md)
 - [TagParams](docs/TagParams.md)
 - [TagResponse](docs/TagResponse.md)
 - [Tax](docs/Tax.md)
 - [TaxResponse](docs/TaxResponse.md)
 - [TooManyRequestsError](docs/TooManyRequestsError.md)
 - [TooManyRequestsErrorMeta](docs/TooManyRequestsErrorMeta.md)
 - [Transfer](docs/Transfer.md)
 - [TransferParams](docs/TransferParams.md)
 - [TransferResponse](docs/TransferResponse.md)
 - [TrialBsResponse](docs/TrialBsResponse.md)
 - [TrialBsResponseTrialBs](docs/TrialBsResponseTrialBs.md)
 - [TrialBsResponseTrialBsBalances](docs/TrialBsResponseTrialBsBalances.md)
 - [TrialBsResponseTrialBsItems](docs/TrialBsResponseTrialBsItems.md)
 - [TrialBsResponseTrialBsPartners](docs/TrialBsResponseTrialBsPartners.md)
 - [TrialBsResponseTrialBsSections](docs/TrialBsResponseTrialBsSections.md)
 - [TrialBsResponseTrialBsSegment1Tags](docs/TrialBsResponseTrialBsSegment1Tags.md)
 - [TrialBsResponseTrialBsSegment2Tags](docs/TrialBsResponseTrialBsSegment2Tags.md)
 - [TrialBsResponseTrialBsSegment3Tags](docs/TrialBsResponseTrialBsSegment3Tags.md)
 - [TrialBsThreeYearsResponse](docs/TrialBsThreeYearsResponse.md)
 - [TrialBsThreeYearsResponseTrialBsThreeYears](docs/TrialBsThreeYearsResponseTrialBsThreeYears.md)
 - [TrialBsThreeYearsResponseTrialBsThreeYearsBalances](docs/TrialBsThreeYearsResponseTrialBsThreeYearsBalances.md)
 - [TrialBsThreeYearsResponseTrialBsThreeYearsItems](docs/TrialBsThreeYearsResponseTrialBsThreeYearsItems.md)
 - [TrialBsThreeYearsResponseTrialBsThreeYearsPartners](docs/TrialBsThreeYearsResponseTrialBsThreeYearsPartners.md)
 - [TrialBsThreeYearsResponseTrialBsThreeYearsSections](docs/TrialBsThreeYearsResponseTrialBsThreeYearsSections.md)
 - [TrialBsThreeYearsResponseTrialBsThreeYearsSegment1Tags](docs/TrialBsThreeYearsResponseTrialBsThreeYearsSegment1Tags.md)
 - [TrialBsThreeYearsResponseTrialBsThreeYearsSegment2Tags](docs/TrialBsThreeYearsResponseTrialBsThreeYearsSegment2Tags.md)
 - [TrialBsThreeYearsResponseTrialBsThreeYearsSegment3Tags](docs/TrialBsThreeYearsResponseTrialBsThreeYearsSegment3Tags.md)
 - [TrialBsTwoYearsResponse](docs/TrialBsTwoYearsResponse.md)
 - [TrialBsTwoYearsResponseTrialBsTwoYears](docs/TrialBsTwoYearsResponseTrialBsTwoYears.md)
 - [TrialBsTwoYearsResponseTrialBsTwoYearsBalances](docs/TrialBsTwoYearsResponseTrialBsTwoYearsBalances.md)
 - [TrialBsTwoYearsResponseTrialBsTwoYearsItems](docs/TrialBsTwoYearsResponseTrialBsTwoYearsItems.md)
 - [TrialBsTwoYearsResponseTrialBsTwoYearsPartners](docs/TrialBsTwoYearsResponseTrialBsTwoYearsPartners.md)
 - [TrialBsTwoYearsResponseTrialBsTwoYearsSections](docs/TrialBsTwoYearsResponseTrialBsTwoYearsSections.md)
 - [TrialBsTwoYearsResponseTrialBsTwoYearsSegment1Tags](docs/TrialBsTwoYearsResponseTrialBsTwoYearsSegment1Tags.md)
 - [TrialBsTwoYearsResponseTrialBsTwoYearsSegment2Tags](docs/TrialBsTwoYearsResponseTrialBsTwoYearsSegment2Tags.md)
 - [TrialBsTwoYearsResponseTrialBsTwoYearsSegment3Tags](docs/TrialBsTwoYearsResponseTrialBsTwoYearsSegment3Tags.md)
 - [TrialCrResponse](docs/TrialCrResponse.md)
 - [TrialCrResponseTrialCr](docs/TrialCrResponseTrialCr.md)
 - [TrialCrResponseTrialCrBalances](docs/TrialCrResponseTrialCrBalances.md)
 - [TrialCrResponseTrialCrItems](docs/TrialCrResponseTrialCrItems.md)
 - [TrialCrResponseTrialCrPartners](docs/TrialCrResponseTrialCrPartners.md)
 - [TrialCrResponseTrialCrSegment1Tags](docs/TrialCrResponseTrialCrSegment1Tags.md)
 - [TrialCrResponseTrialCrSegment2Tags](docs/TrialCrResponseTrialCrSegment2Tags.md)
 - [TrialCrResponseTrialCrSegment3Tags](docs/TrialCrResponseTrialCrSegment3Tags.md)
 - [TrialCrSectionsResponse](docs/TrialCrSectionsResponse.md)
 - [TrialCrSectionsResponseTrialCrSections](docs/TrialCrSectionsResponseTrialCrSections.md)
 - [TrialCrSectionsResponseTrialCrSectionsBalances](docs/TrialCrSectionsResponseTrialCrSectionsBalances.md)
 - [TrialCrSectionsResponseTrialCrSectionsItems](docs/TrialCrSectionsResponseTrialCrSectionsItems.md)
 - [TrialCrSectionsResponseTrialCrSectionsPartners](docs/TrialCrSectionsResponseTrialCrSectionsPartners.md)
 - [TrialCrSectionsResponseTrialCrSectionsSections](docs/TrialCrSectionsResponseTrialCrSectionsSections.md)
 - [TrialCrSectionsResponseTrialCrSectionsSegment1Tags](docs/TrialCrSectionsResponseTrialCrSectionsSegment1Tags.md)
 - [TrialCrSectionsResponseTrialCrSectionsSegment2Tags](docs/TrialCrSectionsResponseTrialCrSectionsSegment2Tags.md)
 - [TrialCrSectionsResponseTrialCrSectionsSegment3Tags](docs/TrialCrSectionsResponseTrialCrSectionsSegment3Tags.md)
 - [TrialCrSegment1TagsResponse](docs/TrialCrSegment1TagsResponse.md)
 - [TrialCrSegment1TagsResponseTrialCrSegment1Tags](docs/TrialCrSegment1TagsResponseTrialCrSegment1Tags.md)
 - [TrialCrSegment1TagsResponseTrialCrSegment1TagsBalances](docs/TrialCrSegment1TagsResponseTrialCrSegment1TagsBalances.md)
 - [TrialCrSegment1TagsResponseTrialCrSegment1TagsSections](docs/TrialCrSegment1TagsResponseTrialCrSegment1TagsSections.md)
 - [TrialCrSegment1TagsResponseTrialCrSegment1TagsSegment1Tags](docs/TrialCrSegment1TagsResponseTrialCrSegment1TagsSegment1Tags.md)
 - [TrialCrSegment2TagsResponse](docs/TrialCrSegment2TagsResponse.md)
 - [TrialCrSegment2TagsResponseTrialCrSegment2Tags](docs/TrialCrSegment2TagsResponseTrialCrSegment2Tags.md)
 - [TrialCrSegment2TagsResponseTrialCrSegment2TagsBalances](docs/TrialCrSegment2TagsResponseTrialCrSegment2TagsBalances.md)
 - [TrialCrSegment2TagsResponseTrialCrSegment2TagsSegment2Tags](docs/TrialCrSegment2TagsResponseTrialCrSegment2TagsSegment2Tags.md)
 - [TrialCrSegment3TagsResponse](docs/TrialCrSegment3TagsResponse.md)
 - [TrialCrSegment3TagsResponseTrialCrSegment3Tags](docs/TrialCrSegment3TagsResponseTrialCrSegment3Tags.md)
 - [TrialCrSegment3TagsResponseTrialCrSegment3TagsBalances](docs/TrialCrSegment3TagsResponseTrialCrSegment3TagsBalances.md)
 - [TrialCrSegment3TagsResponseTrialCrSegment3TagsSegment3Tags](docs/TrialCrSegment3TagsResponseTrialCrSegment3TagsSegment3Tags.md)
 - [TrialCrThreeYearsResponse](docs/TrialCrThreeYearsResponse.md)
 - [TrialCrThreeYearsResponseTrialCrThreeYears](docs/TrialCrThreeYearsResponseTrialCrThreeYears.md)
 - [TrialCrThreeYearsResponseTrialCrThreeYearsBalances](docs/TrialCrThreeYearsResponseTrialCrThreeYearsBalances.md)
 - [TrialCrThreeYearsResponseTrialCrThreeYearsItems](docs/TrialCrThreeYearsResponseTrialCrThreeYearsItems.md)
 - [TrialCrThreeYearsResponseTrialCrThreeYearsSegment1Tags](docs/TrialCrThreeYearsResponseTrialCrThreeYearsSegment1Tags.md)
 - [TrialCrThreeYearsResponseTrialCrThreeYearsSegment2Tags](docs/TrialCrThreeYearsResponseTrialCrThreeYearsSegment2Tags.md)
 - [TrialCrThreeYearsResponseTrialCrThreeYearsSegment3Tags](docs/TrialCrThreeYearsResponseTrialCrThreeYearsSegment3Tags.md)
 - [TrialCrTwoYearsResponse](docs/TrialCrTwoYearsResponse.md)
 - [TrialCrTwoYearsResponseTrialCrTwoYears](docs/TrialCrTwoYearsResponseTrialCrTwoYears.md)
 - [TrialCrTwoYearsResponseTrialCrTwoYearsBalances](docs/TrialCrTwoYearsResponseTrialCrTwoYearsBalances.md)
 - [TrialCrTwoYearsResponseTrialCrTwoYearsItems](docs/TrialCrTwoYearsResponseTrialCrTwoYearsItems.md)
 - [TrialCrTwoYearsResponseTrialCrTwoYearsPartners](docs/TrialCrTwoYearsResponseTrialCrTwoYearsPartners.md)
 - [TrialCrTwoYearsResponseTrialCrTwoYearsSegment1Tags](docs/TrialCrTwoYearsResponseTrialCrTwoYearsSegment1Tags.md)
 - [TrialCrTwoYearsResponseTrialCrTwoYearsSegment2Tags](docs/TrialCrTwoYearsResponseTrialCrTwoYearsSegment2Tags.md)
 - [TrialCrTwoYearsResponseTrialCrTwoYearsSegment3Tags](docs/TrialCrTwoYearsResponseTrialCrTwoYearsSegment3Tags.md)
 - [TrialPlResponse](docs/TrialPlResponse.md)
 - [TrialPlResponseTrialPl](docs/TrialPlResponseTrialPl.md)
 - [TrialPlResponseTrialPlBalances](docs/TrialPlResponseTrialPlBalances.md)
 - [TrialPlResponseTrialPlSections](docs/TrialPlResponseTrialPlSections.md)
 - [TrialPlSectionsResponse](docs/TrialPlSectionsResponse.md)
 - [TrialPlSectionsResponseTrialPlSections](docs/TrialPlSectionsResponseTrialPlSections.md)
 - [TrialPlSectionsResponseTrialPlSectionsBalances](docs/TrialPlSectionsResponseTrialPlSectionsBalances.md)
 - [TrialPlSectionsResponseTrialPlSectionsItems](docs/TrialPlSectionsResponseTrialPlSectionsItems.md)
 - [TrialPlSectionsResponseTrialPlSectionsPartners](docs/TrialPlSectionsResponseTrialPlSectionsPartners.md)
 - [TrialPlSectionsResponseTrialPlSectionsSections](docs/TrialPlSectionsResponseTrialPlSectionsSections.md)
 - [TrialPlSectionsResponseTrialPlSectionsSegment1Tags](docs/TrialPlSectionsResponseTrialPlSectionsSegment1Tags.md)
 - [TrialPlSectionsResponseTrialPlSectionsSegment2Tags](docs/TrialPlSectionsResponseTrialPlSectionsSegment2Tags.md)
 - [TrialPlSectionsResponseTrialPlSectionsSegment3Tags](docs/TrialPlSectionsResponseTrialPlSectionsSegment3Tags.md)
 - [TrialPlSegment1TagsResponse](docs/TrialPlSegment1TagsResponse.md)
 - [TrialPlSegment1TagsResponseTrialPlSegment1Tags](docs/TrialPlSegment1TagsResponseTrialPlSegment1Tags.md)
 - [TrialPlSegment1TagsResponseTrialPlSegment1TagsBalances](docs/TrialPlSegment1TagsResponseTrialPlSegment1TagsBalances.md)
 - [TrialPlSegment1TagsResponseTrialPlSegment1TagsSections](docs/TrialPlSegment1TagsResponseTrialPlSegment1TagsSections.md)
 - [TrialPlSegment1TagsResponseTrialPlSegment1TagsSegment1Tags](docs/TrialPlSegment1TagsResponseTrialPlSegment1TagsSegment1Tags.md)
 - [TrialPlSegment2TagsResponse](docs/TrialPlSegment2TagsResponse.md)
 - [TrialPlSegment2TagsResponseTrialPlSegment2Tags](docs/TrialPlSegment2TagsResponseTrialPlSegment2Tags.md)
 - [TrialPlSegment2TagsResponseTrialPlSegment2TagsBalances](docs/TrialPlSegment2TagsResponseTrialPlSegment2TagsBalances.md)
 - [TrialPlSegment2TagsResponseTrialPlSegment2TagsSegment2Tags](docs/TrialPlSegment2TagsResponseTrialPlSegment2TagsSegment2Tags.md)
 - [TrialPlSegment3TagsResponse](docs/TrialPlSegment3TagsResponse.md)
 - [TrialPlSegment3TagsResponseTrialPlSegment3Tags](docs/TrialPlSegment3TagsResponseTrialPlSegment3Tags.md)
 - [TrialPlSegment3TagsResponseTrialPlSegment3TagsBalances](docs/TrialPlSegment3TagsResponseTrialPlSegment3TagsBalances.md)
 - [TrialPlSegment3TagsResponseTrialPlSegment3TagsSegment3Tags](docs/TrialPlSegment3TagsResponseTrialPlSegment3TagsSegment3Tags.md)
 - [TrialPlThreeYearsResponse](docs/TrialPlThreeYearsResponse.md)
 - [TrialPlThreeYearsResponseTrialPlThreeYears](docs/TrialPlThreeYearsResponseTrialPlThreeYears.md)
 - [TrialPlThreeYearsResponseTrialPlThreeYearsBalances](docs/TrialPlThreeYearsResponseTrialPlThreeYearsBalances.md)
 - [TrialPlThreeYearsResponseTrialPlThreeYearsSections](docs/TrialPlThreeYearsResponseTrialPlThreeYearsSections.md)
 - [TrialPlTwoYearsResponse](docs/TrialPlTwoYearsResponse.md)
 - [TrialPlTwoYearsResponseTrialPlTwoYears](docs/TrialPlTwoYearsResponseTrialPlTwoYears.md)
 - [TrialPlTwoYearsResponseTrialPlTwoYearsBalances](docs/TrialPlTwoYearsResponseTrialPlTwoYearsBalances.md)
 - [TrialPlTwoYearsResponseTrialPlTwoYearsSections](docs/TrialPlTwoYearsResponseTrialPlTwoYearsSections.md)
 - [UnauthorizedError](docs/UnauthorizedError.md)
 - [User](docs/User.md)
 - [UserCapability](docs/UserCapability.md)
 - [UserParams](docs/UserParams.md)
 - [UserResponse](docs/UserResponse.md)
 - [WalletTxn](docs/WalletTxn.md)
 - [WalletTxnParams](docs/WalletTxnParams.md)
 - [WalletTxnResponse](docs/WalletTxnResponse.md)
 - [Walletable](docs/Walletable.md)
 - [WalletableCreateParams](docs/WalletableCreateParams.md)
 - [WalletableCreateResponse](docs/WalletableCreateResponse.md)
 - [WalletableCreateResponseWalletable](docs/WalletableCreateResponseWalletable.md)
 - [WalletableUpdateParams](docs/WalletableUpdateParams.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author



