extern crate proc_macro;

use proc_macro::TokenStream;
use quote::quote;
use syn;

#[proc_macro_derive(Point)]
pub fn point_derive(input: TokenStream) -> TokenStream {
    let ast = syn::parse(input).unwrap();
    impl_point(&ast)
}

fn impl_point(ast: &syn::DeriveInput) -> TokenStream {
    let name = &ast.ident;
    let gen = quote! {
        impl Point for #name {
            fn pythagoras_theorem() {
                println!("Esto es el teorema de pitagoras, increibe cierto");
            }
        }
    };
    gen.into()
}
