# Contributing to Fauna Labs

First, thank you for your interest in contributing to Fauna Labs! Contributions like yours help the Fauna community build more effectively, ship faster, and delight customers. We appreciate it!

Reading and following these guidelines helps to make the contribution process easy and effective for everyone involved. It also communicates that you agree to respect the time of the developers managing and developing these open source projects. We reciprocate that respect by addressing your issue, assessing changes, and helping you finalize your pull requests.

## Quicklinks

* [Code of Conduct](#code-of-conduct)
* [Getting Started](#getting-started)
    * [Issues](#issues)
    * [Pull Requests](#pull-requests)
* [Getting Help](#getting-help)

## Code of Conduct

Fauna is dedicated to providing a positive experience for everyone in the Fauna community, and we need your help to ensure that everyone feels welcomed. By participating and contributing to Fauna Labs, you agree to uphold our [Code of Conduct](https://forums.fauna.com/guidelines).

## Getting Started

Contributions are made to this repository via Issues and Pull Requests (PRs).

- To report security vulnerabilities, please follow the guidance in [SECURITY.md](SECURITY.md).

### Issues

Issues should be used to report problems, request new features, or discuss potential changes before a PR is created. Please search for existing Issues and PRs before creating your own.

If you find an Issue that addresses the problem you're having, please add your own reproduction information to the existing issue rather than creating a new issue. Adding a [reaction](https://github.blog/2016-03-10-add-reactions-to-pull-requests-issues-and-comments/) also indicates that a particular problem affects more than just the reporter.

### Pull Requests

PRs to Fauna Labs repositories are always welcome and can be a quick way to get your fix or improvement slated for the next release. In general, PRs should:

- Only fix/add the functionality in question **OR** address wide-spread whitespace/style issues, not both.
- Add unit or integration tests for fixed or changed functionality (if a test suite already exists).
- Address a single concern in the fewest number of changed lines possible.
- Include documentation in the repository.
- Be accompanied by a complete Pull Request template (loaded automatically when a PR is created).

Breaking changes require an Issue to discuss your proposal first.

Fauna Labs follows the ["fork-and-pull" Git workflow](https://github.com/susam/gitpr)

1. Fork the repository to your own Github account
2. Clone the project to your machine
3. Create a branch locally with a succinct but descriptive name
4. Commit changes to the branch
5. Following any formatting and testing guidelines specific to this repository
6. Push changes to your fork
7. Open a PR in our repository and follow the PR template so that we can efficiently review the changes.

## Getting Help

Join us in the [Fauna forums](https://forums.fauna.com/). For best reults, post your question in the relevant category with appropriate tags.
