// Copyright Fauna, Inc.
// SPDX-License-Identifier: MIT-0

mod fql;
use crate::fql::parser::parse_expr;
use crate::fql::serializer::serialize_expr;

use wasm_bindgen::prelude::*;

#[macro_use]
extern crate pest_derive;

#[wasm_bindgen]
pub fn serialize_fql_query(query: &str) -> String {
    let ast = parse_expr(query).unwrap();
    serialize_expr(&ast)
}
