// Copyright Fauna, Inc.
// SPDX-License-Identifier: MIT-0

use crate::fql::verbs::{
  NiladicVerb,
  MonadicVerb,
  DyadicVerb,
  QuadraticVerb,
  TriadicVerb,
  VariadicVerb,
};

pub enum FQLValue<'a> {
  Object(Vec<(&'a str, FQLValue<'a>)>),
  Array(Vec<FQLValue<'a>>),
  String(&'a str),
  Number(f64),
  Boolean(bool),
  NiladicVerb(NiladicVerb<'a>),
  MonadicVerb(MonadicVerb<'a>),
  DyadicVerb(DyadicVerb<'a>),
  TriadicVerb(TriadicVerb<'a>),
  QuadraticVerb(QuadraticVerb<'a>),
  VariadicVerb(VariadicVerb<'a>),
  Null,
}
