This repository contains unofficial patterns, sample code, or tools to help developers build more effectively with [Fauna][fauna]. All [Fauna Labs][fauna-labs] repositories are provided “as-is” and without support. By using this repository or its contents, you agree that this repository may never be officially supported and moved to the [Fauna organization][fauna-organization].

# FQL parser

This is a Rust crate and NPM package that parses raw FQL queries into the wire protocol format.

## Usage

### Rust

To use the parser, add the following to your `Cargo.toml`:
```toml
[dependencies]
fql-parser = "0.1.6"
```

Then, in your code, import the crate and parse your query:
```rust
extern crate fql_parser;

fn main() {
    let query = "Add(2, 2)";
    let result = fql_parser::serialize_fql_query(query);

    println!("{}", result);
}
```

### JavaScript/TypeScript

TODO

## Building and publishing the crate

### Rust

```sh
cargo build
# Publish to https://crates.io/crates/fql-parser
cargo publish
```

### NPM

```sh
wasm-pack build --scope fauna-labs
wasm-pack publish --access=public
```

[fauna]: https://www.fauna.com/
[fauna-labs]: https://github.com/fauna-labs
[fauna-organization]: https://github.com/fauna

