// Copyright Fauna, Inc.
// SPDX-License-Identifier: MIT-0

pub enum FQLValue<'a> {
  Object(Vec<(&'a str, FQLValue<'a>)>),
  Array(Vec<FQLValue<'a>>),
  String(&'a str),
  Number(f64),
  Boolean(bool),
  TriadicVerb((&'a str, Vec<FQLValue<'a>>)),
  VariadicVerb((&'a str, Vec<FQLValue<'a>>)),
  Null,
}