use std::net::{IpAddr, Ipv4Addr};
use std::time::Duration;
use fpp::{Prober, ProbeType, DstInfo};

fn main() {
    let src_ip: IpAddr = IpAddr::V4(Ipv4Addr::new(192, 168, 1, 4));
    //let gateway_ip: IpAddr = IpAddr::V4(Ipv4Addr::new(192, 168, 1, 1));
    let mut prober = Prober::new(src_ip).unwrap();
    //let mut prober = Prober::new_with_gateway_ip(src_ip, gateway_ip).unwrap();
    prober.set_wait_time(Duration::from_millis(200));
    let dst_info: DstInfo = DstInfo {
        ip_addr: IpAddr::V4(Ipv4Addr::new(192, 168, 1, 10)),
        open_tcp_ports: vec![22,80],
        closed_tcp_port: 443,
        open_udp_port: 123,
        closed_udp_port: 33455,
    };
    prober.add_dst_info(dst_info);
    prober.add_probe_type(ProbeType::IcmpEchoProbe);
    prober.add_probe_type(ProbeType::IcmpTimestampProbe);
    prober.add_probe_type(ProbeType::IcmpAddressMaskProbe);
    prober.add_probe_type(ProbeType::IcmpInformationProbe);
    prober.add_probe_type(ProbeType::IcmpUnreachableProbe);
    prober.add_probe_type(ProbeType::TcpSynAckProbe);
    prober.add_probe_type(ProbeType::TcpRstAckProbe);
    prober.add_probe_type(ProbeType::TcpEcnProbe);
    prober.run_probe();
    for result in prober.get_probe_results() {
        println!("{}", result.ip_addr);
        println!("{:?}", result.icmp_echo_result);
        println!("{:?}", result.icmp_timestamp_result);
        println!("{:?}", result.icmp_address_mask_result);
        println!("{:?}", result.icmp_information_result);
        println!("{:?}", result.icmp_unreachable_ip_result);
        println!("{:?}", result.icmp_unreachable_data_result);
        println!("{:?}", result.tcp_syn_ack_result);
        println!("{:?}", result.tcp_rst_ack_result);
        println!("{:?}", result.tcp_ecn_result);
        println!("{:?}", result.tcp_header_result);
        println!();
    }
}
