// ---------------------------------------------------------------------------
// Copyright:   (c) 2021 ff. Michael Amrhein (michael@adrhinum.de)
// License:     This program is part of a larger application. For license
//              details please read the file LICENSE.TXT provided together
//              with the application.
// ---------------------------------------------------------------------------
// $Source: fpdec-core/src/powers_of_ten.rs $
// $Revision: 2021-11-22T15:41:37+01:00 $

const POWERS_OF_10: [i128; 39] = [
    1,
    10,
    100,
    1_000,
    10_000,
    100_000,
    1_000_000,
    10_000_000,
    100_000_000,
    1_000_000_000,
    10_000_000_000,
    100_000_000_000,
    1_000_000_000_000,
    10_000_000_000_000,
    100_000_000_000_000,
    1_000_000_000_000_000,
    10_000_000_000_000_000,
    100_000_000_000_000_000,
    1_000_000_000_000_000_000,
    10_000_000_000_000_000_000,
    100_000_000_000_000_000_000,
    1_000_000_000_000_000_000_000,
    10_000_000_000_000_000_000_000,
    100_000_000_000_000_000_000_000,
    1_000_000_000_000_000_000_000_000,
    10_000_000_000_000_000_000_000_000,
    100_000_000_000_000_000_000_000_000,
    1_000_000_000_000_000_000_000_000_000,
    10_000_000_000_000_000_000_000_000_000,
    100_000_000_000_000_000_000_000_000_000,
    1_000_000_000_000_000_000_000_000_000_000,
    10_000_000_000_000_000_000_000_000_000_000,
    100_000_000_000_000_000_000_000_000_000_000,
    1_000_000_000_000_000_000_000_000_000_000_000,
    10_000_000_000_000_000_000_000_000_000_000_000,
    100_000_000_000_000_000_000_000_000_000_000_000,
    1_000_000_000_000_000_000_000_000_000_000_000_000,
    10_000_000_000_000_000_000_000_000_000_000_000_000,
    100_000_000_000_000_000_000_000_000_000_000_000_000,
];

#[doc(hidden)]
#[inline(always)]
pub fn ten_pow(n: u8) -> i128 {
    POWERS_OF_10[n as usize]
}

#[doc(hidden)]
#[inline(always)]
pub fn checked_ten_pow(n: u8) -> Option<i128> {
    if n > 38 {
        None
    } else {
        Some(POWERS_OF_10[n as usize])
    }
}

#[doc(hidden)]
#[inline(always)]
pub fn mul_pow_ten(val: i128, n: u8) -> i128 {
    val * ten_pow(n)
}

#[doc(hidden)]
#[inline(always)]
pub fn checked_mul_pow_ten(val: i128, n: u8) -> Option<i128> {
    val.checked_mul(checked_ten_pow(n)?)
}
