Wiki: [https://en.wikipedia.org/wiki/Architecture_description_language](https://en.wikipedia.org/wiki/Architecture_description_language)

语言必须：

- 适合将架构传达给所有相关方 
- 支持架构创建，优化和验证的任务
- 为进一步的实现提供基础，因此它必须能够将信息添加到 ADL 规范中，以使最终的系统规范能够从 ADL 派生
- 提供代表大多数常见建筑风格的功能 
- 支持分析功能或提供快速生成的原型实现

ADL的共同点是：

- 图形语法，通常具有文本形式以及正式定义的语法和语义
- 分布式系统建模的功能
- 除通过通用注释机制外，几乎不支持捕获设计信息
- 能够表示细节的层次结构级别，包括通过实例化模板创建子结构

ADL 在以下方面的能力有所不同：

- 在架构级别处理实时构造，例如截止日期和任务优先级
- 支持不同架构风格的规范。很少处理面向对象的类继承或动态体系结构
- 支持架构分析
- 处理与产品线架构相关的同一架构的不同实例

ADL的积极因素

- ADL 是表示架构的一种正式方式
- ADL 旨在为人类和机器可读
- ADL 支持以比以前更高的级别描述系统
- ADL 允许对体系结构进行分析和评估，以实现完整性，一致性，歧义性和性能
- ADL 可以支持自动生成软件系统

## 架构的共同概念

### 对象连接架构

- 配置由面向对象系统的接口和连接组成
- 接口指定符合接口的模块必须提供的功能
- 由接口表示的连接以及调用图
- 通常由编程语言强制执行的一致性
    - 分解-将接口与唯一模块关联
    - 接口一致性-语法规则的静态检查
    - 通信完整性-模块之间的可见性

### 接口连接架构

 - 扩展接口和连接的作用
       - 接口同时指定“必需”和“提供”功能
       - 在“必需”功能和“提供”功能之间定义了连接
 - 由接口，连接和约束组成
       - 约束限制了体系结构中接口和连接的行为
       -  体系结构中的约束映射到系统需求

大多数ADL实现接口连接体系结构。