// Do not use this crate. It is only meant for internal use. Use `format-bytes`
// instead.
//
// Copyright 2020, Raphaël Gomès <rgomes@octobus.net>

/// `extern crate` Required even for 2018 edition
extern crate proc_macro;

mod utils;

use proc_macro2::TokenStream;
use quote::quote;
use syn::parse_macro_input;

/// This macro is documented in the main crate.
#[proc_macro]
pub fn _write_bytes(
    input: proc_macro::TokenStream,
) -> proc_macro::TokenStream {
    let args = parse_macro_input!(input as utils::WriteBytesArgs);
    inner_write_bytes(&args).into()
}

/// This is the unit-testable version using `proc_macro2`
fn inner_write_bytes(args: &utils::WriteBytesArgs) -> TokenStream {
    let format_string = &args.format_string;
    let input = format_string.value();
    let positions = match utils::extract_formatting_positions(&input) {
        Ok(pos) => pos,
        Err(_) => {
            return quote! {compile_error!("unclosed formatting delimiter")}
        }
    };

    if positions.len() > args.positional_args.len() {
        return quote! {compile_error!("not enough arguments for formatting")};
    }
    if positions.len() < args.positional_args.len() {
        return quote! {compile_error!("too many arguments for formatting")};
    }

    let calls = utils::generate_write_calls(args, &input, &positions);
    let output = &args.output;
    let combined = utils::combine_result_expressions(calls);

    quote! {
        {
            let mut output: &mut _ = #output;
            #combined
        }
    }
}
