mod edit;
mod test;

pub use self::edit::*;
pub use self::test::*;
#[cfg(not(feature = "std"))]
use alloc::vec::Vec;

#[derive(Clone, Debug, Default, PartialEq)]
pub struct Match {
    pub target: MatchTarget,
    pub tests: Vec<Test>,
    pub edits: Vec<Edit>,
}

#[derive(Clone, Copy, Debug, PartialEq, Eq)]
pub enum MatchTarget {
    Pattern,
    Font,
    Scan,
}

parse_enum! {
    MatchTarget,
    (Pattern, "pattern"),
    (Font, "font"),
    (Scan, "scan"),
}

impl Default for MatchTarget {
    fn default() -> Self {
        MatchTarget::Pattern
    }
}
