// @generated
//
// This source is autogenerated. Do not modify it directly.
// To make modfications to this code, see `scripts/gen_case_lookups.rb`.
//
// Last generated on 2022-01-23 03:22:04 UTC.
//
// Unicode version:
// CaseFolding-14.0.0.txt
// Date: 2021-03-08, 19:35:41 GMT
// © 2021 Unicode®, Inc.

use super::{Mapping, Mode};

#[must_use]
#[allow(clippy::match_same_arms)]
#[allow(clippy::too_many_lines)]
pub const fn lookup(c: char, mode: Mode) -> Mapping {
    let codepoint = c as u32;
    let char_bytes = codepoint.to_be_bytes();
    let mid_byte = char_bytes[2];
    let high_bytes = u16::from_be_bytes([char_bytes[0], char_bytes[1]]);
    match (high_bytes, mid_byte) {
        (0x0000, 0x00) => match c {
            // Turkic mapping in ASCII range
            // 0049; T; 0131; # LATIN CAPITAL LETTER I
            '\u{0049}' if matches!(mode, Mode::Turkic) => Mapping::Single(0x0131),
            c if c.is_ascii() => Mapping::Single(c.to_ascii_lowercase() as u32),
            '\u{00B5}' => Mapping::Single(0x03BC),
            '\u{00C0}'..='\u{00D6}' => Mapping::Single(codepoint.wrapping_add(0x0020)),
            '\u{00D8}'..='\u{00DE}' => Mapping::Single(codepoint.wrapping_add(0x0020)),
            '\u{00DF}' => Mapping::Double(0x0073, 0x0073),
            _ => Mapping::Single(codepoint),
        },
        (0x0000, 0x01) => match c {
            '\u{0100}' => Mapping::Single(0x0101),
            '\u{0102}' => Mapping::Single(0x0103),
            '\u{0104}' => Mapping::Single(0x0105),
            '\u{0106}' => Mapping::Single(0x0107),
            '\u{0108}' => Mapping::Single(0x0109),
            '\u{010A}' => Mapping::Single(0x010B),
            '\u{010C}' => Mapping::Single(0x010D),
            '\u{010E}' => Mapping::Single(0x010F),
            '\u{0110}' => Mapping::Single(0x0111),
            '\u{0112}' => Mapping::Single(0x0113),
            '\u{0114}' => Mapping::Single(0x0115),
            '\u{0116}' => Mapping::Single(0x0117),
            '\u{0118}' => Mapping::Single(0x0119),
            '\u{011A}' => Mapping::Single(0x011B),
            '\u{011C}' => Mapping::Single(0x011D),
            '\u{011E}' => Mapping::Single(0x011F),
            '\u{0120}' => Mapping::Single(0x0121),
            '\u{0122}' => Mapping::Single(0x0123),
            '\u{0124}' => Mapping::Single(0x0125),
            '\u{0126}' => Mapping::Single(0x0127),
            '\u{0128}' => Mapping::Single(0x0129),
            '\u{012A}' => Mapping::Single(0x012B),
            '\u{012C}' => Mapping::Single(0x012D),
            '\u{012E}' => Mapping::Single(0x012F),
            '\u{0130}' if matches!(mode, Mode::Full) => Mapping::Double(0x0069, 0x0307),
            '\u{0130}' if matches!(mode, Mode::Turkic) => Mapping::Single(0x0069),
            '\u{0132}' => Mapping::Single(0x0133),
            '\u{0134}' => Mapping::Single(0x0135),
            '\u{0136}' => Mapping::Single(0x0137),
            '\u{0139}' => Mapping::Single(0x013A),
            '\u{013B}' => Mapping::Single(0x013C),
            '\u{013D}' => Mapping::Single(0x013E),
            '\u{013F}' => Mapping::Single(0x0140),
            '\u{0141}' => Mapping::Single(0x0142),
            '\u{0143}' => Mapping::Single(0x0144),
            '\u{0145}' => Mapping::Single(0x0146),
            '\u{0147}' => Mapping::Single(0x0148),
            '\u{0149}' => Mapping::Double(0x02BC, 0x006E),
            '\u{014A}' => Mapping::Single(0x014B),
            '\u{014C}' => Mapping::Single(0x014D),
            '\u{014E}' => Mapping::Single(0x014F),
            '\u{0150}' => Mapping::Single(0x0151),
            '\u{0152}' => Mapping::Single(0x0153),
            '\u{0154}' => Mapping::Single(0x0155),
            '\u{0156}' => Mapping::Single(0x0157),
            '\u{0158}' => Mapping::Single(0x0159),
            '\u{015A}' => Mapping::Single(0x015B),
            '\u{015C}' => Mapping::Single(0x015D),
            '\u{015E}' => Mapping::Single(0x015F),
            '\u{0160}' => Mapping::Single(0x0161),
            '\u{0162}' => Mapping::Single(0x0163),
            '\u{0164}' => Mapping::Single(0x0165),
            '\u{0166}' => Mapping::Single(0x0167),
            '\u{0168}' => Mapping::Single(0x0169),
            '\u{016A}' => Mapping::Single(0x016B),
            '\u{016C}' => Mapping::Single(0x016D),
            '\u{016E}' => Mapping::Single(0x016F),
            '\u{0170}' => Mapping::Single(0x0171),
            '\u{0172}' => Mapping::Single(0x0173),
            '\u{0174}' => Mapping::Single(0x0175),
            '\u{0176}' => Mapping::Single(0x0177),
            '\u{0178}' => Mapping::Single(0x00FF),
            '\u{0179}' => Mapping::Single(0x017A),
            '\u{017B}' => Mapping::Single(0x017C),
            '\u{017D}' => Mapping::Single(0x017E),
            '\u{017F}' => Mapping::Single(0x0073),
            '\u{0181}' => Mapping::Single(0x0253),
            '\u{0182}' => Mapping::Single(0x0183),
            '\u{0184}' => Mapping::Single(0x0185),
            '\u{0186}' => Mapping::Single(0x0254),
            '\u{0187}' => Mapping::Single(0x0188),
            '\u{0189}'..='\u{018A}' => Mapping::Single(codepoint.wrapping_add(0x00cd)),
            '\u{018B}' => Mapping::Single(0x018C),
            '\u{018E}' => Mapping::Single(0x01DD),
            '\u{018F}' => Mapping::Single(0x0259),
            '\u{0190}' => Mapping::Single(0x025B),
            '\u{0191}' => Mapping::Single(0x0192),
            '\u{0193}' => Mapping::Single(0x0260),
            '\u{0194}' => Mapping::Single(0x0263),
            '\u{0196}' => Mapping::Single(0x0269),
            '\u{0197}' => Mapping::Single(0x0268),
            '\u{0198}' => Mapping::Single(0x0199),
            '\u{019C}' => Mapping::Single(0x026F),
            '\u{019D}' => Mapping::Single(0x0272),
            '\u{019F}' => Mapping::Single(0x0275),
            '\u{01A0}' => Mapping::Single(0x01A1),
            '\u{01A2}' => Mapping::Single(0x01A3),
            '\u{01A4}' => Mapping::Single(0x01A5),
            '\u{01A6}' => Mapping::Single(0x0280),
            '\u{01A7}' => Mapping::Single(0x01A8),
            '\u{01A9}' => Mapping::Single(0x0283),
            '\u{01AC}' => Mapping::Single(0x01AD),
            '\u{01AE}' => Mapping::Single(0x0288),
            '\u{01AF}' => Mapping::Single(0x01B0),
            '\u{01B1}'..='\u{01B2}' => Mapping::Single(codepoint.wrapping_add(0x00d9)),
            '\u{01B3}' => Mapping::Single(0x01B4),
            '\u{01B5}' => Mapping::Single(0x01B6),
            '\u{01B7}' => Mapping::Single(0x0292),
            '\u{01B8}' => Mapping::Single(0x01B9),
            '\u{01BC}' => Mapping::Single(0x01BD),
            '\u{01C4}' => Mapping::Single(0x01C6),
            '\u{01C5}' => Mapping::Single(0x01C6),
            '\u{01C7}' => Mapping::Single(0x01C9),
            '\u{01C8}' => Mapping::Single(0x01C9),
            '\u{01CA}' => Mapping::Single(0x01CC),
            '\u{01CB}' => Mapping::Single(0x01CC),
            '\u{01CD}' => Mapping::Single(0x01CE),
            '\u{01CF}' => Mapping::Single(0x01D0),
            '\u{01D1}' => Mapping::Single(0x01D2),
            '\u{01D3}' => Mapping::Single(0x01D4),
            '\u{01D5}' => Mapping::Single(0x01D6),
            '\u{01D7}' => Mapping::Single(0x01D8),
            '\u{01D9}' => Mapping::Single(0x01DA),
            '\u{01DB}' => Mapping::Single(0x01DC),
            '\u{01DE}' => Mapping::Single(0x01DF),
            '\u{01E0}' => Mapping::Single(0x01E1),
            '\u{01E2}' => Mapping::Single(0x01E3),
            '\u{01E4}' => Mapping::Single(0x01E5),
            '\u{01E6}' => Mapping::Single(0x01E7),
            '\u{01E8}' => Mapping::Single(0x01E9),
            '\u{01EA}' => Mapping::Single(0x01EB),
            '\u{01EC}' => Mapping::Single(0x01ED),
            '\u{01EE}' => Mapping::Single(0x01EF),
            '\u{01F0}' => Mapping::Double(0x006A, 0x030C),
            '\u{01F1}' => Mapping::Single(0x01F3),
            '\u{01F2}' => Mapping::Single(0x01F3),
            '\u{01F4}' => Mapping::Single(0x01F5),
            '\u{01F6}' => Mapping::Single(0x0195),
            '\u{01F7}' => Mapping::Single(0x01BF),
            '\u{01F8}' => Mapping::Single(0x01F9),
            '\u{01FA}' => Mapping::Single(0x01FB),
            '\u{01FC}' => Mapping::Single(0x01FD),
            '\u{01FE}' => Mapping::Single(0x01FF),
            _ => Mapping::Single(codepoint),
        },
        (0x0000, 0x02) => match c {
            '\u{0200}' => Mapping::Single(0x0201),
            '\u{0202}' => Mapping::Single(0x0203),
            '\u{0204}' => Mapping::Single(0x0205),
            '\u{0206}' => Mapping::Single(0x0207),
            '\u{0208}' => Mapping::Single(0x0209),
            '\u{020A}' => Mapping::Single(0x020B),
            '\u{020C}' => Mapping::Single(0x020D),
            '\u{020E}' => Mapping::Single(0x020F),
            '\u{0210}' => Mapping::Single(0x0211),
            '\u{0212}' => Mapping::Single(0x0213),
            '\u{0214}' => Mapping::Single(0x0215),
            '\u{0216}' => Mapping::Single(0x0217),
            '\u{0218}' => Mapping::Single(0x0219),
            '\u{021A}' => Mapping::Single(0x021B),
            '\u{021C}' => Mapping::Single(0x021D),
            '\u{021E}' => Mapping::Single(0x021F),
            '\u{0220}' => Mapping::Single(0x019E),
            '\u{0222}' => Mapping::Single(0x0223),
            '\u{0224}' => Mapping::Single(0x0225),
            '\u{0226}' => Mapping::Single(0x0227),
            '\u{0228}' => Mapping::Single(0x0229),
            '\u{022A}' => Mapping::Single(0x022B),
            '\u{022C}' => Mapping::Single(0x022D),
            '\u{022E}' => Mapping::Single(0x022F),
            '\u{0230}' => Mapping::Single(0x0231),
            '\u{0232}' => Mapping::Single(0x0233),
            '\u{023A}' => Mapping::Single(0x2C65),
            '\u{023B}' => Mapping::Single(0x023C),
            '\u{023D}' => Mapping::Single(0x019A),
            '\u{023E}' => Mapping::Single(0x2C66),
            '\u{0241}' => Mapping::Single(0x0242),
            '\u{0243}' => Mapping::Single(0x0180),
            '\u{0244}' => Mapping::Single(0x0289),
            '\u{0245}' => Mapping::Single(0x028C),
            '\u{0246}' => Mapping::Single(0x0247),
            '\u{0248}' => Mapping::Single(0x0249),
            '\u{024A}' => Mapping::Single(0x024B),
            '\u{024C}' => Mapping::Single(0x024D),
            '\u{024E}' => Mapping::Single(0x024F),
            _ => Mapping::Single(codepoint),
        },
        (0x0000, 0x03) => match c {
            '\u{0345}' => Mapping::Single(0x03B9),
            '\u{0370}' => Mapping::Single(0x0371),
            '\u{0372}' => Mapping::Single(0x0373),
            '\u{0376}' => Mapping::Single(0x0377),
            '\u{037F}' => Mapping::Single(0x03F3),
            '\u{0386}' => Mapping::Single(0x03AC),
            '\u{0388}'..='\u{038A}' => Mapping::Single(codepoint.wrapping_add(0x0025)),
            '\u{038C}' => Mapping::Single(0x03CC),
            '\u{038E}'..='\u{038F}' => Mapping::Single(codepoint.wrapping_add(0x003f)),
            '\u{0390}' => Mapping::Triple(0x03B9, 0x0308, 0x0301),
            '\u{0391}'..='\u{03A1}' => Mapping::Single(codepoint.wrapping_add(0x0020)),
            '\u{03A3}'..='\u{03AB}' => Mapping::Single(codepoint.wrapping_add(0x0020)),
            '\u{03B0}' => Mapping::Triple(0x03C5, 0x0308, 0x0301),
            '\u{03C2}' => Mapping::Single(0x03C3),
            '\u{03CF}' => Mapping::Single(0x03D7),
            '\u{03D0}' => Mapping::Single(0x03B2),
            '\u{03D1}' => Mapping::Single(0x03B8),
            '\u{03D5}' => Mapping::Single(0x03C6),
            '\u{03D6}' => Mapping::Single(0x03C0),
            '\u{03D8}' => Mapping::Single(0x03D9),
            '\u{03DA}' => Mapping::Single(0x03DB),
            '\u{03DC}' => Mapping::Single(0x03DD),
            '\u{03DE}' => Mapping::Single(0x03DF),
            '\u{03E0}' => Mapping::Single(0x03E1),
            '\u{03E2}' => Mapping::Single(0x03E3),
            '\u{03E4}' => Mapping::Single(0x03E5),
            '\u{03E6}' => Mapping::Single(0x03E7),
            '\u{03E8}' => Mapping::Single(0x03E9),
            '\u{03EA}' => Mapping::Single(0x03EB),
            '\u{03EC}' => Mapping::Single(0x03ED),
            '\u{03EE}' => Mapping::Single(0x03EF),
            '\u{03F0}' => Mapping::Single(0x03BA),
            '\u{03F1}' => Mapping::Single(0x03C1),
            '\u{03F4}' => Mapping::Single(0x03B8),
            '\u{03F5}' => Mapping::Single(0x03B5),
            '\u{03F7}' => Mapping::Single(0x03F8),
            '\u{03F9}' => Mapping::Single(0x03F2),
            '\u{03FA}' => Mapping::Single(0x03FB),
            '\u{03FD}'..='\u{03FF}' => Mapping::Single(codepoint.wrapping_sub(0x0082)),
            _ => Mapping::Single(codepoint),
        },
        (0x0000, 0x04) => match c {
            '\u{0400}'..='\u{040F}' => Mapping::Single(codepoint.wrapping_add(0x0050)),
            '\u{0410}'..='\u{042F}' => Mapping::Single(codepoint.wrapping_add(0x0020)),
            '\u{0460}' => Mapping::Single(0x0461),
            '\u{0462}' => Mapping::Single(0x0463),
            '\u{0464}' => Mapping::Single(0x0465),
            '\u{0466}' => Mapping::Single(0x0467),
            '\u{0468}' => Mapping::Single(0x0469),
            '\u{046A}' => Mapping::Single(0x046B),
            '\u{046C}' => Mapping::Single(0x046D),
            '\u{046E}' => Mapping::Single(0x046F),
            '\u{0470}' => Mapping::Single(0x0471),
            '\u{0472}' => Mapping::Single(0x0473),
            '\u{0474}' => Mapping::Single(0x0475),
            '\u{0476}' => Mapping::Single(0x0477),
            '\u{0478}' => Mapping::Single(0x0479),
            '\u{047A}' => Mapping::Single(0x047B),
            '\u{047C}' => Mapping::Single(0x047D),
            '\u{047E}' => Mapping::Single(0x047F),
            '\u{0480}' => Mapping::Single(0x0481),
            '\u{048A}' => Mapping::Single(0x048B),
            '\u{048C}' => Mapping::Single(0x048D),
            '\u{048E}' => Mapping::Single(0x048F),
            '\u{0490}' => Mapping::Single(0x0491),
            '\u{0492}' => Mapping::Single(0x0493),
            '\u{0494}' => Mapping::Single(0x0495),
            '\u{0496}' => Mapping::Single(0x0497),
            '\u{0498}' => Mapping::Single(0x0499),
            '\u{049A}' => Mapping::Single(0x049B),
            '\u{049C}' => Mapping::Single(0x049D),
            '\u{049E}' => Mapping::Single(0x049F),
            '\u{04A0}' => Mapping::Single(0x04A1),
            '\u{04A2}' => Mapping::Single(0x04A3),
            '\u{04A4}' => Mapping::Single(0x04A5),
            '\u{04A6}' => Mapping::Single(0x04A7),
            '\u{04A8}' => Mapping::Single(0x04A9),
            '\u{04AA}' => Mapping::Single(0x04AB),
            '\u{04AC}' => Mapping::Single(0x04AD),
            '\u{04AE}' => Mapping::Single(0x04AF),
            '\u{04B0}' => Mapping::Single(0x04B1),
            '\u{04B2}' => Mapping::Single(0x04B3),
            '\u{04B4}' => Mapping::Single(0x04B5),
            '\u{04B6}' => Mapping::Single(0x04B7),
            '\u{04B8}' => Mapping::Single(0x04B9),
            '\u{04BA}' => Mapping::Single(0x04BB),
            '\u{04BC}' => Mapping::Single(0x04BD),
            '\u{04BE}' => Mapping::Single(0x04BF),
            '\u{04C0}' => Mapping::Single(0x04CF),
            '\u{04C1}' => Mapping::Single(0x04C2),
            '\u{04C3}' => Mapping::Single(0x04C4),
            '\u{04C5}' => Mapping::Single(0x04C6),
            '\u{04C7}' => Mapping::Single(0x04C8),
            '\u{04C9}' => Mapping::Single(0x04CA),
            '\u{04CB}' => Mapping::Single(0x04CC),
            '\u{04CD}' => Mapping::Single(0x04CE),
            '\u{04D0}' => Mapping::Single(0x04D1),
            '\u{04D2}' => Mapping::Single(0x04D3),
            '\u{04D4}' => Mapping::Single(0x04D5),
            '\u{04D6}' => Mapping::Single(0x04D7),
            '\u{04D8}' => Mapping::Single(0x04D9),
            '\u{04DA}' => Mapping::Single(0x04DB),
            '\u{04DC}' => Mapping::Single(0x04DD),
            '\u{04DE}' => Mapping::Single(0x04DF),
            '\u{04E0}' => Mapping::Single(0x04E1),
            '\u{04E2}' => Mapping::Single(0x04E3),
            '\u{04E4}' => Mapping::Single(0x04E5),
            '\u{04E6}' => Mapping::Single(0x04E7),
            '\u{04E8}' => Mapping::Single(0x04E9),
            '\u{04EA}' => Mapping::Single(0x04EB),
            '\u{04EC}' => Mapping::Single(0x04ED),
            '\u{04EE}' => Mapping::Single(0x04EF),
            '\u{04F0}' => Mapping::Single(0x04F1),
            '\u{04F2}' => Mapping::Single(0x04F3),
            '\u{04F4}' => Mapping::Single(0x04F5),
            '\u{04F6}' => Mapping::Single(0x04F7),
            '\u{04F8}' => Mapping::Single(0x04F9),
            '\u{04FA}' => Mapping::Single(0x04FB),
            '\u{04FC}' => Mapping::Single(0x04FD),
            '\u{04FE}' => Mapping::Single(0x04FF),
            _ => Mapping::Single(codepoint),
        },
        (0x0000, 0x05) => match c {
            '\u{0500}' => Mapping::Single(0x0501),
            '\u{0502}' => Mapping::Single(0x0503),
            '\u{0504}' => Mapping::Single(0x0505),
            '\u{0506}' => Mapping::Single(0x0507),
            '\u{0508}' => Mapping::Single(0x0509),
            '\u{050A}' => Mapping::Single(0x050B),
            '\u{050C}' => Mapping::Single(0x050D),
            '\u{050E}' => Mapping::Single(0x050F),
            '\u{0510}' => Mapping::Single(0x0511),
            '\u{0512}' => Mapping::Single(0x0513),
            '\u{0514}' => Mapping::Single(0x0515),
            '\u{0516}' => Mapping::Single(0x0517),
            '\u{0518}' => Mapping::Single(0x0519),
            '\u{051A}' => Mapping::Single(0x051B),
            '\u{051C}' => Mapping::Single(0x051D),
            '\u{051E}' => Mapping::Single(0x051F),
            '\u{0520}' => Mapping::Single(0x0521),
            '\u{0522}' => Mapping::Single(0x0523),
            '\u{0524}' => Mapping::Single(0x0525),
            '\u{0526}' => Mapping::Single(0x0527),
            '\u{0528}' => Mapping::Single(0x0529),
            '\u{052A}' => Mapping::Single(0x052B),
            '\u{052C}' => Mapping::Single(0x052D),
            '\u{052E}' => Mapping::Single(0x052F),
            '\u{0531}'..='\u{0556}' => Mapping::Single(codepoint.wrapping_add(0x0030)),
            '\u{0587}' => Mapping::Double(0x0565, 0x0582),
            _ => Mapping::Single(codepoint),
        },
        (0x0000, 0x10) => match c {
            '\u{10A0}'..='\u{10C5}' => Mapping::Single(codepoint.wrapping_add(0x1c60)),
            '\u{10C7}' => Mapping::Single(0x2D27),
            '\u{10CD}' => Mapping::Single(0x2D2D),
            _ => Mapping::Single(codepoint),
        },
        (0x0000, 0x13) => match c {
            '\u{13F8}'..='\u{13FD}' => Mapping::Single(codepoint.wrapping_sub(0x0008)),
            _ => Mapping::Single(codepoint),
        },
        (0x0000, 0x1C) => match c {
            '\u{1C80}' => Mapping::Single(0x0432),
            '\u{1C81}' => Mapping::Single(0x0434),
            '\u{1C82}' => Mapping::Single(0x043E),
            '\u{1C83}'..='\u{1C84}' => Mapping::Single(codepoint.wrapping_sub(0x1842)),
            '\u{1C85}' => Mapping::Single(0x0442),
            '\u{1C86}' => Mapping::Single(0x044A),
            '\u{1C87}' => Mapping::Single(0x0463),
            '\u{1C88}' => Mapping::Single(0xA64B),
            '\u{1C90}'..='\u{1CBA}' => Mapping::Single(codepoint.wrapping_sub(0x0bc0)),
            '\u{1CBD}'..='\u{1CBF}' => Mapping::Single(codepoint.wrapping_sub(0x0bc0)),
            _ => Mapping::Single(codepoint),
        },
        (0x0000, 0x1E) => match c {
            '\u{1E00}' => Mapping::Single(0x1E01),
            '\u{1E02}' => Mapping::Single(0x1E03),
            '\u{1E04}' => Mapping::Single(0x1E05),
            '\u{1E06}' => Mapping::Single(0x1E07),
            '\u{1E08}' => Mapping::Single(0x1E09),
            '\u{1E0A}' => Mapping::Single(0x1E0B),
            '\u{1E0C}' => Mapping::Single(0x1E0D),
            '\u{1E0E}' => Mapping::Single(0x1E0F),
            '\u{1E10}' => Mapping::Single(0x1E11),
            '\u{1E12}' => Mapping::Single(0x1E13),
            '\u{1E14}' => Mapping::Single(0x1E15),
            '\u{1E16}' => Mapping::Single(0x1E17),
            '\u{1E18}' => Mapping::Single(0x1E19),
            '\u{1E1A}' => Mapping::Single(0x1E1B),
            '\u{1E1C}' => Mapping::Single(0x1E1D),
            '\u{1E1E}' => Mapping::Single(0x1E1F),
            '\u{1E20}' => Mapping::Single(0x1E21),
            '\u{1E22}' => Mapping::Single(0x1E23),
            '\u{1E24}' => Mapping::Single(0x1E25),
            '\u{1E26}' => Mapping::Single(0x1E27),
            '\u{1E28}' => Mapping::Single(0x1E29),
            '\u{1E2A}' => Mapping::Single(0x1E2B),
            '\u{1E2C}' => Mapping::Single(0x1E2D),
            '\u{1E2E}' => Mapping::Single(0x1E2F),
            '\u{1E30}' => Mapping::Single(0x1E31),
            '\u{1E32}' => Mapping::Single(0x1E33),
            '\u{1E34}' => Mapping::Single(0x1E35),
            '\u{1E36}' => Mapping::Single(0x1E37),
            '\u{1E38}' => Mapping::Single(0x1E39),
            '\u{1E3A}' => Mapping::Single(0x1E3B),
            '\u{1E3C}' => Mapping::Single(0x1E3D),
            '\u{1E3E}' => Mapping::Single(0x1E3F),
            '\u{1E40}' => Mapping::Single(0x1E41),
            '\u{1E42}' => Mapping::Single(0x1E43),
            '\u{1E44}' => Mapping::Single(0x1E45),
            '\u{1E46}' => Mapping::Single(0x1E47),
            '\u{1E48}' => Mapping::Single(0x1E49),
            '\u{1E4A}' => Mapping::Single(0x1E4B),
            '\u{1E4C}' => Mapping::Single(0x1E4D),
            '\u{1E4E}' => Mapping::Single(0x1E4F),
            '\u{1E50}' => Mapping::Single(0x1E51),
            '\u{1E52}' => Mapping::Single(0x1E53),
            '\u{1E54}' => Mapping::Single(0x1E55),
            '\u{1E56}' => Mapping::Single(0x1E57),
            '\u{1E58}' => Mapping::Single(0x1E59),
            '\u{1E5A}' => Mapping::Single(0x1E5B),
            '\u{1E5C}' => Mapping::Single(0x1E5D),
            '\u{1E5E}' => Mapping::Single(0x1E5F),
            '\u{1E60}' => Mapping::Single(0x1E61),
            '\u{1E62}' => Mapping::Single(0x1E63),
            '\u{1E64}' => Mapping::Single(0x1E65),
            '\u{1E66}' => Mapping::Single(0x1E67),
            '\u{1E68}' => Mapping::Single(0x1E69),
            '\u{1E6A}' => Mapping::Single(0x1E6B),
            '\u{1E6C}' => Mapping::Single(0x1E6D),
            '\u{1E6E}' => Mapping::Single(0x1E6F),
            '\u{1E70}' => Mapping::Single(0x1E71),
            '\u{1E72}' => Mapping::Single(0x1E73),
            '\u{1E74}' => Mapping::Single(0x1E75),
            '\u{1E76}' => Mapping::Single(0x1E77),
            '\u{1E78}' => Mapping::Single(0x1E79),
            '\u{1E7A}' => Mapping::Single(0x1E7B),
            '\u{1E7C}' => Mapping::Single(0x1E7D),
            '\u{1E7E}' => Mapping::Single(0x1E7F),
            '\u{1E80}' => Mapping::Single(0x1E81),
            '\u{1E82}' => Mapping::Single(0x1E83),
            '\u{1E84}' => Mapping::Single(0x1E85),
            '\u{1E86}' => Mapping::Single(0x1E87),
            '\u{1E88}' => Mapping::Single(0x1E89),
            '\u{1E8A}' => Mapping::Single(0x1E8B),
            '\u{1E8C}' => Mapping::Single(0x1E8D),
            '\u{1E8E}' => Mapping::Single(0x1E8F),
            '\u{1E90}' => Mapping::Single(0x1E91),
            '\u{1E92}' => Mapping::Single(0x1E93),
            '\u{1E94}' => Mapping::Single(0x1E95),
            '\u{1E96}' => Mapping::Double(0x0068, 0x0331),
            '\u{1E97}' => Mapping::Double(0x0074, 0x0308),
            '\u{1E98}' => Mapping::Double(0x0077, 0x030A),
            '\u{1E99}' => Mapping::Double(0x0079, 0x030A),
            '\u{1E9A}' => Mapping::Double(0x0061, 0x02BE),
            '\u{1E9B}' => Mapping::Single(0x1E61),
            '\u{1E9E}' => Mapping::Double(0x0073, 0x0073),
            '\u{1EA0}' => Mapping::Single(0x1EA1),
            '\u{1EA2}' => Mapping::Single(0x1EA3),
            '\u{1EA4}' => Mapping::Single(0x1EA5),
            '\u{1EA6}' => Mapping::Single(0x1EA7),
            '\u{1EA8}' => Mapping::Single(0x1EA9),
            '\u{1EAA}' => Mapping::Single(0x1EAB),
            '\u{1EAC}' => Mapping::Single(0x1EAD),
            '\u{1EAE}' => Mapping::Single(0x1EAF),
            '\u{1EB0}' => Mapping::Single(0x1EB1),
            '\u{1EB2}' => Mapping::Single(0x1EB3),
            '\u{1EB4}' => Mapping::Single(0x1EB5),
            '\u{1EB6}' => Mapping::Single(0x1EB7),
            '\u{1EB8}' => Mapping::Single(0x1EB9),
            '\u{1EBA}' => Mapping::Single(0x1EBB),
            '\u{1EBC}' => Mapping::Single(0x1EBD),
            '\u{1EBE}' => Mapping::Single(0x1EBF),
            '\u{1EC0}' => Mapping::Single(0x1EC1),
            '\u{1EC2}' => Mapping::Single(0x1EC3),
            '\u{1EC4}' => Mapping::Single(0x1EC5),
            '\u{1EC6}' => Mapping::Single(0x1EC7),
            '\u{1EC8}' => Mapping::Single(0x1EC9),
            '\u{1ECA}' => Mapping::Single(0x1ECB),
            '\u{1ECC}' => Mapping::Single(0x1ECD),
            '\u{1ECE}' => Mapping::Single(0x1ECF),
            '\u{1ED0}' => Mapping::Single(0x1ED1),
            '\u{1ED2}' => Mapping::Single(0x1ED3),
            '\u{1ED4}' => Mapping::Single(0x1ED5),
            '\u{1ED6}' => Mapping::Single(0x1ED7),
            '\u{1ED8}' => Mapping::Single(0x1ED9),
            '\u{1EDA}' => Mapping::Single(0x1EDB),
            '\u{1EDC}' => Mapping::Single(0x1EDD),
            '\u{1EDE}' => Mapping::Single(0x1EDF),
            '\u{1EE0}' => Mapping::Single(0x1EE1),
            '\u{1EE2}' => Mapping::Single(0x1EE3),
            '\u{1EE4}' => Mapping::Single(0x1EE5),
            '\u{1EE6}' => Mapping::Single(0x1EE7),
            '\u{1EE8}' => Mapping::Single(0x1EE9),
            '\u{1EEA}' => Mapping::Single(0x1EEB),
            '\u{1EEC}' => Mapping::Single(0x1EED),
            '\u{1EEE}' => Mapping::Single(0x1EEF),
            '\u{1EF0}' => Mapping::Single(0x1EF1),
            '\u{1EF2}' => Mapping::Single(0x1EF3),
            '\u{1EF4}' => Mapping::Single(0x1EF5),
            '\u{1EF6}' => Mapping::Single(0x1EF7),
            '\u{1EF8}' => Mapping::Single(0x1EF9),
            '\u{1EFA}' => Mapping::Single(0x1EFB),
            '\u{1EFC}' => Mapping::Single(0x1EFD),
            '\u{1EFE}' => Mapping::Single(0x1EFF),
            _ => Mapping::Single(codepoint),
        },
        (0x0000, 0x1F) => match c {
            '\u{1F08}'..='\u{1F0F}' => Mapping::Single(codepoint.wrapping_sub(0x0008)),
            '\u{1F18}'..='\u{1F1D}' => Mapping::Single(codepoint.wrapping_sub(0x0008)),
            '\u{1F28}'..='\u{1F2F}' => Mapping::Single(codepoint.wrapping_sub(0x0008)),
            '\u{1F38}'..='\u{1F3F}' => Mapping::Single(codepoint.wrapping_sub(0x0008)),
            '\u{1F48}'..='\u{1F4D}' => Mapping::Single(codepoint.wrapping_sub(0x0008)),
            '\u{1F50}' => Mapping::Double(0x03C5, 0x0313),
            '\u{1F52}' => Mapping::Triple(0x03C5, 0x0313, 0x0300),
            '\u{1F54}' => Mapping::Triple(0x03C5, 0x0313, 0x0301),
            '\u{1F56}' => Mapping::Triple(0x03C5, 0x0313, 0x0342),
            '\u{1F59}' => Mapping::Single(0x1F51),
            '\u{1F5B}' => Mapping::Single(0x1F53),
            '\u{1F5D}' => Mapping::Single(0x1F55),
            '\u{1F5F}' => Mapping::Single(0x1F57),
            '\u{1F68}'..='\u{1F6F}' => Mapping::Single(codepoint.wrapping_sub(0x0008)),
            '\u{1F80}'..='\u{1F87}' => Mapping::Double(codepoint.wrapping_sub(0x0080), 0x03B9),
            '\u{1F88}'..='\u{1F8F}' => Mapping::Double(codepoint.wrapping_sub(0x0088), 0x03B9),
            '\u{1F90}'..='\u{1F97}' => Mapping::Double(codepoint.wrapping_sub(0x0070), 0x03B9),
            '\u{1F98}'..='\u{1F9F}' => Mapping::Double(codepoint.wrapping_sub(0x0078), 0x03B9),
            '\u{1FA0}'..='\u{1FA7}' => Mapping::Double(codepoint.wrapping_sub(0x0040), 0x03B9),
            '\u{1FA8}'..='\u{1FAF}' => Mapping::Double(codepoint.wrapping_sub(0x0048), 0x03B9),
            '\u{1FB2}' => Mapping::Double(0x1F70, 0x03B9),
            '\u{1FB3}' => Mapping::Double(0x03B1, 0x03B9),
            '\u{1FB4}' => Mapping::Double(0x03AC, 0x03B9),
            '\u{1FB6}' => Mapping::Double(0x03B1, 0x0342),
            '\u{1FB7}' => Mapping::Triple(0x03B1, 0x0342, 0x03B9),
            '\u{1FB8}'..='\u{1FB9}' => Mapping::Single(codepoint.wrapping_sub(0x0008)),
            '\u{1FBA}'..='\u{1FBB}' => Mapping::Single(codepoint.wrapping_sub(0x004a)),
            '\u{1FBC}' => Mapping::Double(0x03B1, 0x03B9),
            '\u{1FBE}' => Mapping::Single(0x03B9),
            '\u{1FC2}' => Mapping::Double(0x1F74, 0x03B9),
            '\u{1FC3}' => Mapping::Double(0x03B7, 0x03B9),
            '\u{1FC4}' => Mapping::Double(0x03AE, 0x03B9),
            '\u{1FC6}' => Mapping::Double(0x03B7, 0x0342),
            '\u{1FC7}' => Mapping::Triple(0x03B7, 0x0342, 0x03B9),
            '\u{1FC8}'..='\u{1FCB}' => Mapping::Single(codepoint.wrapping_sub(0x0056)),
            '\u{1FCC}' => Mapping::Double(0x03B7, 0x03B9),
            '\u{1FD2}' => Mapping::Triple(0x03B9, 0x0308, 0x0300),
            '\u{1FD3}' => Mapping::Triple(0x03B9, 0x0308, 0x0301),
            '\u{1FD6}' => Mapping::Double(0x03B9, 0x0342),
            '\u{1FD7}' => Mapping::Triple(0x03B9, 0x0308, 0x0342),
            '\u{1FD8}'..='\u{1FD9}' => Mapping::Single(codepoint.wrapping_sub(0x0008)),
            '\u{1FDA}'..='\u{1FDB}' => Mapping::Single(codepoint.wrapping_sub(0x0064)),
            '\u{1FE2}' => Mapping::Triple(0x03C5, 0x0308, 0x0300),
            '\u{1FE3}' => Mapping::Triple(0x03C5, 0x0308, 0x0301),
            '\u{1FE4}' => Mapping::Double(0x03C1, 0x0313),
            '\u{1FE6}' => Mapping::Double(0x03C5, 0x0342),
            '\u{1FE7}' => Mapping::Triple(0x03C5, 0x0308, 0x0342),
            '\u{1FE8}'..='\u{1FE9}' => Mapping::Single(codepoint.wrapping_sub(0x0008)),
            '\u{1FEA}'..='\u{1FEB}' => Mapping::Single(codepoint.wrapping_sub(0x0070)),
            '\u{1FEC}' => Mapping::Single(0x1FE5),
            '\u{1FF2}' => Mapping::Double(0x1F7C, 0x03B9),
            '\u{1FF3}' => Mapping::Double(0x03C9, 0x03B9),
            '\u{1FF4}' => Mapping::Double(0x03CE, 0x03B9),
            '\u{1FF6}' => Mapping::Double(0x03C9, 0x0342),
            '\u{1FF7}' => Mapping::Triple(0x03C9, 0x0342, 0x03B9),
            '\u{1FF8}'..='\u{1FF9}' => Mapping::Single(codepoint.wrapping_sub(0x0080)),
            '\u{1FFA}'..='\u{1FFB}' => Mapping::Single(codepoint.wrapping_sub(0x007e)),
            '\u{1FFC}' => Mapping::Double(0x03C9, 0x03B9),
            _ => Mapping::Single(codepoint),
        },
        (0x0000, 0x21) => match c {
            '\u{2126}' => Mapping::Single(0x03C9),
            '\u{212A}' => Mapping::Single(0x006B),
            '\u{212B}' => Mapping::Single(0x00E5),
            '\u{2132}' => Mapping::Single(0x214E),
            '\u{2160}'..='\u{216F}' => Mapping::Single(codepoint.wrapping_add(0x0010)),
            '\u{2183}' => Mapping::Single(0x2184),
            _ => Mapping::Single(codepoint),
        },
        (0x0000, 0x24) => match c {
            '\u{24B6}'..='\u{24CF}' => Mapping::Single(codepoint.wrapping_add(0x001a)),
            _ => Mapping::Single(codepoint),
        },
        (0x0000, 0x2C) => match c {
            '\u{2C00}'..='\u{2C2F}' => Mapping::Single(codepoint.wrapping_add(0x0030)),
            '\u{2C60}' => Mapping::Single(0x2C61),
            '\u{2C62}' => Mapping::Single(0x026B),
            '\u{2C63}' => Mapping::Single(0x1D7D),
            '\u{2C64}' => Mapping::Single(0x027D),
            '\u{2C67}' => Mapping::Single(0x2C68),
            '\u{2C69}' => Mapping::Single(0x2C6A),
            '\u{2C6B}' => Mapping::Single(0x2C6C),
            '\u{2C6D}' => Mapping::Single(0x0251),
            '\u{2C6E}' => Mapping::Single(0x0271),
            '\u{2C6F}' => Mapping::Single(0x0250),
            '\u{2C70}' => Mapping::Single(0x0252),
            '\u{2C72}' => Mapping::Single(0x2C73),
            '\u{2C75}' => Mapping::Single(0x2C76),
            '\u{2C7E}'..='\u{2C7F}' => Mapping::Single(codepoint.wrapping_sub(0x2a3f)),
            '\u{2C80}' => Mapping::Single(0x2C81),
            '\u{2C82}' => Mapping::Single(0x2C83),
            '\u{2C84}' => Mapping::Single(0x2C85),
            '\u{2C86}' => Mapping::Single(0x2C87),
            '\u{2C88}' => Mapping::Single(0x2C89),
            '\u{2C8A}' => Mapping::Single(0x2C8B),
            '\u{2C8C}' => Mapping::Single(0x2C8D),
            '\u{2C8E}' => Mapping::Single(0x2C8F),
            '\u{2C90}' => Mapping::Single(0x2C91),
            '\u{2C92}' => Mapping::Single(0x2C93),
            '\u{2C94}' => Mapping::Single(0x2C95),
            '\u{2C96}' => Mapping::Single(0x2C97),
            '\u{2C98}' => Mapping::Single(0x2C99),
            '\u{2C9A}' => Mapping::Single(0x2C9B),
            '\u{2C9C}' => Mapping::Single(0x2C9D),
            '\u{2C9E}' => Mapping::Single(0x2C9F),
            '\u{2CA0}' => Mapping::Single(0x2CA1),
            '\u{2CA2}' => Mapping::Single(0x2CA3),
            '\u{2CA4}' => Mapping::Single(0x2CA5),
            '\u{2CA6}' => Mapping::Single(0x2CA7),
            '\u{2CA8}' => Mapping::Single(0x2CA9),
            '\u{2CAA}' => Mapping::Single(0x2CAB),
            '\u{2CAC}' => Mapping::Single(0x2CAD),
            '\u{2CAE}' => Mapping::Single(0x2CAF),
            '\u{2CB0}' => Mapping::Single(0x2CB1),
            '\u{2CB2}' => Mapping::Single(0x2CB3),
            '\u{2CB4}' => Mapping::Single(0x2CB5),
            '\u{2CB6}' => Mapping::Single(0x2CB7),
            '\u{2CB8}' => Mapping::Single(0x2CB9),
            '\u{2CBA}' => Mapping::Single(0x2CBB),
            '\u{2CBC}' => Mapping::Single(0x2CBD),
            '\u{2CBE}' => Mapping::Single(0x2CBF),
            '\u{2CC0}' => Mapping::Single(0x2CC1),
            '\u{2CC2}' => Mapping::Single(0x2CC3),
            '\u{2CC4}' => Mapping::Single(0x2CC5),
            '\u{2CC6}' => Mapping::Single(0x2CC7),
            '\u{2CC8}' => Mapping::Single(0x2CC9),
            '\u{2CCA}' => Mapping::Single(0x2CCB),
            '\u{2CCC}' => Mapping::Single(0x2CCD),
            '\u{2CCE}' => Mapping::Single(0x2CCF),
            '\u{2CD0}' => Mapping::Single(0x2CD1),
            '\u{2CD2}' => Mapping::Single(0x2CD3),
            '\u{2CD4}' => Mapping::Single(0x2CD5),
            '\u{2CD6}' => Mapping::Single(0x2CD7),
            '\u{2CD8}' => Mapping::Single(0x2CD9),
            '\u{2CDA}' => Mapping::Single(0x2CDB),
            '\u{2CDC}' => Mapping::Single(0x2CDD),
            '\u{2CDE}' => Mapping::Single(0x2CDF),
            '\u{2CE0}' => Mapping::Single(0x2CE1),
            '\u{2CE2}' => Mapping::Single(0x2CE3),
            '\u{2CEB}' => Mapping::Single(0x2CEC),
            '\u{2CED}' => Mapping::Single(0x2CEE),
            '\u{2CF2}' => Mapping::Single(0x2CF3),
            _ => Mapping::Single(codepoint),
        },
        (0x0000, 0xA6) => match c {
            '\u{A640}' => Mapping::Single(0xA641),
            '\u{A642}' => Mapping::Single(0xA643),
            '\u{A644}' => Mapping::Single(0xA645),
            '\u{A646}' => Mapping::Single(0xA647),
            '\u{A648}' => Mapping::Single(0xA649),
            '\u{A64A}' => Mapping::Single(0xA64B),
            '\u{A64C}' => Mapping::Single(0xA64D),
            '\u{A64E}' => Mapping::Single(0xA64F),
            '\u{A650}' => Mapping::Single(0xA651),
            '\u{A652}' => Mapping::Single(0xA653),
            '\u{A654}' => Mapping::Single(0xA655),
            '\u{A656}' => Mapping::Single(0xA657),
            '\u{A658}' => Mapping::Single(0xA659),
            '\u{A65A}' => Mapping::Single(0xA65B),
            '\u{A65C}' => Mapping::Single(0xA65D),
            '\u{A65E}' => Mapping::Single(0xA65F),
            '\u{A660}' => Mapping::Single(0xA661),
            '\u{A662}' => Mapping::Single(0xA663),
            '\u{A664}' => Mapping::Single(0xA665),
            '\u{A666}' => Mapping::Single(0xA667),
            '\u{A668}' => Mapping::Single(0xA669),
            '\u{A66A}' => Mapping::Single(0xA66B),
            '\u{A66C}' => Mapping::Single(0xA66D),
            '\u{A680}' => Mapping::Single(0xA681),
            '\u{A682}' => Mapping::Single(0xA683),
            '\u{A684}' => Mapping::Single(0xA685),
            '\u{A686}' => Mapping::Single(0xA687),
            '\u{A688}' => Mapping::Single(0xA689),
            '\u{A68A}' => Mapping::Single(0xA68B),
            '\u{A68C}' => Mapping::Single(0xA68D),
            '\u{A68E}' => Mapping::Single(0xA68F),
            '\u{A690}' => Mapping::Single(0xA691),
            '\u{A692}' => Mapping::Single(0xA693),
            '\u{A694}' => Mapping::Single(0xA695),
            '\u{A696}' => Mapping::Single(0xA697),
            '\u{A698}' => Mapping::Single(0xA699),
            '\u{A69A}' => Mapping::Single(0xA69B),
            _ => Mapping::Single(codepoint),
        },
        (0x0000, 0xA7) => match c {
            '\u{A722}' => Mapping::Single(0xA723),
            '\u{A724}' => Mapping::Single(0xA725),
            '\u{A726}' => Mapping::Single(0xA727),
            '\u{A728}' => Mapping::Single(0xA729),
            '\u{A72A}' => Mapping::Single(0xA72B),
            '\u{A72C}' => Mapping::Single(0xA72D),
            '\u{A72E}' => Mapping::Single(0xA72F),
            '\u{A732}' => Mapping::Single(0xA733),
            '\u{A734}' => Mapping::Single(0xA735),
            '\u{A736}' => Mapping::Single(0xA737),
            '\u{A738}' => Mapping::Single(0xA739),
            '\u{A73A}' => Mapping::Single(0xA73B),
            '\u{A73C}' => Mapping::Single(0xA73D),
            '\u{A73E}' => Mapping::Single(0xA73F),
            '\u{A740}' => Mapping::Single(0xA741),
            '\u{A742}' => Mapping::Single(0xA743),
            '\u{A744}' => Mapping::Single(0xA745),
            '\u{A746}' => Mapping::Single(0xA747),
            '\u{A748}' => Mapping::Single(0xA749),
            '\u{A74A}' => Mapping::Single(0xA74B),
            '\u{A74C}' => Mapping::Single(0xA74D),
            '\u{A74E}' => Mapping::Single(0xA74F),
            '\u{A750}' => Mapping::Single(0xA751),
            '\u{A752}' => Mapping::Single(0xA753),
            '\u{A754}' => Mapping::Single(0xA755),
            '\u{A756}' => Mapping::Single(0xA757),
            '\u{A758}' => Mapping::Single(0xA759),
            '\u{A75A}' => Mapping::Single(0xA75B),
            '\u{A75C}' => Mapping::Single(0xA75D),
            '\u{A75E}' => Mapping::Single(0xA75F),
            '\u{A760}' => Mapping::Single(0xA761),
            '\u{A762}' => Mapping::Single(0xA763),
            '\u{A764}' => Mapping::Single(0xA765),
            '\u{A766}' => Mapping::Single(0xA767),
            '\u{A768}' => Mapping::Single(0xA769),
            '\u{A76A}' => Mapping::Single(0xA76B),
            '\u{A76C}' => Mapping::Single(0xA76D),
            '\u{A76E}' => Mapping::Single(0xA76F),
            '\u{A779}' => Mapping::Single(0xA77A),
            '\u{A77B}' => Mapping::Single(0xA77C),
            '\u{A77D}' => Mapping::Single(0x1D79),
            '\u{A77E}' => Mapping::Single(0xA77F),
            '\u{A780}' => Mapping::Single(0xA781),
            '\u{A782}' => Mapping::Single(0xA783),
            '\u{A784}' => Mapping::Single(0xA785),
            '\u{A786}' => Mapping::Single(0xA787),
            '\u{A78B}' => Mapping::Single(0xA78C),
            '\u{A78D}' => Mapping::Single(0x0265),
            '\u{A790}' => Mapping::Single(0xA791),
            '\u{A792}' => Mapping::Single(0xA793),
            '\u{A796}' => Mapping::Single(0xA797),
            '\u{A798}' => Mapping::Single(0xA799),
            '\u{A79A}' => Mapping::Single(0xA79B),
            '\u{A79C}' => Mapping::Single(0xA79D),
            '\u{A79E}' => Mapping::Single(0xA79F),
            '\u{A7A0}' => Mapping::Single(0xA7A1),
            '\u{A7A2}' => Mapping::Single(0xA7A3),
            '\u{A7A4}' => Mapping::Single(0xA7A5),
            '\u{A7A6}' => Mapping::Single(0xA7A7),
            '\u{A7A8}' => Mapping::Single(0xA7A9),
            '\u{A7AA}' => Mapping::Single(0x0266),
            '\u{A7AB}' => Mapping::Single(0x025C),
            '\u{A7AC}' => Mapping::Single(0x0261),
            '\u{A7AD}' => Mapping::Single(0x026C),
            '\u{A7AE}' => Mapping::Single(0x026A),
            '\u{A7B0}' => Mapping::Single(0x029E),
            '\u{A7B1}' => Mapping::Single(0x0287),
            '\u{A7B2}' => Mapping::Single(0x029D),
            '\u{A7B3}' => Mapping::Single(0xAB53),
            '\u{A7B4}' => Mapping::Single(0xA7B5),
            '\u{A7B6}' => Mapping::Single(0xA7B7),
            '\u{A7B8}' => Mapping::Single(0xA7B9),
            '\u{A7BA}' => Mapping::Single(0xA7BB),
            '\u{A7BC}' => Mapping::Single(0xA7BD),
            '\u{A7BE}' => Mapping::Single(0xA7BF),
            '\u{A7C0}' => Mapping::Single(0xA7C1),
            '\u{A7C2}' => Mapping::Single(0xA7C3),
            '\u{A7C4}' => Mapping::Single(0xA794),
            '\u{A7C5}' => Mapping::Single(0x0282),
            '\u{A7C6}' => Mapping::Single(0x1D8E),
            '\u{A7C7}' => Mapping::Single(0xA7C8),
            '\u{A7C9}' => Mapping::Single(0xA7CA),
            '\u{A7D0}' => Mapping::Single(0xA7D1),
            '\u{A7D6}' => Mapping::Single(0xA7D7),
            '\u{A7D8}' => Mapping::Single(0xA7D9),
            '\u{A7F5}' => Mapping::Single(0xA7F6),
            _ => Mapping::Single(codepoint),
        },
        (0x0000, 0xAB) => match c {
            '\u{AB70}'..='\u{ABBF}' => Mapping::Single(codepoint.wrapping_sub(0x97d0)),
            _ => Mapping::Single(codepoint),
        },
        (0x0000, 0xFB) => match c {
            '\u{FB00}' => Mapping::Double(0x0066, 0x0066),
            '\u{FB01}' => Mapping::Double(0x0066, 0x0069),
            '\u{FB02}' => Mapping::Double(0x0066, 0x006C),
            '\u{FB03}' => Mapping::Triple(0x0066, 0x0066, 0x0069),
            '\u{FB04}' => Mapping::Triple(0x0066, 0x0066, 0x006C),
            '\u{FB05}' => Mapping::Double(0x0073, 0x0074),
            '\u{FB06}' => Mapping::Double(0x0073, 0x0074),
            '\u{FB13}' => Mapping::Double(0x0574, 0x0576),
            '\u{FB14}' => Mapping::Double(0x0574, 0x0565),
            '\u{FB15}' => Mapping::Double(0x0574, 0x056B),
            '\u{FB16}' => Mapping::Double(0x057E, 0x0576),
            '\u{FB17}' => Mapping::Double(0x0574, 0x056D),
            _ => Mapping::Single(codepoint),
        },
        (0x0000, 0xFF) => match c {
            '\u{FF21}'..='\u{FF3A}' => Mapping::Single(codepoint.wrapping_add(0x0020)),
            _ => Mapping::Single(codepoint),
        },
        (0x0001, 0x04) => match c {
            '\u{10400}'..='\u{10427}' => Mapping::Single(codepoint.wrapping_add(0x0028)),
            '\u{104B0}'..='\u{104D3}' => Mapping::Single(codepoint.wrapping_add(0x0028)),
            _ => Mapping::Single(codepoint),
        },
        (0x0001, 0x05) => match c {
            '\u{10570}'..='\u{1057A}' => Mapping::Single(codepoint.wrapping_add(0x0027)),
            '\u{1057C}'..='\u{1058A}' => Mapping::Single(codepoint.wrapping_add(0x0027)),
            '\u{1058C}'..='\u{10592}' => Mapping::Single(codepoint.wrapping_add(0x0027)),
            '\u{10594}'..='\u{10595}' => Mapping::Single(codepoint.wrapping_add(0x0027)),
            _ => Mapping::Single(codepoint),
        },
        (0x0001, 0x0C) => match c {
            '\u{10C80}'..='\u{10CB2}' => Mapping::Single(codepoint.wrapping_add(0x0040)),
            _ => Mapping::Single(codepoint),
        },
        (0x0001, 0x18) => match c {
            '\u{118A0}'..='\u{118BF}' => Mapping::Single(codepoint.wrapping_add(0x0020)),
            _ => Mapping::Single(codepoint),
        },
        (0x0001, 0x6E) => match c {
            '\u{16E40}'..='\u{16E5F}' => Mapping::Single(codepoint.wrapping_add(0x0020)),
            _ => Mapping::Single(codepoint),
        },
        (0x0001, 0xE9) => match c {
            '\u{1E900}'..='\u{1E921}' => Mapping::Single(codepoint.wrapping_add(0x0022)),
            _ => Mapping::Single(codepoint),
        },
        _ => Mapping::Single(codepoint),
    }
}
