# TO DO - 0.2.5 - add new functions and types
- [ ] new functions
  - [ ] perlin_noise_*n*d( x, y, optional z ) 2-3 dimensions
  - [ ] simplex_noise_*n*d( x, y, optional z ) 2-3 dimensions
- [ ] angle axis
- [ ] Re-write example for README

# TO DO - 0.2.4 - minor fixes
- [x] Matrix4x4
  - [x] mul vector3 and vector4 use &Self instead of &self
  - [x] add default trs constructor
- [x] remove Angle enum
- [x] change types accessing - now modules are private with types exposed public
- [x] test function in 'tests' for every type
- [x] rewrite examples
- [x] rewrite vector display so that it just shows the relevant data
- [x] RGBA float formatting

# TO DO - 0.2.3 - add quaternions and rewrite RGB
- [x] new functions
  - [x] lerp( a, b, t ) f32
    - ( 1 - t ) * a + b * t
  - [x] inverse lerp( a, b, v ) f32
    - ( v - a ) / ( b - a )
  - [x] remap( min1, max1, min2, max2, v ) f32
    - lerp( min2, max2, inverse_lerp( min1, max1, v ) )
- [x] quaternion
- [x] Rewrite colors to use u32 to represent all RGB/RGBA values, offer float representation from/as fn's
  - [x] little endian so AA BB GG RR will be the order of channels in this u32
  - [x] bitwise operations to set/get each channel
  - [x] as tuple for color types
  - [x] write documentation for RGB
  - [x] update HSV to work with new RGB struct
  - [x] new_red
  - [x] new_green
  - [x] new_blue
  - [x] new_yellow
  - [x] new_cyan
  - [x] new_magenta
  - [x] new_white
  - [x] new_gray
  - [x] new_black
  - [x] new_clear
- [x] Remove functions already in rust ( oops )
  - [x] overflow add/sub/mul
  - [x] clamp
- [x] Re-write example for README

# TO DO - 0.2.2 - public interface heavily affected
- [x] include links to TODO.md and CHANGELOG.md in README.md
- [x] re-write example to reflect changes
- [x] Re-organize modules
  - [x] types ( ::* should imports all structs )
    - [x] vector
      - [x] Vector2
      - [x] Vector3
      - [x] Vector4
    - [x] matrix
      - [x] Matrix4x4
    - [x] color ( remove "Color" prefix from each type )
      - [x] RGB
      - [x] RGBA
      - [x] RGB8
      - [x] RGBA8
      - [x] HSV
    - [x] angle
      - [x] angle enum
  - [x] functions
    - [x] hexadecimal
      - [x] encode
      - [x] decode
    - [x] clamp
    - [x] min
    - [x] max
    - [x] angles
      - [x] radians to degrees
      - [x] degrees to radians
      - [x] degrees_overflow
- [x] make conversion between related types more consistent
  - [x] larger vectors should have an "implicit" function ( impl *from* ) to convert from smaller vector
    - [x] Vector2 -> Vector3
    - [x] Vector2 -> Vector4
    - [x] Vector3 -> Vector4
  - [x] smaller vectors should have an *explicit* function ( **not** impl *from* ) to convert from larger vector
    - [x] Vector4 -> Vector3
    - [x] Vector4 -> Vector2
    - [x] Vector3 -> Vector2
  - [x] RGB8    <-> RGB  should have an "implicit" function ( impl *from* )
  - [x] RGBA8   <-> RGBA should have an "implicit" function ( impl *from* )
  - [x] RGB     <-> HSV  should have an "implicit" function ( impl *from* )
  - [x] HSV      -> RGBA should have an "implicit" function ( impl *from* )
  - [x] RGBA     -> RGB  should have an *explicit* function ( **not** impl *from* )
  - [x] RGBA8    -> RGBA should have an *explicit* function ( **not** impl *from* )
  - [x] RGBA     -> HSV  should have an *explicit* function ( **not** impl *from* )
  - [x] Vector4  -> RGBA should have an *explicit* function ( **not** impl *from* )
- [x] Consts should be static "constructors" for each type
  - [x] Matrix4x4
    - [x] new_identity
    - [x] new_zero
  - [x] Vector2
    - [x] new_one
    - [x] new_zero
    - [x] new_left
    - [x] new_right
    - [x] new_up
    - [x] new_down
  - [x] Vector3
    - [x] new_one
    - [x] new_zero
    - [x] new_left
    - [x] new_right
    - [x] new_up
    - [x] new_down
    - [x] new_forward
    - [x] new_back
  - [x] Vector4
    - [x] new_one
    - [x] new_zero
  - [x] Colors ( for RGBA/RGBA8, alpha = 1.0/255 )
    - [x] new_red
    - [x] new_green
    - [x] new_blue
    - [x] new_yellow
    - [x] new_cyan
    - [x] new_magenta
    - [x] new_white
    - [x] new_gray
    - [x] new_black
  - [x] Colors with alpha
    - [x] new_clear