# TO DO - 0.2.2 - public interface heavily affected
- [x] include links to TODO.md and CHANGELOG.md in README.md
- [x] re-write example to reflect changes
- [x] Re-organize modules
  - [x] types ( ::* should imports all structs )
    - [x] vector
      - [x] Vector2
      - [x] Vector3
      - [x] Vector4
    - [x] matrix
      - [x] Matrix4x4
    - [x] color ( remove "Color" prefix from each type )
      - [x] RGB
      - [x] RGBA
      - [x] RGB8
      - [x] RGBA8
      - [x] HSV
    - [x] angle
      - [x] angle enum
  - [x] functions
    - [x] hexadecimal
      - [x] encode
      - [x] decode
    - [x] clamp
    - [x] min
    - [x] max
    - [x] angles
      - [x] radians to degrees
      - [x] degrees to radians
      - [x] degrees_overflow
- [x] make conversion between related types more consistent
  - [x] larger vectors should have an "implicit" function ( impl *from* ) to convert from smaller vector
    - [x] Vector2 -> Vector3
    - [x] Vector2 -> Vector4
    - [x] Vector3 -> Vector4
  - [x] smaller vectors should have an *explicit* function ( **not** impl *from* ) to convert from larger vector
    - [x] Vector4 -> Vector3
    - [x] Vector4 -> Vector2
    - [x] Vector3 -> Vector2
  - [x] RGB8    <-> RGB  should have an "implicit" function ( impl *from* )
  - [x] RGBA8   <-> RGBA should have an "implicit" function ( impl *from* )
  - [x] RGB     <-> HSV  should have an "implicit" function ( impl *from* )
  - [x] HSV      -> RGBA should have an "implicit" function ( impl *from* )
  - [x] RGBA     -> RGB  should have an *explicit* function ( **not** impl *from* )
  - [x] RGBA8    -> RGBA should have an *explicit* function ( **not** impl *from* )
  - [x] RGBA     -> HSV  should have an *explicit* function ( **not** impl *from* )
  - [x] Vector4  -> RGBA should have an *explicit* function ( **not** impl *from* )
- [x] Consts should be static "constructors" for each type
  - [x] Matrix4x4
    - [x] new_identity
    - [x] new_zero
  - [x] Vector2
    - [x] new_one
    - [x] new_zero
    - [x] new_left
    - [x] new_right
    - [x] new_up
    - [x] new_down
  - [x] Vector3
    - [x] new_one
    - [x] new_zero
    - [x] new_left
    - [x] new_right
    - [x] new_up
    - [x] new_down
    - [x] new_forward
    - [x] new_back
  - [x] Vector4
    - [x] new_one
    - [x] new_zero
  - [x] Colors ( for RGBA/RGBA8, alpha = 1.0/255 )
    - [x] new_red
    - [x] new_green
    - [x] new_blue
    - [x] new_yellow
    - [x] new_cyan
    - [x] new_magenta
    - [x] new_white
    - [x] new_gray
    - [x] new_black
  - [x] Colors with alpha
    - [x] new_clear