//! # Art
//!
//! A library for modeling artistic concepts.
use std::{env, fs};
use std::error::Error;

pub use self::kinds::Keys::KEY1;
pub use self::kinds::Keys::KEY2;
pub use self::kinds::Keys::KEY3;

pub mod  kinds{
    pub  enum Keys{
        KEY1,
        KEY2,
        KEY3,
    }
}

pub fn run(config: Config) ->Result<(),Box<dyn Error>> {
    println!("query:{}", config.query);
    println!("filename:{}", config.filename);
    let contents = fs::read_to_string(config.filename)?;
    println!("file content:\n{}", contents);

    println!("{}","------------------------------------");

    let  results=if config.case_sensitive {
        search(&config.query,&contents)
    } else{
        search_case_insensitive(&config.query,&contents)
    };

    for line in  &results {
        println!("{}", line);
    }
    //println!("{:?}",results.iter().next());
    Ok(())
}

pub struct Config{
    query:String,
    filename:String,
    case_sensitive:bool,
}

impl Config {
    pub fn new(mut args:env::Args)->Result<Config, &'static str>{
        if args.len()<3 {
            return  Err("param not cont");
        }
        args.next();
        let query = match args.next() {
            Some(arg) => arg,
            None => return  Err("query param error")
        };
        let filename = match args.next() {
            Some(arg) =>  arg ,
            None => return  Err("filename param error")
        };

        let  case_sensitive=env::var("CASE_INSENSITIVE").is_err();

        println!("----------------->{}",case_sensitive);

        Ok(Config {query, filename,case_sensitive})
    }
   pub fn test_lifetime<'b>(param:String)->&'b str{
       println!("{}", param);
        "test_lifetime"
    }
}

pub  fn  search<'a>(query:&'a str,contents:&'a str)->Vec<&'a str>{

    Config::test_lifetime("123".to_string());
    contents.lines().filter(|line|line.contains(query)).collect()
    // for line in contents.lines() {
    //     if line.contains(query) {
    //         list.push(line);
    //     }
    // }
}
pub  fn  search_case_insensitive<'a> (query:&'a str,contents:&'a str)->Vec<&'a str>{
    //let  mut results=vec![];
    let  query=query.to_uppercase();

   let  results= contents.lines()
        .filter(|line| line.to_uppercase().contains(&query))
        .collect();
    // for line in contents.lines() {
    //     if line.to_uppercase().contains(&query) {
    //         results.push(line);
    //     }
    // }
    results
}

#[cfg(test)]
mod  tests{
    use super::*;
    #[test]
    fn  case_sensitive(){
        let  query="duct";
        let  contents="\
Rust:
safe, fast, productive.
Pick three.
Duct tape.";

        assert_eq!(vec!["safe, fast, productive."],search(query,contents));

    }

    #[test]
    fn  case_insensitive(){
        let  query="rUsT";
        let  contens="\
Rust:
safe, fast, productive.
Pick three.
Trust me.";
        assert_eq!(vec!["Rust:", "Trust me."],search_case_insensitive(query, contens));
    }


}
