pub mod core;
mod io;

pub use crate::core::FLV;

#[cfg(test)]
mod tests {
    use crate::core::FLV;
    #[test]
    fn test_header() {
        let flv_result = FLV::open(r"d:\test.flv");
        assert!(flv_result.is_ok(), "{}", flv_result.unwrap_err());
        let flv = flv_result.unwrap();
        assert_eq!(flv.header.signature, "FLV".to_string());
        assert!(flv.header.has_video());
        assert!(flv.header.has_audio());
        assert_eq!(flv.header.version, 1);
        assert_eq!(flv.header.size, 9);
    }

    #[test]
    fn test_write2file() {
        let flv_result = FLV::open(r"d:\test2.flv");
        assert!(flv_result.is_ok(), "{}", flv_result.unwrap_err());
        let mut flv = flv_result.unwrap();

        flv.write_file("d:/test_flv.flv").unwrap();
    }
}
