use fluent_templates::ArcLoader;
use handlebars::Handlebars;
use unic_langid::langid;
use crate::FluentHandlebars;

#[test]
fn it_should_fill_from_data() {
    let data = serde_json::json!({
        "lang": "en-US",
        "variable": "baz"
    });

    let loader = ArcLoader::builder(
        "resources/locales",
        langid!("en-US"),
    )
        .customize(|b| b.set_use_isolating(false))
        .build()
        .unwrap();

    let mut handlebars = Handlebars::new();
    handlebars.register_helper("t", Box::from(FluentHandlebars::new(&loader)));
    assert_eq!(
        format!("{}", handlebars.render_template(r#"{{t "placeholder"}}"#, &data).unwrap()),
        "this has a placeholder baz"
    );
}