use super::{GenBuffer, MetaType, OptStr};

#[allow(deprecated, dead_code)]
#[deprecated(
    since = "0.1.10",
    note = "Please use the do_gen_src<F>() function instead"
)]
pub fn gen_src_match(vec_optstr: &[OptStr]) -> anyhow::Result<String> {
    Ok(gen_src_match0(vec_optstr))
}
pub(crate) fn gen_src_match0(vec_optstr: &[OptStr]) -> String {
    let mut sss = GenBuffer::with_capacity(4 * 1024);
    //
    sss.push_str_ary(&[
        r#"// WARN: This file is auto generated by "#,
        env!("CARGO_PKG_NAME"),
        "\n",
    ]);
    //
    sss += concat!("match CmdOp::from(nv.opt.num) {", "\n");
    for rec in vec_optstr.iter() {
        let a: &[&str] = &["    CmdOp::", &rec.enum_s, " => {\n"];
        sss += a;
        let s: String = match &rec.meta_type {
            MetaType::Bool => "true".into(),
            MetaType::String => "value_to_string(nv)?".into(),
            MetaType::I8 => "value_to_i8(nv)?".into(),
            MetaType::I16 => "value_to_i16(nv)?".into(),
            MetaType::I32 => "value_to_i32(nv)?".into(),
            MetaType::I64 => "value_to_i64(nv)?".into(),
            MetaType::I128 => "value_to_i128(nv)?".into(),
            MetaType::U8 => "value_to_u8(nv)?".into(),
            MetaType::U16 => "value_to_u16(nv)?".into(),
            MetaType::U32 => "value_to_u32(nv)?".into(),
            MetaType::U64 => "value_to_u64(nv)?".into(),
            MetaType::U128 => "value_to_u128(nv)?".into(),
            MetaType::Isize => "value_to_isize(nv)?".into(),
            MetaType::Usize => "value_to_usize(nv)?".into(),
            MetaType::F32 => "value_to_f32(nv)?".into(),
            MetaType::F64 => "value_to_f64(nv)?".into(),
            MetaType::Other(string) => format!("value_to_{}(nv)?", string),
        };
        if !s.is_empty() {
            sss += "        conf.";
            if rec.is_vec {
                if rec.is_opt {
                    sss.push_str_ary(&[&rec.field_s, ".push(Some(", &s, "));\n"]);
                } else {
                    sss.push_str_ary(&[&rec.field_s, ".push(", &s, ");\n"]);
                }
            } else if rec.is_opt {
                sss.push_str_ary(&[&rec.field_s, " = Some(", &s, ");\n"]);
            } else {
                sss.push_str_ary(&[&rec.field_s, " = ", &s, ";\n"]);
            };
        }
        sss += "    }\n";
    }
    sss += "}\n";
    //
    sss.into_string()
}
