#[allow(deprecated)]
use super::{GenBuffer, MetaType, OptStr, SrcHelpFlags, SrcHelpFlags0};
use std::cmp::Ordering;

#[allow(clippy::unnecessary_wraps)]
#[allow(deprecated, dead_code)]
#[deprecated(
    since = "0.1.10",
    note = "Please use the do_gen_src<F>() function instead"
)]
pub fn gen_src_help(
    vec_optstr: &[OptStr],
    vec_line: &[String],
    out_flags: SrcHelpFlags,
) -> anyhow::Result<String> {
    Ok(gen_src_help0(vec_optstr, vec_line, out_flags.into()))
}

pub(crate) fn gen_src_help0(
    vec_optstr: &[OptStr],
    vec_line: &[String],
    out_flags: SrcHelpFlags0,
) -> String {
    let mut sss = GenBuffer::with_capacity(4 * 1024);
    //
    sss.push_str_ary(&[
        r#"// WARN: This file is auto generated by "#,
        env!("CARGO_PKG_NAME"),
        "\n",
    ]);
    //
    if !out_flags.options_text {
        sss += "/*\n";
    }
    sss += "const OPTIONS_TEXT: &str = r\"";
    for line in vec_line {
        sss.push_str_ary(&[line, "\n"]);
    }
    sss += "\";\n";
    if !out_flags.options_text {
        sss += "*/\n";
    }
    //
    if !out_flags.cmd_op {
        sss += "/*\n";
    }
    gen_src_cmd_opt(&mut sss, vec_optstr);
    if !out_flags.cmd_op {
        sss += "*/\n";
    }
    //
    let vec_optstr_sorted = {
        let mut target: Vec<&OptStr> = vec_optstr.iter().collect();
        target.sort_by(|&a, &b| match a.lon.cmp(&b.lon) {
            Ordering::Less => Ordering::Less,
            Ordering::Greater => Ordering::Greater,
            Ordering::Equal => match a.sho.cmp(&b.sho) {
                Ordering::Less => Ordering::Less,
                Ordering::Greater => Ordering::Greater,
                Ordering::Equal => a.num.cmp(&b.num),
            },
        });
        target
    };
    //
    if !out_flags.opt_ary {
        sss += "/*\n";
    }
    gen_src_opt_ary(&mut sss, &vec_optstr_sorted);
    if !out_flags.opt_ary {
        sss += "*/\n";
    }
    //
    if !out_flags.opt_ary_sho_idx {
        sss += "/*\n";
    }
    gen_src_opt_ary_sho_idx(&mut sss, &vec_optstr_sorted);
    if !out_flags.opt_ary_sho_idx {
        sss += "*/\n";
    }
    //
    if !out_flags.cmd_opt_conf {
        sss += "/*\n";
    }
    gen_src_struct_cmd_opt_conf(&mut sss, vec_optstr, &out_flags);
    if !out_flags.cmd_opt_conf {
        sss += "*/\n";
    }
    //
    if !out_flags.value_to {
        sss += "/*\n";
    }
    gen_src_value_to(&mut sss, vec_optstr);
    if !out_flags.value_to {
        sss += "*/\n";
    }
    //
    sss.into_string()
}

fn gen_src_cmd_opt(sss: &mut GenBuffer, vec_optstr: &[OptStr]) {
    *sss += r#"
#[repr(u8)]
#[derive(Debug, PartialEq)]
enum CmdOp {
"#;
    for rec in vec_optstr.iter() {
        sss.push_str_ary(&["    ", &rec.enum_s, ",\n"]);
    }
    *sss += "}\n";
    *sss += r#"
impl std::convert::From<u8> for CmdOp {
    fn from(value: u8) -> Self {
        unsafe { std::mem::transmute(value) }
    }
}
impl CmdOp {
    pub const fn to(self) -> OptNum {
        self as OptNum
    }
}
"#;
}

fn gen_src_opt_ary(sss: &mut GenBuffer, vec_optstr_sorted: &[&OptStr]) {
    let s = r#"
#[rustfmt::skip]
const OPT_ARY: [Opt;"#;
    *sss += &format!("{}{}] = [\n", s, vec_optstr_sorted.len());
    for rec in vec_optstr_sorted.iter() {
        *sss += "    Opt { ";
        if rec.sho.is_empty() {
            *sss += "sho: 0u8,  ";
        } else {
            *sss += &format!("sho: b'{}', ", rec.sho);
        }
        let s = "\"".to_string() + &rec.lon + "\",";
        *sss += &format!("lon: {:-17}", s);
        *sss += if rec.meta.is_empty() {
            "has: Arg::No,  "
        } else {
            "has: Arg::Yes, "
        };
        *sss += &format!("num: CmdOp::{}.to(), ", rec.enum_s);
        *sss += "},\n";
    }
    *sss += "];\n";
}

fn gen_src_opt_ary_sho_idx(sss: &mut GenBuffer, vec_optstr_sorted: &[&OptStr]) {
    let mut vec_optstr_sho_idx: Vec<(_, usize)> = vec_optstr_sorted
        .iter()
        .enumerate()
        .filter(|(_, &o)| !o.sho.is_empty())
        .map(|(i, &o)| (&o.sho, i))
        .collect();
    vec_optstr_sho_idx.sort_by(|a, b| a.0.cmp(&b.0));
    //
    let s = r#"
#[rustfmt::skip]
const OPT_ARY_SHO_IDX: [(u8,usize);"#;
    *sss += &format!("{}{}] = [\n", s, vec_optstr_sho_idx.len());
    for elm in vec_optstr_sho_idx.iter() {
        *sss += &format!("(b'{}',{}),", elm.0, elm.1);
    }
    *sss += "];\n";
}

fn gen_src_struct_cmd_opt_conf(
    sss: &mut GenBuffer,
    vec_optstr: &[OptStr],
    out_flags: &SrcHelpFlags0,
) {
    if !out_flags.subcmd_opt_conf {
        *sss += r#"
#[derive(Debug, Default, PartialEq)]
pub struct CmdOptConf {
    pub prog_name: String,
"#;
        if out_flags.cmd_opt_conf_has_subcmd {
            *sss += r#"    pub subcmd: String,
"#;
        }
    } else {
        *sss += r#"
#[derive(Debug, PartialEq)]
pub struct SubCmdOptConf<'a> {
    pub parent: &'a CmdOptConf,
    pub prog_name: String,
"#;
    }
    *sss += r#"    //
"#;
    let mut have_help: bool = false;
    let mut have_version: bool = false;
    for rec in vec_optstr.iter() {
        let v_type = if rec.is_vec {
            if rec.is_opt {
                format!("Vec<Option<{}>>", rec.meta_type.as_type_string())
            } else {
                format!("Vec<{}>", rec.meta_type.as_type_string())
            }
        } else if rec.is_opt {
            format!("Option<{}>", rec.meta_type.as_type_string())
        } else {
            rec.meta_type.as_type_string().to_string()
        };
        *sss += &format!("    pub {}: {},\n", rec.field_s, v_type);
        if rec.enum_s == "Help" {
            have_help = true;
        }
        if rec.enum_s == "Version" {
            have_version = true;
        }
    }
    *sss += r#"    //
    pub arg_params: Vec<String>,
}
"#;
    if out_flags.subcmd_opt_conf {
        *sss += r#"
impl<'a> SubCmdOptConf<'a> {
    pub fn new(a_parent: &'a CmdOptConf, a_prog_name: String) -> SubCmdOptConf<'a> {
        SubCmdOptConf {
            parent: a_parent,
            prog_name: a_prog_name,
            //
"#;
        for rec in vec_optstr.iter() {
            let v_init = "Default::default()".to_string();
            *sss += &format!("            {}: {},\n", rec.field_s, v_init);
        }
        *sss += r#"            //
            arg_params: Vec::new(),
        }
    }
}
"#;
    }
    if out_flags.cmd_opt_conf_has_subcmd {
        *sss += r#"
impl flood_tide::SubCommand for CmdOptConf {
    fn set_subcmd(&mut self, a_subcmd: String) {
        self.subcmd = a_subcmd;
    }
}
"#;
    }
    if !out_flags.subcmd_opt_conf {
        *sss += r#"
impl flood_tide::HelpVersion for CmdOptConf {
    fn is_help(&self) -> bool {"#;
    } else {
        *sss += r#"
impl<'a> flood_tide::HelpVersion for SubCmdOptConf<'a> {
    fn is_help(&self) -> bool {"#;
    }
    if have_help {
        *sss += r#"
        self.flg_help"#;
    } else {
        *sss += r#"
        false"#;
    }
    *sss += r#"
    }
    fn is_version(&self) -> bool {"#;
    if have_version {
        *sss += r#"
        self.flg_version"#;
    } else {
        *sss += r#"
        false"#;
    }
    *sss += r#"
    }
}
"#;
}

fn gen_src_value_to(sss: &mut GenBuffer, vec_optstr: &[OptStr]) {
    let mut vec_mt: Vec<&MetaType> = Vec::new();
    for rec in vec_optstr.iter() {
        let mt = &rec.meta_type;
        if let MetaType::Bool = mt {
            continue;
        }
        if !vec_mt.contains(&mt) {
            vec_mt.push(mt);
        }
    }
    //
    #[allow(unused_assignments)]
    let mut buf = String::new();
    vec_mt.sort();
    for mt in vec_mt.iter() {
        let s = match mt {
            MetaType::Bool => "",
            MetaType::String => {
                r#"
fn value_to_string(nv: &NameVal<'_>) -> Result<String, OptParseError> {
    match nv.val {
        Some(x) => Ok(x.to_string()),
        None => Err(OptParseError::missing_option_argument(&nv.opt.lon_or_sho())),
    }
}
"#
            }
            MetaType::I8 => {
                r#"
fn value_to_i8(nv: &NameVal<'_>) -> Result<i8, OptParseError> {
    match nv.val {
        Some(x) => match x.parse::<i8>() {
            Ok(d) => Ok(d),
            Err(err) => Err(OptParseError::invalid_option_argument(
                &nv.opt.lon_or_sho(),
                &err.to_string(),
            )),
        },
        None => Err(OptParseError::missing_option_argument(&nv.opt.lon_or_sho())),
    }
}
"#
            }
            MetaType::I16 => {
                r#"
fn value_to_i16(nv: &NameVal<'_>) -> Result<i16, OptParseError> {
    match nv.val {
        Some(x) => match x.parse::<i16>() {
            Ok(d) => Ok(d),
            Err(err) => Err(OptParseError::invalid_option_argument(
                &nv.opt.lon_or_sho(),
                &err.to_string(),
            )),
        },
        None => Err(OptParseError::missing_option_argument(&nv.opt.lon_or_sho())),
    }
}
"#
            }
            MetaType::I32 => {
                r#"
fn value_to_i32(nv: &NameVal<'_>) -> Result<i32, OptParseError> {
    match nv.val {
        Some(x) => match x.parse::<i32>() {
            Ok(d) => Ok(d),
            Err(err) => Err(OptParseError::invalid_option_argument(
                &nv.opt.lon_or_sho(),
                &err.to_string(),
            )),
        },
        None => Err(OptParseError::missing_option_argument(&nv.opt.lon_or_sho())),
    }
}
"#
            }
            MetaType::I64 => {
                r#"
fn value_to_i64(nv: &NameVal<'_>) -> Result<i64, OptParseError> {
    match nv.val {
        Some(x) => match x.parse::<i64>() {
            Ok(d) => Ok(d),
            Err(err) => Err(OptParseError::invalid_option_argument(
                &nv.opt.lon_or_sho(),
                &err.to_string(),
            )),
        },
        None => Err(OptParseError::missing_option_argument(&nv.opt.lon_or_sho())),
    }
}
"#
            }
            MetaType::I128 => {
                r#"
fn value_to_i128(nv: &NameVal<'_>) -> Result<i128, OptParseError> {
    match nv.val {
        Some(x) => match x.parse::<i128>() {
            Ok(d) => Ok(d),
            Err(err) => Err(OptParseError::invalid_option_argument(
                &nv.opt.lon_or_sho(),
                &err.to_string(),
            )),
        },
        None => Err(OptParseError::missing_option_argument(&nv.opt.lon_or_sho())),
    }
}
"#
            }
            MetaType::U8 => {
                r#"
fn value_to_u8(nv: &NameVal<'_>) -> Result<u8, OptParseError> {
    match nv.val {
        Some(x) => match x.parse::<u8>() {
            Ok(d) => Ok(d),
            Err(err) => Err(OptParseError::invalid_option_argument(
                &nv.opt.lon_or_sho(),
                &err.to_string(),
            )),
        },
        None => Err(OptParseError::missing_option_argument(&nv.opt.lon_or_sho())),
    }
}
"#
            }
            MetaType::U16 => {
                r#"
fn value_to_u16(nv: &NameVal<'_>) -> Result<u16, OptParseError> {
    match nv.val {
        Some(x) => match x.parse::<u16>() {
            Ok(d) => Ok(d),
            Err(err) => Err(OptParseError::invalid_option_argument(
                &nv.opt.lon_or_sho(),
                &err.to_string(),
            )),
        },
        None => Err(OptParseError::missing_option_argument(&nv.opt.lon_or_sho())),
    }
}
"#
            }
            MetaType::U32 => {
                r#"
fn value_to_u32(nv: &NameVal<'_>) -> Result<u32, OptParseError> {
    match nv.val {
        Some(x) => match x.parse::<u32>() {
            Ok(d) => Ok(d),
            Err(err) => Err(OptParseError::invalid_option_argument(
                &nv.opt.lon_or_sho(),
                &err.to_string(),
            )),
        },
        None => Err(OptParseError::missing_option_argument(&nv.opt.lon_or_sho())),
    }
}
"#
            }
            MetaType::U64 => {
                r#"
fn value_to_u64(nv: &NameVal<'_>) -> Result<u64, OptParseError> {
    match nv.val {
        Some(x) => match x.parse::<u64>() {
            Ok(d) => Ok(d),
            Err(err) => Err(OptParseError::invalid_option_argument(
                &nv.opt.lon_or_sho(),
                &err.to_string(),
            )),
        },
        None => Err(OptParseError::missing_option_argument(&nv.opt.lon_or_sho())),
    }
}
"#
            }
            MetaType::U128 => {
                r#"
fn value_to_u128(nv: &NameVal<'_>) -> Result<u128, OptParseError> {
    match nv.val {
        Some(x) => match x.parse::<u128>() {
            Ok(d) => Ok(d),
            Err(err) => Err(OptParseError::invalid_option_argument(
                &nv.opt.lon_or_sho(),
                &err.to_string(),
            )),
        },
        None => Err(OptParseError::missing_option_argument(&nv.opt.lon_or_sho())),
    }
}
"#
            }
            MetaType::Isize => {
                r#"
fn value_to_isize(nv: &NameVal<'_>) -> Result<isize, OptParseError> {
    match nv.val {
        Some(x) => match x.parse::<isize>() {
            Ok(d) => Ok(d),
            Err(err) => Err(OptParseError::invalid_option_argument(
                &nv.opt.lon_or_sho(),
                &err.to_string(),
            )),
        },
        None => Err(OptParseError::missing_option_argument(&nv.opt.lon_or_sho())),
    }
}
"#
            }
            MetaType::Usize => {
                r#"
fn value_to_usize(nv: &NameVal<'_>) -> Result<usize, OptParseError> {
    match nv.val {
        Some(x) => match x.parse::<usize>() {
            Ok(d) => Ok(d),
            Err(err) => Err(OptParseError::invalid_option_argument(
                &nv.opt.lon_or_sho(),
                &err.to_string(),
            )),
        },
        None => Err(OptParseError::missing_option_argument(&nv.opt.lon_or_sho())),
    }
}
"#
            }
            MetaType::F32 => {
                r#"
fn value_to_f32(nv: &NameVal<'_>) -> Result<f32, OptParseError> {
    match nv.val {
        Some(x) => match x.parse::<f32>() {
            Ok(d) => Ok(d),
            Err(err) => Err(OptParseError::invalid_option_argument(
                &nv.opt.lon_or_sho(),
                &err.to_string(),
            )),
        },
        None => Err(OptParseError::missing_option_argument(&nv.opt.lon_or_sho())),
    }
}
"#
            }
            MetaType::F64 => {
                r#"
fn value_to_f64(nv: &NameVal<'_>) -> Result<f64, OptParseError> {
    match nv.val {
        Some(x) => match x.parse::<f64>() {
            Ok(d) => Ok(d),
            Err(err) => Err(OptParseError::invalid_option_argument(
                &nv.opt.lon_or_sho(),
                &err.to_string(),
            )),
        },
        None => Err(OptParseError::missing_option_argument(&nv.opt.lon_or_sho())),
    }
}
"#
            }
            MetaType::Other(string) => {
                buf = format!(
                    r#"
fn value_to_{}(nv: &NameVal<'_>) -> Result<{}, OptParseError> {{
    match nv.val {{
        Some(s) => match FromStr::from_str(s) {{
            Ok(x) => Ok(x),
            Err(err) => Err(OptParseError::invalid_option_argument(
                &nv.opt.lon_or_sho(),
                &err.to_string(),
            )),
        }},
        None => Err(OptParseError::missing_option_argument(&nv.opt.lon_or_sho())),
    }}
}}
"#,
                    string,
                    mt.as_type_string(),
                );
                buf.as_str()
            }
        };
        sss.push_str(s);
    }
}
