#![no_std]
#![allow(dead_code)]
#![allow(unused_parens)]
#![allow(unused_imports)]
#![allow(non_snake_case)]
#![cfg_attr(feature = "portable_simd", feature(portable_simd))]
#![cfg_attr(feature = "core_intrinsics", feature(core_intrinsics))]

/// Does all our conditional compilation selection.
#[macro_export]
macro_rules! pick {
  // with a trailing else
  ($(if #[cfg($($test:meta),*)] {
      $($if_tokens:tt)*
    })else+ else {
      $($else_tokens:tt)*
    }) => {
    $crate::pick!{
      @__forests [ ] ;
      $( [ {$($test),*} {$($if_tokens)*} ], )*
      [ { } {$($else_tokens)*} ],
    }
  };

  // without a trailing else
  (if #[cfg($($if_meta:meta),*)] {
      $($if_tokens:tt)*
    } $(else if #[cfg($($else_meta:meta),*)] {
      $($else_tokens:tt)*
    })*) => {
    $crate::pick!{
      @__forests [ ] ;
      [ {$($if_meta),*} {$($if_tokens)*} ],
      $( [ {$($else_meta),*} {$($else_tokens)*} ], )*
    }
  };

  // private
  (@__forests [$($not:meta,)*];) => {
    /* halt expansion */
  };

  // private
  (@__forests [$($not:meta,)*]; [{$($m:meta),*} {$($tokens:tt)*}], $($rest:tt)*) => {
    // This "one weird trick" works because you can't apply a `cfg` to an
    // expression, only an item or a block, but a macro usage is an item, so
    // we're configuring the macro usage, which (if configured in) will then
    // contain a token tree that turns into either an item or an expression.
    #[cfg(all( $($m,)* not(any($($not),*)) ))]
    $crate::pick!{ @__identity $($tokens)* }

    $crate::pick!{ @__forests [ $($not,)* $($m,)* ] ; $($rest)* }
  };

  // private
  (@__identity $($tokens:tt)*) => {
    $($tokens)*
  };
}

macro_rules! simdif {
  ( $test:expr => { $($yes_tt:tt)* } else { $($no_tt:tt)* }) => {{
      $test.select({$($yes_tt)*},{$($no_tt)*})
  }}
}

pub mod ops;
pub use ops::*;

pub mod float_constants;
pub use float_constants::*;

#[cfg(feature = "portable_simd")]
#[inline(always)]
fn u32xN_to_i32xN<const N: usize>(f: core::simd::Simd<u32, N>) -> core::simd::Simd<i32, N>
where
  core::simd::LaneCount<N>: core::simd::SupportedLaneCount,
{
  unsafe { core::mem::transmute_copy(&f) }
}
#[cfg(feature = "portable_simd")]
#[inline(always)]
fn i32xN_to_u32xN<const N: usize>(f: core::simd::Simd<i32, N>) -> core::simd::Simd<u32, N>
where
  core::simd::LaneCount<N>: core::simd::SupportedLaneCount,
{
  unsafe { core::mem::transmute_copy(&f) }
}

#[cfg(feature = "portable_simd")]
#[inline(always)]
fn u64xN_to_i64xN<const N: usize>(f: core::simd::Simd<u64, N>) -> core::simd::Simd<i64, N>
where
  core::simd::LaneCount<N>: core::simd::SupportedLaneCount,
{
  unsafe { core::mem::transmute_copy(&f) }
}
#[cfg(feature = "portable_simd")]
#[inline(always)]
fn i64xN_to_u64xN<const N: usize>(f: core::simd::Simd<i64, N>) -> core::simd::Simd<u64, N>
where
  core::simd::LaneCount<N>: core::simd::SupportedLaneCount,
{
  unsafe { core::mem::transmute_copy(&f) }
}
