//! Abstraction over a device capable of measuring barometric altitudes.
use crate::flight_phase::BaroData;
use embedded_hal::blocking::delay::DelayMs;
use fugit::MillisDuration;
pub trait Altimeter {
    /// # Take a pressure/altitude measurement
    fn measure<D: DelayMs<u8>>(
        &mut self,
        delay: &mut D,
        ground_ref: BaroData,
        timestamp: MillisDuration<u64>,
    ) -> BaroData;
}
