# flexi_logger

**A flexible and easy-to-use logger that writes logs to stderr and/or to files, and/or to
other output streams, and that can be influenced while the program is running.**

[![Latest version](https://img.shields.io/crates/v/flexi_logger.svg)](https://crates.io/crates/flexi_logger)
[![Documentation](https://docs.rs/flexi_logger/badge.svg)](https://docs.rs/flexi_logger)
[![License](https://img.shields.io/crates/l/flexi_logger.svg)](https://github.com/emabee/flexi_logger)
[![Build](https://img.shields.io/github/workflow/status/emabee/flexi_logger/CI/master)](https://github.com/emabee/flexi_logger/actions?query=workflow%3ACI)

## Usage

Add flexi_logger to the dependencies section in your project's `Cargo.toml`, with

```toml
[dependencies]
flexi_logger = "0.22"
log = "0.4"
```

or, if you want to use some of the optional features, with something like

```toml
[dependencies]
flexi_logger = { version = "0.22", features = ["async", "specfile", "compress"] }
log = "0.4"
```

or, to get the smallest footprint (and no colors), with

```toml
[dependencies]
flexi_logger = { version = "0.22", default_features = false }
log = "0.4"
```

Note: `log` is needed because `flexi_logger` plugs into the standard Rust logging facade given
by the [log crate](https://crates.io/crates/log),
and you use the ```log``` macros to write log lines from your code.

The minimal rust version is currently "1.51.0".

## Versions

See the [change log](https://github.com/emabee/flexi_logger/blob/master/CHANGELOG.md)
for more details.

## Code examples

See the documentation of module
[code_examples](https://docs.rs/flexi_logger/latest/flexi_logger/code_examples/index.html).

## Options

There are configuration options to e.g.

* decide whether you want to write your logs to stderr or to a file,
* configure the path and the filenames of the log files,
* use file rotation,
* specify the line format for the log lines,
* apply a stateful filter before log lines are really written,
* define additional log streams, e.g for alert or security messages,
* support changing the log specification on the fly, while the program is running,

See the API documentation for a complete reference.

## Crate Features

Make use of any of these features by specifying them in your `Cargo.toml`
(see above in the usage section).

### **`async`**

Adds an additional write mode that decouples `flexi_logger`'s I/O from your application threads.
Works with `log_to_stdout()`, `log_to_stderr()`, and `log_to_file()`.
See [here](./docs/diagrams.pdf) for a performance comparison of some write modes.

Adds a dependency to [`crossbeam`](https://docs.rs/crossbeam/0.8.1/crossbeam/index.html).

### **`colors`** (*default feature*)

Getting colored output is also possible without this feature,
by implementing and using your own coloring format function.

The default feature `colors` simplifies this by doing three things:

* it activates the optional dependency to `ansi_term` and
* provides additional colored pendants to the existing uncolored format functions
* it uses `colored_default_format()` for the output to stderr,
  and the non-colored `default_format()` for the output to files
* it activates the optional dependency to `atty` to being able to switch off
  coloring if the output is not sent to a terminal but e.g. piped to another program.

**<span style="color:red">C</span><span style="color:blue">o</span><span style="color:green">l</span><span style="color:orange">o</span><span style="color:magenta">r</span><span style="color:darkturquoise">s</span>**,
or styles in general, are a matter of taste, and no choice will fit every need.
So you can override the default formatting and coloring in various ways.

With switching off the default features and choosing feature `atty` explicitly
(see [usage](#usage)) you can remove the ansi_term-based coloring
but keep the capability to switch off your own coloring.

### **`compress`**

Adds two variants to the `enum` `Logger::Cleanup`, which allow keeping some
or all rotated log files in compressed form (`.gz`) rather than as plain text files.

### **`dont_minimize_extra_stacks`**

Normally, `flexi_logger` reduces the stack size of all threads that it might spawn
(flusher, specfile-watcher, async writer, cleanup) to a bare minimum.
For usecases where this is not desirable
(see e.g. [issue-95](https://github.com/emabee/flexi_logger/issues/95)),
you can activate this feature.

### **`external_rotation`**

**This feature is not yet stable - the tests work well on windows, but not on linux and macos.**

If logs are written to files, `flexi_logger` expects that nobody modifies these, and it offers
its own capabilities to rotate, compress, and clean up log files.

Alternatively, tools like linux' `logrotate` can be used to rotate, compress or remove
log files. But renaming or deleting the current output file e.g. will not stop
`flexi_logger` from writing to the now renamed or even deleted file! You should configure `flexi_logger`
with `Logger::watch_external_rotations()` (which is only available with feature `external_rotation`)
to make it watch for OS events that affect its outputfile
and react with closing its current output stream and recreating its configured output file.

### **`specfile`**

Adds a method `Logger::start_with_specfile(specfile)`.

If started with this method, `flexi_logger` uses the log specification
that was given to the factory method (one of `Logger::with...()`) as initial spec
and then tries to read the log specification from the named file.

If the file does not exist, it is created and filled with the initial spec.

By editing the log specification in the file while the program is running,
you can change the logging behavior in real-time.

The implementation of this feature uses some additional crates that you might
not want to depend on with your program if you don't use this functionality.
For that reason the feature is not active by default.

### **`specfile_without_notification`**

Pretty much like `specfile`, except that updates to the file are being ignored.
See [issue-59](https://github.com/emabee/flexi_logger/issues/59) for more details.

### **`syslog`**

Adds `SyslogWriter`, a `LogWriter` implementation that sends log entries to the syslog.

Not all variations of it are well tested. Feedback of all kinds is appreciated.

### **`textfilter`** (*default feature*)

Adds the ability to filter logs by text, but also adds a dependency on the regex crate.

### **`trc`**

An experimental feature that allows using `flexi_logger` functionality with `tracing`.

### **`use_chrono_for_offset`**

The advisory [RUSTSEC-2020-0159](https://rustsec.org/advisories/RUSTSEC-2020-0159) hits both
the `chrono` and the `time` crate.
Since `time` is striving for a solution, while `chrono` appears to be unmaintained,
`flexi_logger` switched from `chrono` to `time`.
However, `time`'s "strategy" to solve the advisory is overly puristic:
it refuses to obtain the UTC offset on unix platforms, if the program is multi-threaded,
or running on a unix version other than `linux`.

`flexi_logger` tries to solve this dilemma by obtaining the UTC offset only once,
during initialization, when most programs are still single-threaded.
`time` should then be able to provide the correct offset on linux.

If this does not work, activate feature `use_chrono_for_offset`, which

* re-introduces the dependency to `chrono`
* uses `chrono` to determine the UTC offset
* makes your program again affected by
  [RUSTSEC-2020-0159](https://rustsec.org/advisories/RUSTSEC-2020-0159),
  which in many cases seems acceptable.

Note that this feature will be removed as soon as `time` allows obtaining the UTC offset
again on all platforms.
