mod lex;
use core::str;
use std::process;
use ansi_term::Colour::{Red, Green};
use no_comment::{IntoWithoutComments as _, languages};

pub fn lexer(txt: &str, commentstyle: &str){
    let finalstr=if commentstyle.to_ascii_lowercase() == "cstyle"{
    
       txt.chars().without_comments(languages::c()).collect::<String>()
    }else if commentstyle.to_ascii_lowercase() == "haskellstyle" {
        txt.chars().without_comments(languages::haskell()).collect::<String>()
    }
    else if commentstyle.to_ascii_lowercase() == "pystyle" { 
      txt.chars().without_comments(languages::python()).collect::<String>()
    } else{
        println!("{} error: {}, Found {}",Red.paint("Comment Remover(flex.rs)"),Green.paint("Expected \"cstyle, haskellstyle or pystyle\""), Red.paint(commentstyle));
        process::exit(1);
    };
    lex::lexer(finalstr.as_str());
}