use flex_page::Pages;
use std::{fs::File, io::Result};

#[test]
fn read_write() -> Result<()> {
    let file = File::options()
        .read(true)
        .write(true)
        .create(true)
        .open("test1.db")?;

    let pages: Pages<4> = Pages::open(file)?;

    pages.alloc(1)?;
    assert_eq!(pages.read(0)?, [0; 4]);
    pages.write(0, [1, 2, 3, 4])?;
    assert_eq!(pages.read(0)?, [1, 2, 3, 4]);

    std::fs::remove_file("test1.db")
}
