use flex_page::Pages;
use std::{fs::File, io::Result};

#[test]
fn alloc_page() -> Result<()> {
    let file = File::options()
        .read(true)
        .write(true)
        .create(true)
        .open("alloc_page")?;

    let pages: Pages<64> = Pages::open(file)?;

    assert_eq!(pages.create([0; 64])?, 0);
    assert_eq!(pages.len(), 1);
    assert_eq!(pages.alloc(2)?, 1);
    assert_eq!(pages.len(), 3);
    
    pages.set_len(0)?;
    assert_eq!(pages.len(), 0);

    std::fs::remove_file("alloc_page")
}
