[Docs](https://docs.rs/flex-page)

This library provides a interface to create database pages.

A page is a fixed size buffer that can be used to store data.

### Example

In your cargo.toml:
```toml
[dependencies]
flex-page = "2"
```

```rust
use std::fs::{File, remove_file};
use flex_page::Pages;

let file = File::options()
    .read(true)
    .write(true)
    .create(true)
    .open("_foo_").unwrap();

// First generic argument is the page number type. Number of page that can be stored in the file.
// Second generic argument is the size of the page.
let pages: Pages<64> = Pages::open(file).unwrap();

// Create a page.
pages.create([1; 64]).unwrap();
 
// Overwrite a page.
pages.write(0, [2; 64]).unwrap();
 
// Read a page.
assert_eq!(pages.read(0).unwrap(), [2; 64]);

assert_eq!(pages.len(), 1);

// Alloc 2 more pages
pages.alloc(2).unwrap();

assert_eq!(pages.len(), 3);

remove_file("_foo_");
```

See [/tests](https://github.com/nurmohammed840/flex-page.rs/tree/master/tests) folder for more examples.