use flex_page::Pages;
use std::{io::Result, fs::File};

#[tokio::test]
async fn create_read_write() -> Result<()> {
    let file = File::options()
        .read(true)
        .write(true)
        .create(true)
        .open("test1.db")?;

    let pages: Pages<u16, 64> = Pages::open(file)?;

    // Default page for metadata.
    assert_eq!(pages.len(), 1);
    assert_eq!(pages.create([1; 64]).await?, 1);
    assert_eq!(pages.len(), 2);

    let mut page = pages.goto(1).await?;
    assert_eq!(page.buf, [1; 64]);
    page.buf = [2; 64];
    page.write().await?;

    assert_eq!(pages.read(1).await?.as_ref(), &[2; 64]);

    pages.write(1, [3; 64]).await?;
    assert_eq!(pages.read(1).await?.as_ref(), &[3; 64]);

    std::fs::remove_file("test1.db")
}
