use flex_page::Pages;
use std::{fs::File, io::Result};

#[tokio::test]
async fn alloc_page() -> Result<()> {
    let file = File::options()
        .read(true)
        .write(true)
        .create(true)
        .open("alloc_page")?;

    let pages: Pages<u16, 64> = Pages::open(file)?;

    assert_eq!(pages.create([0; 64]).await?, 1);
    assert_eq!(pages.len(), 2);
    assert_eq!(pages.alloc(3).await?, 2);
    assert_eq!(pages.len(), 5);

    std::fs::remove_file("alloc_page")
}
