use crate::page_no::PageNo;
use crate::Pages;
use std::io::Result;
use std::ops::{Deref, DerefMut};

use page_lock::LockGuard;

pub struct Page<'a, N: PageNo, const SIZE: usize> {
    pub buf: [u8; SIZE],
    pub(crate) num: N,
    pub(crate) _lock: LockGuard<'a, N>,
    pub(crate) pages: &'a Pages<N, SIZE>,
}

impl<N: PageNo, const SIZE: usize> Page<'_, N, SIZE> {
    pub async fn write(self) -> Result<()> {
        self.pages.write(self.num, self.buf).await
    }
}

impl<'a, N: PageNo, const SIZE: usize> Deref for Page<'a, N, SIZE> {
    type Target = [u8; SIZE];

    fn deref(&self) -> &Self::Target {
        &self.buf
    }
}
impl<'a, N: PageNo, const SIZE: usize> DerefMut for Page<'a, N, SIZE> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.buf
    }
}
