[Docs](https://docs.rs/flex-page)

This library provides a interface to create database pages.

A page is a fixed size buffer that can be used to store data.

# Example

In your cargo.toml:
```
[dependencies]
flex-page = "0.4" 
```

```rust
use flex_page::Pages;

// First generic argument is the page number type. Number of page that can be stored in the file.
// Second generic argument is the size of the page.
let pages: Pages<u16, 4096> = Pages::open("test.db")?;

// Create a page.
pages.create([0; 4096]).await?;
 
// Overwrite a page.
pages.write(1, [1; 4096]).await?;
 
// Reading a page and write to it.
// It also lock the page num. So, this page can't be read by other thread.
let mut page = pages.goto(1).await?;
assert_eq!(page.buf, [1; 4096]);
page.buf = [2; 4096];

// Write to the page.
// It drops the lock. So, this page can be accessable by other thread.
page.write().await?;

// Read a page.
assert_eq!(pages.read(1).await?, [2; 4096]);
```
