// Generated by gir (https://github.com/gtk-rs/gir @ ee37253c10af)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git @ 5264fd0c3183)
// DO NOT EDIT

#![allow(non_camel_case_types, non_upper_case_globals, non_snake_case)]
#![allow(
    clippy::approx_constant,
    clippy::type_complexity,
    clippy::unreadable_literal,
    clippy::upper_case_acronyms
)]
#![cfg_attr(feature = "dox", feature(doc_cfg))]

#[allow(unused_imports)]
use libc::{
    c_char, c_double, c_float, c_int, c_long, c_short, c_uchar, c_uint, c_ulong, c_ushort, c_void,
    intptr_t, size_t, ssize_t, uintptr_t, FILE,
};

#[allow(unused_imports)]
use glib::{gboolean, gconstpointer, gpointer, GType};

// Enums
pub type FlatpakError = c_int;
pub const FLATPAK_ERROR_ALREADY_INSTALLED: FlatpakError = 0;
pub const FLATPAK_ERROR_NOT_INSTALLED: FlatpakError = 1;
pub const FLATPAK_ERROR_ONLY_PULLED: FlatpakError = 2;
pub const FLATPAK_ERROR_DIFFERENT_REMOTE: FlatpakError = 3;
pub const FLATPAK_ERROR_ABORTED: FlatpakError = 4;
pub const FLATPAK_ERROR_SKIPPED: FlatpakError = 5;
pub const FLATPAK_ERROR_NEED_NEW_FLATPAK: FlatpakError = 6;
pub const FLATPAK_ERROR_REMOTE_NOT_FOUND: FlatpakError = 7;
pub const FLATPAK_ERROR_RUNTIME_NOT_FOUND: FlatpakError = 8;
pub const FLATPAK_ERROR_DOWNGRADE: FlatpakError = 9;
pub const FLATPAK_ERROR_INVALID_REF: FlatpakError = 10;
pub const FLATPAK_ERROR_INVALID_DATA: FlatpakError = 11;
pub const FLATPAK_ERROR_UNTRUSTED: FlatpakError = 12;
pub const FLATPAK_ERROR_SETUP_FAILED: FlatpakError = 13;
pub const FLATPAK_ERROR_EXPORT_FAILED: FlatpakError = 14;
pub const FLATPAK_ERROR_REMOTE_USED: FlatpakError = 15;
pub const FLATPAK_ERROR_RUNTIME_USED: FlatpakError = 16;
pub const FLATPAK_ERROR_INVALID_NAME: FlatpakError = 17;
pub const FLATPAK_ERROR_OUT_OF_SPACE: FlatpakError = 18;
pub const FLATPAK_ERROR_WRONG_USER: FlatpakError = 19;
pub const FLATPAK_ERROR_NOT_CACHED: FlatpakError = 20;
pub const FLATPAK_ERROR_REF_NOT_FOUND: FlatpakError = 21;
pub const FLATPAK_ERROR_PERMISSION_DENIED: FlatpakError = 22;
pub const FLATPAK_ERROR_AUTHENTICATION_FAILED: FlatpakError = 23;
pub const FLATPAK_ERROR_NOT_AUTHORIZED: FlatpakError = 24;

pub type FlatpakPortalError = c_int;
pub const FLATPAK_PORTAL_ERROR_FAILED: FlatpakPortalError = 0;
pub const FLATPAK_PORTAL_ERROR_INVALID_ARGUMENT: FlatpakPortalError = 1;
pub const FLATPAK_PORTAL_ERROR_NOT_FOUND: FlatpakPortalError = 2;
pub const FLATPAK_PORTAL_ERROR_EXISTS: FlatpakPortalError = 3;
pub const FLATPAK_PORTAL_ERROR_NOT_ALLOWED: FlatpakPortalError = 4;
pub const FLATPAK_PORTAL_ERROR_CANCELLED: FlatpakPortalError = 5;
pub const FLATPAK_PORTAL_ERROR_WINDOW_DESTROYED: FlatpakPortalError = 6;

pub type FlatpakRefKind = c_int;
pub const FLATPAK_REF_KIND_APP: FlatpakRefKind = 0;
pub const FLATPAK_REF_KIND_RUNTIME: FlatpakRefKind = 1;

pub type FlatpakRemoteType = c_int;
pub const FLATPAK_REMOTE_TYPE_STATIC: FlatpakRemoteType = 0;
pub const FLATPAK_REMOTE_TYPE_USB: FlatpakRemoteType = 1;
pub const FLATPAK_REMOTE_TYPE_LAN: FlatpakRemoteType = 2;

pub type FlatpakStorageType = c_int;
pub const FLATPAK_STORAGE_TYPE_DEFAULT: FlatpakStorageType = 0;
pub const FLATPAK_STORAGE_TYPE_HARD_DISK: FlatpakStorageType = 1;
pub const FLATPAK_STORAGE_TYPE_SDCARD: FlatpakStorageType = 2;
pub const FLATPAK_STORAGE_TYPE_MMC: FlatpakStorageType = 3;
pub const FLATPAK_STORAGE_TYPE_NETWORK: FlatpakStorageType = 4;

pub type FlatpakTransactionOperationType = c_int;
pub const FLATPAK_TRANSACTION_OPERATION_INSTALL: FlatpakTransactionOperationType = 0;
pub const FLATPAK_TRANSACTION_OPERATION_UPDATE: FlatpakTransactionOperationType = 1;
pub const FLATPAK_TRANSACTION_OPERATION_INSTALL_BUNDLE: FlatpakTransactionOperationType = 2;
pub const FLATPAK_TRANSACTION_OPERATION_UNINSTALL: FlatpakTransactionOperationType = 3;
pub const FLATPAK_TRANSACTION_OPERATION_LAST_TYPE: FlatpakTransactionOperationType = 4;

pub type FlatpakTransactionRemoteReason = c_int;
pub const FLATPAK_TRANSACTION_REMOTE_GENERIC_REPO: FlatpakTransactionRemoteReason = 0;
pub const FLATPAK_TRANSACTION_REMOTE_RUNTIME_DEPS: FlatpakTransactionRemoteReason = 1;

// Constants

// Flags
pub type FlatpakInstallFlags = c_uint;
pub const FLATPAK_INSTALL_FLAGS_NONE: FlatpakInstallFlags = 0;
pub const FLATPAK_INSTALL_FLAGS_NO_STATIC_DELTAS: FlatpakInstallFlags = 1;
pub const FLATPAK_INSTALL_FLAGS_NO_DEPLOY: FlatpakInstallFlags = 4;
pub const FLATPAK_INSTALL_FLAGS_NO_PULL: FlatpakInstallFlags = 8;
pub const FLATPAK_INSTALL_FLAGS_NO_TRIGGERS: FlatpakInstallFlags = 16;

pub type FlatpakLaunchFlags = c_uint;
pub const FLATPAK_LAUNCH_FLAGS_NONE: FlatpakLaunchFlags = 0;
pub const FLATPAK_LAUNCH_FLAGS_DO_NOT_REAP: FlatpakLaunchFlags = 1;

pub type FlatpakQueryFlags = c_uint;
pub const FLATPAK_QUERY_FLAGS_NONE: FlatpakQueryFlags = 0;
pub const FLATPAK_QUERY_FLAGS_ONLY_CACHED: FlatpakQueryFlags = 1;
pub const FLATPAK_QUERY_FLAGS_ONLY_SIDELOADED: FlatpakQueryFlags = 2;

pub type FlatpakTransactionErrorDetails = c_uint;
pub const FLATPAK_TRANSACTION_ERROR_DETAILS_NON_FATAL: FlatpakTransactionErrorDetails = 1;

pub type FlatpakTransactionResult = c_uint;
pub const FLATPAK_TRANSACTION_RESULT_NO_CHANGE: FlatpakTransactionResult = 1;

pub type FlatpakUninstallFlags = c_uint;
pub const FLATPAK_UNINSTALL_FLAGS_NONE: FlatpakUninstallFlags = 0;
pub const FLATPAK_UNINSTALL_FLAGS_NO_PRUNE: FlatpakUninstallFlags = 1;
pub const FLATPAK_UNINSTALL_FLAGS_NO_TRIGGERS: FlatpakUninstallFlags = 2;

pub type FlatpakUpdateFlags = c_uint;
pub const FLATPAK_UPDATE_FLAGS_NONE: FlatpakUpdateFlags = 0;
pub const FLATPAK_UPDATE_FLAGS_NO_DEPLOY: FlatpakUpdateFlags = 1;
pub const FLATPAK_UPDATE_FLAGS_NO_PULL: FlatpakUpdateFlags = 2;
pub const FLATPAK_UPDATE_FLAGS_NO_STATIC_DELTAS: FlatpakUpdateFlags = 4;
pub const FLATPAK_UPDATE_FLAGS_NO_PRUNE: FlatpakUpdateFlags = 8;
pub const FLATPAK_UPDATE_FLAGS_NO_TRIGGERS: FlatpakUpdateFlags = 16;

// Callbacks
pub type FlatpakProgressCallback =
    Option<unsafe extern "C" fn(*const c_char, c_uint, gboolean, gpointer)>;

// Records
#[derive(Copy, Clone)]
#[repr(C)]
pub struct FlatpakBundleRefClass {
    pub parent_class: FlatpakRefClass,
}

impl ::std::fmt::Debug for FlatpakBundleRefClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("FlatpakBundleRefClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct FlatpakInstallationClass {
    pub parent_class: gobject::GObjectClass,
}

impl ::std::fmt::Debug for FlatpakInstallationClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("FlatpakInstallationClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct FlatpakInstalledRefClass {
    pub parent_class: FlatpakRefClass,
}

impl ::std::fmt::Debug for FlatpakInstalledRefClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("FlatpakInstalledRefClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct FlatpakInstanceClass {
    pub parent_class: gobject::GObjectClass,
}

impl ::std::fmt::Debug for FlatpakInstanceClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("FlatpakInstanceClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct FlatpakRefClass {
    pub parent_class: gobject::GObjectClass,
}

impl ::std::fmt::Debug for FlatpakRefClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("FlatpakRefClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct FlatpakRelatedRefClass {
    pub parent_class: FlatpakRefClass,
}

impl ::std::fmt::Debug for FlatpakRelatedRefClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("FlatpakRelatedRefClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct FlatpakRemoteClass {
    pub parent_class: gobject::GObjectClass,
}

impl ::std::fmt::Debug for FlatpakRemoteClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("FlatpakRemoteClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct FlatpakRemoteRefClass {
    pub parent_class: FlatpakRefClass,
}

impl ::std::fmt::Debug for FlatpakRemoteRefClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("FlatpakRemoteRefClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct FlatpakTransactionClass {
    pub parent_class: gobject::GObjectClass,
    pub new_operation: Option<
        unsafe extern "C" fn(
            *mut FlatpakTransaction,
            *mut FlatpakTransactionOperation,
            *mut FlatpakTransactionProgress,
        ),
    >,
    pub operation_done: Option<
        unsafe extern "C" fn(
            *mut FlatpakTransaction,
            *mut FlatpakTransactionOperation,
            *const c_char,
            FlatpakTransactionResult,
        ),
    >,
    pub operation_error: Option<
        unsafe extern "C" fn(
            *mut FlatpakTransaction,
            *mut FlatpakTransactionOperation,
            *const glib::GError,
            FlatpakTransactionErrorDetails,
        ) -> gboolean,
    >,
    pub choose_remote_for_ref: Option<
        unsafe extern "C" fn(
            *mut FlatpakTransaction,
            *const c_char,
            *const c_char,
            *const *const c_char,
        ) -> c_int,
    >,
    pub end_of_lifed: Option<
        unsafe extern "C" fn(*mut FlatpakTransaction, *const c_char, *const c_char, *const c_char),
    >,
    pub ready: Option<unsafe extern "C" fn(*mut FlatpakTransaction) -> gboolean>,
    pub add_new_remote: Option<
        unsafe extern "C" fn(
            *mut FlatpakTransaction,
            FlatpakTransactionRemoteReason,
            *const c_char,
            *const c_char,
            *const c_char,
        ) -> gboolean,
    >,
    pub run: Option<
        unsafe extern "C" fn(
            *mut FlatpakTransaction,
            *mut gio::GCancellable,
            *mut *mut glib::GError,
        ) -> gboolean,
    >,
    pub end_of_lifed_with_rebase: Option<
        unsafe extern "C" fn(
            *mut FlatpakTransaction,
            *const c_char,
            *const c_char,
            *const c_char,
            *const c_char,
            *mut *const c_char,
        ) -> gboolean,
    >,
    pub webflow_start: Option<
        unsafe extern "C" fn(
            *mut FlatpakTransaction,
            *const c_char,
            *const c_char,
            *mut glib::GVariant,
            c_uint,
        ) -> gboolean,
    >,
    pub webflow_done:
        Option<unsafe extern "C" fn(*mut FlatpakTransaction, *mut glib::GVariant, c_uint)>,
    pub basic_auth_start: Option<
        unsafe extern "C" fn(
            *mut FlatpakTransaction,
            *const c_char,
            *const c_char,
            *mut glib::GVariant,
            c_uint,
        ) -> gboolean,
    >,
    pub install_authenticator:
        Option<unsafe extern "C" fn(*mut FlatpakTransaction, *const c_char, *const c_char)>,
    pub padding: [gpointer; 4],
}

impl ::std::fmt::Debug for FlatpakTransactionClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("FlatpakTransactionClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .field("new_operation", &self.new_operation)
            .field("operation_done", &self.operation_done)
            .field("operation_error", &self.operation_error)
            .field("choose_remote_for_ref", &self.choose_remote_for_ref)
            .field("end_of_lifed", &self.end_of_lifed)
            .field("ready", &self.ready)
            .field("add_new_remote", &self.add_new_remote)
            .field("run", &self.run)
            .field("end_of_lifed_with_rebase", &self.end_of_lifed_with_rebase)
            .field("webflow_start", &self.webflow_start)
            .field("webflow_done", &self.webflow_done)
            .field("basic_auth_start", &self.basic_auth_start)
            .field("install_authenticator", &self.install_authenticator)
            .field("padding", &self.padding)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct FlatpakTransactionOperationClass {
    pub parent_class: gobject::GObjectClass,
}

impl ::std::fmt::Debug for FlatpakTransactionOperationClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("FlatpakTransactionOperationClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct FlatpakTransactionProgressClass {
    pub parent_class: gobject::GObjectClass,
}

impl ::std::fmt::Debug for FlatpakTransactionProgressClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("FlatpakTransactionProgressClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

// Classes
#[derive(Copy, Clone)]
#[repr(C)]
pub struct FlatpakBundleRef {
    pub parent: FlatpakRef,
}

impl ::std::fmt::Debug for FlatpakBundleRef {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("FlatpakBundleRef @ {:p}", self))
            .field("parent", &self.parent)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct FlatpakInstallation {
    pub parent: gobject::GObject,
}

impl ::std::fmt::Debug for FlatpakInstallation {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("FlatpakInstallation @ {:p}", self))
            .field("parent", &self.parent)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct FlatpakInstalledRef {
    pub parent: FlatpakRef,
}

impl ::std::fmt::Debug for FlatpakInstalledRef {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("FlatpakInstalledRef @ {:p}", self))
            .field("parent", &self.parent)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct FlatpakInstance {
    pub parent: gobject::GObject,
}

impl ::std::fmt::Debug for FlatpakInstance {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("FlatpakInstance @ {:p}", self))
            .field("parent", &self.parent)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct FlatpakRef {
    pub parent: gobject::GObject,
}

impl ::std::fmt::Debug for FlatpakRef {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("FlatpakRef @ {:p}", self))
            .field("parent", &self.parent)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct FlatpakRelatedRef {
    pub parent: FlatpakRef,
}

impl ::std::fmt::Debug for FlatpakRelatedRef {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("FlatpakRelatedRef @ {:p}", self))
            .field("parent", &self.parent)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct FlatpakRemote {
    pub parent: gobject::GObject,
}

impl ::std::fmt::Debug for FlatpakRemote {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("FlatpakRemote @ {:p}", self))
            .field("parent", &self.parent)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct FlatpakRemoteRef {
    pub parent: FlatpakRef,
}

impl ::std::fmt::Debug for FlatpakRemoteRef {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("FlatpakRemoteRef @ {:p}", self))
            .field("parent", &self.parent)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct FlatpakTransaction {
    pub parent_instance: gobject::GObject,
}

impl ::std::fmt::Debug for FlatpakTransaction {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("FlatpakTransaction @ {:p}", self))
            .field("parent_instance", &self.parent_instance)
            .finish()
    }
}

#[repr(C)]
pub struct FlatpakTransactionOperation {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

impl ::std::fmt::Debug for FlatpakTransactionOperation {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("FlatpakTransactionOperation @ {:p}", self))
            .finish()
    }
}

#[repr(C)]
pub struct FlatpakTransactionProgress {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

impl ::std::fmt::Debug for FlatpakTransactionProgress {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("FlatpakTransactionProgress @ {:p}", self))
            .finish()
    }
}

#[link(name = "flatpak")]
extern "C" {

    //=========================================================================
    // FlatpakError
    //=========================================================================
    pub fn flatpak_error_get_type() -> GType;
    pub fn flatpak_error_quark() -> glib::GQuark;

    //=========================================================================
    // FlatpakPortalError
    //=========================================================================
    pub fn flatpak_portal_error_get_type() -> GType;
    pub fn flatpak_portal_error_quark() -> glib::GQuark;

    //=========================================================================
    // FlatpakRefKind
    //=========================================================================
    pub fn flatpak_ref_kind_get_type() -> GType;

    //=========================================================================
    // FlatpakRemoteType
    //=========================================================================
    pub fn flatpak_remote_type_get_type() -> GType;

    //=========================================================================
    // FlatpakStorageType
    //=========================================================================
    #[cfg(any(feature = "v0_6_15", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_6_15")))]
    pub fn flatpak_storage_type_get_type() -> GType;

    //=========================================================================
    // FlatpakTransactionOperationType
    //=========================================================================
    pub fn flatpak_transaction_operation_type_get_type() -> GType;
    pub fn flatpak_transaction_operation_type_to_string(
        kind: FlatpakTransactionOperationType,
    ) -> *const c_char;

    //=========================================================================
    // FlatpakTransactionRemoteReason
    //=========================================================================
    pub fn flatpak_transaction_remote_reason_get_type() -> GType;

    //=========================================================================
    // FlatpakInstallFlags
    //=========================================================================
    pub fn flatpak_install_flags_get_type() -> GType;

    //=========================================================================
    // FlatpakLaunchFlags
    //=========================================================================
    pub fn flatpak_launch_flags_get_type() -> GType;

    //=========================================================================
    // FlatpakQueryFlags
    //=========================================================================
    #[cfg(any(feature = "v1_3_3", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_3_3")))]
    pub fn flatpak_query_flags_get_type() -> GType;

    //=========================================================================
    // FlatpakTransactionErrorDetails
    //=========================================================================
    pub fn flatpak_transaction_error_details_get_type() -> GType;

    //=========================================================================
    // FlatpakTransactionResult
    //=========================================================================
    pub fn flatpak_transaction_result_get_type() -> GType;

    //=========================================================================
    // FlatpakUninstallFlags
    //=========================================================================
    #[cfg(any(feature = "v0_11_8", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_11_8")))]
    pub fn flatpak_uninstall_flags_get_type() -> GType;

    //=========================================================================
    // FlatpakUpdateFlags
    //=========================================================================
    pub fn flatpak_update_flags_get_type() -> GType;

    //=========================================================================
    // FlatpakBundleRef
    //=========================================================================
    pub fn flatpak_bundle_ref_get_type() -> GType;
    pub fn flatpak_bundle_ref_new(
        file: *mut gio::GFile,
        error: *mut *mut glib::GError,
    ) -> *mut FlatpakBundleRef;
    pub fn flatpak_bundle_ref_get_appstream(self_: *mut FlatpakBundleRef) -> *mut glib::GBytes;
    pub fn flatpak_bundle_ref_get_file(self_: *mut FlatpakBundleRef) -> *mut gio::GFile;
    pub fn flatpak_bundle_ref_get_icon(
        self_: *mut FlatpakBundleRef,
        size: c_int,
    ) -> *mut glib::GBytes;
    pub fn flatpak_bundle_ref_get_installed_size(self_: *mut FlatpakBundleRef) -> u64;
    pub fn flatpak_bundle_ref_get_metadata(self_: *mut FlatpakBundleRef) -> *mut glib::GBytes;
    pub fn flatpak_bundle_ref_get_origin(self_: *mut FlatpakBundleRef) -> *mut c_char;
    #[cfg(any(feature = "v0_8", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_8")))]
    pub fn flatpak_bundle_ref_get_runtime_repo_url(self_: *mut FlatpakBundleRef) -> *mut c_char;

    //=========================================================================
    // FlatpakInstallation
    //=========================================================================
    pub fn flatpak_installation_get_type() -> GType;
    pub fn flatpak_installation_new_for_path(
        path: *mut gio::GFile,
        user: gboolean,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut FlatpakInstallation;
    pub fn flatpak_installation_new_system(
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut FlatpakInstallation;
    #[cfg(any(feature = "v0_8", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_8")))]
    pub fn flatpak_installation_new_system_with_id(
        id: *const c_char,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut FlatpakInstallation;
    pub fn flatpak_installation_new_user(
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut FlatpakInstallation;
    #[cfg(any(feature = "v1_3_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_3_4")))]
    pub fn flatpak_installation_add_remote(
        self_: *mut FlatpakInstallation,
        remote: *mut FlatpakRemote,
        if_needed: gboolean,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    #[cfg(any(feature = "v0_10", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_10")))]
    pub fn flatpak_installation_cleanup_local_refs_sync(
        self_: *mut FlatpakInstallation,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn flatpak_installation_create_monitor(
        self_: *mut FlatpakInstallation,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut gio::GFileMonitor;
    pub fn flatpak_installation_drop_caches(
        self_: *mut FlatpakInstallation,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn flatpak_installation_fetch_remote_metadata_sync(
        self_: *mut FlatpakInstallation,
        remote_name: *const c_char,
        ref_: *mut FlatpakRef,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GBytes;
    pub fn flatpak_installation_fetch_remote_ref_sync(
        self_: *mut FlatpakInstallation,
        remote_name: *const c_char,
        kind: FlatpakRefKind,
        name: *const c_char,
        arch: *const c_char,
        branch: *const c_char,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut FlatpakRemoteRef;
    #[cfg(any(feature = "v1_3_3", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_3_3")))]
    pub fn flatpak_installation_fetch_remote_ref_sync_full(
        self_: *mut FlatpakInstallation,
        remote_name: *const c_char,
        kind: FlatpakRefKind,
        name: *const c_char,
        arch: *const c_char,
        branch: *const c_char,
        flags: FlatpakQueryFlags,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut FlatpakRemoteRef;
    pub fn flatpak_installation_fetch_remote_size_sync(
        self_: *mut FlatpakInstallation,
        remote_name: *const c_char,
        ref_: *mut FlatpakRef,
        download_size: *mut u64,
        installed_size: *mut u64,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn flatpak_installation_get_config(
        self_: *mut FlatpakInstallation,
        key: *const c_char,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut c_char;
    pub fn flatpak_installation_get_current_installed_app(
        self_: *mut FlatpakInstallation,
        name: *const c_char,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut FlatpakInstalledRef;
    #[cfg(any(feature = "v1_5", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_5")))]
    pub fn flatpak_installation_get_default_languages(
        self_: *mut FlatpakInstallation,
        error: *mut *mut glib::GError,
    ) -> *mut *mut c_char;
    #[cfg(any(feature = "v1_5_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_5_1")))]
    pub fn flatpak_installation_get_default_locales(
        self_: *mut FlatpakInstallation,
        error: *mut *mut glib::GError,
    ) -> *mut *mut c_char;
    #[cfg(any(feature = "v0_8", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_8")))]
    pub fn flatpak_installation_get_display_name(self_: *mut FlatpakInstallation) -> *const c_char;
    #[cfg(any(feature = "v0_8", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_8")))]
    pub fn flatpak_installation_get_id(self_: *mut FlatpakInstallation) -> *const c_char;
    pub fn flatpak_installation_get_installed_ref(
        self_: *mut FlatpakInstallation,
        kind: FlatpakRefKind,
        name: *const c_char,
        arch: *const c_char,
        branch: *const c_char,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut FlatpakInstalledRef;
    pub fn flatpak_installation_get_is_user(self_: *mut FlatpakInstallation) -> gboolean;
    #[cfg(any(feature = "v1_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1")))]
    pub fn flatpak_installation_get_min_free_space_bytes(
        self_: *mut FlatpakInstallation,
        out_bytes: *mut u64,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    #[cfg(any(feature = "v1_1_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_1")))]
    pub fn flatpak_installation_get_no_interaction(self_: *mut FlatpakInstallation) -> gboolean;
    pub fn flatpak_installation_get_path(self_: *mut FlatpakInstallation) -> *mut gio::GFile;
    #[cfg(any(feature = "v0_8", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_8")))]
    pub fn flatpak_installation_get_priority(self_: *mut FlatpakInstallation) -> c_int;
    pub fn flatpak_installation_get_remote_by_name(
        self_: *mut FlatpakInstallation,
        name: *const c_char,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut FlatpakRemote;
    #[cfg(any(feature = "v0_8", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_8")))]
    pub fn flatpak_installation_get_storage_type(
        self_: *mut FlatpakInstallation,
    ) -> FlatpakStorageType;
    pub fn flatpak_installation_install(
        self_: *mut FlatpakInstallation,
        remote_name: *const c_char,
        kind: FlatpakRefKind,
        name: *const c_char,
        arch: *const c_char,
        branch: *const c_char,
        progress: FlatpakProgressCallback,
        progress_data: gpointer,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut FlatpakInstalledRef;
    pub fn flatpak_installation_install_bundle(
        self_: *mut FlatpakInstallation,
        file: *mut gio::GFile,
        progress: FlatpakProgressCallback,
        progress_data: gpointer,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut FlatpakInstalledRef;
    pub fn flatpak_installation_install_full(
        self_: *mut FlatpakInstallation,
        flags: FlatpakInstallFlags,
        remote_name: *const c_char,
        kind: FlatpakRefKind,
        name: *const c_char,
        arch: *const c_char,
        branch: *const c_char,
        subpaths: *const *const c_char,
        progress: FlatpakProgressCallback,
        progress_data: gpointer,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut FlatpakInstalledRef;
    #[cfg(any(feature = "v0_6_10", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_6_10")))]
    pub fn flatpak_installation_install_ref_file(
        self_: *mut FlatpakInstallation,
        ref_file_data: *mut glib::GBytes,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut FlatpakRemoteRef;
    pub fn flatpak_installation_launch(
        self_: *mut FlatpakInstallation,
        name: *const c_char,
        arch: *const c_char,
        branch: *const c_char,
        commit: *const c_char,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    #[cfg(any(feature = "v1_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1")))]
    pub fn flatpak_installation_launch_full(
        self_: *mut FlatpakInstallation,
        flags: FlatpakLaunchFlags,
        name: *const c_char,
        arch: *const c_char,
        branch: *const c_char,
        commit: *const c_char,
        instance_out: *mut *mut FlatpakInstance,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn flatpak_installation_list_installed_refs(
        self_: *mut FlatpakInstallation,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GPtrArray;
    pub fn flatpak_installation_list_installed_refs_by_kind(
        self_: *mut FlatpakInstallation,
        kind: FlatpakRefKind,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GPtrArray;
    pub fn flatpak_installation_list_installed_refs_for_update(
        self_: *mut FlatpakInstallation,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GPtrArray;
    #[cfg(any(feature = "v0_6_7", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_6_7")))]
    pub fn flatpak_installation_list_installed_related_refs_sync(
        self_: *mut FlatpakInstallation,
        remote_name: *const c_char,
        ref_: *const c_char,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GPtrArray;
    pub fn flatpak_installation_list_remote_refs_sync(
        self_: *mut FlatpakInstallation,
        remote_or_uri: *const c_char,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GPtrArray;
    #[cfg(any(feature = "v1_3_3", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_3_3")))]
    pub fn flatpak_installation_list_remote_refs_sync_full(
        self_: *mut FlatpakInstallation,
        remote_or_uri: *const c_char,
        flags: FlatpakQueryFlags,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GPtrArray;
    #[cfg(any(feature = "v0_6_7", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_6_7")))]
    pub fn flatpak_installation_list_remote_related_refs_sync(
        self_: *mut FlatpakInstallation,
        remote_name: *const c_char,
        ref_: *const c_char,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GPtrArray;
    pub fn flatpak_installation_list_remotes(
        self_: *mut FlatpakInstallation,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GPtrArray;
    pub fn flatpak_installation_list_remotes_by_type(
        self_: *mut FlatpakInstallation,
        types: *const FlatpakRemoteType,
        num_types: size_t,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GPtrArray;
    #[cfg(any(feature = "v1_1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_2")))]
    pub fn flatpak_installation_list_unused_refs(
        self_: *mut FlatpakInstallation,
        arch: *const c_char,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GPtrArray;
    pub fn flatpak_installation_load_app_overrides(
        self_: *mut FlatpakInstallation,
        app_id: *const c_char,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut c_char;
    pub fn flatpak_installation_modify_remote(
        self_: *mut FlatpakInstallation,
        remote: *mut FlatpakRemote,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    #[cfg(any(feature = "v0_10", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_10")))]
    pub fn flatpak_installation_prune_local_repo(
        self_: *mut FlatpakInstallation,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    #[cfg(any(feature = "v0_10", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_10")))]
    pub fn flatpak_installation_remove_local_ref_sync(
        self_: *mut FlatpakInstallation,
        remote_name: *const c_char,
        ref_: *const c_char,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn flatpak_installation_remove_remote(
        self_: *mut FlatpakInstallation,
        name: *const c_char,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    #[cfg(any(feature = "v1_0_3", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_0_3")))]
    pub fn flatpak_installation_run_triggers(
        self_: *mut FlatpakInstallation,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn flatpak_installation_set_config_sync(
        self_: *mut FlatpakInstallation,
        key: *const c_char,
        value: *const c_char,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    #[cfg(any(feature = "v1_1_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_1")))]
    pub fn flatpak_installation_set_no_interaction(
        self_: *mut FlatpakInstallation,
        no_interaction: gboolean,
    );
    pub fn flatpak_installation_uninstall(
        self_: *mut FlatpakInstallation,
        kind: FlatpakRefKind,
        name: *const c_char,
        arch: *const c_char,
        branch: *const c_char,
        progress: FlatpakProgressCallback,
        progress_data: gpointer,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    #[cfg(any(feature = "v0_11_8", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_11_8")))]
    pub fn flatpak_installation_uninstall_full(
        self_: *mut FlatpakInstallation,
        flags: FlatpakUninstallFlags,
        kind: FlatpakRefKind,
        name: *const c_char,
        arch: *const c_char,
        branch: *const c_char,
        progress: FlatpakProgressCallback,
        progress_data: gpointer,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn flatpak_installation_update(
        self_: *mut FlatpakInstallation,
        flags: FlatpakUpdateFlags,
        kind: FlatpakRefKind,
        name: *const c_char,
        arch: *const c_char,
        branch: *const c_char,
        progress: FlatpakProgressCallback,
        progress_data: gpointer,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut FlatpakInstalledRef;
    pub fn flatpak_installation_update_appstream_full_sync(
        self_: *mut FlatpakInstallation,
        remote_name: *const c_char,
        arch: *const c_char,
        progress: FlatpakProgressCallback,
        progress_data: gpointer,
        out_changed: *mut gboolean,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn flatpak_installation_update_appstream_sync(
        self_: *mut FlatpakInstallation,
        remote_name: *const c_char,
        arch: *const c_char,
        out_changed: *mut gboolean,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn flatpak_installation_update_full(
        self_: *mut FlatpakInstallation,
        flags: FlatpakUpdateFlags,
        kind: FlatpakRefKind,
        name: *const c_char,
        arch: *const c_char,
        branch: *const c_char,
        subpaths: *const *const c_char,
        progress: FlatpakProgressCallback,
        progress_data: gpointer,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut FlatpakInstalledRef;
    #[cfg(any(feature = "v0_6_13", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_6_13")))]
    pub fn flatpak_installation_update_remote_sync(
        self_: *mut FlatpakInstallation,
        name: *const c_char,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;

    //=========================================================================
    // FlatpakInstalledRef
    //=========================================================================
    pub fn flatpak_installed_ref_get_type() -> GType;
    #[cfg(any(feature = "v1_4_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4_2")))]
    pub fn flatpak_installed_ref_get_appdata_content_rating(
        self_: *mut FlatpakInstalledRef,
    ) -> *mut glib::GHashTable;
    #[cfg(any(feature = "v1_4_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4_2")))]
    pub fn flatpak_installed_ref_get_appdata_content_rating_type(
        self_: *mut FlatpakInstalledRef,
    ) -> *const c_char;
    #[cfg(any(feature = "v1_1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_2")))]
    pub fn flatpak_installed_ref_get_appdata_license(
        self_: *mut FlatpakInstalledRef,
    ) -> *const c_char;
    #[cfg(any(feature = "v1_1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_2")))]
    pub fn flatpak_installed_ref_get_appdata_name(self_: *mut FlatpakInstalledRef)
        -> *const c_char;
    #[cfg(any(feature = "v1_1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_2")))]
    pub fn flatpak_installed_ref_get_appdata_summary(
        self_: *mut FlatpakInstalledRef,
    ) -> *const c_char;
    #[cfg(any(feature = "v1_1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_2")))]
    pub fn flatpak_installed_ref_get_appdata_version(
        self_: *mut FlatpakInstalledRef,
    ) -> *const c_char;
    pub fn flatpak_installed_ref_get_deploy_dir(self_: *mut FlatpakInstalledRef) -> *const c_char;
    pub fn flatpak_installed_ref_get_eol(self_: *mut FlatpakInstalledRef) -> *const c_char;
    pub fn flatpak_installed_ref_get_eol_rebase(self_: *mut FlatpakInstalledRef) -> *const c_char;
    pub fn flatpak_installed_ref_get_installed_size(self_: *mut FlatpakInstalledRef) -> u64;
    pub fn flatpak_installed_ref_get_is_current(self_: *mut FlatpakInstalledRef) -> gboolean;
    pub fn flatpak_installed_ref_get_latest_commit(
        self_: *mut FlatpakInstalledRef,
    ) -> *const c_char;
    pub fn flatpak_installed_ref_get_origin(self_: *mut FlatpakInstalledRef) -> *const c_char;
    pub fn flatpak_installed_ref_get_subpaths(
        self_: *mut FlatpakInstalledRef,
    ) -> *const *const c_char;
    #[cfg(any(feature = "v1_1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_2")))]
    pub fn flatpak_installed_ref_load_appdata(
        self_: *mut FlatpakInstalledRef,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GBytes;
    pub fn flatpak_installed_ref_load_metadata(
        self_: *mut FlatpakInstalledRef,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GBytes;

    //=========================================================================
    // FlatpakInstance
    //=========================================================================
    pub fn flatpak_instance_get_type() -> GType;
    #[cfg(any(feature = "v1_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1")))]
    pub fn flatpak_instance_get_all() -> *mut glib::GPtrArray;
    #[cfg(any(feature = "v1_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1")))]
    pub fn flatpak_instance_get_app(self_: *mut FlatpakInstance) -> *const c_char;
    #[cfg(any(feature = "v1_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1")))]
    pub fn flatpak_instance_get_arch(self_: *mut FlatpakInstance) -> *const c_char;
    #[cfg(any(feature = "v1_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1")))]
    pub fn flatpak_instance_get_branch(self_: *mut FlatpakInstance) -> *const c_char;
    #[cfg(any(feature = "v1_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1")))]
    pub fn flatpak_instance_get_child_pid(self_: *mut FlatpakInstance) -> c_int;
    #[cfg(any(feature = "v1_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1")))]
    pub fn flatpak_instance_get_commit(self_: *mut FlatpakInstance) -> *const c_char;
    #[cfg(any(feature = "v1_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1")))]
    pub fn flatpak_instance_get_id(self_: *mut FlatpakInstance) -> *const c_char;
    #[cfg(any(feature = "v1_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1")))]
    pub fn flatpak_instance_get_info(self_: *mut FlatpakInstance) -> *mut glib::GKeyFile;
    #[cfg(any(feature = "v1_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1")))]
    pub fn flatpak_instance_get_pid(self_: *mut FlatpakInstance) -> c_int;
    #[cfg(any(feature = "v1_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1")))]
    pub fn flatpak_instance_get_runtime(self_: *mut FlatpakInstance) -> *const c_char;
    #[cfg(any(feature = "v1_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1")))]
    pub fn flatpak_instance_get_runtime_commit(self_: *mut FlatpakInstance) -> *const c_char;
    pub fn flatpak_instance_is_running(self_: *mut FlatpakInstance) -> gboolean;

    //=========================================================================
    // FlatpakRef
    //=========================================================================
    pub fn flatpak_ref_get_type() -> GType;
    pub fn flatpak_ref_parse(ref_: *const c_char, error: *mut *mut glib::GError)
        -> *mut FlatpakRef;
    pub fn flatpak_ref_format_ref(self_: *mut FlatpakRef) -> *mut c_char;
    pub fn flatpak_ref_get_arch(self_: *mut FlatpakRef) -> *const c_char;
    pub fn flatpak_ref_get_branch(self_: *mut FlatpakRef) -> *const c_char;
    pub fn flatpak_ref_get_collection_id(self_: *mut FlatpakRef) -> *const c_char;
    pub fn flatpak_ref_get_commit(self_: *mut FlatpakRef) -> *const c_char;
    pub fn flatpak_ref_get_kind(self_: *mut FlatpakRef) -> FlatpakRefKind;
    pub fn flatpak_ref_get_name(self_: *mut FlatpakRef) -> *const c_char;

    //=========================================================================
    // FlatpakRelatedRef
    //=========================================================================
    pub fn flatpak_related_ref_get_type() -> GType;
    #[cfg(any(feature = "v0_6_7", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_6_7")))]
    pub fn flatpak_related_ref_get_subpaths(self_: *mut FlatpakRelatedRef) -> *const *const c_char;
    #[cfg(any(feature = "v0_11_8", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_11_8")))]
    pub fn flatpak_related_ref_should_autoprune(self_: *mut FlatpakRelatedRef) -> gboolean;
    #[cfg(any(feature = "v0_6_7", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_6_7")))]
    pub fn flatpak_related_ref_should_delete(self_: *mut FlatpakRelatedRef) -> gboolean;
    #[cfg(any(feature = "v0_6_7", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_6_7")))]
    pub fn flatpak_related_ref_should_download(self_: *mut FlatpakRelatedRef) -> gboolean;

    //=========================================================================
    // FlatpakRemote
    //=========================================================================
    pub fn flatpak_remote_get_type() -> GType;
    pub fn flatpak_remote_new(name: *const c_char) -> *mut FlatpakRemote;
    #[cfg(any(feature = "v1_3_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_3_4")))]
    pub fn flatpak_remote_new_from_file(
        name: *const c_char,
        data: *mut glib::GBytes,
        error: *mut *mut glib::GError,
    ) -> *mut FlatpakRemote;
    pub fn flatpak_remote_get_appstream_dir(
        self_: *mut FlatpakRemote,
        arch: *const c_char,
    ) -> *mut gio::GFile;
    pub fn flatpak_remote_get_appstream_timestamp(
        self_: *mut FlatpakRemote,
        arch: *const c_char,
    ) -> *mut gio::GFile;
    pub fn flatpak_remote_get_collection_id(self_: *mut FlatpakRemote) -> *mut c_char;
    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    pub fn flatpak_remote_get_comment(self_: *mut FlatpakRemote) -> *mut c_char;
    #[cfg(any(feature = "v0_6_12", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_6_12")))]
    pub fn flatpak_remote_get_default_branch(self_: *mut FlatpakRemote) -> *mut c_char;
    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    pub fn flatpak_remote_get_description(self_: *mut FlatpakRemote) -> *mut c_char;
    pub fn flatpak_remote_get_disabled(self_: *mut FlatpakRemote) -> gboolean;
    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    pub fn flatpak_remote_get_filter(self_: *mut FlatpakRemote) -> *mut c_char;
    pub fn flatpak_remote_get_gpg_verify(self_: *mut FlatpakRemote) -> gboolean;
    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    pub fn flatpak_remote_get_homepage(self_: *mut FlatpakRemote) -> *mut c_char;
    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    pub fn flatpak_remote_get_icon(self_: *mut FlatpakRemote) -> *mut c_char;
    #[cfg(any(feature = "v1_1_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_1")))]
    pub fn flatpak_remote_get_main_ref(self_: *mut FlatpakRemote) -> *mut c_char;
    pub fn flatpak_remote_get_name(self_: *mut FlatpakRemote) -> *const c_char;
    pub fn flatpak_remote_get_nodeps(self_: *mut FlatpakRemote) -> gboolean;
    pub fn flatpak_remote_get_noenumerate(self_: *mut FlatpakRemote) -> gboolean;
    pub fn flatpak_remote_get_prio(self_: *mut FlatpakRemote) -> c_int;
    #[cfg(any(feature = "v0_9_8", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_9_8")))]
    pub fn flatpak_remote_get_remote_type(self_: *mut FlatpakRemote) -> FlatpakRemoteType;
    pub fn flatpak_remote_get_title(self_: *mut FlatpakRemote) -> *mut c_char;
    pub fn flatpak_remote_get_url(self_: *mut FlatpakRemote) -> *mut c_char;
    pub fn flatpak_remote_set_collection_id(
        self_: *mut FlatpakRemote,
        collection_id: *const c_char,
    );
    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    pub fn flatpak_remote_set_comment(self_: *mut FlatpakRemote, comment: *const c_char);
    #[cfg(any(feature = "v0_6_12", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_6_12")))]
    pub fn flatpak_remote_set_default_branch(
        self_: *mut FlatpakRemote,
        default_branch: *const c_char,
    );
    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    pub fn flatpak_remote_set_description(self_: *mut FlatpakRemote, description: *const c_char);
    pub fn flatpak_remote_set_disabled(self_: *mut FlatpakRemote, disabled: gboolean);
    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    pub fn flatpak_remote_set_filter(self_: *mut FlatpakRemote, filter_path: *const c_char);
    pub fn flatpak_remote_set_gpg_key(self_: *mut FlatpakRemote, gpg_key: *mut glib::GBytes);
    pub fn flatpak_remote_set_gpg_verify(self_: *mut FlatpakRemote, gpg_verify: gboolean);
    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    pub fn flatpak_remote_set_homepage(self_: *mut FlatpakRemote, homepage: *const c_char);
    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    pub fn flatpak_remote_set_icon(self_: *mut FlatpakRemote, icon: *const c_char);
    #[cfg(any(feature = "v1_1_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_1")))]
    pub fn flatpak_remote_set_main_ref(self_: *mut FlatpakRemote, main_ref: *const c_char);
    pub fn flatpak_remote_set_nodeps(self_: *mut FlatpakRemote, nodeps: gboolean);
    pub fn flatpak_remote_set_noenumerate(self_: *mut FlatpakRemote, noenumerate: gboolean);
    pub fn flatpak_remote_set_prio(self_: *mut FlatpakRemote, prio: c_int);
    pub fn flatpak_remote_set_title(self_: *mut FlatpakRemote, title: *const c_char);
    pub fn flatpak_remote_set_url(self_: *mut FlatpakRemote, url: *const c_char);

    //=========================================================================
    // FlatpakRemoteRef
    //=========================================================================
    pub fn flatpak_remote_ref_get_type() -> GType;
    pub fn flatpak_remote_ref_get_download_size(self_: *mut FlatpakRemoteRef) -> u64;
    pub fn flatpak_remote_ref_get_eol(self_: *mut FlatpakRemoteRef) -> *const c_char;
    pub fn flatpak_remote_ref_get_eol_rebase(self_: *mut FlatpakRemoteRef) -> *const c_char;
    pub fn flatpak_remote_ref_get_installed_size(self_: *mut FlatpakRemoteRef) -> u64;
    pub fn flatpak_remote_ref_get_metadata(self_: *mut FlatpakRemoteRef) -> *mut glib::GBytes;
    pub fn flatpak_remote_ref_get_remote_name(self_: *mut FlatpakRemoteRef) -> *const c_char;

    //=========================================================================
    // FlatpakTransaction
    //=========================================================================
    pub fn flatpak_transaction_get_type() -> GType;
    pub fn flatpak_transaction_new_for_installation(
        installation: *mut FlatpakInstallation,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut FlatpakTransaction;
    #[cfg(any(feature = "v1_5_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_5_1")))]
    pub fn flatpak_transaction_abort_webflow(self_: *mut FlatpakTransaction, id: c_uint);
    pub fn flatpak_transaction_add_default_dependency_sources(self_: *mut FlatpakTransaction);
    pub fn flatpak_transaction_add_dependency_source(
        self_: *mut FlatpakTransaction,
        installation: *mut FlatpakInstallation,
    );
    pub fn flatpak_transaction_add_install(
        self_: *mut FlatpakTransaction,
        remote: *const c_char,
        ref_: *const c_char,
        subpaths: *mut *const c_char,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn flatpak_transaction_add_install_bundle(
        self_: *mut FlatpakTransaction,
        file: *mut gio::GFile,
        gpg_data: *mut glib::GBytes,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn flatpak_transaction_add_install_flatpakref(
        self_: *mut FlatpakTransaction,
        flatpakref_data: *mut glib::GBytes,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    #[cfg(any(feature = "v1_3_3", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_3_3")))]
    pub fn flatpak_transaction_add_rebase(
        self_: *mut FlatpakTransaction,
        remote: *const c_char,
        ref_: *const c_char,
        subpaths: *mut *const c_char,
        previous_ids: *mut *const c_char,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    #[cfg(any(feature = "v1_7_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_7_1")))]
    pub fn flatpak_transaction_add_sideload_repo(
        self_: *mut FlatpakTransaction,
        path: *const c_char,
    );
    pub fn flatpak_transaction_add_uninstall(
        self_: *mut FlatpakTransaction,
        ref_: *const c_char,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn flatpak_transaction_add_update(
        self_: *mut FlatpakTransaction,
        ref_: *const c_char,
        subpaths: *mut *const c_char,
        commit: *const c_char,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    #[cfg(any(feature = "v1_5_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_5_2")))]
    pub fn flatpak_transaction_complete_basic_auth(
        self_: *mut FlatpakTransaction,
        id: c_uint,
        user: *const c_char,
        password: *const c_char,
        options: *mut glib::GVariant,
    );
    pub fn flatpak_transaction_get_current_operation(
        self_: *mut FlatpakTransaction,
    ) -> *mut FlatpakTransactionOperation;
    pub fn flatpak_transaction_get_installation(
        self_: *mut FlatpakTransaction,
    ) -> *mut FlatpakInstallation;
    #[cfg(any(feature = "v1_5_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_5_1")))]
    pub fn flatpak_transaction_get_no_deploy(self_: *mut FlatpakTransaction) -> gboolean;
    #[cfg(any(feature = "v1_5_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_5_1")))]
    pub fn flatpak_transaction_get_no_pull(self_: *mut FlatpakTransaction) -> gboolean;
    pub fn flatpak_transaction_get_operations(self_: *mut FlatpakTransaction) -> *mut glib::GList;
    #[cfg(any(feature = "v1_5_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_5_1")))]
    pub fn flatpak_transaction_get_parent_window(self_: *mut FlatpakTransaction) -> *const c_char;
    pub fn flatpak_transaction_is_empty(self_: *mut FlatpakTransaction) -> gboolean;
    pub fn flatpak_transaction_run(
        transaction: *mut FlatpakTransaction,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn flatpak_transaction_set_default_arch(
        self_: *mut FlatpakTransaction,
        arch: *const c_char,
    );
    pub fn flatpak_transaction_set_disable_dependencies(
        self_: *mut FlatpakTransaction,
        disable_dependencies: gboolean,
    );
    pub fn flatpak_transaction_set_disable_prune(
        self_: *mut FlatpakTransaction,
        disable_prune: gboolean,
    );
    pub fn flatpak_transaction_set_disable_related(
        self_: *mut FlatpakTransaction,
        disable_related: gboolean,
    );
    pub fn flatpak_transaction_set_disable_static_deltas(
        self_: *mut FlatpakTransaction,
        disable_static_deltas: gboolean,
    );
    pub fn flatpak_transaction_set_force_uninstall(
        self_: *mut FlatpakTransaction,
        force_uninstall: gboolean,
    );
    pub fn flatpak_transaction_set_no_deploy(self_: *mut FlatpakTransaction, no_deploy: gboolean);
    #[cfg(any(feature = "v1_7_3", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_7_3")))]
    pub fn flatpak_transaction_set_no_interaction(
        self_: *mut FlatpakTransaction,
        no_interaction: gboolean,
    );
    pub fn flatpak_transaction_set_no_pull(self_: *mut FlatpakTransaction, no_pull: gboolean);
    #[cfg(any(feature = "v1_5_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_5_1")))]
    pub fn flatpak_transaction_set_parent_window(
        self_: *mut FlatpakTransaction,
        parent_window: *const c_char,
    );
    pub fn flatpak_transaction_set_reinstall(self_: *mut FlatpakTransaction, reinstall: gboolean);

    //=========================================================================
    // FlatpakTransactionOperation
    //=========================================================================
    pub fn flatpak_transaction_operation_get_type() -> GType;
    pub fn flatpak_transaction_operation_get_bundle_path(
        self_: *mut FlatpakTransactionOperation,
    ) -> *mut gio::GFile;
    pub fn flatpak_transaction_operation_get_commit(
        self_: *mut FlatpakTransactionOperation,
    ) -> *const c_char;
    #[cfg(any(feature = "v1_1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_2")))]
    pub fn flatpak_transaction_operation_get_download_size(
        self_: *mut FlatpakTransactionOperation,
    ) -> u64;
    #[cfg(any(feature = "v1_1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_2")))]
    pub fn flatpak_transaction_operation_get_installed_size(
        self_: *mut FlatpakTransactionOperation,
    ) -> u64;
    #[cfg(any(feature = "v1_7_3", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_7_3")))]
    pub fn flatpak_transaction_operation_get_is_skipped(
        self_: *mut FlatpakTransactionOperation,
    ) -> gboolean;
    pub fn flatpak_transaction_operation_get_metadata(
        self_: *mut FlatpakTransactionOperation,
    ) -> *mut glib::GKeyFile;
    pub fn flatpak_transaction_operation_get_old_metadata(
        self_: *mut FlatpakTransactionOperation,
    ) -> *mut glib::GKeyFile;
    pub fn flatpak_transaction_operation_get_operation_type(
        self_: *mut FlatpakTransactionOperation,
    ) -> FlatpakTransactionOperationType;
    pub fn flatpak_transaction_operation_get_ref(
        self_: *mut FlatpakTransactionOperation,
    ) -> *const c_char;
    #[cfg(any(feature = "v1_7_3", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_7_3")))]
    pub fn flatpak_transaction_operation_get_related_to_ops(
        self_: *mut FlatpakTransactionOperation,
    ) -> *mut glib::GPtrArray;
    pub fn flatpak_transaction_operation_get_remote(
        self_: *mut FlatpakTransactionOperation,
    ) -> *const c_char;

    //=========================================================================
    // FlatpakTransactionProgress
    //=========================================================================
    pub fn flatpak_transaction_progress_get_type() -> GType;
    #[cfg(any(feature = "v1_1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_2")))]
    pub fn flatpak_transaction_progress_get_bytes_transferred(
        self_: *mut FlatpakTransactionProgress,
    ) -> u64;
    pub fn flatpak_transaction_progress_get_is_estimating(
        self_: *mut FlatpakTransactionProgress,
    ) -> gboolean;
    pub fn flatpak_transaction_progress_get_progress(
        self_: *mut FlatpakTransactionProgress,
    ) -> c_int;
    #[cfg(any(feature = "v1_1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_2")))]
    pub fn flatpak_transaction_progress_get_start_time(
        self_: *mut FlatpakTransactionProgress,
    ) -> u64;
    pub fn flatpak_transaction_progress_get_status(
        self_: *mut FlatpakTransactionProgress,
    ) -> *mut c_char;
    pub fn flatpak_transaction_progress_set_update_frequency(
        self_: *mut FlatpakTransactionProgress,
        update_interval: c_uint,
    );

    //=========================================================================
    // Other functions
    //=========================================================================
    pub fn flatpak_get_default_arch() -> *const c_char;
    pub fn flatpak_get_supported_arches() -> *const *const c_char;
    #[cfg(any(feature = "v0_8", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_8")))]
    pub fn flatpak_get_system_installations(
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GPtrArray;

}
